

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppListClientGroups.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppListClientGroups.sp,v $ $Id: AppListClientGroups.sp,v 1.1.2.1 2019/03/07 21:35:29 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppListClientGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppListClientGroups <<<'
	drop procedure AppListClientGroups
END
IF EXISTS (select * from GxQscripts where name='AppListClientGroups')
	delete from GxQscripts where name = 'AppListClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppListClientGroups')
	delete from GXDBVersions where aliasname = 'AppListClientGroups'
GO
print '... Creating Procedure: AppListClientGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppListClientGroups
-- in_clientId is 0 get all client groups or >0 just client groups associated with clientId
  @in_clientId INT
AS
  DECLARE @id INT
  DECLARE @name NVARCHAR(512)
  DECLARE @status INT
  DECLARE @flag INT
BEGIN
	SET NOCOUNT ON
	IF (@in_clientId = 0)
	BEGIN
		-- All Client Groups
		SELECT
			cg.id,
			cg.name,
			cg.status,
			cg.flag
		FROM APP_ClientGroup cg WITH(NOLOCK)
		WHERE
			cg.id > 0
		ORDER BY cg.name
	END
	ELSE
	BEGIN
		-- All Client Groups associated with inputted clientId
		SELECT
			cg.id,
			cg.name,
			cg.status,
			cg.flag
		FROM APP_ClientGroup cg WITH(NOLOCK)
		WHERE
			cg.id > 0
			AND cg.id IN (
				SELECT
					cga.clientGroupId
				FROM APP_ClientGroupAssoc cga WITH(NOLOCK)
				WHERE
					cga.clientId = @in_clientId
			)
		ORDER BY cg.name
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppListClientGroups')
	delete from GxQscripts where name = 'AppListClientGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppListClientGroups')
	delete from GXDBVersions where aliasname = 'AppListClientGroups'
GO

insert into GXDBVersions values(2, 'AppListClientGroups',  '00010001000200010000', 'AppListClientGroups', '00010001000200010000')
GO

