

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppJournalSetRecipientsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppJournalSetRecipientsInfo.sp,v $ $Id: AppJournalSetRecipientsInfo.sp,v 1.1.4.5 2018/03/27 08:55:01 jiechen Exp $";
--	+===================================================================+
--	|  					  AppJournalSetRecipientsInfo					|
--	|		Procedure for create/update the journal email info			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppJournalSetRecipientsInfo <<<'

IF EXISTS (select * from sysobjects where name='AppJournalSetRecipientsInfo')
	drop procedure AppJournalSetRecipientsInfo
IF EXISTS (select * from GxQscripts where name='AppJournalSetRecipientsInfo')
	delete from GxQscripts where name = 'AppJournalSetRecipientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJournalSetRecipientsInfo')
	delete from GXDBVersions where aliasname = 'AppJournalSetRecipientsInfo'
GO
print '... Creating Procedure: AppJournalSetRecipientsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppJournalSetRecipientsInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTimeUnix		INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @subClientId		INT = 0
	DECLARE @journalMail		XML
	DECLARE @journalGUID		NVARCHAR(40) = ''
	DECLARE @journalId			INT = 0
	DECLARE @userId				INT = (SELECT TOP 1 id FROM UMUsers (NOLOCK) WHERE flags&0x40=0x40)
	DECLARE @localeId			INT = 0
	DECLARE @rowCount			INT = 0
	IF object_id('tempdb.dbo.#journalEmail_userEmailsTable') is not null
		DROP TABLE #journalEmail_userEmailsTable
	CREATE TABLE #journalEmail_userEmailsTable
		(userEmails XML, userGUID NVARCHAR(40))
	CREATE CLUSTERED INDEX #journalEmail_userEmailsTable_userGuid_Index1 ON #journalEmail_userEmailsTable ([userGUID])
	IF object_id('tempdb.dbo.#usersEmail_compareTable') is not null
		DROP TABLE #usersEmail_compareTable
	CREATE TABLE #usersEmail_compareTable
		(id INT, componentId INT, userEmails XML, userGUID NVARCHAR(40))
	CREATE CLUSTERED INDEX #usersEmail_compareTable_userGuid_id_Index1 ON #usersEmail_compareTable ([userGUID], [id])
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
			FROM    @i_xmlString.nodes('Ida_SetJuornalRecipientsInfoReq/processinginstructioninfo/user') R ( ref )), @userId)
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @i_xmlString.nodes('Ida_SetJuornalRecipientsInfoReq/processinginstructioninfo/locale') R ( ref )), @localeId)
	SET @subClientId = ISNULL((SELECT  ref.value('@subclientId', 'int')
			FROM    @i_xmlString.nodes('Ida_SetJuornalRecipientsInfoReq/journalInfo/subclientEntity') R ( ref )), 0)
	SELECT @journalMail = jm.query('.'), @journalGUID = jm.value('user[1]/@userGUID', 'NVARCHAR(40)')
	FROM    @i_xmlString.nodes('Ida_SetJuornalRecipientsInfoReq/journalInfo') R(ref)
	CROSS APPLY ref.nodes('./journalEmail') J(jm)
	INSERT #journalEmail_userEmailsTable (userEmails, userGUID)
	SELECT um.query('.') userEmails, um.value('user[1]/@userGUID', 'NVARCHAR(40)') userGUID
	FROM    @i_xmlString.nodes('Ida_SetJuornalRecipientsInfoReq/journalInfo') R(ref)
	CROSS APPLY ref.nodes('./recipients') M(um)
	SELECT @journalId = T.journalId--, jm.value('user[1]/@userGUID', 'NVARCHAR(40)'), @journalGUID
	FROM
	(
		SELECT CAST(stringVal AS XML) xmlString, id journalId
		FROM APP_ComponentProp (NOLOCK)
WHERE componentType = 6 --_CV_COMPONENT_TYPE_SUBCLIENT
		AND componentId=@subClientId
AND propertyTypeId = 1150 --_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
	) T
	CROSS APPLY xmlString.nodes('./journalEmail') J(jm)
	WHERE jm.value('user[1]/@userGUID', 'NVARCHAR(40)') = @journalGUID
	BEGIN TRAN
		IF @journalId = 0
		BEGIN
			INSERT INTO APP_ComponentProp (componentType, componentId, propertyTypeId, dataType, stringVal, longVal, longlongVal, created, modified)
VALUES(6,	--_CV_COMPONENT_TYPE_SUBCLIENT
			@subClientId,
1150,	--_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
			1, --PROPERTY_STRING
			CAST(@journalMail AS NVARCHAR(MAX)), 0, 0, @nowTimeUnix, 0)
			--Check Error
			SELECT @errorCode = @@ERROR, @rowCount = @@ROWCOUNT
			IF(@errorCode <> 0)
				GOTO ERROR
			IF @rowCount > 0
				SET @journalId = IDENT_CURRENT('APP_ComponentProp')
		END
		--GET EXISTING VALUES FROM DB
		INSERT INTO #usersEmail_compareTable
		(id, componentId, userEmails, userGUID)
		SELECT id, componentId, CAST(stringVal AS XML) userEmails, ''
		FROM APP_ComponentProp (NOLOCK)
WHERE componentType = 11 --_CV_COMPONENT_TYPE_JOURNAL_EMAILS
		AND componentId = @journalId
AND propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
		UPDATE #usersEmail_compareTable
		SET userGUID = uGuid
		FROM
		(
			SELECT um.value('user[1]/@userGUID', 'NVARCHAR(40)') uGuid, id propId
			FROM #usersEmail_compareTable
			CROSS APPLY userEmails.nodes('./recipients') M(um)
		) CT
		WHERE CT.propId = id
		UPDATE APP_ComponentProp
		SET stringVal = CAST(T.userEmails AS NVARCHAR(MAX)),
		modified = @nowTimeUnix
		FROM
		(
			SELECT CP.id tableId, UE.userEmails
			FROM #usersEmail_compareTable CP
			JOIN #journalEmail_userEmailsTable UE ON UE.userGUID = CP.userGUID
		) T
		WHERE id = T.tableId
		--DELETE ENTRIES WHICH ALREADY BEEN UPDATED
		DELETE #journalEmail_userEmailsTable
		WHERE userGUID IN (
			SELECT userGUID FROM #usersEmail_compareTable
		)
		INSERT INTO APP_ComponentProp
		(componentType, componentId, propertyTypeId, dataType, stringVal, longVal, longlongVal, created, modified)
SELECT 11, --_CV_COMPONENT_TYPE_JOURNAL_EMAILS
		@journalId,
1151, --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
		1, --PROPERTY_STRING
		CAST(userEmails AS NVARCHAR(MAX)), 0, 0, @nowTimeUnix, 0
		FROM #journalEmail_userEmailsTable
		--Check Error
		SELECT @errorCode = @@ERROR
		IF(@errorCode <> 0)
			GOTO ERROR
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
    SET @o_xmlString =
    (
		SELECT
			(SELECT
				(SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
				FOR XML PATH ('resp'), TYPE
				)
			FOR XML PATH(''), ROOT('Ida_JuornalRecipientsResp')
			)
    )
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#journalEmail_userEmailsTable') is not null
		DROP TABLE #journalEmail_userEmailsTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppJournalSetRecipientsInfo')
	delete from GxQscripts where name = 'AppJournalSetRecipientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJournalSetRecipientsInfo')
	delete from GXDBVersions where aliasname = 'AppJournalSetRecipientsInfo'
GO

insert into GXDBVersions values(2, 'AppJournalSetRecipientsInfo',  '00010001000400050000', 'AppJournalSetRecipientsInfo', '00010001000400050000')
GO

