

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppJournalGetRecipientsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppJournalGetRecipientsInfo.sp,v $ $Id: AppJournalGetRecipientsInfo.sp,v 1.1.4.6 2018/03/27 08:39:52 jiechen Exp $";
--	+===================================================================+
--	|  					  AppJournalGetRecipientsInfo					|
--	|		Procedure to get the journal email info						|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppJournalGetRecipientsInfo <<<'

IF EXISTS (select * from sysobjects where name='AppJournalGetRecipientsInfo')
	drop procedure AppJournalGetRecipientsInfo
IF EXISTS (select * from GxQscripts where name='AppJournalGetRecipientsInfo')
	delete from GxQscripts where name = 'AppJournalGetRecipientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJournalGetRecipientsInfo')
	delete from GXDBVersions where aliasname = 'AppJournalGetRecipientsInfo'
GO
print '... Creating Procedure: AppJournalGetRecipientsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppJournalGetRecipientsInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTimeUnix		INT = datediff(second, '01/01/1970', GETDATE())
	DECLARE @subClientId		INT = 0
	DECLARE @journalId			INT = 0
	DECLARE @subClientName		NVARCHAR(1024) = ''
	DECLARE @journalGUID		NVARCHAR(40) = ''
	DECLARE @journalInfo		XML
	 -- READ THE XML
	DECLARE @localeId			INT = 0
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @i_xmlString.nodes('Ida_GetJuornalRecipientsInfoReq/processinginstructioninfo/locale') R ( ref )), @localeId)
	SET @subClientId = ISNULL((SELECT  ref.value('@subclientId', 'int')
			FROM    @i_xmlString.nodes('Ida_GetJuornalRecipientsInfoReq/journalInfo/subclientEntity') R ( ref )), 0)
--
	IF object_id('tempdb.dbo.#journalEmail_journalInfoTable') is not null
		DROP TABLE #journalEmail_journalInfoTable
	CREATE TABLE #journalEmail_journalInfoTable
		(journalId INT, journalInfo XML)
	CREATE CLUSTERED INDEX #journalEmail_journalInfoTable_id_Index1 ON #journalEmail_journalInfoTable ([journalId])
	SELECT @journalGUID = jm.value('user[1]/@userGUID', 'NVARCHAR(40)')
	FROM    @i_xmlString.nodes('Ida_GetJuornalRecipientsInfoReq/journalInfo') R(ref)
	CROSS APPLY ref.nodes('./journalEmail') J(jm)
	INSERT INTO #journalEmail_journalInfoTable (journalId, journalInfo)
	SELECT id, xmlString
	FROM
	(
		SELECT CAST(stringVal AS XML) xmlString, id
		FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 6 --_CV_COMPONENT_TYPE_SUBCLIENT
		AND componentId=@subClientId
AND propertyTypeId = 1150 --_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
	) T
	WHERE xmlString.value('journalEmail[1]/user[1]/@userGUID', 'NVARCHAR(40)') = @journalGUID
	INSERT INTO #journalEmail_journalInfoTable (journalId, journalInfo)
	SELECT id, xmlString
	FROM
	(
		SELECT CAST(stringVal AS XML) xmlString, id
		FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 6 --_CV_COMPONENT_TYPE_SUBCLIENT
		AND componentId=@subClientId
AND propertyTypeId = 1150 --_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
	) T
	WHERE @journalGUID = ''
	IF NOT EXISTS (SELECT 1 FROM #journalEmail_journalInfoTable)
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Invalid input in request'
		GOTO ERROR_EXIT
	END
	SELECT @subClientName = subclientName
	FROM APP_Application (NOLOCK) WHERE id = @subClientId
ERROR_EXIT:
	IF @journalGUID = ''	--RETURN ALL THE JOURNAL EMAILS WITHOUT THE RECIPIENTS
	BEGIN
		SET @o_xmlString =
		(SELECT
			(SELECT
				(SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
				FOR XML PATH ('resp'), TYPE
				),
				IT.journalInfo.query('.'),
				(
					SELECT @subClientId '@subclientId', @subClientName '@subclientName'
					FOR XML PATH('subclientEntity'), TYPE
				)
				FROM #journalEmail_journalInfoTable IT
				FOR XML PATH('journals'), TYPE
			)
			FOR XML PATH(''), ROOT('Ida_JuornalRecipientsResp')
		)
	END
	ELSE
	BEGIN
		SET @o_xmlString =
		(SELECT
			(SELECT
				(SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
				FOR XML PATH ('resp'), TYPE
				),
				IT.journalInfo.query('.'),
				(
					SELECT @subClientId '@subclientId', @subClientName '@subclientName'
					FOR XML PATH('subclientEntity'), TYPE
				),
				(
					SELECT CAST(stringVal AS XML)
					FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 11 --_CV_COMPONENT_TYPE_JOURNAL_EMAILS
					AND componentId=IT.journalId
AND propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
					FOR XML PATH(''), TYPE
				)
				FROM #journalEmail_journalInfoTable IT
				FOR XML PATH('journals'), TYPE
			)
			FOR XML PATH(''), ROOT('Ida_JuornalRecipientsResp')
		)
	END
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<Ida_JuornalRecipientsResp/>'
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#journalEmail_journalInfoTable') is not null
		DROP TABLE #journalEmail_journalInfoTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppJournalGetRecipientsInfo')
	delete from GxQscripts where name = 'AppJournalGetRecipientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJournalGetRecipientsInfo')
	delete from GXDBVersions where aliasname = 'AppJournalGetRecipientsInfo'
GO

insert into GXDBVersions values(2, 'AppJournalGetRecipientsInfo',  '00010001000400060000', 'AppJournalGetRecipientsInfo', '00010001000400060000')
GO

