

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppJournalDeleteRecipientsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppJournalDeleteRecipientsInfo						|
--	|			Procedure for deleting a journal email info				|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppJournalDeleteRecipientsInfo <<<'

IF EXISTS (select * from sysobjects where name='AppJournalDeleteRecipientsInfo')
	drop procedure AppJournalDeleteRecipientsInfo
IF EXISTS (select * from GxQscripts where name='AppJournalDeleteRecipientsInfo')
	delete from GxQscripts where name = 'AppJournalDeleteRecipientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJournalDeleteRecipientsInfo')
	delete from GXDBVersions where aliasname = 'AppJournalDeleteRecipientsInfo'
GO
print '... Creating Procedure: AppJournalDeleteRecipientsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppJournalDeleteRecipientsInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GETDATE())
	DECLARE @journalGUID		NVARCHAR(40) = ''
	DECLARE @journalId			INT = 0
	DECLARE @subClientId		INT = 0
	DECLARE @userId				INT = (SELECT TOP 1 id FROM UMUsers (NOLOCK) WHERE flags&0x40=0x40)
	DECLARE @localeId			INT = 0
	-- READ THE XML
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
			FROM    @i_xmlString.nodes('Ida_RemoveJuornalRecipientsReq/processinginstructioninfo/user') R ( ref )), @userId)
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @i_xmlString.nodes('Ida_RemoveJuornalRecipientsReq/processinginstructioninfo/locale') R ( ref )), @localeId)
	SET @subClientId = ISNULL((SELECT  ref.value('@subclientId', 'int')
			FROM    @i_xmlString.nodes('Ida_RemoveJuornalRecipientsReq/journalInfo/subclientEntity') R ( ref )), 0)
	IF object_id('tempdb.dbo.#journalEmail_userEmailsTable') is not null
		DROP TABLE #journalEmail_userEmailsTable
	CREATE TABLE #journalEmail_userEmailsTable
		(userGUID NVARCHAR(40))
	CREATE CLUSTERED INDEX #journalEmail_userEmailsTable_userGuid_Index1 ON #journalEmail_userEmailsTable ([userGUID])
	SELECT @journalGUID = jm.value('user[1]/@userGUID', 'NVARCHAR(40)')
	FROM    @i_xmlString.nodes('Ida_RemoveJuornalRecipientsReq/journalInfo') R(ref)
	CROSS APPLY ref.nodes('./journalEmail') J(jm)
	SELECT @journalId = id
	FROM
	(
		SELECT CAST(stringVal AS XML) xmlString, id
		FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 6 --_CV_COMPONENT_TYPE_SUBCLIENT
		AND componentId=@subClientId
AND propertyTypeId = 1150 --_CV_COMPONENT_EXONEPASS_JOURNAL_MAILBOX
	) T
	WHERE xmlString.value('journalEmail[1]/user[1]/@userGUID', 'NVARCHAR(40)') = @journalGUID
	IF @journalId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Journal GUID [' + @journalGUID + '] not found in table'
		GOTO ERROR_EXIT
	END
	INSERT #journalEmail_userEmailsTable (userGUID)
	SELECT um.value('user[1]/@userGUID', 'NVARCHAR(40)') userGUID
	FROM    @i_xmlString.nodes('Ida_RemoveJuornalRecipientsReq/journalInfo') R(ref)
	CROSS APPLY ref.nodes('./recipients') M(um)
	BEGIN TRAN
		IF EXISTS(SELECT 1 FROM #journalEmail_userEmailsTable)
		BEGIN
			DELETE APP_ComponentProp
			WHERE id IN
			(
				SELECT id
				FROM
				(
					SELECT id, xmlString.value('recipients[1]/user[1]/@userGUID', 'NVARCHAR(40)') emailGUID
					FROM
					(
						SELECT id, CAST(stringVal AS XML) xmlString
						FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 11 --_CV_COMPONENT_TYPE_JOURNAL_EMAILS
						AND componentId=@journalId
AND propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
					) T
				) E
				JOIN #journalEmail_userEmailsTable ET ON ET.userGUID = emailGUID
			)
		END
		ELSE
		BEGIN
			DELETE APP_ComponentProp
			WHERE id IN
			(
				SELECT id
				FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 11 --_CV_COMPONENT_TYPE_JOURNAL_EMAILS
				AND componentId=@journalId
AND propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
			)
		END
		SET @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
		DELETE APP_ComponentProp
		WHERE id = @journalId
		AND NOT
		EXISTS(	SELECT id
					FROM APP_ComponentProp (NOLOCK)
WHERE  componentType = 11 --_CV_COMPONENT_TYPE_JOURNAL_EMAILS
					AND componentId=@journalId
AND propertyTypeId = 1151 --_CV_COMPONENT_EXONEPASS_USER_MAILBOX
		)
		SET @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('Ida_GenericResp'), TYPE)
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#journalEmail_userEmailsTable') is not null
		DROP TABLE #journalEmail_userEmailsTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppJournalDeleteRecipientsInfo')
	delete from GxQscripts where name = 'AppJournalDeleteRecipientsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJournalDeleteRecipientsInfo')
	delete from GXDBVersions where aliasname = 'AppJournalDeleteRecipientsInfo'
GO

insert into GXDBVersions values(2, 'AppJournalDeleteRecipientsInfo',  '00000000000000000000', 'AppJournalDeleteRecipientsInfo', '00000000000000000000')
GO

