

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppJobDetailUpdateSubscription.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppJobDetailUpdateSubscription.sp,v $ $Id: AppJobDetailUpdateSubscription.sp,v 1.1.2.1 2018/08/13 14:57:37 mnatarajan Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  AppJobDetailUpdateSubscription()
--  |
--  | Description:  Updates entityId list in job detail subscription.
--  |
--  |       Input:
--	|
--	|
--  |      Output:
--  |      Return:
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1		   Madhusudhanan N
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppJobDetailUpdateSubscription <<<'

IF EXISTS (select * from sysobjects where name='AppJobDetailUpdateSubscription')
	drop procedure AppJobDetailUpdateSubscription
IF EXISTS (select * from GxQscripts where name='AppJobDetailUpdateSubscription')
	delete from GxQscripts where name = 'AppJobDetailUpdateSubscription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJobDetailUpdateSubscription')
	delete from GXDBVersions where aliasname = 'AppJobDetailUpdateSubscription'
GO
print '... Creating Procedure: AppJobDetailUpdateSubscription'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppJobDetailUpdateSubscription
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @subscriptionId Integer,
  @jobListXml XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_errCode INTEGER = 0
DECLARE @o_errString NVARCHAR(1024) = ''
DECLARE @startTranHere INTEGER = 0
BEGIN TRY
	IF @@TRANCOUNT=0
	BEGIN
		BEGIN TRAN
		SET @startTranHere = 1
	END
	DECLARE @jobIdsList XML
	SET @jobIdsList = ( SELECT x.value('@val','int') '@val'FROM @jobListXml.nodes('TMMsg_CreateTaskResp/jobIds') J(x)
	FOR XML PATH('entityIds')
	)
	UPDATE App_NotificationSubscription
	SET filter.modify('insert sql:variable ("@jobIdsList") into (/Api_NotificationFilter/filterIds)[1]')
	WHERE subscriptionId = @subscriptionId AND Type = 0 AND filter.value('(Api_NotificationFilter/@subType)[1]', 'int') = 14  -- job subscription type and job detail subscription sub type.
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     SET @o_errCode = 1
 END CATCH
END_SP:
IF (@startTranHere=1)
BEGIN
	IF @o_errCode = 0
	BEGIN
		COMMIT TRAN
	END
	ELSE
	BEGIN
		ROLLBACK TRAN
	END
END
DECLARE @xmlOutput XML
SET @xmlOutput = ( SELECT	@o_errCode '@errorCode' ,@o_errString '@errorMessage'
FOR XML PATH('Api_GenericResp') )
SELECT @xmlOutput AS o_responseXML
GO

IF EXISTS (select * from GxQscripts where name = 'AppJobDetailUpdateSubscription')
	delete from GxQscripts where name = 'AppJobDetailUpdateSubscription'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppJobDetailUpdateSubscription')
	delete from GXDBVersions where aliasname = 'AppJobDetailUpdateSubscription'
GO

insert into GXDBVersions values(2, 'AppJobDetailUpdateSubscription',  '00010001000200010000', 'AppJobDetailUpdateSubscription', '00010001000200010000')
GO

