

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsSyncClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppIsSyncClient								|
--	|  Procedure to check if sync is active on a client	|
--	+=======================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIsSyncClient <<<'

IF EXISTS (select * from sysobjects where name='AppIsSyncClient')
	drop procedure AppIsSyncClient
IF EXISTS (select * from GxQscripts where name='AppIsSyncClient')
	delete from GxQscripts where name = 'AppIsSyncClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsSyncClient')
	delete from GXDBVersions where aliasname = 'AppIsSyncClient'
GO
print '... Creating Procedure: AppIsSyncClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsSyncClient
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inClientId INT
-----------------------------------------------------------
AS
  DECLARE @outIsSyncClient INT
SET NOCOUNT ON
BEGIN
	IF EXISTS (SELECT 1 FROM App_SyncCloudConfig CONF
			   INNER JOIN App_SyncCloudFolder SYNC ON SYNC.syncWebFolderId = CONF.syncWebFolderId
			   WHERE CONF.flag & 1 = 0 AND SYNC.flag & 1 = 0
			   AND CONF.syncType & 1 = 0
			   AND CONF.clientId = @inClientId)
		SET @outIsSyncClient = 1
	SELECT @outIsSyncClient
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsSyncClient')
	delete from GxQscripts where name = 'AppIsSyncClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsSyncClient')
	delete from GXDBVersions where aliasname = 'AppIsSyncClient'
GO

insert into GXDBVersions values(2, 'AppIsSyncClient',  '00000000000000000000', 'AppIsSyncClient', '00000000000000000000')
GO

