

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsSubclientApplicableForPlanProcessing.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppIsSubclientApplicableForPlanProcessing
--  | Description:  Check if backup plan can be applied to subclient
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIsSubclientApplicableForPlanProcessing.sp,v $ $Id: AppIsSubclientApplicableForPlanProcessing.sp,v 1.1.2.3.4.1 2021/02/04 07:37:06 alakra Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppIsSubclientApplicableForPlanProcessing')
BEGIN
	print '>>> Drop Stored Procedure: AppIsSubclientApplicableForPlanProcessing <<<'
	drop procedure AppIsSubclientApplicableForPlanProcessing
END
IF EXISTS (select * from GxQscripts where name='AppIsSubclientApplicableForPlanProcessing')
	delete from GxQscripts where name = 'AppIsSubclientApplicableForPlanProcessing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsSubclientApplicableForPlanProcessing')
	delete from GXDBVersions where aliasname = 'AppIsSubclientApplicableForPlanProcessing'
GO
print '... Creating Procedure: AppIsSubclientApplicableForPlanProcessing'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppIsSubclientApplicableForPlanProcessing
  @subclientId INT OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @canProcessBackupPlan INT
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
DECLARE @subclientStatusNotAllowed INT = CAST(0x00004 AS INT) | CAST(0x200000 AS INT) | CAST(0x00010 AS INT) | CAST(0x00020 AS INT) | CAST(0x2000 AS INT)
    SELECT @canProcessBackupPlan=1
	FROM APP_Application AAP WITH(NOLOCK)
    INNER JOIN APP_CLIENT C WITH(NOLOCK)
ON C.id = AAP.clientId AND C.status & 0x1000 = 0
    LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK)
        ON ASCP.componentNameId=AAP.id AND ASCP.attrName IN ('Turbo Mode Enable Stubbing', 'DDB Backup', 'Index SubClient') AND ASCP.modified=0 AND ASCP.attrval='1'
            AND ASCP.cs_attrName IN (CHECKSUM(N'Turbo Mode Enable Stubbing'), CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
    LEFT OUTER JOIN APP_ClientProp ACP  WITH(NOLOCK)
        ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.modified=0
    LEFT OUTER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
        ON ABP.componentNameId=AAP.backupSet AND ABP.attrName='Is Archiving Enabled' AND ABP.modified=0 AND ABP.attrval='1'
	LEFT OUTER JOIN APP_ClientProp ACP_NFSObjectStore WITH(NOLOCK)
		ON ACP_NFSObjectStore.componentNameId=C.id AND ACP_NFSObjectStore.attrName='System Drive Type' AND ACP_NFSObjectStore.modified=0 AND ACP_NFSObjectStore.attrval='4'
    WHERE AAP.id=@subclientId
    AND AAP.subclientStatus & @subclientStatusNotAllowed=0
    AND AAP.subclientName NOT IN ('IndexBackup', 'IndexingSubclient', 'DDBbackup', 'System State', 'CvFailoverLogShipping')
AND AAP.appTypeId NOT IN (1000)
    AND ASCP.id IS NULL
    AND ACP.id IS NULL
    AND ABP.id IS NULL
AND ((C.status & 0x10000000 = 0) OR (ACP_NFSObjectStore.id IS NOT NULL))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @errorCode = 1205  --DEADLOCK error
    BEGIN
        ;THROW;   -- rethrow the DEADLOCK so XE captures.
    END
END CATCH
SCRIPT_EXIT:
SELECT @canProcessBackupPlan, @errorCode, @errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsSubclientApplicableForPlanProcessing')
	delete from GxQscripts where name = 'AppIsSubclientApplicableForPlanProcessing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsSubclientApplicableForPlanProcessing')
	delete from GXDBVersions where aliasname = 'AppIsSubclientApplicableForPlanProcessing'
GO

insert into GXDBVersions values(2, 'AppIsSubclientApplicableForPlanProcessing',  'v1.1.2.3.4.1', 'AppIsSubclientApplicableForPlanProcessing', 'v1.1.2.3.4.1')
GO

