

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsPostgresPortInUse.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppIsPostgresPortInUse						|
--	|  Procedure to check if PostgreSQL port already in use on a client		|
--	+=======================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIsPostgresPortInUse <<<'

IF EXISTS (select * from sysobjects where name='AppIsPostgresPortInUse')
	drop procedure AppIsPostgresPortInUse
IF EXISTS (select * from GxQscripts where name='AppIsPostgresPortInUse')
	delete from GxQscripts where name = 'AppIsPostgresPortInUse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsPostgresPortInUse')
	delete from GXDBVersions where aliasname = 'AppIsPostgresPortInUse'
GO
print '... Creating Procedure: AppIsPostgresPortInUse'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsPostgresPortInUse
  @inClientId INT,
  @inPort VARCHAR(MAX)
AS
  DECLARE @portInUse INT
SET NOCOUNT ON
BEGIN
	SET @portInUse = ISNULL( (SELECT DISTINCT 1 FROM APP_InstanceProp WITH (NOLOCK) WHERE attrName = 'PostgreSQL Port' AND attrVal = @inPort AND componentNameId IN
							(SELECT DISTINCT instance FROM APP_Application WITH (NOLOCK) WHERE clientId = @inClientId)), 0)
	SELECT @portInUse
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsPostgresPortInUse')
	delete from GxQscripts where name = 'AppIsPostgresPortInUse'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsPostgresPortInUse')
	delete from GXDBVersions where aliasname = 'AppIsPostgresPortInUse'
GO

insert into GXDBVersions values(2, 'AppIsPostgresPortInUse',  '00000000000000000000', 'AppIsPostgresPortInUse', '00000000000000000000')
GO

