

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsOlderOrUpgradedClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIsOlderOrUpgradedClient.sp,v $ $Id: AppIsOlderOrUpgradedClient.sp,v 1.2.180.2 2018/03/22 01:45:08 jiechen Exp $";
SET NOCOUNT ON
-- ---------------------------------------------------------------------------
--	AppGetClientUpgradeTime takes releaseId and clientId as input parameter.
--	It returns oupgradeTime if client is less than releaseID OR client is upgraded to releaseID
--	Example: releaseID is 15(10.0), if client is a 9.0 client then it returns oupgradeTime as install time.
--				If 9.0 client is upgraded to 10.0 then it returns oupgradeTime with the time it was upgraded to 10.0
--				It it is 10.0 client then it returns error 1.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIsOlderOrUpgradedClient <<<'

IF EXISTS (select * from sysobjects where name='AppIsOlderOrUpgradedClient')
	drop procedure AppIsOlderOrUpgradedClient
IF EXISTS (select * from GxQscripts where name='AppIsOlderOrUpgradedClient')
	delete from GxQscripts where name = 'AppIsOlderOrUpgradedClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsOlderOrUpgradedClient')
	delete from GXDBVersions where aliasname = 'AppIsOlderOrUpgradedClient'
GO
print '... Creating Procedure: AppIsOlderOrUpgradedClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsOlderOrUpgradedClient
  @releaseID INT,
  @clientId INT
AS
  DECLARE @errorCode INT	= 0
  DECLARE @errorString VARCHAR(MAX) = 'Success'
  DECLARE @oupgradeTime INT = 0
DECLARE @oldInstallTime AS DATETIME = ISNULL((SELECT MIN(createTimeUTC) FROM LicUsageHistory WITH (NOLOCK) WHERE CId = @clientID AND LicType <> 71 AND ReleaseId < @releaseID), 0)
DECLARE @upgradeTime AS DATETIME = ISNULL((SELECT MIN(createTimeUTC) FROM LicUsageHistory WITH (NOLOCK) WHERE CId = @clientID AND LicType <> 71 AND ReleaseId >= @releaseID), 0)
IF @oldInstallTime = 0 AND @upgradeTime = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Client install time is not available.'
	END
ELSE IF @oldInstallTime = 0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Client is not an upgraded client.'
	END
ELSE IF @upgradeTime = 0
	BEGIN
		SET @oupgradeTime = dbo.GetUnixTime (@oldInstallTime)
		SET @errorCode = 3
		SET @errorString = 'Client is a older than [' + CAST( @releaseID AS VARCHAR(MAX))  + '].'
	END
ELSE
	BEGIN
		SET @errorCode = 4
		SET @oupgradeTime = dbo.GetUnixTime (@upgradeTime)
	END
SELECT @errorCode errorCode, @errorString errorString, @oupgradeTime oupgradeTime
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsOlderOrUpgradedClient')
	delete from GxQscripts where name = 'AppIsOlderOrUpgradedClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsOlderOrUpgradedClient')
	delete from GXDBVersions where aliasname = 'AppIsOlderOrUpgradedClient'
GO

insert into GXDBVersions values(2, 'AppIsOlderOrUpgradedClient',  '00010002018000020000', 'AppIsOlderOrUpgradedClient', '00010002018000020000')
GO

