

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsLSConfiguredClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Procedure: AppIsLSConfiguredClient
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        jswaminathan      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIsLSConfiguredClient <<<'

IF EXISTS (select * from sysobjects where name='AppIsLSConfiguredClient')
	drop procedure AppIsLSConfiguredClient
IF EXISTS (select * from GxQscripts where name='AppIsLSConfiguredClient')
	delete from GxQscripts where name = 'AppIsLSConfiguredClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsLSConfiguredClient')
	delete from GXDBVersions where aliasname = 'AppIsLSConfiguredClient'
GO
print '... Creating Procedure: AppIsLSConfiguredClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsLSConfiguredClient
  @clientId INT
AS
  DECLARE @LSMAStatus integer
SET @LSMAStatus = 0		--default
--1. Check whether the client has the flag LS Configured MA set
declare @attribute as int
set @attribute = ISNULL((select attribute & 4096 from MMHost where clientId = @clientId),0)
if @attribute = 4096
set @LSMAStatus |= 1
--If the client is a LS MA, then exit
if(@LSMAStatus = 0)
begin
		--check whether it is a CS
		declare @cclId as int = 0
		set @cclId = ISNULL((select id from App_Commcell where clientId = @clientId),0)
		--check whether it has a MA configured client
		if @cclId <> 0
		begin
			declare @temptbl table
			(
				clientid  int,
				isLSMA  int
			)
			insert into @temptbl (clientId,isLSMA )
select distinct cli.id,mm.attribute & 4096
			from App_Client as cli inner join MMHost as mm
			on mm.clientId = cli.id
			where cli.origCCId = @cclId
			declare @isCShavingLSMA as int = 0
			set @isCShavingLSMA = isnull((select MAX(isLSMA) from @temptbl),0)
			if(@isCShavingLSMA <> 0)
SET @LSMAStatus |= 2
		end
end
select @LSMAStatus
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsLSConfiguredClient')
	delete from GxQscripts where name = 'AppIsLSConfiguredClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsLSConfiguredClient')
	delete from GXDBVersions where aliasname = 'AppIsLSConfiguredClient'
GO

insert into GXDBVersions values(2, 'AppIsLSConfiguredClient',  '00000000000000000000', 'AppIsLSConfiguredClient', '00000000000000000000')
GO

