

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsEntityApplicableForIndexingSetup.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIsEntityApplicableForIndexingSetup.sp,v $ $Id: AppIsEntityApplicableForIndexingSetup.sp,v 1.1.2.5 2019/11/08 07:46:11 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppIsEntityApplicableForIndexingSetup')
BEGIN
	print '>>> Drop Stored Procedure: AppIsEntityApplicableForIndexingSetup <<<'
	drop procedure AppIsEntityApplicableForIndexingSetup
END
IF EXISTS (select * from GxQscripts where name='AppIsEntityApplicableForIndexingSetup')
	delete from GxQscripts where name = 'AppIsEntityApplicableForIndexingSetup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsEntityApplicableForIndexingSetup')
	delete from GXDBVersions where aliasname = 'AppIsEntityApplicableForIndexingSetup'
GO
print '... Creating Procedure: AppIsEntityApplicableForIndexingSetup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsEntityApplicableForIndexingSetup
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_subclientId INTEGER,
  @i_backupsetId INTEGER,
  @i_xmlRequest XML,
  @o_isOperationApplicable INTEGER OUTPUT,
  @o_appType INTEGER OUTPUT,
  @o_clientId INTEGER OUTPUT,
  @o_planId INTEGER OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
SET @o_errCode = 0
SET @o_errString = 'Success'
SET @o_isOperationApplicable = 0
SET @o_clientId = 0
SET @o_appType = 0
DECLARE @vendorId INT = 0
-- No change
IF (@i_subclientId = 0)
BEGIN
	SET @i_subclientId = ISNULL(@i_xmlRequest.value('(//./subClientProperties/subClientEntity/@subclientId)[1]','INT'), 0)
END
IF (@i_backupsetId = 0)
BEGIN
	SET @i_backupsetId = ISNULL(@i_xmlRequest.value('(//./backupsetProperties/backupSetEntity/@backupsetId)[1]','INT'), 0)
END
DECLARE @i_clientId				INTEGER = ISNULL(@i_xmlRequest.value('(//./subClientProperties/subClientEntity/@clientId)[1]','INT'),
													ISNULL(@i_xmlRequest.value('(//./backupsetProperties/backupSetEntity/@clientId)[1]','INT'),
														ISNULL(@i_xmlRequest.value('(//./backupSetInfo/backupSetEntity/@clientId)[1]','INT'), 0)))
DECLARE @i_appType				INTEGER = ISNULL(@i_xmlRequest.value('(//./subClientProperties/subClientEntity/@applicationId)[1]','INT'),
													ISNULL(@i_xmlRequest.value('(//./backupsetProperties/backupSetEntity/@applicationId)[1]','INT'),
													ISNULL(@i_xmlRequest.value('(//./backupSetInfo/backupSetEntity/@applicationId)[1]','INT'), 0)))
DECLARE @i_instanceId			INTEGER = ISNULL(@i_xmlRequest.value('(//./subClientProperties/subClientEntity/@instanceId)[1]','INT'),
												ISNULL(@i_xmlRequest.value('(//./backupsetProperties/backupSetEntity/@instanceId)[1]','INT'),
												ISNULL(@i_xmlRequest.value('(//./backupSetInfo/backupSetEntity/@instanceId)[1]','INT'),0)))
SET @o_planId = ISNULL(@i_xmlRequest.value('(//./subClientProperties/planEntity/@planId)[1]','INT'),
												ISNULL(@i_xmlRequest.value('(//./backupsetProperties/planEntity/@planId)[1]','INT'),
												ISNULL(@i_xmlRequest.value('(//./backupSetInfo/planEntity/@planId)[1]','INT'), 0)))
IF @i_subclientId > 0
BEGIN
	 SELECT @i_appType=AAP.appTypeId, @o_clientId=AAP.clientId, @vendorId=ISNULL(dbo.MapVSVendorId(CAST(AIP.attrVal AS INT), -1), 0)
		FROM APP_Application AAP  WITH(NOLOCK)
			LEFT OUTER JOIN APP_InstanceProp AIP  WITH(NOLOCK)
                ON AIP.componentNameId = AAP.instance AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified = 0
		WHERE AAP.id = @i_subclientId
END
ELSE IF (@i_backupsetId > 0)
BEGIN
	SELECT @i_appType=AAP.appTypeId, @o_clientId=AAP.clientId, @vendorId=ISNULL(dbo.MapVSVendorId(CAST(AIP.attrVal AS INT), -1), 0)
		FROM APP_Application AAP  WITH(NOLOCK)
			LEFT OUTER JOIN APP_InstanceProp AIP  WITH(NOLOCK)
                ON AIP.componentNameId = AAP.instance AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified = 0
WHERE AAP.backupSet = @i_backupsetId AND AAP.subclientStatus&0x00008<>0
END
ELSE IF ((@i_instanceId > 0) AND (@i_appType = 106))
BEGIN
		SELECT @vendorId=ISNULL(dbo.MapVSVendorId(CAST(AIP.attrVal AS INT), -1), 0) FROM
	    APP_InstanceProp AIP  WITH(NOLOCK)
		WHERE AIP.componentNameId = @i_instanceId AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified = 0
END
ELSE IF ((@i_clientId > 0) AND (@i_appType > 0))
BEGIN
	SET @o_clientId = @i_clientId
END
ELSE
BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @o_errString = REPLACE(@o_errString, '^1%s', 'Generic')
END
IF @o_errCode = 0
BEGIN
	SET @o_appType = @i_appType
	-- VSA entity type  is not supported via this route now
	IF(@i_appType=106)
	BEGIN
		-- Set true only if apptype is 106 and vendor is one of the above
		SET @o_isOperationApplicable = 0
	END
	-- Now check for FS IDA. We need to have plan to allow anything for FS Agents
	IF EXISTS(SELECT 1 FROM APP_AppTypeGroupAssoc WITH(NOLOCK) WHERE appGroupId=35 AND appTypeId=@i_appType)
AND EXISTS(SELECT 1 FROM APP_Plan WITH(NOLOCK) WHERE id=@o_planId AND subtype=33554437)
	BEGIN
		-- Try to check if Enable Indexing is Set to TRUE for this plan
DECLARE @enableIndexing INTEGER = ISNULL(dbo.AppPlanGetEntityValue(@o_planId, 'Enable Indexing', default), 0)
		-- After that, we have to check if Index server is set or not.
DECLARE @indexServer INTEGER = ISNULL(dbo.AppPlanGetEntityValue(@o_planId, 'Analytics Index Server Id', default), 0)
		-- In case of enableIndexing is 1 and no index server being present, then we have to create index server
		IF ((@enableIndexing = 1) AND (@indexServer = 0))
		BEGIN
			-- Set true as Indexing is enabled for plan and
			SET @o_isOperationApplicable = 1
		END
	END
END
RETURN
ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsEntityApplicableForIndexingSetup')
	delete from GxQscripts where name = 'AppIsEntityApplicableForIndexingSetup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsEntityApplicableForIndexingSetup')
	delete from GXDBVersions where aliasname = 'AppIsEntityApplicableForIndexingSetup'
GO

insert into GXDBVersions values(2, 'AppIsEntityApplicableForIndexingSetup',  '00010001000200050000', 'AppIsEntityApplicableForIndexingSetup', '00010001000200050000')
GO

