

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsDeletedCompanyRetireClientComplete.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "AppIsDeletedCompanyRetireClientComplete"
--  |   Description: Stored procedure to check whether retire client of deleted company is complete
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppIsDeletedCompanyRetireClientComplete')
BEGIN
	print '>>> Drop Stored Procedure: AppIsDeletedCompanyRetireClientComplete <<<'
	drop procedure AppIsDeletedCompanyRetireClientComplete
END
IF EXISTS (select * from GxQscripts where name='AppIsDeletedCompanyRetireClientComplete')
	delete from GxQscripts where name = 'AppIsDeletedCompanyRetireClientComplete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsDeletedCompanyRetireClientComplete')
	delete from GXDBVersions where aliasname = 'AppIsDeletedCompanyRetireClientComplete'
GO
print '... Creating Procedure: AppIsDeletedCompanyRetireClientComplete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsDeletedCompanyRetireClientComplete
  @companyId INTEGER
AS
  DECLARE @r_IsRetireClientComplete INTEGER
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET @r_IsRetireClientComplete = 0
DECLARE @c_flags INT = 0
SELECT @c_flags = flags FROM UMDSProviders WHERE id = @companyId AND enabled=0
DECLARE @RowCount       integer = 0
IF  @c_flags & 0x0002 = 0x0002
BEGIN
	SELECT   @RowCount = count(*)
	FROM App_CompanyEntities App
	INNER JOIN APP_Client C
	ON C.id = App.entityId
	WHERE companyId = @companyId AND
entityType = 3 AND
App.flags & 0x4 = 0     -- skip checking of entities which are not supposed to be deleted
	IF @RowCount = 0
	BEGIN
		SET @r_IsRetireClientComplete = 1
	END
END
SELECT @r_IsRetireClientComplete as 'r_IsRetireClientComplete'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsDeletedCompanyRetireClientComplete')
	delete from GxQscripts where name = 'AppIsDeletedCompanyRetireClientComplete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsDeletedCompanyRetireClientComplete')
	delete from GXDBVersions where aliasname = 'AppIsDeletedCompanyRetireClientComplete'
GO

insert into GXDBVersions values(2, 'AppIsDeletedCompanyRetireClientComplete',  '00000000000000000000', 'AppIsDeletedCompanyRetireClientComplete', '00000000000000000000')
GO

