

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsClientApplicableForIndexingSetupEx.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIsClientApplicableForIndexingSetupEx.sp,v $ $Id: AppIsClientApplicableForIndexingSetupEx.sp,v 1.1.4.3 2018/10/19 15:43:08 alakra Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppIsClientApplicableForIndexingSetupEx')
BEGIN
	print '>>> Drop Stored Procedure: AppIsClientApplicableForIndexingSetupEx <<<'
	drop procedure AppIsClientApplicableForIndexingSetupEx
END
IF EXISTS (select * from GxQscripts where name='AppIsClientApplicableForIndexingSetupEx')
	delete from GxQscripts where name = 'AppIsClientApplicableForIndexingSetupEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsClientApplicableForIndexingSetupEx')
	delete from GXDBVersions where aliasname = 'AppIsClientApplicableForIndexingSetupEx'
GO
print '... Creating Procedure: AppIsClientApplicableForIndexingSetupEx'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsClientApplicableForIndexingSetupEx
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_clientId INTEGER,
  @o_planId INTEGER			OUTPUT,
  @o_planName NVARCHAR(1024)	OUTPUT,
  @o_planOwnerId INTEGER			OUTPUT,
  @o_mediaAgentId INTEGER			OUTPUT,
  @o_isMAHavePackages INTEGER			OUTPUT,
  @o_dcPlanId INTEGER			OUTPUT,
  @o_errCode INTEGER			OUTPUT,
  @o_errString NVARCHAR(1024)	OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @o_errCode = 0
SET @o_errString = 'Success'
SET @o_planId = 0
IF (@i_clientId > 0)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#idaClientList') IS NOT NULL DROP TABLE #idaClientList
	CREATE TABLE #idaClientList
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#idaClientList'
	IF EXISTS (SELECT 1 FROM #idaClientList WHERE t_clientId=@i_clientId)
	BEGIN
		-- Get All Instances for this client which lies in our criteria
		SELECT TOP 1 @o_planId=AP.id, @o_planName=AP.name, @o_planOwnerId= AP.ownerId FROM APP_Application AAP WITH(NOLOCK)
		INNER JOIN APP_SubClientProp ASCP WITH(NOLOCK)
ON ASCP.componentNameId=AAP.id AND ASCP.attrName='Associated Plan' AND ASCP.modified=0
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON CAST(AP.id AS NVARCHAR(64))=ASCP.attrVal AND AP.subType=33554437
		WHERE AAP.clientId=@i_clientId AND AAP.appTypeId=106
AND AAP.appTypeId NOT IN (1000, 1030) AND (AAP.subclientStatus&0x0200 = 0) AND (AAP.subclientStatus&0x00004 = 0)  AND (AAP.subclientStatus&0x00002 = 0)
	END
	ELSE
	BEGIN
SET @o_errCode =  (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
        SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @o_errCode AND [localeId] = @i_localeId)
		GOTO ERROR_EXIT
	END
END
ELSE
BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @o_errString = REPLACE(@o_errString, '^1%s', 'Generic')
	GOTO ERROR_EXIT
END
-- VSA entity type and supported vendors
IF(@o_planId IS NULL OR @o_planId=0)
BEGIN
SET @o_errCode = (3802 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (3802 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
END
ELSE
BEGIN
	-- Let's check if there is associated DC plan for the server plan
	SELECT @o_dcPlanId=AP.id FROM APP_PlanProp APP
			INNER JOIN App_Plan AP
ON CAST(AP.id AS NVARCHAR(64))=APP.attrVal AND APP.modified=0 AND AP.subtype=117506053
WHERE componentNameId=@o_planId AND APP.attrname='Default Data classification Plan'
	-- If we have DC plan id, then no need to get MA client ID
	IF (@o_dcPlanId = 0)
	BEGIN
DECLARE @storagePolicyId   INT = dbo.AppPlanGetEntityValue(@o_planId, 'Storage policy',  default)
		DECLARE @count INT = 0
		-- Now get MA Client ID from this Storage Policy
		-- So, we will get MA with maximum packages installed here
SELECT	TOP 1 @o_mediaAgentId=DPool.ClientId, @count= ( SELECT COUNT(*) FROM simInstalledPackages WITH(READUNCOMMITTED) WHERE simInstalledPackages.ClientId=DPool.ClientId AND simPackageID IN (55,263,725) )
		FROM	ArchGroup AG WITH(READUNCOMMITTED),
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED),
				App_Client AC  WITH(READUNCOMMITTED),
				simOperatingSystem SIM  WITH(READUNCOMMITTED)
		WHERE	AG.id = @storagePolicyId
				AND AG.defaultCopy = DPath.CopyId
				AND DPath.DrivePoolId = DPool.DrivePoolId
				AND AC.id=DPool.ClientId
				AND SIM.id=Ac.simOperatingSystemId AND SIM.Type='Windows'
		ORDER BY 2 DESC
		-- Now for this MA, check if this one has all the required packages installed.
		IF @count = 3
		BEGIN
			SET @o_isMAHavePackages = 1
		END
		ELSE
		BEGIN
			SET @o_isMAHavePackages = 0
		END
	END
	ELSE
	BEGIN
		-- We don't need to honor anything with these values
		SET @o_mediaAgentId = 0
		SET @o_isMAHavePackages = 0
	END
END
ERROR_EXIT:
IF OBJECT_ID('tempdb.dbo.#idaClientList') IS NOT NULL DROP TABLE #idaClientList
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsClientApplicableForIndexingSetupEx')
	delete from GxQscripts where name = 'AppIsClientApplicableForIndexingSetupEx'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsClientApplicableForIndexingSetupEx')
	delete from GXDBVersions where aliasname = 'AppIsClientApplicableForIndexingSetupEx'
GO

insert into GXDBVersions values(2, 'AppIsClientApplicableForIndexingSetupEx',  '00010001000400030000', 'AppIsClientApplicableForIndexingSetupEx', '00010001000400030000')
GO

