

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsClientApplicableForIndexingSetup.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIsClientApplicableForIndexingSetup.sp,v $ $Id: AppIsClientApplicableForIndexingSetup.sp,v 1.1.4.3 2018/09/29 19:14:11 pshenoy Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIsClientApplicableForIndexingSetup <<<'

IF EXISTS (select * from sysobjects where name='AppIsClientApplicableForIndexingSetup')
	drop procedure AppIsClientApplicableForIndexingSetup
IF EXISTS (select * from GxQscripts where name='AppIsClientApplicableForIndexingSetup')
	delete from GxQscripts where name = 'AppIsClientApplicableForIndexingSetup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsClientApplicableForIndexingSetup')
	delete from GXDBVersions where aliasname = 'AppIsClientApplicableForIndexingSetup'
GO
print '... Creating Procedure: AppIsClientApplicableForIndexingSetup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsClientApplicableForIndexingSetup
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_subclientId INTEGER,
  @i_clientId INTEGER,
  @i_appType INTEGER,
  @i_instanceId INTEGER,
  @o_isOperationApplicable INTEGER OUTPUT,
  @o_clientId INTEGER OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
SET @o_errCode = 0
SET @o_errString = 'Success'
SET @o_isOperationApplicable = 0
SET @o_clientId = 0
DECLARE @vendorId INT = 0
-- definition. see http:--cvs.commvault.com/source/xref/win/vaultcx/Source/Common/XmlMessage/Common.x
DECLARE @X_NONE                             AS INT = 0
DECLARE @X_VMW                              AS INT = 1
DECLARE @X_MICROSOFT                        AS INT = 2
DECLARE @X_XEN_SERVER                       AS INT = 3
DECLARE @X_AMAZON                           AS INT = 4
DECLARE @X_AZURE                            AS INT = 5
DECLARE @X_REDHAT                           AS INT = 6
DECLARE @X_AZURE_V2                         AS INT = 7
DECLARE @X_SCVMM                            AS INT = 8
DECLARE @X_NUTANIX                          AS INT = 9
DECLARE @X_ORACLE_VM                        AS INT = 10
DECLARE @X_DOCKER                           AS INT = 11
DECLARE @X_OPENSTACK                        AS INT = 12
DECLARE @X_ORACLE_CLOUD                     AS INT = 13
DECLARE @X_FUSIONCOMPUTE                    AS INT = 14
DECLARE @X_VCLOUD                           AS INT = 15
DECLARE @X_GOOGLE_CLOUD                     AS INT = 16
DECLARE @X_AZURE_STACK                         AS INT = 17
DECLARE @X_ORACLE_CLOUD_INFRASTRUCTURE                     AS INT = 19
DECLARE @X_ALIBABA_CLOUD                    AS INT = 18
DECLARE @X_KUBERNETES                       AS INT = 20
DECLARE @X_REDHAT_OPENSHIFT                 AS INT = 21
IF @i_subclientId > 0
BEGIN
	 SELECT @i_appType=AAP.appTypeId, @o_clientId=AAP.clientId, @vendorId=ISNULL(dbo.MapVSVendorId(CAST(AIP.attrVal AS INT), -1), 0)
		FROM APP_Application AAP  WITH(NOLOCK)
			INNER JOIN APP_InstanceProp AIP  WITH(NOLOCK)
                ON AIP.componentNameId = AAP.instance AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified = 0
		WHERE AAP.id = @i_subclientId
END
ELSE IF ((@i_clientId > 0) AND (@i_instanceId > 0) AND (@i_appType > 0))
BEGIN
	SET @o_clientId = @i_clientId
	SELECT @vendorId=ISNULL(dbo.MapVSVendorId(CAST(AIP.attrVal AS INT), -1), 0) FROM
	    APP_InstanceProp AIP  WITH(NOLOCK)
		WHERE AIP.componentNameId = @i_instanceId AND AIP.attrName = 'Virtual Server Instance Type' AND AIP.modified = 0
END
ELSE
BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @o_errString = REPLACE(@o_errString, '^1%s', 'Generic')
END
-- VSA entity type and supported vendors
IF((@i_appType=106) AND ((@vendorId) IN (@X_AZURE_V2, @X_AMAZON, @X_AZURE_STACK)))
BEGIN
	-- Set true only if apptype is 106 and vendor is one of the above
	SET @o_isOperationApplicable = 1
END
RETURN
ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsClientApplicableForIndexingSetup')
	delete from GxQscripts where name = 'AppIsClientApplicableForIndexingSetup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsClientApplicableForIndexingSetup')
	delete from GXDBVersions where aliasname = 'AppIsClientApplicableForIndexingSetup'
GO

insert into GXDBVersions values(2, 'AppIsClientApplicableForIndexingSetup',  '00010001000400030000', 'AppIsClientApplicableForIndexingSetup', '00010001000400030000')
GO

