

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIsBackupsetContentMatch.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIsBackupsetContentMatch.sp,v $ $Id: AppIsBackupsetContentMatch.sp,v 1.6 2010/05/25 21:03:06 agupta Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppAddProps   - Add properties for the APP_SubClientProp table
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIsBackupsetContentMatch <<<'

IF EXISTS (select * from sysobjects where name='AppIsBackupsetContentMatch')
	drop procedure AppIsBackupsetContentMatch
IF EXISTS (select * from GxQscripts where name='AppIsBackupsetContentMatch')
	delete from GxQscripts where name = 'AppIsBackupsetContentMatch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsBackupsetContentMatch')
	delete from GXDBVersions where aliasname = 'AppIsBackupsetContentMatch'
GO
print '... Creating Procedure: AppIsBackupsetContentMatch'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIsBackupsetContentMatch
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_bsId integer,
  @browseTime1 integer,
  @browseTime2 integer
AS
SET NOCOUNT ON
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @appType int
DECLARE @diffCount INT
--CHECK IF THIS IS SUBCLIENT POLICY
SET @i_bsId = ISNULL((SELECT CAST([attrVal] AS INT) FROM [APP_BackupSetProp] WHERE [componentNameId] = @i_bsId AND [attrName] = 'Associated subclient Policy' AND modified = 0) , @i_bsId)
--GET THE APPTYPE OF BACKUPSET
SET @appType = (SELECT DISTINCT [appTypeId] FROM [APP_Application] WHERE [backupset] = @i_bsId)
--SWAP TIME SO THAT TIME2 IS ALWAYS BIGGER
IF (@browseTime1 > @browseTime2)
BEGIN
	DECLARE @temp INT
	SET @temp = @browseTime1
	SET @browseTime1 = @browseTime2
	SET @browseTime2 = @temp
END
--IF APPTYPE IS EXCHANGE WE WILL FETCH IT FROM SUBCLIENTPROP
IF @appType IN (8,14,54,67,68,45,56,57)
BEGIN
	SET @diffCount = (SELECT COUNT(*) FROM [APP_SubClientProp] WHERE [componentNameId] IN
	(SELECT id FROM [APP_Application] WHERE [backupSet] = @i_bsId) AND
	(( created > @browseTime1 AND created < @browseTime2) OR ( modified > @browseTime1 AND modified < @browseTime2 )) AND attrType = 111)
END
ELSE
IF @appType IN (106)
BEGIN
	SET @diffCount = (SELECT COUNT(*) FROM [APP_SubClientProp] WHERE [componentNameId] IN
	(SELECT id FROM [APP_Application] WHERE [backupSet] = @i_bsId) AND
	(( created > @browseTime1 AND created < @browseTime2) OR ( modified > @browseTime1 AND modified < @browseTime2 )) AND attrType = 121)
END
ELSE
IF @appType IN (107)
BEGIN
	SET @diffcount =  (SELECT COUNT(*) FROM [app_ScReplicationPair] WHERE [pairId] IN
	(SELECT id FROM [APP_Application] WHERE [backupSet] = @i_bsId) AND
	(( created > @browseTime1 AND created < @browseTime2) OR ( modified > @browseTime1 AND modified < @browseTime2 )))
END
ELSE
--FOR OTHER SUBCLIENTS
BEGIN
SET @diffcount =  (SELECT COUNT(*) FROM [APP_ScFilterFile] WHERE [componentNameId] IN
(SELECT id FROM [APP_Application] WHERE [backupSet] = @i_bsId) AND
(( created > @browseTime1 AND created < @browseTime2) OR ( modified > @browseTime1 AND modified < @browseTime2 )))
END
SET NOCOUNT OFF
SELECT @diffcount
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppIsBackupsetContentMatch')
	delete from GxQscripts where name = 'AppIsBackupsetContentMatch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIsBackupsetContentMatch')
	delete from GXDBVersions where aliasname = 'AppIsBackupsetContentMatch'
GO

insert into GXDBVersions values(2, 'AppIsBackupsetContentMatch',  '00010006000000000000', 'AppIsBackupsetContentMatch', '00010006000000000000')
GO

