

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppInviteUserEmailSettings.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCreateCompanyEmailSetting
--  | Description:  This procedure will be used while creating a company. This will get email related settings
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppInviteUserEmailSettings.sp,v $ $Id: AppInviteUserEmailSettings.sp,v 1.1.2.6 2020/04/30 22:28:29 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppInviteUserEmailSettings')
BEGIN
	print '>>> Drop Stored Procedure: AppInviteUserEmailSettings <<<'
	drop procedure AppInviteUserEmailSettings
END
IF EXISTS (select * from GxQscripts where name='AppInviteUserEmailSettings')
	delete from GxQscripts where name = 'AppInviteUserEmailSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInviteUserEmailSettings')
	delete from GXDBVersions where aliasname = 'AppInviteUserEmailSettings'
GO
print '... Creating Procedure: AppInviteUserEmailSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppInviteUserEmailSettings
  @i_UserEmail NVARCHAR(255),
  @i_isEmailForDownloadPackageOnly INT,
  @i_isSystemGeneratedUser INT,
  @i_initiatorId INT,
  @i_localeId INT
AS
  DECLARE @errorCode int
  DECLARE @InviteUserEmailSettings XML
SET @errorCode = 0
DECLARE @WebConsoleURL NVARCHAR(MAX)
DECLARE @encryptPwd nvarchar(800)
DECLARE @pwd nvarchar(255)
DECLARE @downloadURL nvarchar(max)
DECLARE @companyName NVARCHAR(255) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @companyName = (SELECT dbo.AppGetOrganizationNameForUser(@i_initiatorId))
DECLARE @templateTypeId int
 IF(@i_isEmailForDownloadPackageOnly = 1)
	SELECT @templateTypeId=typeId from App_EmailTemplateType where name='INVITE_AD_USER'
ELSE
	SELECT @templateTypeId=typeId from App_EmailTemplateType where name='INVITE_LOCAL_USER'
DECLARE @i_userId int = 0
SELECT @i_userId = id, @encryptPwd=password FROM umusers WHERE email=@i_UserEmail AND flags <>0
 IF(@i_isSystemGeneratedUser = 1)
 BEGIN
	EXEC miscProc2 @encryptPwd, @pwd OUTPUT
END
ELSE
BEGIN
	SET @pwd = 'Please contact your administrator for your password'
END
SELECT @WebConsoleURL=value FROM GXGlobalParam WHERE name='WebConsoleURL' and modified=0
SET @WebConsoleURL = (SELECT SUBSTRING(@webConsoleURL,1,(CHARINDEX('/webconsole',@webConsoleURL)-1))+'/webconsole')
DECLARE @passwordLink NVARCHAR(max) = ''
DECLARE @sessionid VARCHAR(255)
DECLARE @qsdkSessionId  VARCHAR(255)
DECLARE @sessionTable TABLE (errorCode       int, guidOut         VARCHAR(255))
DECLARE @timeoutInHoursMins nvarchar(50)=''
DECLARE @timeoutInMins int = ISNULL((SELECT CAST(value as int) from GXGlobalParam WITH (NOLOCK) WHERE name = 'ChangePasswordLinkExpirationTimeInMinutes'), 4320)--72 hours
IF(@i_isEmailForDownloadPackageOnly <> 1)
BEGIN
	SET @timeoutInHoursMins = (SELECT dbo.AppGetTimeOutFormatedString(@timeoutInMins, @i_localeId))
END
INSERT INTO @sessionTable
EXEC QSDK_CreateSession @sessionid,@i_userId, '',16, @timeoutInMins-- EC_API
IF((SELECT errorCode FROM @sessionTable) <> 0)
BEGIN
SET @errorCode = (3344 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	GOTO PROC_END
END
SET @qsdkSessionId = (SELECT guidOut FROM @sessionTable)
DECLARE @encryptedSessionId nvarchar(max)
EXEC dbo.pswEncryptionManaged @qsdkSessionId , @encryptedSessionId OUTPUT
SET @passwordLink = (SELECT SUBSTRING(@webConsoleURL, 1, (CHARINDEX('/webconsole', @webConsoleURL) - 1)) + '/webconsole')
SET @passwordLink = @passwordLink + '/login/resetPassword.jsp?tk=' + @encryptedSessionId;
SET @downloadURL = @WebConsoleURL + '/summary/addComputer.do';
DECLARE @commserverName nvarchar(255)
SELECT @commserverName=net_hostname FROM app_client WHERE id=2 --DEFAULT_COMMCELL_ID
SELECT @InviteUserEmailSettings = (
SELECT @templateTypeId as '@templateTypeId'
, (SELECT 'COMMSERVER_NAME' as '@name', @commserverName as '@value' for xml path('tokenValues'), type)
, (SELECT 'COMPANY_NAME' as '@name', @companyName as '@value' for xml path('tokenValues'), type)
, (SELECT 'WEBCONSOLE_URL' as '@name', @downloadURL as '@value' for xml path('tokenValues'), type)
, CASE WHEN @i_isEmailForDownloadPackageOnly <> 1 THEN (SELECT 'USERNAME' as '@name', @i_UserEmail as '@value' for xml path('tokenValues'), type) END
, CASE WHEN @i_isEmailForDownloadPackageOnly <> 1 THEN (SELECT 'PASSWORD' as '@name', @pwd as '@value' for xml path('tokenValues'), type) END
, CASE WHEN @i_isEmailForDownloadPackageOnly <> 1 THEN (SELECT 'CHANGE_PASSWORD_LINK' as '@name', @passwordLink as '@value' for xml path('tokenValues'), type) END
, CASE WHEN @i_isEmailForDownloadPackageOnly <> 1 THEN (SELECT 'CHANGE_PASSWORD_LINK_EXPIRATION' as '@name', @timeoutInHoursMins as '@value' for xml path('tokenValues'), type) END
,(SELECT @i_UserEmail as '@val' for xml path('toEmails'), type)
FOR XML PATH('Api_SendEmailTemplateMailRequest'))
PROC_END:
SELECT  @errorCode as 'errorCode', @InviteUserEmailSettings as 'InviteUserEmailSettings'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppInviteUserEmailSettings')
	delete from GxQscripts where name = 'AppInviteUserEmailSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInviteUserEmailSettings')
	delete from GXDBVersions where aliasname = 'AppInviteUserEmailSettings'
GO

insert into GXDBVersions values(2, 'AppInviteUserEmailSettings',  '00010001000200060000', 'AppInviteUserEmailSettings', '00010001000200060000')
GO

