

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppInsertThirdPartyProp.sp] ---------- 

-------------------------------------------------------------------------------
--   AppInsertIdaSetProp - Add/Update properties in the App_ThirdPartyAppProp Table	---
-------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppInsertThirdPartyProp.sp,v $ $Id: AppInsertThirdPartyProp.sp,v 1.1.2.2 2020/01/23 11:35:41 mdilshad Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppInsertThirdPartyProp')
BEGIN
	print '>>> Drop Stored Procedure: AppInsertThirdPartyProp <<<'
	drop procedure AppInsertThirdPartyProp
END
IF EXISTS (select * from GxQscripts where name='AppInsertThirdPartyProp')
	delete from GxQscripts where name = 'AppInsertThirdPartyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertThirdPartyProp')
	delete from GXDBVersions where aliasname = 'AppInsertThirdPartyProp'
GO
print '... Creating Procedure: AppInsertThirdPartyProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppInsertThirdPartyProp
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @componentId integer,
  @attrName nvarchar(1024),
  @attrType integer,
  @newAttrVal nvarchar(1024)
AS
SET NOCOUNT ON
BEGIN TRY
	DECLARE @errCode INT = 0
	DECLARE @errString AS varchar(1024) = ''
	DECLARE @nowTime	AS integer = dbo.GetUnixTime (GetUTCdate())
	MERGE App_ThirdPartyAppProp AS target
		USING (values (@attrType, @newAttrVal)) AS SOURCE (attrType, attrVal)
			ON target.componentNameId = @componentId AND target.attrName = @attrName
		WHEN MATCHED THEN
			UPDATE
			SET attrVal = SOURCE.attrVal,
			attrType = SOURCE.attrType
		WHEN NOT MATCHED THEN
			INSERT ( componentNameId, attrName, attrType, attrVal, created, modified )
			values ( @componentId, @attrName, @attrType, @newAttrVal, @nowTime, 0 );
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SELECT @errCode
END	  CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppInsertThirdPartyProp')
	delete from GxQscripts where name = 'AppInsertThirdPartyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertThirdPartyProp')
	delete from GXDBVersions where aliasname = 'AppInsertThirdPartyProp'
GO

insert into GXDBVersions values(2, 'AppInsertThirdPartyProp',  '00010001000200020000', 'AppInsertThirdPartyProp', '00010001000200020000')
GO

