

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppInsertSubclient.sp] ---------- 

--#define   DEBUG_MODE   1
-------------------------------------------------------------------------------------------
--   appInsertSubclient - When creating a new subClient, "push" content to associated 	---
--						  clients, creating objects as needed along the way				---
-------------------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppInsertSubclient.sp,v $ $Id: AppInsertSubclient.sp,v 1.11.56.2 2017/02/10 21:04:46 sjohnson Exp $";
/*
	UsE CommSerV
	IF ExistS (SelEcT * from SysObjectS Where name = 'AppInsertSubclient')
		Drop proc AppInsertSubclient
	DeleTe GxDBverSionS where name = 'AppInsertSubclient'
	GO
*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: appInsertSubclient <<<'

IF EXISTS (select * from sysobjects where name='appInsertSubclient')
	drop procedure appInsertSubclient
IF EXISTS (select * from GxQscripts where name='appInsertSubclient')
	delete from GxQscripts where name = 'appInsertSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='appInsertSubclient')
	delete from GXDBVersions where aliasname = 'appInsertSubclient'
GO
print '... Creating Procedure: appInsertSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure appInsertSubclient
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @i_name nvarchar(256),
  @i_clientId integer,
  @i_appTypeId integer,
  @i_instance integer,
  @i_backupSet integer,
  @i_dataArchGrpID integer,
  @i_logArchGrpID integer,
  @i_refTime integer,
  @i_status integer,
  @i_ccpId integer,
  @i_ccpTime integer
AS
-------------------------------------------------------
---  LOCAL VARIABLES 								---
-------------------------------------------------------
DECLARE @componentNameId	AS integer = 0
DECLARE @errCode			AS integer = 0				-- Returned as column to caller, 0 == SUCCESS
DECLARE @errString			AS varchar(2048) = ''
DECLARE @nowTime			AS integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @coupledClient		integer
DECLARE	@rowCount			as integer = 0
DECLARE	@cv_STATUS_CCP		AS integer		= 0x10000		--'CV_STATUS_CCP'
DECLARE @tempInstance		integer
DECLARE @tempBackupset		integer
DECLARE @tempSubclient		integer							-- For debugging only
----------------------------------------------------------------------------------------------------------
BEGIN TRY
--GUI allows creation of subclient in deconf clients, make sure to set the flag correctly. -sergio
	IF EXISTS(SELECT * FROM APP_BackupSetName WHERE status&2=2 AND id=@i_backupSet)
		SET @i_status = @i_status | 2
--FIRST, CREATE THE ENTRY IN THE APPLICATION TABLE THAT WAS REQUESTED:
	INSERT APP_Application(clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime, modified, subclientName, subclientStatus, ccpId, ccpTime, origCCId, GUID)
		VALUES (@i_clientId, @i_appTypeId, @i_instance, @i_backupset, 0, @i_dataArchGrpID, @i_logArchGrpID, @i_refTime, @i_refTime, @i_name, @i_status, @i_ccpId, @i_ccpTime, 2 , newid())
	SET @componentNameId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
	IF (@i_ccpid = 0)										-- IF THIS ISN'T CCP, NO MORE WORK TO DO!
		GoTo ALL_WORK_DONE
	IF object_id('tempdb.dbo.#applicationList') is not null
		DROP TABLE #applicationList
	CREATE TABLE #applicationList
	(
		[id]            integer NOT NuLL,
		[clientId]      integer NOT NuLL,
		[appTypeId]     integer NOT NuLL,
		[instance]      integer NOT NuLL,
		[backupSet]     integer NOT NuLL,
		[iDaId]         integer NOT NuLL,       -- NOT SURE IF THIS IS NEEDED OR NOT!
		[ccPId]         integer NOT NuLL
	)
	DECLARE @ccpIda as int = isnull((select id from app_idaname WHERE appTypeId = @i_appTypeId AND clientId = @i_clientId AND (status & 0x10000) <> 0), 0)
	IF @ccpIda = 0
	BEGIN
		SET @errCode = 1
		SET @errString = 'Error, cannot find CCP iDa for ClientId['+convert(varchar(8), @i_clientId) + '], appType['+ convert(varchar(10), @i_appTypeId) + '].'
		goto ALL_WORK_DONE
	END
INSERT #applicationList
		SELECT distinct 0, clientId, appTypeId, 0, 0, 0, 0
		FROM App_IdaName
		WHERE ccpId = @ccpIda AND appTypeId = @i_appTypeId
	Set @rowCount = @@rowcount
	IF @rowCount = 0
	BEGIN
		SET	@errString = 'No clients with appType[' + convert(varchar(10), @i_appTypeId) + '] currently configured under CCPid[' +Convert(varchar(10), @i_ccpId) +'].'
		SET @errCode	 = 0				-- (No Error)
		goto ALL_WORK_DONE
	END
	DECLARE	clientIdCursor CURSOR
	FOR
	SELECT distinct clientId
from #applicationList
	OPEN clientIdCursor
	FETCH NEXT from clientIdCursor INTO @coupledClient
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--------------------------------------------
		--		CREATE NEW INSTANCE, IF REQUIRED ---
		--------------------------------------------
		IF @i_instance = 1
			SET @tempInstance = @i_instance
		ELSE
		BEGIN
			SET @tempInstance = ISNULL((SELECT id from APP_INSTANCENAME Where id in
									(Select DISTINCT instance From App_Application
											 WHERE clientId = @coupledClient AND appTypeId = @i_appTypeId ) AND ccpId = @i_instance) , 0)
  		    IF @tempInstance = 0
			BEGIN
				INSERT App_InstanceName(name, refTime, modified, status, ccpId, ccpTime, origCCId, GUID)
					Select  name,@i_refTime, @i_refTime, @i_status & ~@cv_STATUS_CCP, @i_instance, @i_refTime, 2, newid()
					   FROM App_InstanceName
						 Where id = @i_instance
				SET @tempInstance = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
			END
			-- DON'T THINK WE NEED TO PUSH  PROPS,  THERE SHOULDN'T BE ANY (YET) --
		END
UPDATE #applicationList Set instance = @tempInstance
			WHERE  clientId  = @coupledClient
		--------------------------------------------
		--		CREATE NEW BACKUPSET, IF REQ'D	 ---
		--------------------------------------------
		SET @tempBackupSet = ISNULL((Select id from app_backupsetName WHERE id in (Select DISTINCT backupset From App_Application
			WHERE clientId = @coupledClient AND appTypeId = @i_appTypeId AND instance = @tempInstance) AND ccpId = @i_backupSet), 0)
			IF @tempBackupSet = 0
		BEGIN
			INSERT App_BackupsetName(name, refTime, modified, status, ccpId, ccpTime, origCCId, GUID)
			  SELECT  name,@i_refTime, @i_refTime, @i_status & ~@cv_STATUS_CCP, @i_backupset, @i_refTime, 2, newid()
				FROM App_BackupsetName
				WHERE id = @i_backupset
			SET @tempBackupSet = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
		END
UPDATE #applicationList Set backupset = @tempBackupSet
		  WHERE  clientId  = @coupledClient
		-- DON'T THINK WE NEED TO PUSH  PROPS,  THERE SHOULDN'T BE ANY (YET) --
		--------------------------------------------
		--	   CREATE SUBCLIENT					----
		--------------------------------------------
		INSERT APP_Application(clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime, modified,
								subclientName, subclientStatus, ccpId, ccpTime, origCCId, GUID)
			VALUES (@coupledClient, @i_appTypeId, @tempInstance, @tempBackupSet, 0, @i_dataArchGrpID, @i_logArchGrpID, @i_refTime, @i_refTime,
								@i_name, @i_status & ~@cv_STATUS_CCP, @componentNameId, @i_refTime, 2, newid())
		SET @tempSubClient = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
UPDATE #applicationList Set id = @tempSubClient						-- Purely for Debugging
		  WHERE  clientId  = @coupledClient
		--------------------------------------------
		--- Do Next Client in the List			----
		--------------------------------------------
			FETCH NEXT from clientIdCursor INTO @coupledClient
	END
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
ALL_WORK_DONE:
IF object_id('tempdb.dbo.#applicationList') is not null
	DROP TABLE #applicationList
	IF ( CURSOR_STATUS('global', 'clientIdCursor') >= 0 	OR CURSOR_STATUS('local', 'clientIdCursor') >= 0 )
BEGIN
	CLOSE		clientIdCursor
	DEALLOCATE	clientIdCursor
END
SELECT @componentNameId, @errCode, @errString


IF EXISTS (select * from GxQscripts where name = 'AppInsertSubclient')
	delete from GxQscripts where name = 'AppInsertSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertSubclient')
	delete from GXDBVersions where aliasname = 'AppInsertSubclient'
GO

insert into GXDBVersions values(2, 'AppInsertSubclient',  '00010011005600020000', 'AppInsertSubclient', '00010011005600020000')
GO

