

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppInsertSubClientProp.sp] ---------- 

--------------------------------------------------------------------------------------------
--   AppInsertSubClientSetProp - Add/Update properties in the App_SubClientProp Table	---
-------------------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 2009  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppInsertSubClientProp.sp,v $ $Id: AppInsertSubClientProp.sp,v 1.8.208.6 2020/12/23 14:13:26 logeshg Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppInsertSubClientProp')
BEGIN
	print '>>> Drop Stored Procedure: AppInsertSubClientProp <<<'
	drop procedure AppInsertSubClientProp
END
IF EXISTS (select * from GxQscripts where name='AppInsertSubClientProp')
	delete from GxQscripts where name = 'AppInsertSubClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertSubClientProp')
	delete from GXDBVersions where aliasname = 'AppInsertSubClientProp'
GO
print '... Creating Procedure: AppInsertSubClientProp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppInsertSubClientProp
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @componentId integer,
  @isPIT integer,
  @createdTime integer,
  @attrName nvarchar(1024),
  @attrType integer,
  @newAttrVal nvarchar(MAX)
AS
SET NOCOUNT ON
BEGIN TRY
-- Need the following for determining if prop is CCP or not:
-- Added NOLOCK to correct deadlock issue
DECLARE		@appTypeId	AS INT = (Select appTypeId from dbo.APP_Application WITH(NOLOCK) Where id = @componentId)
DECLARE		@ccpTypeId  AS INT = ISNULL((Select ccpType from dbo.APP_iDAType WITH(NOLOCK) Where type=@appTypeId), 0)
--- CODE BELOW HERE IS FROM AppInsertProp.spb  ----------
DECLARE @errCode	AS integer = 0				-- Returned as column to caller, 0 == SUCCESS
DECLARE @errString	AS varchar(1024) = ''
DECLARE	@hasChanged	AS integer = 0				-- Tells caller if anything changed or not (0==NOT)
DECLARE @nowTime	AS integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @status		AS integer = 0
DECLARE @ccpId		AS integer = 0				-- Client Configuration Policy Id
DECLARE	@isCCPobj	AS integer = 0				-- This is a CCP Object
DECLARE	@isCCPAssoc	AS integer = 0				-- This is a CCP Associated Object
DECLARE	@isCCPprop	AS integer = 0				-- This is a CCP Property
DECLARE @CV_STATUS_CCP_VAL AS integer = 0x10000
DECLARE @propId		integer				-- Set to id of current value of property (or Null)
DECLARE	@oldVal		nvarchar(MAX)		-- Set to current value of property (or Null)
DECLARE @isCaseSensitive as integer = 0			--Deefault, attrVal is NOT case sensitive
DECLARE @isCaseSensitiveValue as integer = 0
IF @createdTime <> 0					-- CALLER MAY WANT TO USE THE SAME "time" for multiple  properties
	SET @nowTime = @createdTime
IF @attrType = 120						-- Overkill, could have used test for attrType below, but there may be more
	SET @isCaseSensitive = 1			-- .. "case sensitive" cases in the future, this makes it easier to add them.
IF @attrName = 'prepost username' OR @attrName = 'Virtual Server Disk Filters'
	SET @isCaseSensitiveValue = 1
	----------------------------------------------------------------------------------------------
	-- WE WANT TO SET THE ccpId in the property ONLY IF the property is one that is  A property --
	-- Maintained for CCPs																	    --
	----------------------------------------------------------------------------------------------
SELECT @ccpId = ccpId,  @status = subClientstatus FROM app_application WITH (NOLOCK) where id = @componentId
	IF @ccpId = 0					-- SIMPLEST CASE, NOTHING TO DO WITH CCP!
		GOTO PROCESS
--	DETERMINE IF THE PROPERTY BEING SET IS A CCP PROPERTY OR NOT
	if EXISTS (Select * from APP_CCP_PROP  WITH (NOLOCK)
					 WHERE [attrName] = @attrName
AND (componentLevel = 0 or componentLevel =  50)
					   AND (appTypeId = @ccpTypeId OR appTypeId = 0)
	)
		Set @isCCPprop = 1
--	DETERMINE IF THIS PROPERTY IS FOR A CCP OBJECT OR AN OBJECT ASSOCIATED
--	.. WITH A CCP OBJECT
	IF (@status & @CV_STATUS_CCP_VAL) <> 0
		SET @isCCPobj = 1
	IF (@status & @CV_STATUS_CCP_VAL = 0) AND @ccpId <> 0
		SET @isCCPassoc = 1
-------------------------------------------------------
--	DECIDE WHETHER TO PROCESS THIS REQUEST OR NOT:	---
-- 		IS A CCP OBJECT AND IS A CCP PROPERTY (OK)	---
--		NOT A CCP OBJECT & NOT A CCP PROPERTY (OK)	---
-------------------------------------------------------
	IF @isCCPobj <> 0 AND  @isCCPprop = 0			-- Don't "Process" Non-CCP properties for CCP objects and ..
		GOTO SKIP
	IF @isCCPassoc <> 0 AND @isCCPprop <> 0		-- Don't "Process" CCP properties for associated objects
		GOTO SKIP
--	FALL THRU CASES:
--		o IS A CCPObject and IS a CCP Property
--		o IS an ASSOCIATED CCP object and is NOT a CCP Property
--		o NOT A CCPObject or ASSociated CCP Object
PROCESS:
	----------------------------------------------
	-- IS PROPERTY NEW, OR HAS VALUE CHANGED?  ---
	----------------------------------------------
	IF @isCaseSensitive <> 0
		SELECT @propId = id, @oldVal = [attrVal]
FROM app_subClientProp WITH(INDEX(IX_subClientProp), NOLOCK)
			WHERE	componentNameId = @componentId
			  AND (CAST([attrName] AS varbinary(1024)) = CAST(@attrName AS varbinary(1024)))
			  AND modified = 0
AND cs_attrName = checksum(@attrName)
	ELSE
		SELECT @propId = id, @oldVal = [attrVal]
FROM app_subClientProp WITH(INDEX(IX_subClientProp), NOLOCK)
			WHERE	componentNameId = @componentId
			  AND [attrName] = @attrName
			  AND modified = 0
AND cs_attrName = checksum(@attrName)
	IF @isCaseSensitiveValue = 1
	BEGIN
		IF @propId IS NOT Null AND CAST(@oldVal AS varbinary(MAX)) = CAST(@newAttrVal AS varbinary(MAX))
		BEGIN
SET @errString = 'Subclient'+'['+ convert(varchar(5), @componentId) +'], Property [' + @attrName + '] has not changed.'
			GOTO SKIP
		END
	END
	ELSE IF @propId IS NOT Null AND @oldVal = @newAttrVal
	BEGIN
SET @errString = 'Subclient'+'['+ convert(varchar(5), @componentId) +'], Property [' + @attrName + '] has not changed.'
		GOTO SKIP
	END
	SET	@hasChanged	= 1								-- YUP, NEW OR VALUE HAS CHANGED
----------------------------------------------------------------------------------------------------------
---  BEFORE WE UPDATE OR CH	ANGE DB ENTRY, SEE IF THE PROPERTY IS CONTENT (SubClientProp only) AND IF SO	--
---	 .. CHECK FOR DUPLICATES WITHIN SAME BACKUPSET.  RETURN ERROR IF SAME CONTENT FOUND					--
----------------------------------------------------------------------------------------------------------
	IF @attrType in (101, 102, 111, 112, 113, 114, 115, 120, 121)         -- LNOTES DOC/DB, XCHG Mbox/DB, SharePoint DB/DOC/V2 DB, MYSQL, VIRT Server
	BEGIN
		DECLARE @dupCount		integer
		DECLARE @backupSet  AS integer = ISNULL((Select top 1 backupset from app_application with (nolock) where id = @componentId), 0)
		IF @isCaseSensitive <> 0
			UPDATE T
				SET modified = @nowTime
FROM app_subClientProp T WITH(INDEX(IX_subClientProp))
WHERE componentNameid in  (Select id from  app_application WITH(NOLOCK) where backupset = @backupset)
				  AND modified = 0
				  AND componentNameId <> @componentId
				  AND (CAST([attrName] AS varbinary(1024)) = CAST(@attrName AS varbinary(1024)))
AND cs_attrName = checksum(@attrName)
		ELSE
			UPDATE T
				SET modified = @nowTime
FROM app_subClientProp T WITH(INDEX(IX_subClientProp))
WHERE componentNameid in  (Select id from  app_application WITH(NOLOCK) where backupset = @backupset)
				  AND modified = 0
				  AND componentNameId <> @componentId
				  AND [attrName] = @attrName
AND cs_attrName = checksum(@attrName)
		SET @dupCount = @@rowCount
		IF @dupCount <> 0
		BEGIN
--			set @errCode 	= 0x090005				-- NO ERROR ANYMORE! --			-- CV_DUPL_CONTENT_FOUND from appMgr/errors.h
			set @errString	= 'Duplicate of content found in Backupset['
			+ CONVERT(varchar(8), @backupset)
			+'], (' + Convert(varchar(20), @dupCount) + ') entrie(s) aged with timeStamp[' + convert(varchar(10), @nowTime) + '].'
--			GOTO SKIP
		END
	END
----------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------
	IF @propId IS NOT Null
	BEGIN
		IF @isPIT <> 0
		BEGIN
			-- "AGE" OLD PROPERTY VALUE:
UPDATE app_subClientProp SET [modified] = @nowTime
				WHERE id = @propId
--#ifdef USE_CCP
--			IF @isCCPobj <> 0						-- ALSO AGE THE PROP FOR ALL THE ASSOCIATED OBJECTS!
--				UPDATE APP_PROPERTY_TABLE SET [modified] = @nowTime
--				 WHERE   ccpId = @componentId AND [attrName] = @attrName AND modified = 0
--#endif
			SET @propId = Null	-- "FORCE" creation of a new row for new value
		END
		ELSE
--				NOT PIT, SO JUST UPDATE THE CURRENT VALUE
		BEGIN
UPDATE app_subClientProp SET [attrVal] = @newAttrVal, [ccpId] = @ccpId
			WHERE id = @propId
--#ifdef USE_CCP
--			IF @isCCPobj <> 0 						-- ALSO UPDATE THE PROP FOR ALL THE ASSOCIATED OBJECTS!
--				UPDATE APP_PROPERTY_TABLE SET [attrVal] = @newAttrVal, [ccpId] = @componentId
--					WHERE
--					ccpId = @componentId AND [attrName] = @attrName AND modified = 0
--#endif
		END
	END
--	EITHER A BRAND NEW PROPERTY OR WE JUST AGED A PIT PROPERTY:
	IF @propId IS Null
	BEGIN
INSERT app_subClientProp (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
			VALUES (@componentId, @attrName, @attrType, @newAttrVal, @nowTime, 0, @ccpId)
			SET @propId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
--			-----------------------------------------------------
--			PUSH PROPERTY TO ASSOCIATED CCP's, AS NECESSARY   ---
--			-----------------------------------------------------
--#ifdef USE_CCP
--		IF (@isCCPobj <> 0)
--			INSERT APP_PROPERTY_TABLE (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
--				SELECT id, @attrName, @attrType, @newAttrVal, @nowTime, 0, @componentId
--				FROM APP_COMPONENT_TABLE WITH(NOLOCK)
--				WHERE ccpId = @componentId  AND (STATUS_COLUMN & @CV_STATUS_CCP_VAL) = 0  		-- For Client, ccpId = @componentId for CCP def, don't want to add prop in twice!
--#endif
	END
	--File Anomaly report uses createTime for time to show anomaly count
	--Thus updating created time for anomaly properties.
IF @attrName = 'Anomaly Flag' OR @attrName = 'Anomaly Deleted Files'
OR @attrName = 'Anomaly Created Files' OR @attrName = 'Anomaly Modified Files'
OR @attrName = 'Anomaly Renamed Files' OR @attrName = 'Anomaly Application Size'
OR @attrName = 'Anomaly Total Files'
	BEGIN
UPDATE app_subClientProp
		SET [created] = @nowTime
		WHERE componentNameId = @componentId AND attrName=@attrName AND modified = 0
	END
SKIP:
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errCode, @hasChanged, @propId, @errString

IF EXISTS (select * from GxQscripts where name = 'AppInsertSubClientProp')
	delete from GxQscripts where name = 'AppInsertSubClientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertSubClientProp')
	delete from GXDBVersions where aliasname = 'AppInsertSubClientProp'
GO

insert into GXDBVersions values(2, 'AppInsertSubClientProp',  '00010008020800060000', 'AppInsertSubClientProp', '00010008020800060000')
GO

