

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppInsertSubClientContent.sp] ---------- 

--------------------------------------------------------------------------------------------
---   AppInsertSubClientSetContent - Add/Update properties in the app_Scfilterfile Table ---
--------------------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--
--		Note: CCP, or Client Configuration Policy was a feature that was
--		      removed from 9.0 but is expected back in 10.0.  The relevant
--			  code is "ifdef'ed" out.
--
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppInsertSubClientContent.sp,v $ $Id: AppInsertSubClientContent.sp,v 1.19.60.3 2020/11/17 22:45:19 jswaminathan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppInsertSubClientContent')
BEGIN
	print '>>> Drop Stored Procedure: AppInsertSubClientContent <<<'
	drop procedure AppInsertSubClientContent
END
IF EXISTS (select * from GxQscripts where name='AppInsertSubClientContent')
	delete from GxQscripts where name = 'AppInsertSubClientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertSubClientContent')
	delete from GXDBVersions where aliasname = 'AppInsertSubClientContent'
GO
print '... Creating Procedure: AppInsertSubClientContent'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppInsertSubClientContent
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @icomponentNameId integer,
  @isCaseSensitive integer,
  @iContentType integer,
  @iContent nvarchar(max),
  @createdTime integer,
  @isPIT integer
AS
BEGIN TRY
DECLARE	@brAlertTrace			varchar(256)
SET 	@brAlertTrace			= (select value from gxglobalParam Where name = 'bralertTrace' AND modified = 0)
SET 	@brAlertTrace         	= ISNULL(@brAlertTrace, 0)
DECLARE @traceString			varchar(2048)		-- For "trace"
DECLARE @myDate DATETIME							-- For "trace"
if @brAlertTrace <> 0
BEGIN
	SET @myDate = getDate()
	SET @traceString = CONVERT(varchar(12),@icomponentNameId) + ', '
				+CONVERT(varchar(12),@isCaseSensitive) + ', '
				+CONVERT(varchar(12),@iContentType) + ', '
				+'[' +@iContent + '], '
				+CONVERT(varchar(12),@createdTime)
	EXEC br_ntTrace '.. AppInsertSubClientContent', 0, @myDate, 0, 0, @traceString
END
DECLARE @errCode	AS integer			= 0				-- Returned as column to caller, 0 == SUCCESS
DECLARE @errString	AS varchar(1024)	= ''			-- ASSUME SUCCESS
DECLARE	@hasChanged	AS integer			= 0				-- Tells caller if anything changed or not (0==NOT)
DECLARE @nowTime	AS integer			= @createdTime	-- Time value to be used for created/modified fields
DECLARE @status     AS integer = 0
DECLARE @cmpStatus	AS integer = 0x10000
DECLARE @appTypeId  AS INT				= ISNULL((Select appTypeId from APP_Application Where id = @icomponentNameId), 0)
DECLARE @ccpId		integer				-- Client Configuration Policy Id
DECLARE @propId		integer				-- Id of existing content, if it exists
DECLARE	@oldVal		nvarchar(MAX)		-- Set to current value of property (or Null)
DECLARE @backupSet	integer				-- Need this so we can scan for duplicate content.
DECLARE @dupCount	integer				-- ""
SET		@dupCount 	= 0
	IF @createdTime = 0
		SET @nowTime = dbo.GetUnixTime (GetUTCdate())
	-----------------------------------------------------------------------------------------------
	-- IF WE'VE RECEIVED CONTENT FOR A SC ASSOCIATED WITH A CCP, WE NEED TO IGNORE IT!  ONLY	---
	-- .. CONTENT PUSHED FROM THE CCP IS ACCEPTABLE FOR ASSOCIATED CCP SUBCLIENTS!				---                                                                    --
	-----------------------------------------------------------------------------------------------
	SELECT @ccpId = ccpId,  @status = subClientStatus, @backupset=backupSet FROM APP_Application  where id = @icomponentNameId
	IF (@status & 4)  <> 0				 -- Deleted(4) | Uninstalled(2)  --Allow for unistalled since GUI allows creation of subclient in deconf clients. -sergio
	BEGIN
		SET @errCode   =  0x090006            -- from APPMGR\Errors.h:  CV_CONTENT_INVALID_SUBCLIENT
		SET @errString = 'SubClient[' + Convert(varchar(10), @icomponentNameId) + '] is either deleted or uninstalled so content will not be written to DB'
		GoTo  IGNORE_CONTENT
	END
	IF @ccpId <> 0 AND (@status & @cmpStatus) = 0
	BEGIN
		SET @errCode   = 0x090004            -- from APPMGR\Errors.h:  CV_ASSOC_CCP_ATTEMPT
		SET @errString = 'SubClient[' + Convert(varchar(10), @icomponentNameId) + '] is associated with a CCP so content will not be written to DB'
		GoTo  IGNORE_CONTENT
	END
	IF (@isCaseSensitive <> 0)
		SELECT @propId = ISNULL((select id from app_scfilterFile						-- THIS HAS TO BE DIFFERENT FOR UNIX AND OTHER APPTYPES
							WHERE componentNameId = @iComponentNameId					--   WHERE FILENAMES ARE CASE-SENSITIVE
							  AND (CAST(fileName AS varbinary(max)) = CAST(@iContent AS varbinary(max)))
							  AND type	      = @iContentType
							  AND cs_fileName = checksum(@iContent)
							  AND modified    = 0), 0)
	ELSE
		SELECT @propId = ISNULL((select id from app_scfilterFile
							WHERE componentNameId = @iComponentNameId
							  AND fileName    = @iContent
							  AND type	      = @iContentType
							  AND cs_fileName = checksum(@iContent)
							  AND modified = 0), 0)
	IF @propId = 0															-- CONTENT DOESN'T EXIST YET, ADD IT!
	BEGIN
		IF @iContentType = 1
--		IF 0 =1								-- SKIP FOR NOW
		BEGIN
			-- DO CHECK FOR DUPLICATE CONTENT !BEFORE! INSERTING NEW CONTENT! --
			IF (@isCaseSensitive <> 0)
IF ((@status & CAST( 0x1000000 AS INT )) = 0 )
										UPDATE app_scfilterfile
										SET Modified = @nowTime
										WHERE componentNameid in  (Select id from  app_application where backupset = @backupset AND ((subClientstatus & 6) =0) ) -- Skip uninstalled/deleted subClients from check. Skip adhoc archiving  subclient also.
										  AND modified = 0
										  AND  type    = @iContentType
			  							  AND cs_fileName = checksum(@iContent)
										  AND (CAST(fileName AS varbinary(max)) = CAST(@iContent AS varbinary(max)))
			ELSE
IF ((@status & CAST( 0x1000000 AS INT )) = 0 )
										UPDATE app_scfilterfile
										SET Modified = @nowTime
										WHERE componentNameid in  (Select id from  app_application where backupset = @backupset AND ((subClientstatus & 6) =0) ) -- Skip uninstalled/deleted subClients from check. Skip adhoc archiving  subclient also.
										  AND modified = 0
										  AND type     =  @iContentType
			  							  AND cs_fileName = checksum(@iContent)
										  AND fileName = @iContent
			END
		SET @dupCount = @@rowCount
		IF @dupCount <> 0
		BEGIN
			set @errCode 	= 0   							-- CV_DUPL_CONTENT_FOUND from appMgr/errors.h
			set @errString	= 'Duplicate of content found in Backupset['
			+(select name from app_BackupsetName where id = @backupset)
			+'], (' + Convert(varchar(20), @dupCount) + ') entrie(s) aged with timeStamp[' + convert(varchar(10), @nowTime) + '].'
	--			GOTO IGNORE_CONTENT
		END
		INSERT APP_SCFILTERFILE (componentNameId, type, filename, created, modified, ccpId)
		   VALUES(@iComponentNameId, @iContentType, @iContent, @nowTime, 0, @ccpId)
--		----------------------------------------------------------------------------------------------------
--		IF THIS NEW CONTENT WAS FOR A CCP SUBCLIENT, NEED TO PUSH IT OUT TO ALL THE ASSOCIATED SUBCLIENTS --
--		----------------------------------------------------------------------------------------------------
		IF (@status & @cmpStatus) <> 0
			INSERT APP_SCFILTERFILE (componentNameId, type, filename, created, modified, ccpId)
				SELECT  id, @iContentType, @iContent, @nowTime, 0, @iComponentNameId
					FROM APP_Application
					WHERE ccpId = @icomponentNameId
					  AND (subclientStatus & @cmpStatus) = 0
		SET	@hasChanged	= 1
	END
	ELSE
		SET @errString = 'Subclient['+ convert(varchar(5), @iComponentNameId) +'], Content [' + @iContent + '] has not changed.'
IGNORE_CONTENT:
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errCode, @hasChanged, @errString
/*
DROP PROC AppInsertSubClientContent
DELETE app_ScfilterFile where fileName = 'CONTeNT 02'
exec AppInsertSubClientContent 2, 1, 1, 'CONTeNT 02', 0, 0
exec AppInsertSubClientContent 6, 1, 1, 'CONTeNT 02', 0, 0
select id, componentNameId, type, filename=convert(varchar(30), fileName), created, modified
 from APP_ScFilterFile where componentNameId in (2,6) order by componentNameId
*/

IF EXISTS (select * from GxQscripts where name = 'AppInsertSubClientContent')
	delete from GxQscripts where name = 'AppInsertSubClientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertSubClientContent')
	delete from GXDBVersions where aliasname = 'AppInsertSubClientContent'
GO

insert into GXDBVersions values(2, 'AppInsertSubClientContent',  '00010019006000030000', 'AppInsertSubClientContent', '00010019006000030000')
GO

