

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppInsertGlobalParam.sp] ---------- 

-----------------------------------------------------------------------------------
--   AppInsertGlobalParam - Add/Update properties in the gxGlobalParam Table	---
-----------------------------------------------------------------------------------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppInsertGlobalParam.sp,v $ $Id: AppInsertGlobalParam.sp,v 1.3.56.1 2017/02/10 21:04:46 sjohnson Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppInsertGlobalParam <<<'

IF EXISTS (select * from sysobjects where name='AppInsertGlobalParam')
	drop procedure AppInsertGlobalParam
IF EXISTS (select * from GxQscripts where name='AppInsertGlobalParam')
	delete from GxQscripts where name = 'AppInsertGlobalParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertGlobalParam')
	delete from GXDBVersions where aliasname = 'AppInsertGlobalParam'
GO
print '... Creating Procedure: AppInsertGlobalParam'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppInsertGlobalParam
---------------------------------------
--   PARAMETERS   &   OUTPUTS 		---
---------------------------------------
  @isPIT integer,
  @createdTime integer,
  @name nvarchar(1024),
  @newValue nvarchar(MAX)
AS
SET NOCOUNT ON
--DECLARE @status		AS integer = 0
DECLARE @propId		integer				-- Set to id of current value of property (or Null)
DECLARE	@oldVal		nvarchar(MAX)		-- Set to current value of property (or Null)
DECLARE @isCaseSensitive as integer = 0	--Default, value is NOT case sensitive (CURRENTLY NOT USED FOR GLOBAL PARAM,
										--BUT ... May be useful in the future!
DECLARE @errCode	AS integer = 0				-- Returned as column to caller, 0 == SUCCESS
DECLARE @errString	AS varchar(1024) = ''
DECLARE	@hasChanged	AS integer = 0				-- Tells caller if anything changed or not (0==NOT)
DECLARE @nowTime	AS integer = dbo.GetUnixTime (GetUTCdate())
IF @createdTime <> 0					-- CALLER MAY WANT TO USE THE SAME "time" for multiple  properties
	SET @nowTime = @createdTime			-- if not, just use current time
BEGIN TRY
	----------------------------------------------
	-- IS PROPERTY NEW, OR HAS VALUE CHANGED?  ---
	----------------------------------------------
	IF @isCaseSensitive <> 0
		SELECT @propId = id, @oldVal = [value]
			FROM gxGlobalParam
			WHERE (CAST([name] AS varbinary(1024)) = CAST(@name AS varbinary(1024))) AND modified = 0
	ELSE
		SELECT @propId = id, @oldVal = [value]
			FROM gxGlobalParam
			WHERE	[name] = @name  AND modified = 0
	IF @propId IS NOT Null AND @oldVal = @newValue
	BEGIN
		SET @errString = 'Global Property [' + @name + '] has not changed.'
		GOTO SKIP
	END
	----------------------------------------------
	-- GOT HERE, PROP IS NEW/HAS CHANGED. 		--
	----------------------------------------------
	SET	@hasChanged	= 1								-- YUP, NEW OR VALUE HAS CHANGED
	IF @propId IS NOT Null
	BEGIN
		IF @isPIT <> 0
		BEGIN
			-- "AGE" OLD PROPERTY VALUE:
			UPDATE gxGlobalParam SET [modified] = @nowTime
				WHERE id = @propId
			SET @propId = Null	-- "FORCE" CREATION OF A NEW ROW FOR NEW VALUE
		END
		ELSE 				-- NOT PIT, SO JUST UPDATE THE CURRENT VALUE
		BEGIN
			UPDATE gxGlobalParam SET [value] = @newValue
			WHERE id = @propId
		END
	END
--	EITHER A BRAND NEW PROPERTY OR WE JUST AGED A PIT PROPERTY:
	IF @propId IS Null
	BEGIN
		INSERT gxGlobalParam ([name], [value], created, modified)
			VALUES (@name, @newValue, @nowTime, 0)
			SET @propId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
	END
SKIP:			-- (Came here if new prop same as old prop)
END	  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errCode, @hasChanged, @propId, @errString
go
--SOME DEBUG CODE:
--exec AppInsertGlobalParam 1, 1296073680, 'StuTest1', 'Stu Value 03'
--select * from GXGlobalParam where [name] like 'StuTest%'

IF EXISTS (select * from GxQscripts where name = 'AppInsertGlobalParam')
	delete from GxQscripts where name = 'AppInsertGlobalParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppInsertGlobalParam')
	delete from GXDBVersions where aliasname = 'AppInsertGlobalParam'
GO

insert into GXDBVersions values(2, 'AppInsertGlobalParam',  '00010003005600010000', 'AppInsertGlobalParam', '00010003005600010000')
GO

