

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIndexServerBackupSchedule.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIndexServerBackupSchedule.sp,v $ $Id: AppIndexServerBackupSchedule.sp,v 1.1.2.1.4.1 2021/01/12 23:21:13 pankajkumar Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppIndexServerBackupSchedule')
BEGIN
	print '>>> Drop Stored Procedure: AppIndexServerBackupSchedule <<<'
	drop procedure AppIndexServerBackupSchedule
END
IF EXISTS (select * from GxQscripts where name='AppIndexServerBackupSchedule')
	delete from GxQscripts where name = 'AppIndexServerBackupSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIndexServerBackupSchedule')
	delete from GXDBVersions where aliasname = 'AppIndexServerBackupSchedule'
GO
print '... Creating Procedure: AppIndexServerBackupSchedule'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppIndexServerBackupSchedule
  @i_indexServerClientId INT =0
AS
BEGIN TRY
-------------------------------------------------------------------------------------
	----------------------------------------------------------------------------
	--									Variables							  --
	----------------------------------------------------------------------------
	DECLARE @errCode INTEGER =0
	DECLARE @errStr varchar(1024) ='Success'
	--Index Server Backup--
	DECLARE @l_taskId2		INTEGER
	DECLARE @l_subTaskId2	INTEGER
	DECLARE @l_patternId2	INTEGER
	DECLARE @currentDate	DATETIME
	DECLARE @userId 	INTEGER
	DECLARE @currentTime	INTEGER
	DECLARE @xmlText		XML
	SET @userId = (SELECT TOP 1 id FROM UMUsers WHERE flags&0x40=0x40)
	SET @currentDate = CONVERT(VARCHAR(12), GETUTCDATE())
	set @currentTime = (SELECT DATEDIFF(s, CONVERT(DATETIME, '1970-01-01'), GETDATE()))
	DECLARE @nowTime  INTEGER =  DATEDIFF(second, '01/01/1970', GETUTCDATE())
	IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL
		DROP TABLE #TM_IDTable
	SELECT 0 as id, 0 as type INTO #TM_IDTable
------------------------------------------------------------------------------------
	-- System Created Index Server Backup Schedule Policy
DECLARE @taskName NVARCHAR(1024) = 'System Created for Index Server Backup'
IF NOT EXISTS (SELECT TOP 1 1 FROM TM_Task (NOLOCK) WHERE flags & 0x200000 = 0x200000
	AND taskName = @taskName)
	BEGIN
		-- Schedule Policy
		INSERT INTO TM_Task(taskName,
							taskType,
							flags,
							status,
							created,
							modified,
							alertId,
							ownerId,
							runUserId,
							initiatedFrom,
							sequenceNumber,
							localeId,
							description,
							deleted,
							disabled,
							uninstalled,
							invalid,
							defaultTask,
							savedReport,
							serial,
							policyType,
							origCCId,
							GUID,
							isEZOperation,
							isAgentlessSRM,
							hidden)
		OUTPUT	INSERTED.taskId , 5 INTO #TM_IDTable
		VALUES			   (@taskName,		-- Task Name
4,		-- Task Type
CAST(0x200000 AS INT)|CAST(0x4 AS INT),					-- Task Flags
							0,								-- Status
							@currentTime,					-- Created
							0,								-- Modified
							0,								-- Alert ID
							@userId,							-- Owner ID
							@userId,							-- Run User ID
3,			-- Initiated From
							0,								-- Seq No
							0,								-- Locale ID
'System created schedule policy for Index Server Backup',		-- Description
							0,								-- Deleted
							0,								-- Disabled
							0,								-- Uninstalled
							0,								-- Invalid
							0,								-- Default Task ???
							0,								-- Saved Report
							0,								-- Serial
							0,								-- Policy Type
							DEFAULT,						-- Original CC ID
							newid(),						-- GUID
							0,								-- isEZOperation
							0,								-- isAgentlessSRM
							0)								-- hidden
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_Task'
			GOTO ERROR_EXIT
		END
		SET @l_taskId2 = (SELECT id FROM #TM_IDTable WHERE type = 5)
		-- Schedule 2 :
		-- Full Schedule
		INSERT INTO TM_SubTask (subTaskName,
	 				 			taskId,
								subTaskType	,
								operationType,
								flags		,
								subTaskOrder,
								deleted,
 		 						uninstalled,
								defaultTask)
		OUTPUT	INSERTED.subTaskId , 6 INTO #TM_IDTable
		VALUES				   ('',							-- SubTask Name
								@l_taskId2,					-- Task ID
2,		-- SubTask Type
2,	-- Operation Type
0x8000000,	-- Flags
								0,							-- SubTask Order
								0,							-- Deleted
								0,							-- Uninstalled
								0)							-- Default Task ???
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTask'
			GOTO ERROR_EXIT
		END
		SET @l_subTaskId2 = (SELECT id FROM #TM_IDTable WHERE type = 6)
		-- Pattern 1:
		-- WEEKLY at 1 PM
		INSERT INTO TM_Pattern(name,
							   ownerId,
							   status,
							   flags,
							   freq_type,
							   freq_interval,
							   freq_relative_interval,
							   freq_recurrence_factor,
							   freq_subday_interval,
							   skipOccurence,
							   skipDayNumber,
							   active_start_date,
							   active_start_time,
							   active_end_date,
							   active_end_time,
							   active_end_occurence,
							   created,
							   modified,
							   tzId,
							   calendarId,
							   description,
							   local_start_date,
							   local_end_date,
							   disabled,
							   deleted,
							   scheduling,
							   freq_restart_interval)
		OUTPUT	INSERTED.patternId , 7 INTO #TM_IDTable
		VALUES				  ('',							-- Name
							   @userId,						-- Owner ID
							   0,							-- Status
							   0,							-- Flags
0x8,			-- Freq Type
							   64,							-- Freq Interval
							   0,							-- Freq Relative Interval
							   1,							-- Freq Recurrence Factor
							   0,							-- Freq Subday Interval
							   0,							-- Skip Occurrence
							   0,							-- Skip Day Number
							   @currentDate,				-- Active Start Date
							   36000,						-- Active Start Time			--saturday 10 AM
							   '1970-01-01 00:00:00',		-- Active End Date
							   0,					    -- Active End Time
							   0,							-- Active End Occurrence
							   0,							-- Created
							   0,							-- Modified
							   1000,						-- Time Zone Id
							   1,							-- Calendar Id
							   'Every Saturday Day at 10:00 AM',		-- Description
							   DATEDIFF(s, '1970-01-01 00:00:00', @currentDate),-- Local Start Date
							   0,							-- Local End Date
							   0,							-- Disabled
							   0,							-- Deleted
							   0,							-- Scheduling
							   0)							-- Freq Restart Interval
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_Pattern '
			GOTO ERROR_EXIT
		END
		SET @l_patternId2 = (SELECT id FROM #TM_IDTable WHERE type = 7)
		-- Create Pattern Assoc
		INSERT INTO TM_PatternAssoc(patternId,
									subTaskId,
									flags,
						   			disabled,
									deleted,
									scheduling)
		VALUES					   (@l_patternId2,				-- Pattern ID
									@l_subTaskId2,				-- SubTask ID
									0,							-- Flags
									0,							-- Disabled
									0,							-- Deleted
									0)							-- Scheduling
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created IndexBackup Schedule Policy -- Failed to insert in TM_PatternAssoc '
			GOTO ERROR_EXIT
		END
		-- SubTask XML Options
		INSERT INTO TM_SubTaskXMLOptions(subTaskID,
										 xmlValue)
		VALUES							(@l_subTaskId2,
										'<TMMsg_JobOption><backupOpts runIncrementalBackup="1" collectMetaInfo="1" backupLevel="1" incLevel="1" sybaseSkipFullafterLogBkp="0" bkpLatestVersion="0" doNotTruncateLog="0" runSILOBackup="0"><oracleOptions cumulative="0" level="1"><deleteArchLogOptions backupArchiveLogCriteria="0" /><backupArchLogOptions backupArchiveLog="1" endLSN="1" backupArchiveLogCriteria="7" startLSN="1" /></oracleOptions><dataOpt startLogBackupAfterSuccessfullBackup="0" createNewIndex="1" followMountPoints="1" /></backupOpts></TMMsg_JobOption>')
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskXMLOptions '
			GOTO ERROR_EXIT
		END
		SET @xmlText = (SELECT xmlValue FROM TM_SubTaskXMLOptions WHERE subTaskId = @l_subTaskId2)
		INSERT INTO TM_JobXMLOptions SELECT 0, @xmlText, @l_taskId2, @l_subTaskId2, 0, @currentTime, 0
		SET @errCode = @@ERROR
		IF  @errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy-- Failed to insert in TM_JobXMLOptions'
			GOTO ERROR_EXIT
		END
		-- Full Backup
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
312510015,
									   2,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
1816887603,
									   2,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
458405394,
									   7,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
756999446,
									   7,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
1004091438,
									   2,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
1349608518,
									   14,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
2000217775,
									   7,
									   7)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
283876525,
									   14,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
2045937773,
									   2,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_SubTaskOptions(subTaskID,
									  optionID,
									  type,
									  value)
		VALUES						  (@l_subTaskId2,
1817749836,
									   2,
									   1)
		SET @errCode = @@ERROR
		IF	@errCode <> 0
		BEGIN
			SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy -- Failed to insert in TM_SubTaskOptions'
			GOTO ERROR_EXIT
		END
		INSERT INTO TM_JobOptions SELECT 0, OPT.optionId, OPT.type, OPT.value, @l_taskId2, @l_subTaskId2, 0, @currentTime, 0
		FROM TM_SubTaskOptions AS OPT
		INNER JOIN TM_StaticTaskOption ST ON ST.optionId = OPT.optionId AND ST.defVal<>OPT.value
WHERE subTaskId = @l_subTaskId2 AND OPT.optionId NOT IN (152984797, 587329586, 1189579219, 1496752764, 38201114, 458405394, 239177580)
	END
	SET @l_taskId2 = (SELECT id FROM #TM_IDTable WHERE type = 5)
		IF 	ISNULL(@l_taskId2, 0) =0
			SET @l_taskId2 = (SELECT TOP 1 taskId FROM TM_Task (NOLOCK)
WHERE flags & 0x200000 = 0x200000 AND taskName = @taskName)
		DECLARE @backupSetId INT
		DECLARE @InstanceId INT
		DECLARE @appTypeId INT
		DECLARE @subclientId INT
		SELECT @backupSetId=backupSet, @InstanceId=instance, @appTypeId=appTypeId, @subclientId=id FROM APP_Application (NOLOCK)
								WHERE clientId = @i_indexServerClientId and subclientName ='default'
		IF @subclientId >0
			INSERT INTO TM_AssocEntity(assocType,
                                       taskId,
                                       flags,
                                       created,
                                       clientGroupId,
                                       clientId,
                                       appTypeId,
                                       instanceId,
                                       backupsetId,
                                       subclientId,
                                       policyId,
                                       copyId,
                                       srmReportSet,
                                       srmReportType,
                                       exclude,
                                       trackingPolicyId,
                                       MediaagentId,
                                       agentlessPolicyId,
                                       workflowId,
                                       sidbStoreId,
                                       libraryId,
                                       logMonitoringPolicyId
                                       )
VALUES                    (7,          -- assocTye     --ENTITY_TYPE_SUBCLIENT_ENTITY
                                       @l_taskId2,				-- Task ID
                                       0,						-- Flags
                                       @currentTime,			-- Created
                                       0,						-- ClientGroupID
                                       @i_indexServerClientId,  -- ClientID
                                       @appTypeId,				-- AppTypeID
                                       @InstanceId,				-- InstanceID
                                       @backupSetId,			-- BackupSetID
                                       @subClientId,			-- SubClient ID
                                       0,           -- PolicyID
                                       0,           -- Copy ID
                                       0,           -- SRM Report Set
                                       0,           -- SRM Report Type
                                       0,           -- Exclude
                                       0,           -- Trackung Policy ID
                                       0,           -- Media Agent ID
                                       0,           -- Agentless SRM ID
                                       0,           -- Workflow ID
                                       0,           -- SIDB Store ID
                                       0,           -- Library ID
                                       0            -- Log Monitor Policy ID
                                       )
            SET @errCode = @@ERROR
            IF  @errCode <> 0
            BEGIN
                SET @errStr = 'ERROR: System Created Index Server Backup Schedule Policy-- Failed to insert in TM_AssocEntity'
                GOTO ERROR_EXIT
            END
-----------------------------------------------------------------
	--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @errStr OUTPUT , @errCode OUTPUT
END CATCH;
ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#TM_IDTable') IS NOT NULL
		DROP TABLE #TM_IDTable
GO

IF EXISTS (select * from GxQscripts where name = 'AppIndexServerBackupSchedule')
	delete from GxQscripts where name = 'AppIndexServerBackupSchedule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIndexServerBackupSchedule')
	delete from GXDBVersions where aliasname = 'AppIndexServerBackupSchedule'
GO

insert into GXDBVersions values(2, 'AppIndexServerBackupSchedule',  'v1.1.2.1.4.1', 'AppIndexServerBackupSchedule', 'v1.1.2.1.4.1')
GO

