

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIndexCloudToCvCloud.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIndexCloudToCvCloud.sp,v $ $Id: AppIndexCloudToCvCloud.sp,v 1.1.2.7 2020/11/20 15:47:23 pankajkumar Exp $";
--
--  +========================================================================+
--  |      Cursor:  AppIndexCloudToCvCloud()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppIndexCloudToCvCloud')
BEGIN
	print '>>> Drop Stored Procedure: AppIndexCloudToCvCloud <<<'
	drop procedure AppIndexCloudToCvCloud
END
IF EXISTS (select * from GxQscripts where name='AppIndexCloudToCvCloud')
	delete from GxQscripts where name = 'AppIndexCloudToCvCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIndexCloudToCvCloud')
	delete from GXDBVersions where aliasname = 'AppIndexCloudToCvCloud'
GO
print '... Creating Procedure: AppIndexCloudToCvCloud'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppIndexCloudToCvCloud
  @i_indexServerClientId INT=0,
  @i_backupsetGUID VARCHAR(36)='',
  @o_ErrorCode INT =0 OUTPUT,
  @o_ErrorMessage NVARCHAR(2048)=N'SUCCESS' OUTPUT
AS
SET @o_ErrorCode =0
SET @o_ErrorMessage = N'SUCCESS'
DECLARE @UpgradeToCvCloud INT = 1  -- mailbox
SET @UpgradeToCvCloud = ISNULL((SELECT TOP 1 CAST (value AS INT) FROM GxGlobalParam (NOLOCK) WHERE name = 'UpgradeToCvCloud' AND modified =0),1)
IF @UpgradeToCvCloud IN (1, 2, 3)
BEGIN
	BEGIN TRY
	BEGIN TRAN
		--check SP level version for index server, nothing to do if version >= 11.0 SP22
		IF @i_indexServerClientId >0
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
			CREATE TABLE #getIndexServers
                    (     serverURL NVARCHAR(512),
                            clientId INT,
                            clientName NVARCHAR(256),
                            cloudId INT,
                            hostName NVARCHAR(256),
                            basePort INT,
                            engineName  NVARCHAR(256),
                            serverType INT,
                            indexServerClientId INT,
                            internalCloudName NVARCHAR(256)
                    )
			--get all nodes of index server
			EXEC DM2GetIndexServers '', @i_indexServerClientId
			--delete index server node having SP22 or higher version
			DELETE T
			FROM #getIndexServers T
			JOIN App_Client C (NOLOCK) ON T.clientId = C.Id
			JOIN SimInstalledPackages S (NOLOCK) ON T.clientId = S.clientId
WHERE (S.highestSP > 21 AND C.releaseId = 16) OR C.releaseId > 16
			--if no node found, do nothing
			IF NOT EXISTS(SELECT 1 FROM #getIndexServers)
				GOTO SCRIPT_EXIT
		END
		----------------DECLARATIONS --------
		DECLARE @SE_PROPERTY_ATTRIBUTE_NAME VARCHAR(32) = 'shardids'
		DECLARE @CLOUD_CORE_NAME_USERMBX VARCHAR(32) = 'usermbx'
		DECLARE @CLOUD_CORE_NAME_JOURNALMBX VARCHAR(32) = 'journalmbx'
		DECLARE @CLOUD_CORE_NAME_COMMON_MBX VARCHAR(32) = 'mbx'
		DECLARE @CLOUD_SHARD_CORE_POSTFIX VARCHAR(32) = '_shard_'
		DECLARE @CLOUD_MULTINODE_CORE_POSTFIX VARCHAR(32) = '_multinode'
		DECLARE @SE_DATA_SOURCE_TYPE_EXCHANGE VARCHAR(32) = 'exchange'
		DECLARE @SE_DATA_SOURCE_TYPE_MULTINODEFEDERATED VARCHAR(32) = 'multinodefederated'
		DECLARE @SE_DATA_SOURCE_TYPE_BACKUPSETGUID VARCHAR(32) = 'backupsetguid'
		DECLARE @SE_DATA_SOURCE_TYPE_SCHEMAVERSION VARCHAR(32) = 'schemaversion'
		DECLARE @SE_DATA_SOURCE_TYPE_BACKUPSETGUIDXML VARCHAR(32) = 'backupsetguidxml'
		DECLARE @IGNORE_CORE_CREATION INT= 1
		DECLARE @USE_ORIGINAL_CORENAME INT= 2
		DECLARE @DB_ONLY_INFO INT= 8
		DECLARE @DUMMY_CI_INFO INT=16
		DECLARE @ROUTE_TYPE_HASH INT= 1
		DECLARE @ROUTE_TYPE_MODULUS INT= 2
		DECLARE @ROUTE_TYPE_JOURNAL VARCHAR(32) = '80000000-7fffffff'
		DECLARE @ROUTE_ATTRIBUTE_QUERY INT= 1
		DECLARE @ROUTE_ATTRIBUTE_UPDATE INT= 2
		DECLARE @SIM_ID_GX_REL110 INT= 16
		DECLARE @OwnerUserId INT = 1  -- ADMIN
		DECLARE @schemaType VARCHAR(32) =''
		DECLARE @tempSchemaType TABLE (schemaType VARCHAR(32))
		DECLARE @SHARDS_DS_ATTRIBUTE INT= @DB_ONLY_INFO |  @USE_ORIGINAL_CORENAME
		DECLARE @MULTINODE_DS_ATTRIBUTE INT= @IGNORE_CORE_CREATION | @DB_ONLY_INFO |  @USE_ORIGINAL_CORENAME | @DUMMY_CI_INFO
		DECLARE @typeIdExchange INT = (SELECT TOP 1 TypeId FROM SEDataSourceType WHERE TypeName = @SE_DATA_SOURCE_TYPE_EXCHANGE)
		DECLARE @typeIdmultinodefederated INT = (SELECT TOP 1 TypeId FROM SEDataSourceType WHERE TypeName = @SE_DATA_SOURCE_TYPE_MULTINODEFEDERATED)
		DECLARE @BackupSetGuidPropertyId INT  = (SELECT TOP 1 PropertyId FROM  SEProperty  WHERE PropertyName = @SE_DATA_SOURCE_TYPE_BACKUPSETGUID)
		DECLARE @schemaVersionPropertyId INT  = (SELECT TOP 1 PropertyId FROM  SEProperty  WHERE PropertyName = @SE_DATA_SOURCE_TYPE_SCHEMAVERSION)
		DECLARE @BackupSetGuidXMLPropertyId INT  = (SELECT PropertyId FROM  SEProperty  WHERE PropertyName = @SE_DATA_SOURCE_TYPE_BACKUPSETGUIDXML)
		----------------------------------------------
		IF @UpgradeToCvCloud = 1
			SET @schemaType = @CLOUD_CORE_NAME_USERMBX
		ELSE IF @UpgradeToCvCloud = 2
			SET @schemaType = @CLOUD_CORE_NAME_JOURNALMBX
		ELSE IF @UpgradeToCvCloud = 3
			SET @schemaType = @CLOUD_CORE_NAME_COMMON_MBX
		--HANDLE EXISTING SCHEMA
		INSERT INTO SEDataSourceProperty
		SELECT R.DatasourceId , @schemaVersionPropertyId , 2, getutcdate()
		FROM SEDataSourceRoute R
		LEFT JOIN SEDataSourceProperty P ON R.DataSourceId = P.DataSourceId AND P.PropertyId = @schemaVersionPropertyId
		WHERE P.DataSourceId IS NULL
		UNION
		SELECT DISTINCT FederatedDataSourceId , @schemaVersionPropertyId , 2 , getutcdate()
		FROM SEDataSourceRoute R
		LEFT JOIN SEDataSourceProperty P ON R.DataSourceId = P.DataSourceId AND P.PropertyId = @schemaVersionPropertyId
		WHERE P.DataSourceId IS NULL
		UNION
		SELECT P1.DatasourceId , @schemaVersionPropertyId , 2 , getutcdate()
		FROM SEDataSourceProperty P1
		JOIN SEDataSourceRoute R ON P1.PropertyValue = R.FederatedDataSourceId
		LEFT JOIN SEDataSourceProperty P2 ON P1.DataSourceId = P2.DataSourceId AND P2.PropertyId = @schemaVersionPropertyId
		WHERE P1.PropertyId = @typeIdmultinodefederated
		AND P2.DataSourceId IS NULL
		--Get index servers which are associated to Case Manager
		IF object_id('tempdb.dbo.#backupsetGuidTbl') IS NOT null DROP TABLE #backupsetGuidTbl
		CREATE TABLE #backupsetGuidTbl (t_clientId INT, t_cloudId INT, t_backupSetname VARCHAR(256), t_backupSetGUID VARCHAR(36), t_schemaType INT)
		INSERT INTO #backupsetGuidTbl
		SELECT DISTINCT A.clientId, DC.cloudId, D.name, D.GUID, BP.attrVal
		From APP_Application A (NOLOCK)
		JOIN App_IdaName B (NOLOCK) ON A.clientid = B.clientId AND A.appTypeId = B.appTypeId
		JOIN App_IdaProp C (NOLOCK) ON B.id = C.componentNameId AND  C.attrName = 'OnePass Index Server'
		JOIN APP_BackupSetName D (NOLOCK) ON A.backupSet = D.id
		JOIN DM2Cloud DC ON CAST(C.attrval as INT) = DC.pseudoClientId
		JOIN APP_BackupSetProp BP ON D.id =BP.componentNameId AND BP.attrname = 'Exchange OnePass BackupSet Type'   --Handle only input schemaType
		LEFT JOIN APP_ClientProp CP ON A.clientId = CP.componentNameId AND CP.attrName ='Case Manager Pseudo Client'  --case manager clients
		WHERE C.modified = 0
AND A.appTypeId = 137			-- only exchange onepass
AND DC.CloudType = 1   --only standalone index server
			AND CP.attrVal IS NULL  									--exclude case Manager client
			AND (@i_backupsetGUID ='' OR @i_backupsetGUID = CAST(D.GUID as VARCHAR(36)))   --if backupsetGuid is provided as input
			AND ( (@UpgradeToCvCloud =1 AND BP.attrVal = 1) 			-- only input schemaType
				OR  (@UpgradeToCvCloud =3 AND BP.attrVal IN (1,2,3))
				OR  (@UpgradeToCvCloud =2 AND BP.attrVal IN (2,3)))
		--do not include existing backupSetGUID  --Old IS =>New IS =>old IS
		IF @i_indexServerClientId > 0
		BEGIN
			DELETE B
			FROM #backupsetGuidTbl B
			JOIN SEDataSourceProperty DSP (NOLOCK) ON DSP.PropertyValue =  t_backupSetGUID AND DSP.PropertyId = @BackupSetGuidPropertyId
			LEFT JOIN #getIndexServers S ON B.t_cloudId =S.cloudId
			WHERE S.cloudId IS NULL AND DSP.PropertyValue != 'BackupSetGuid_XML_Property'
			--handle multiple backupsetguids
			DELETE B
			FROM #backupsetGuidTbl B
			JOIN SEDataSourceProperty DSP (NOLOCK) ON DSP.PropertyValue LIKE '%'+ t_backupSetGUID +'%' AND DSP.PropertyId = @BackupSetGuidXMLPropertyId
			LEFT JOIN #getIndexServers S ON B.t_cloudId =S.cloudId
			WHERE S.cloudId IS NULL
		END
		ELSE --do not include existing backupSetGUID
		BEGIN
			DELETE B
			FROM #backupsetGuidTbl B
			JOIN SEDataSourceProperty DSP (NOLOCK) ON DSP.PropertyValue =  t_backupSetGUID AND DSP.PropertyId = @BackupSetGuidPropertyId
			WHERE DSP.PropertyValue != 'BackupSetGuid_XML_Property'
			--handle multiple backupsetguids
			DELETE B
			FROM #backupsetGuidTbl B
			JOIN SEDataSourceProperty DSP (NOLOCK) ON DSP.PropertyValue LIKE '%'+ t_backupSetGUID +'%' AND DSP.PropertyId = @BackupSetGuidXMLPropertyId
		END
		--do nothing if no backupsetguid found
		IF NOT EXISTS (SELECT TOP 1 1 FROM #backupsetGuidTbl)
			GOTO SCRIPT_EXIT
		--GET STANDALONE/CVCLOUD INDEX SERVER WITH EXCHANGE INDEX ROLE WITH DEFAULT/PRIMARY NODE
		DECLARE @tempCloudTable TABLE (internalCloudName NVARCHAR(256), cloudId INT, clientId INT)
		INSERT INTO @tempCloudTable
		SELECT DISTINCT C.name, S.cloudId,  S.clientId
		from DM2CloudcoreRole R
		join DM2SearchServerCoreInfo S on R.cloudId = S.cloudId
		join DM2Cloud C on C.cloudId = S.cloudId
		join #backupsetGuidTbl B on B.t_cloudId = C.cloudId
where R.roleId = 12
and (S.coreRoles & 128) > 0
AND C.CloudType = 1
			AND (@i_indexServerClientId = 0 OR C.pseudoClientId = @i_indexServerClientId)
			---Delete existing cvsolr cloud, will have entries into SECollectionInfo table
		IF @i_indexServerClientId = 0
			DELETE T
			FROM @tempCloudTable T
			JOIN SECollectionInfo SC (NOLOCK) on T.cloudId = SC.CloudID	AND SC.CoreName like  '%' + @schemaType + '_' + internalCloudName + '%'
		--delete non applicable cloud
		DELETE B
		FROM #backupsetGuidTbl B
		WHERE t_cloudId NOT IN (SELECT cloudId FROM  @tempCloudTable)
		--NOTHING TO DO, IF NO INDEX SERVER FOUND WITH EXCHANGE ROLE
		IF NOT EXISTS (SELECT TOP 1 1 FROM @tempCloudTable) OR NOT EXISTS (SELECT TOP 1 1 FROM #backupsetGuidTbl)
			GOTO SCRIPT_EXIT
		DECLARE @tempShardsTbl TABLE (id VARCHAR(10), schemaType VARCHAR(32), coreNamePostFix VARCHAR(32), attributes INT, ActualCoreNamePostFix VARCHAR(32), ActualCoreNamePostFixNum VARCHAR(32), isMultiNode INT)
		IF @UpgradeToCvCloud IN (1,3)  --mailbox or all
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 1 FROM #backupsetGuidTbl WHERE t_schemaType IN (1))
				GOTO SCRIPT_EXIT
			INSERT INTO @tempSchemaType
			VALUES (@CLOUD_CORE_NAME_USERMBX)
			INSERT INTO @tempShardsTbl
			VALUES ('0',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '0' ,0),
			('1',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '1',0),
			('2',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '2',0),
			('3',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '3',0),
			('4',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '4',0),
			('5',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '5',0),
			('6',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '6',0),
			('7',@CLOUD_CORE_NAME_USERMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '7',0),
			('',@CLOUD_CORE_NAME_USERMBX, @CLOUD_MULTINODE_CORE_POSTFIX, @MULTINODE_DS_ATTRIBUTE, @CLOUD_MULTINODE_CORE_POSTFIX, '',1),
			('',@CLOUD_CORE_NAME_USERMBX, '', @MULTINODE_DS_ATTRIBUTE, @CLOUD_MULTINODE_CORE_POSTFIX, '',1)
		END
		IF @UpgradeToCvCloud IN (2,3) --journal or all
		BEGIN
			IF NOT EXISTS (SELECT TOP 1 1 FROM #backupsetGuidTbl WHERE t_schemaType IN (2,3))
				GOTO SCRIPT_EXIT
			INSERT INTO @tempShardsTbl
			VALUES ('0',@CLOUD_CORE_NAME_JOURNALMBX, @CLOUD_SHARD_CORE_POSTFIX, @SHARDS_DS_ATTRIBUTE, '', '',0),
					('',@CLOUD_CORE_NAME_JOURNALMBX, @CLOUD_MULTINODE_CORE_POSTFIX, @MULTINODE_DS_ATTRIBUTE, @CLOUD_MULTINODE_CORE_POSTFIX, '',1),
					('',@CLOUD_CORE_NAME_JOURNALMBX, '', @MULTINODE_DS_ATTRIBUTE, @CLOUD_MULTINODE_CORE_POSTFIX, '',1)
			INSERT INTO @tempSchemaType
			VALUES (@CLOUD_CORE_NAME_JOURNALMBX)
		END
		--POPULATE SECollectionInfo
		INSERT INTO SECollectionInfo (CoreName,ClientId,CloudID,OwnerUserId,Description,CreateTime,SchemaType,Attribute,ActualCoreName)
		SELECT (T.schemaType + '_'+ C.internalCloudName +T.coreNamePostFix+ T.id),  C.clientId, C.cloudId, @OwnerUserId,'', getutcdate(),  T.schemaType, t.attributes,
					(T.schemaType + CASE WHEN T.isMultiNode = 1 THEN + '_'+ C.internalCloudName ELSE '' END + T.ActualCoreNamePostFix + T.ActualCoreNamePostFixNum)
		FROM @tempCloudTable C
		CROSS JOIN @tempShardsTbl T
		WHERE (T.schemaType + '_'+ C.internalCloudName +T.coreNamePostFix+ T.id) NOT IN (SELECT CoreName FROM SECollectionInfo)
		IF @@ROWCOUNT =0
			GOTO SCRIPT_EXIT
		--POPULATE SEDataSource
		INSERT INTO SEDataSource (DataSourceGuid, CoreId, DataSourceName, DataSourceType, Description, InformationMsg, ConnPropId, OwnerUserID, Status, CreateTime, Attribute, ModifiedBy, ModifiedTime, DisplayName)
		SELECT newId(), coreId, coreName, CASE WHEN CoreName LIKE '%'+@CLOUD_MULTINODE_CORE_POSTFIX THEN @typeIdmultinodefederated ELSE  @typeIdExchange END,'',NULL, NULL,@OwnerUserId, 0,getutcdate(), 0,@OwnerUserId, getutcdate(), corename
		FROM SECollectionInfo SI
		JOIN @tempCloudTable T ON T.cloudId = SI.CloudID
		JOIN @tempSchemaType S ON SI.SchemaType = S.SchemaType
		WHERE SI.coreId NOT IN (SELECT coreId FROM SEDataSource)
		IF @@ROWCOUNT =0
			GOTO SCRIPT_EXIT
		DECLARE @tempRouteTable TABLE (attrName NVARCHAR(1024), dsId INT, shardsName NVARCHAR(256), fedDsId INT, routeValue varchar(32), routeType INT, xmlProp nvarchar(max))
		INSERT INTO @tempRouteTable
		SELECT @SE_PROPERTY_ATTRIBUTE_NAME, DataSourceId, DataSourceName, 0, (CASE WHEN SI.SchemaType = @CLOUD_CORE_NAME_USERMBX THEN substring (DataSourceName, len(DataSourceName), 1) ELSE @ROUTE_TYPE_JOURNAL END),(CASE WHEN SI.SchemaType = @CLOUD_CORE_NAME_USERMBX THEN @ROUTE_TYPE_MODULUS ELSE @ROUTE_TYPE_HASH END), ''
		FROM SEDataSource DS
		JOIN SECollectionInfo SI ON DS.CoreId = SI.CoreId
		JOIN @tempCloudTable T ON T.cloudId = SI.CloudID
		JOIN @tempSchemaType S ON SI.SchemaType = S.SchemaType
		WHERE DataSourceName LIKE '%_shard_%'
		AND DS.DataSourceId NOT IN (SELECT DataSourceId FROM SEDataSourceRoute)
		--NOTHING TO DO, DATA SOURCE FOUND
		IF NOT EXISTS (SELECT TOP 1 1 FROM @tempRouteTable)
			GOTO SCRIPT_EXIT
		DECLARE @tempRouteInfo TABLE (attrName nvarchar(100), attrVal nvarchar(100),routeType INT)
		INSERT INTO @tempRouteInfo
		VALUES ('routingKeyFieldName', 'cvowner', @ROUTE_TYPE_MODULUS), ('routeType', 'MODULUS', @ROUTE_TYPE_MODULUS),
				('routingKeyFieldName', '', @ROUTE_TYPE_HASH),  ('routeType', 'HASH', @ROUTE_TYPE_HASH)
		UPDATE @tempRouteTable
		SET fedDsId = (SELECT DataSourceId FROM SEDataSource WHERE REPLACE(substring(shardsName,0,len(shardsName)), @CLOUD_SHARD_CORE_POSTFIX, @CLOUD_MULTINODE_CORE_POSTFIX) = DataSourceName)
		UPDATE @tempRouteTable
		SET xmlProp =  (SELECT
							(SELECT  attrName as '@name',
								(SELECT dsId AS '@val'
									FROM @tempRouteTable P
									where attrName = @SE_PROPERTY_ATTRIBUTE_NAME AND P.fedDsId = n.fedDsId
									FOR XML PATH('values'), TYPE
								)
							  FOR XML PATH('nameValues'),TYPE),
							 (SELECT DISTINCT p2.attrName as '@name',
											p2.attrVal AS '@value'
									FROM @tempRouteTable P
									JOIN @tempRouteInfo p2 on p.routeType =p2.routeType and  P.fedDsId = n.fedDsId
								FOR XML PATH('nameValues'),TYPE)
							 FOR XML PATH('DM2ContentIndexing_NameValueMaps'))
		FROM @tempRouteTable n
		--SEDataSourceProperty
		INSERT INTO SEDataSourceProperty
		SELECT DISTINCT DS.DataSourceId, P.PropertyId, CASE	WHEN PropertyName= 'sourceType' THEN @SE_DATA_SOURCE_TYPE_EXCHANGE
												WHEN PropertyName= 'subsourceType' THEN SI.schematype
												WHEN PropertyName= 'roleTypeName' THEN 'Exchange Index'
												END, getutcdate()
		FROM SEDataSource DS
		JOIN SECollectionInfo SI ON DS.coreId = SI.coreId
		JOIN @tempCloudTable T ON T.cloudId = SI.CloudID
		JOIN @tempSchemaType S ON SI.SchemaType = S.SchemaType
		LEFT JOIN SEDataSourceProperty SP ON DS.DataSourceId = sp.DataSourceId
		CROSS JOIN SEProperty P
		WHERE PropertyName in ('sourceType', 'subsourceType', 'roleTypeName')
		AND SP.DataSourceId IS NULL
		union
		SELECT DISTINCT DS.DataSourceId, P.PropertyId, (select TOP 1 CAST (DataSourceId AS nvarchar(MAX)) from SEDataSource where DataSourceName = DS.DataSourceName + @CLOUD_MULTINODE_CORE_POSTFIX), getutcdate()
		FROM SEDataSource DS
		JOIN SECollectionInfo SI ON DS.coreId = SI.coreId
		JOIN @tempCloudTable T ON T.cloudId = SI.CloudID
		JOIN @tempSchemaType S ON SI.SchemaType = S.SchemaType
		LEFT JOIN SEDataSourceProperty SP ON DS.DataSourceId = sp.DataSourceId
		CROSS JOIN SEProperty P
		WHERE PropertyName = 'multinodefederatedid' AND SI.Attribute = @MULTINODE_DS_ATTRIBUTE AND DS.DataSourceType <> @typeIdmultinodefederated
		AND SP.DataSourceId IS NULL
		union
		SELECT  distinct DS.DataSourceId, P.PropertyId, T.xmlProp, GETUTCDATE()
		FROM SEDataSource DS
		JOIN SECollectionInfo SI ON DS.coreId = SI.coreId
		JOIN @tempCloudTable TC ON TC.cloudId = SI.CloudID
		JOIN @tempSchemaType S ON SI.SchemaType = S.SchemaType
		LEFT JOIN SEDataSourceProperty SP ON DS.DataSourceId = sp.DataSourceId
		JOIN @tempRouteTable T ON DS.DataSourceId = T.fedDsId
		CROSS JOIN SEProperty P
		WHERE PropertyName = 'routingInfo' AND SI.Attribute = @MULTINODE_DS_ATTRIBUTE AND DS.DataSourceType = @typeIdmultinodefederated
		AND SP.DataSourceId IS NULL
		UNION
		SELECT DISTINCT DS.DataSourceId, @schemaVersionPropertyId, '1', GETUTCDATE()
		FROM SEDataSource DS
		JOIN SECollectionInfo SI ON DS.CoreId = SI.CoreId
		JOIN @tempCloudTable T ON T.cloudId = SI.CloudID
		JOIN @tempSchemaType S ON SI.SchemaType = S.SchemaType
		LEFT JOIN SEDataSourceProperty SP ON DS.DataSourceId = SP.DataSourceId AND SP.PropertyId = @schemaVersionPropertyId
		WHERE SP.PropertyId IS NULL
				AND SP.DataSourceId IS NULL
		--SEDataSourceRoute
		INSERT INTO SEDataSourceRoute (FederatedDataSourceId, DataSourceId, RouteValue, RouteType, Attribute)
		SELECT T.fedDsId, T.dsId, T.routeValue , T.routeType, (@ROUTE_ATTRIBUTE_QUERY  | @ROUTE_ATTRIBUTE_UPDATE)
		FROM @tempRouteTable T
		LEFT JOIN SEDataSourceRoute R ON T.fedDsId = R.FederatedDataSourceId
		WHERE R.FederatedDataSourceId IS NULL
SCRIPT_EXIT:
		--SEDataSourceProperty - backupsetGUID
		DECLARE @FederatedPropertyId INT  = ISNULL( (SELECT PropertyId FROM  SEProperty  WHERE PropertyName = 'multinodefederatedid'),0)
		DECLARE @AdditionalInfo INT  = ISNULL( (SELECT PropertyId FROM  SEProperty  WHERE PropertyName = 'additionalinfo'),0)
		IF @BackupSetGuidPropertyId >0
		BEGIN
			--Handle multiple backupsets which can use the same index server.
			DECLARE @backupSetGUIDToDSMapping TABLE (t_dsId INT, t_backupSetGUID VARCHAR(36))
			INSERT INTO @backupSetGUIDToDSMapping
			SELECT DISTINCT DS.DataSourceId, B.t_backupSetGUID
			FROM #backupsetGuidTbl B
			JOIN SECollectionInfo SC ON B.t_cloudId = SC.CloudID
			JOIN SEDataSource DS ON SC.CoreId = DS.CoreId
			JOIN SEDataSourceProperty DSP ON DS.DataSourceId = DSP.DataSourceId
			JOIN @tempCloudTable T ON B.t_cloudId = T.cloudId						--do not include existing cvsolr data source
			LEFT JOIN SEDataSourceProperty RP ON DS.DataSourceId = RP.DataSourceId AND RP.PropertyId = @AdditionalInfo AND RP.PropertyValue LIKE '%RecoveryPoint%'		-- do not include case manager data source
			WHERE DSP.PropertyId = @FederatedPropertyId					--insert row only for federated property type
				AND RP.DataSourceId IS NULL									--exclude case manager ds
				AND dbo.GetPropValue('Case Manager Pseudo Client', b.t_clientId) IS NULL			--exclude case manager clients
				AND SUBSTRING (SC.SchemaType,0,5) = SUBSTRING (B.t_backupSetname,0,5)  --user mailbox guid to usermbx datasource
				-- temp table with XML column
				DECLARE  @tempPropertyValXML TABLE  ( t_dsId INT, t_propXmlVal XML )
				--convert propertyValue from varchar to XML
				INSERT INTO @tempPropertyValXML
				SELECT P.DataSourceId, P.PropertyValue
				FROM SEDataSourceProperty P (NOLOCK)
				JOIN @backupSetGUIDToDSMapping B ON P.DataSourceId = B.t_dsId
				WHERE P.PropertyId = @BackupSetGuidPropertyId
				--merge existing backupsetguid for same datasourceId
				INSERT INTO @backupSetGUIDToDSMapping
				SELECT DISTINCT t_dsid, ref1.value('@val', 'NVARCHAR(36)')
				FROM @tempPropertyValXML
				CROSS APPLY t_propXmlVal.nodes('backupSetGUID') as R1(ref1)
				UNION ALL
				SELECT DataSourceId, PropertyValue
				FROM SEDataSourceProperty P (NOLOCK)
				JOIN @backupSetGUIDToDSMapping B ON P.DataSourceId = B.t_dsId
				WHERE P.PropertyId =@BackupSetGuidPropertyId
				and PropertyValue != 'BackupSetGuid_XML_Property'
				--do not include existing datasource
				IF @i_indexServerClientId =0
					DELETE B
					FROM @backupSetGUIDToDSMapping B
					JOIN SEDataSourceProperty DSP2 (NOLOCK) ON B.t_dsId = DSP2.DataSourceId AND DSP2.propertyId = @BackupSetGuidPropertyId
				DELETE P
				FROM SEDataSourceProperty P
				JOIN @backupSetGUIDToDSMapping B ON P.DataSourceId = B.t_dsId
				WHERE P.PropertyId IN (@BackupSetGuidPropertyId, @BackupSetGuidXMLPropertyId)
				--
				INSERT INTO SEDataSourceProperty (DataSourceId,PropertyId, PropertyValue)
				SELECT t_dsId, @BackupSetGuidPropertyId, MAX (t_backupSetGUID) FROM  @backupSetGUIDToDSMapping GROUP BY t_dsId HAVING COUNT(*) = 1
				--store as xml for multiple backupsetGuids
				IF EXISTS(SELECT MAX(t_dsId) FROM  @backupSetGUIDToDSMapping GROUP BY t_dsId HAVING COUNT(*) > 1)
				BEGIN
					INSERT INTO SEDataSourceProperty (DataSourceId,PropertyId, PropertyValue)
					SELECT t_dsId, @BackupSetGuidPropertyId, 'BackupSetGuid_XML_Property' FROM  @backupSetGUIDToDSMapping GROUP BY t_dsId HAVING COUNT(*) > 1
					UNION
					SELECT t_dsId,  @BackupSetGuidXMLPropertyId,
							(SELECT t_backupSetGUID AS '@val'
							FROM @backupSetGUIDToDSMapping P WHERE P.t_dsId = N.t_dsId FOR XML PATH('backupSetGUID'))
					FROM @backupSetGUIDToDSMapping AS N
					GROUP BY t_dsId HAVING COUNT(*) > 1
				END
		END
		IF object_id('tempdb.dbo.#backupsetGuidTbl') IS NOT null DROP TABLE #backupsetGuidTbl
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL  DROP TABLE #getIndexServers
	COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			ROLLBACK TRAN
			SET  @o_ErrorCode =@@ERROR
			SET  @o_ErrorMessage =ERROR_MESSAGE()
		END CATCH
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppIndexCloudToCvCloud')
	delete from GxQscripts where name = 'AppIndexCloudToCvCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIndexCloudToCvCloud')
	delete from GXDBVersions where aliasname = 'AppIndexCloudToCvCloud'
GO

insert into GXDBVersions values(2, 'AppIndexCloudToCvCloud',  '00010001000200070000', 'AppIndexCloudToCvCloud', '00010001000200070000')
GO

