

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdxUpdatePrunedCheckpointValidity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   06/12/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdxUpdatePrunedCheckpointValidity.sp,v $ $Id: AppIdxUpdatePrunedCheckpointValidity.sp,v 1.1.2.4 2019/01/18 20:51:26 sbhukar Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppIdxUpdatePrunedCheckpointValidity')
BEGIN
	print '>>> Drop Stored Procedure: AppIdxUpdatePrunedCheckpointValidity <<<'
	drop procedure AppIdxUpdatePrunedCheckpointValidity
END
IF EXISTS (select * from GxQscripts where name='AppIdxUpdatePrunedCheckpointValidity')
	delete from GxQscripts where name = 'AppIdxUpdatePrunedCheckpointValidity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdxUpdatePrunedCheckpointValidity')
	delete from GXDBVersions where aliasname = 'AppIdxUpdatePrunedCheckpointValidity'
GO
print '... Creating Procedure: AppIdxUpdatePrunedCheckpointValidity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdxUpdatePrunedCheckpointValidity
AS
DECLARE @pruningEnabled INT = 0
IF object_id('tempdb.dbo#tmpPruningChkpPtInfo')     IS NOT NULL DROP TABLE #tmpPruningChkpPtInfo
CREATE TABLE #tmpPruningChkpPtInfo (id INT, t_startTime bigint, t_dbName varchar(128), t_backupSetGUID uniqueidentifier, t_commcellId INT, r_no INT)
IF object_id('tempdb.dbo#tmpLastChkpointTime')     IS NOT NULL DROP TABLE #tmpLastChkpointTime
CREATE TABLE #tmpLastChkpointTime (dbName varchar(128), backupSetGUID uniqueidentifier, commcellId INT, maxStartTime bigint)
SELECT @pruningEnabled = CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0 --ENABLE_INDEX_PRUNING
--Mark all the checkpoints as invalid.
-- Example: For CCM case when we migrate client from a CS where pruning was enabled to a client where pruning is not enabled.
IF @pruningEnabled = 0
	UPDATE App_IndexCheckpointInfo SET flags = flags&~(1)
ELSE
BEGIN
	INSERT INTO #tmpLastChkpointTime
	SELECT dbName, backupSetGUID, commCellId, MAX(startTime)
	FROM App_IndexCheckpointInfo WITH (NOLOCK) WHERE flags&1 = 1
	GROUP BY dbName, backupSetGUID, commCellId
	INSERT INTO #tmpPruningChkpPtInfo
	SELECT info.afileId , info.startTime, info.dbName, info.backupSetGUID, info.commCellId,
	ROW_NUMBER() OVER (PARTITION BY startTime, info.dbName, info.backupSetGUID, info.commCellId ORDER BY endTime DESC, afileId DESC) AS RowNumber
	FROM App_IndexCheckpointInfo info WITH (NOLOCK)
	WHERE flags&1 = 1 -- INDEXDBINFO_FLAG_PRUNINGBIT
	--Keep only latest checkpoint from older cycles
	UPDATE info SET flags = flags&~(1)
	FROM App_IndexCheckpointInfo info
	JOIN #tmpPruningChkpPtInfo T1 ON id = info.afileId AND info.dbName = t_dbName AND info.backupSetGUID = t_backupSetGUID AND info.commcellId = t_commcellId
	JOIN #tmpLastChkpointTime T2
	ON T2.dbName = T1.t_dbName AND T2.backupSetGUID = T1.t_backupSetGUID AND T2.commcellId = T1.t_commcellId AND T1.t_startTime < T2.maxStartTime
	WHERE r_no > 1
	DELETE T1 FROM #tmpPruningChkpPtInfo T1
	JOIN #tmpLastChkpointTime T2
	ON T2.dbName = T1.t_dbName AND T2.backupSetGUID = T1.t_backupSetGUID AND T2.commcellId = T1.t_commcellId
	WHERE r_no > 3 OR (T1.t_startTime < T2.maxStartTime)
	--for current cycle which is still not pruned, keep top 3
	UPDATE info SET flags = flags&~(1)
	FROM App_IndexCheckpointInfo info
	JOIN #tmpLastChkpointTime T1 ON
	T1.dbName = info.dbName AND T1.backupSetGUID = info.backupSetGUID AND T1.commcellId = info.commcellId and info.startTime = T1.maxStartTime
	LEFT JOIN #tmpPruningChkpPtInfo T2
	ON T2.t_dbName = info.dbName AND T2.t_backupSetGUID = info.backupSetGUID AND T2.t_commcellId = info.commcellId AND T2.id = info.afileid
	WHERE T2.id IS NULL
	IF object_id('tempdb.dbo#tmpFindAgedChkpoints')     IS NOT NULL DROP TABLE #tmpFindAgedChkpoints
	CREATE TABLE #tmpFindAgedChkpoints (dbName varchar(128), backupSetGUID uniqueidentifier, commcellId INT, afileId INT)
	-- Find out the checkpoint where atleast 1 valid job is present. Mark the rest for deletion during data aging
	INSERT INTO #tmpFindAgedChkpoints
	SELECT DISTINCT info.dbName, info.backupSetGUID, info.commcellId, info.afileId
	FROM archfile AF WITH (NOLOCK)
	JOIN APP_Application App WITH (NOLOCK) ON AF.appId = App.id
	JOIN APP_BackupSetName BS WITH (NOLOCK) ON BS.id = App.backupSet
	JOIN App_IndexCheckpointInfo info WITH (NOLOCK) ON App.GUID = info.dbName AND BS.GUID = info.backupSetGUID AND info.commcellId = AF.commCellId AND info.flags&1 = 1 -- INDEXDBINFO_FLAG_PRUNINGBIT
	WHERE AF.cTime BETWEEN info.startTime AND info.endTime
	UPDATE info SET flags = flags&~(1)
	FROM App_IndexCheckpointInfo info
	LEFT JOIN #tmpFindAgedChkpoints T1 ON
	T1.dbName = info.dbName AND T1.backupSetGUID = info.backupSetGUID AND T1.commcellId = info.commcellId AND T1.afileId = info.afileId
	WHERE T1.afileId IS NULL
	IF object_id('tempdb.dbo.#tmpFindAgedChkpoints') IS NOT NULL DROP TABLE #tmpFindAgedChkpoints
END
IF object_id('tempdb.dbo.#tmpPruningChkpPtInfo') IS NOT NULL DROP TABLE #tmpPruningChkpPtInfo
IF object_id('tempdb.dbo.#tmpLastChkpointTime') IS NOT NULL DROP TABLE #tmpLastChkpointTime
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppIdxUpdatePrunedCheckpointValidity')
	delete from GxQscripts where name = 'AppIdxUpdatePrunedCheckpointValidity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdxUpdatePrunedCheckpointValidity')
	delete from GXDBVersions where aliasname = 'AppIdxUpdatePrunedCheckpointValidity'
GO

insert into GXDBVersions values(2, 'AppIdxUpdatePrunedCheckpointValidity',  '00010001000200040000', 'AppIdxUpdatePrunedCheckpointValidity', '00010001000200040000')
GO

