

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_logspchange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_logspchange <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_logspchange')
	drop procedure AppIdaUpgrade_logspchange
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_logspchange')
	delete from GxQscripts where name = 'AppIdaUpgrade_logspchange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_logspchange')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_logspchange'
GO
print '... Creating Procedure: AppIdaUpgrade_logspchange'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_logspchange
  @clientID int,
  @apptypeID int,
  @prevReleaseID int,
  @errorCode int OUTPUT,
  @errorString nvarchar(1024) OUTPUT
AS
SET NOCOUNT ON
DECLARE @releaseId AS INT
SET @errorCode = 0
SET @errorString = 'Successful'
--Basic checking--
IF EXISTS (SELECT *
		   FROM APP_Client
		   WHERE id = @clientID)
BEGIN
	SET @releaseID = ISNULL((Select top 1 ID from simAllGalaxyRel order by id desc), 0)
	IF @prevReleaseId = @releaseId
	BEGIN
		SET @errorstring  = 'Client [' + (SELECT name FROM APP_Client WHERE id = @clientID) + '] has already been upgraded to release[' + Convert(varchar(3), @releaseId) + '].'
		--	set @errCode = DB_WARN						-- 'DB_WARN'
		SET @errorcode  = 0							-- Ignore, 8.0 -->9.0 Upgrade Kludge
		GOTO Cleanup
	END
END
ELSE
BEGIN
	SET @errorcode = 1
	SET @errorstring = 'Client ID ' + @clientID + ' is invalid'
	GOTO Cleanup
END
IF @prevReleaseId < 15
BEGIN
IF NOT EXISTS (SELECT * FROM APP_APPLICATION WHERE clientId = @clientID AND @apptypeId = apptypeid)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Client [' + (SELECT name FROM APP_Client WHERE id = @clientID) + '] does not have SAP/MAX DB IDA'
	GOTO Cleanup
END
BEGIN TRY
UPDATE APP_Application
SET logArchGrpID = dataArchGrpID
WHERE clientId = @clientID AND @apptypeID = appTypeId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorcode = ERROR_NUMBER()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
	GOTO Cleanup
END CATCH
END
Cleanup:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_logspchange')
	delete from GxQscripts where name = 'AppIdaUpgrade_logspchange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_logspchange')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_logspchange'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_logspchange',  '00000000000000000000', 'AppIdaUpgrade_logspchange', '00000000000000000000')
GO

