

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_Wrapped.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_Wrapped.sp,v $ $Id: AppIdaUpgrade_Wrapped.sp,v 1.35.2.10 2018/03/27 08:14:16 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: AppIdaUpgrade_Wrapped()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
--  NOTE: SINCE 5.9, 6.1, and 7.0 Each have a different set of Oracle related tables (or renames), this Procedure MUST
--        Have a different release number for each one.  Keep this in mind if patches to existing procs is req'd
--		  releaseId from CvSimDefs4_2Later.h
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_Wrapped <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_Wrapped')
	drop procedure AppIdaUpgrade_Wrapped
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_Wrapped')
	delete from GxQscripts where name = 'AppIdaUpgrade_Wrapped'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_Wrapped')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_Wrapped'
GO
print '... Creating Procedure: AppIdaUpgrade_Wrapped'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_Wrapped
  @i_clientId integer,
  @i_appTypeId integer,
  @i_releaseId integer,
  @i_prevReleaseId integer,
  @retCode integer			OUTPUT,
  @infoString varchar(1024)	OUTPUT,
  @i_calledFromUninstalledClients integer = 0
AS
SET NOCOUNT ON
SET @infoString =  ''				-- BE OPTIMISTIC
SET @retCode    =  0
DECLARE @nowTime   integer
SET	@nowTime     =   dbo.GetUnixTime (GetUTCdate())
DECLARE	@DM_RULE_FLAG_PROP	Nvarchar(256) = N'Data Migrator Rule Flag'
----------------------------------------------------
-- Invoke only from AppIdaUPgrade_UninstalledClients, not otherwise.
----------------------------------------------------
IF @i_calledFromUninstalledClients = 0
BEGIN
IF (@i_appTypeId in (36, 33, 74, 64, 48, 40, 29, 21, 20, 19, 18, 17, 34, 43, 42, 58))
	BEGIN
		EXEC AppIdaUpgrade_MvScanOptionToSC @i_clientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
		if @retCode <> 0
			goto RETURN_RESULTS
	END
IF (@i_appTypeId in (29, 21, 17, 19))
	BEGIN
		EXEC AppIdaUpgrade_UseArchiverDriver @i_clientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
		if @retCode <> 0
			goto RETURN_RESULTS
	END
	--Execute AppIdaUpgrade_MvRecoveryPointtoBkp irrespective of the apptypeid, should be done while client gets upgraded
	--This is for moving the RPs for this client from client level to bkpset level in App_ExtendedProperties
IF (@i_appTypeId in (1,11,33,34,42,43,17,18,17,19,20,19,21,29,38,36,63,64,74)
		AND EXISTS (SELECT * FROM APP_ExtendedProperties WHERE clientId = @i_clientId AND attrType = 127))
	BEGIN
		EXEC AppIdaUpgrade_MvRecoveryPointtoBkp @i_clientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
		if @retCode <> 0
			GOTO RETURN_RESULTS
	END
IF (@i_appTypeId in (1,11,33,34,42,43,17,18,17,19,20,19,21,29,38,36,63,64,74))
	BEGIN
		EXEC AppIdaUpgrade_UseVSSOptions @i_ClientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
		if @retCode <> 0
			GOTO RETURN_RESULTS
	END
IF (@i_appTypeId in (1,11,33,34,42,43,17,18,17,19,20,19,21,29,38,36,63,64,74, 13))
	BEGIN
		EXEC AppIdaUpgrade_SRMOptions @i_ClientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
		if @retCode <> 0
			GOTO RETURN_RESULTS
	END
END
----------------------------------------------------
-- SHAREPOINT IDA
----------------------------------------------------
if (@i_appTypeId = 69 or @i_appTypeId = 78)
BEGIN
IF @i_prevReleaseId <= 14
	BEGIN
		exec AppIdaUpgrade_SPContentToXML @i_clientId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
	END
	goto RETURN_RESULTS
END
----------------------------------------------------
-- ORACLE IDA
----------------------------------------------------
if (@i_appTypeId = 61)
BEGIN
	exec AppIdaUpgrade_SAPforOracle @i_clientId,  @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
	exec AppUpdateAddSettingsRelativePathForClient  @i_clientId,N'SAP',N'OracleSapAgent'
	goto RETURN_RESULTS
END
if (@i_appTypeId = 136)
BEGIN
	exec AppIdaUpgrade_SAPHANA @i_clientId,  @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
	goto RETURN_RESULTS
END
if (@i_appTypeId = 79)
BEGIN
	IF @i_calledFromUninstalledClients = 0				--if it is called from uninstalled clients, then we will execute this stored procedure as part of bulk stored procedure
	BEGIN												--but for normal client upgrade, let it be called from here only. Since this will have less regression.
		exec AppIdaUpgrade_logspchange @i_clientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
	END
	IF @retCode = 0
		exec AppUpdateAddSettingsRelativePathForClient  @i_clientId,N'SAP for MAX DB',N'SapMaxDbAgent'
	if @retCode <> 0
		goto RETURN_RESULTS
END
-- DEFECT 53536:
-- ALL ORACLE iDas require upgrade from 8.0 to 9.0
IF        @i_appTypeId = 2   OR @i_appTypeId =  22
OR @i_appTypeId = 80  OR @i_appTypeId =  23
BEGIN
	exec AppIdaUpgrade_Oracle @i_clientId, @i_appTypeId,  @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
	goto RETURN_RESULTS
END
----------------------------------------------------
-- EXCHANGE IDA
----------------------------------------------------
IF ( @i_appTypeId = 67 OR @i_appTypeId = 68 )
BEGIN
		exec AppIdaUpgrade_ExchangeArchiver @i_clientId, @i_appTypeId, @i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
		goto RETURN_RESULTS
END
IF (@i_appTypeId = 104)
BEGIN
	EXEC AppIdaUpgrade_MySql @i_clientId,@i_prevReleaseId, @retCode OUTPUT, @infoString OUTPUT
	goto RETURN_RESULTS
END
----------------------------------------------------
--- LOTUS NOTES DATA MIGRATOR                    ---
---    Note: Do not care about prevRelease, this ---
---          is always safe to do                ---
----------------------------------------------------
if @i_appTypeId = 90       -- 'CV_APPTYPE_NOTES_DOC_DATA_MIGRATOR'
BEGIN
	UPDATE APP_Application
	SET subClientStatus = subClientStatus & ~32            -- CLEAR "Hidden" bit
	WHERE	appTypeId = @i_appTypeId                       -- Only this AppType
    	  AND (subClientStatus & 8) <> 0                   -- default subClients only
          AND clientId = @i_clientId
--  ONLY ADD THE DB RULES SUBCLIENT PROP IF IT DOESN'T ALREADY EXIST:
	INSERT app_subClientProp (componentNameId, [attrName], [attrType],  [attrVal], created, modified, ccpId)
		SELECT id, @DM_RULE_FLAG_PROP, 10, 8208, @nowTime, 0, 0       -- DISABLE ALL | MANUAL MIGRATION
		FROM 	app_application
			WHERE clientId = @i_clientId
			  AND appTypeId = @i_appTypeId
			  AND NOT EXISTS (Select componentNameId from app_subClientProp where componentNameId = app_application.id
								AND attrName = @DM_RULE_FLAG_PROP
								AND cs_attrName = checksum(@DM_RULE_FLAG_PROP))
END
-----------------------------------------------------------------------
--  Retention Options Upgrade - For FS and Exchange from 9.0 to 10.0 --
-----------------------------------------------------------------------
IF	@i_prevReleaseId =  14  -- SIM_ID_GX_REL90
AND	(@i_calledFromUninstalledClients = 0)
AND (EXISTS (select appTypeId from
			 APP_AppTypeGroupAssoc
			where appGroupId IN(22, 34) AND appTypeId = @i_appTypeId)
	OR @i_appTypeId = 54)
BEGIN
		IF object_id('tempdb.dbo.#AppClientList') IS NOT Null
				DROP TABLE #AppClientList
		CREATE TABLE #AppClientList (
			[clientId] 				int,
			[appType]				int,
			[simOperatingSystemId]	int,
			[releaseId] 			int,
			[packageStateId]		int,
			[packageStateName]		varchar(128),
			[licenseName]			varchar(128)
		)
		INSERT #AppClientList
		SELECT @i_clientId,@i_appTypeId,C.simOperatingSystemId,C.releaseId,0,'',''
		fROM  App_Client C
		WHERE C.Id = @i_clientId
-- ------------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
------------------------------------------------------------------------------------------------
---- Description: Bulk version of AppIdaUpgrade_TurboSubclients to be included in AppIdaUpgrade_UninstalledClients.
------------------------------------------------------------------------------------------------
BEGIN
	------------------------------------------------------------------------------------------------
	-- UPGRADE TURBO SUBCLIENT  : Replacing cursor lines 200-255 in App_Idaupgrade_Wrapped.sp
	------------------------------------------------------------------------------------------------
	IF object_id('tempdb.dbo.#tempScTbl') IS NOT Null
		DROP TABLE #tempScTbl
	CREATE TABLE #tempScTbl (
	appId int NOT NULL PRIMARY KEY,
	appTypeId int NOT NULL,
	isTurbo int)
	INSERT INTO #tempScTbl
	SELECT DISTINCT APP.id,APP.apptypeId,0
	FROM #AppClientList C JOIN APP_APPLICATION APP ON (C.clientId = APP.clientId AND C.appType = APP.appTypeId)
	WHERE
		( C.appType IN (select appTypeId from
					APP_AppTypeGroupAssoc
					where appGroupId IN(22, 34)) OR C.appType = 54)
AND C.ReleaseId <= 14
	UPDATE #tempScTbl
	SET isTurbo = 1
	WHERE appID in (SELECT T.appId FROM #tempScTbl T
	JOIN APP_SubClientProp PROP ON PROP.ComponentNameId = T.appId AND PROP.attrName = 'Is Turbo Subclient'
	WHERE PROP.attrVal = '1' and PROP.modified = 0)
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE  modified = 0
	AND (
			(   componentNameId IN ( SELECT appId FROM #tempScTbl where isTurbo = 0)
				AND attrName IN (N'Days to keep items past their expiration', N'Keep items past their expiration')
			) OR
			(
				componentNameId IN ( SELECT appId FROM #tempScTbl where appTypeId <> 54)
				AND attrName = N'Archived expiration days'
			)
		)
	INSERT INTO APP_SubClientProp
	SELECT appId, N'Archived expiration days' , 7 ,'-1', @nowTime, 0, 0
	FROM #tempScTbl WHERE appTypeId <> 54
	UNION
	SELECT appId, N'Days to keep items past their expiration' , 7 , 0, @nowTime, 0, 0
	FROM #tempScTbl where isTurbo = 0
	DROP TABLE #tempScTbl
END
		DROP TABLE #AppClientList
END
---------------------------------------------------------------------------------------------
-- Force full on Lotuse Notes DB subclients.
---------------------------------------------------------------------------------------------
if (@i_appTypeId = 77 or @i_appTypeId = 59)
 BEGIN
		-- Upgrade to v11.
IF @i_prevReleaseId < 16
		BEGIN
			DECLARE @opTable TABLE (errorCode INT)
			INSERT INTO @opTable
			exec AppRemoveBackupRefTimes 2,  @i_clientId, @i_appTypeId, 0, 30 --CV_CLEAR_UPGRADED
			SET @retCode = (SELECT errorCode FROM @opTable)
			IF @retCode <> 0
				goto RETURN_RESULTS
			-- Insert the property to do upgrade check for Transaction log subclients.
			INSERT INTO APP_SubClientProp
			SELECT DISTINCT APP.id, N'Do Upgrade Check On DB Subclients', 7 ,'1', @nowTime, 0, 0
			FROM APP_Application APP
			WHERE APP.clientId = @i_clientId AND APP.appTypeId = @i_appTypeId
			AND subclientName = 'transaction logs'
		END
 END
IF @i_prevReleaseId < 16
BEGIN
	IF OBJECT_ID('tempdb.dbo.#driverLessAgent') IS NOT NULL
	DROP TABLE #driverLessAgent
	CREATE TABLE #driverLessAgent( agentId INT PRIMARY KEY, explorerBasedRecall INT NULL )
	--Get agent id of Winf FS subclients
	INSERT #driverLessAgent(agentId)
	SELECT DISTINCT agent.id FROM APP_IDAName agent
	INNER JOIN APP_AppTypeGroupAssoc appTypeAssociation ON appTypeAssociation.appTypeId = agent.appTypeId AND appTypeAssociation.appGroupId = 22 AND appTypeAssociation.typeOfGroup = 0 --22:WinFS
	WHERE agent.clientId = @i_clientId
	IF (@@ROWCOUNT > 0)
	BEGIN
		UPDATE T
			SET T.explorerBasedRecall = CAST(prop.attrVal AS INT)
		FROM #driverLessAgent T
		INNER JOIN APP_IDAProp prop on prop.componentNameId = T.agentId
		WHERE prop.attrName = N'Explorer Based End User Recall Enabled' AND prop.modified = 0
		UPDATE T
			SET T.modified = @nowTime
		FROM APP_IDAProp T
		INNER JOIN #driverLessAgent S ON T.componentNameId = S.agentId
		WHERE T.attrName = 'Explorer Based End User Recall Enabled' AND T.modified = 0 AND S.explorerBasedRecall = 0
		INSERT APP_IDAProp
		SELECT agentId, N'Explorer Based End User Recall Enabled', 2, N'1', @nowTime, 0, 0 FROM #driverLessAgent WHERE explorerBasedRecall IS NULL OR explorerBasedRecall = 0
	END
END
---------------------------------------------------------------------------------------------
RETURN_RESULTS:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_Wrapped')
	delete from GxQscripts where name = 'AppIdaUpgrade_Wrapped'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_Wrapped')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_Wrapped'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_Wrapped',  '00010035000200100000', 'AppIdaUpgrade_Wrapped', '00010035000200100000')
GO

