

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_UseVSSOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
 --+========================================================================+
--  | Stored Precedure: AppIdaUpgrade_UseVSSOptions
--
--  | 21-08-2012	jswaminathan
--
--  |
--  | Till 9.0, Use VSS was implemented as USE_SHADOW_COPY_PROP - a boolean option.
--  | From 10.0, Use VSS will be implemented USE_VSS_ENABLED_PROP - a boolean option
--	| and USE_VSS_OPTIONS_PROP
--  |
--	| Use Shadow Copy is a combination of Use VSS Enabled = 1 and Use VSS Options = 1
--	|
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        jswaminathan      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_UseVSSOptions <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_UseVSSOptions')
	drop procedure AppIdaUpgrade_UseVSSOptions
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_UseVSSOptions')
	delete from GxQscripts where name = 'AppIdaUpgrade_UseVSSOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_UseVSSOptions')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_UseVSSOptions'
GO
print '... Creating Procedure: AppIdaUpgrade_UseVSSOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_UseVSSOptions
  @clientId INT,
  @appTypeId INT,
  @prevReleaseId INT,
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(1024) OUTPUT
AS
DECLARE @nowtime AS INT
SET @nowtime = dbo.getunixtime(GETUTCDATE())
/*Upgrade rules
If Use Shadow Copy = 1, set Use VSS Enabled = 1 and Use VSS Options = 1
If Use Shadow Copy = 0 or not exists, set Use VSS Enabeld = 0 and Use VSS Options = 1
*/
/*Upgrade rules to 11.0
	If Use VSS Enabled not exists , set Use VSS Enabled = 0 if DR subclient
*/
DECLARE @CSreleaseId AS INT
DECLARE  @isCommServer AS INT
SET @CSreleaseId  = ISNULL((SELECT top 1 id FROM simAllGalaxyRel ORDER BY id DESC),0)
SET @isCommServer = ISNULL((SELECT top 1 platformType FROM APP_Platform WHERE clientId = @clientId AND platformType=1), 0)
SET @errorCode = 0
SET @errorString = 'Successful'		--Be optimistic
IF @prevReleaseId = @CSreleaseId
BEGIN
	SET @errorstring  = 'Client [' + (SELECT name FROM APP_Client WHERE id = @clientID) + '] has already been upgraded to release[' + Convert(varchar(3), @CSreleaseId) + '].'
	SET @errorcode  = 0
	GOTO Cleanup
END
IF @prevReleaseId < 15
BEGIN
BEGIN TRAN
	DECLARE @tempTbl TABLE
	(
		subClientId INT,
		VSSValue nvarchar(MAX)
	)
	-- Push all the subclients of this client and this apptype into the temp table
	-- Don't do any restriction based on the apptype here. They will be handled in AppIdaUpgade_Wrapped.sp
	-- from where this SP is called during upgrade of a client.
	INSERT INTO @tempTbl
		SELECT DISTINCT Appl.id,
				CASE WHEN EXISTS (SELECT *
								  FROM APP_SubclientProp
WHERE componentNameId = Appl.id AND attrName = 'Use Shadow Copy' AND attrVal = '1' AND modified = 0)
						 THEN '1'
					 ELSE
						'0'
				END
		FROM APP_Application AS Appl
		WHERE Appl.clientId = @clientId AND Appl.appTypeId = @appTypeId
	-- Now delete those subclients, who are associated to a subclient policy.
	-- Since for them, the subclient policy will take care of the property.
	DELETE FROM @tempTbl
	WHERE subClientId IN (SELECT componentNameId
						  FROM APP_SubclientProp
						  WHERE attrName = 'Associated subclient Policy' AND modified = 0)
	-- Age the old property
	UPDATE APP_SubclientProp
	SET modified = @nowTime
WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = 'Use Shadow Copy' AND modified = 0
	--Commenting property update, since this upgrade script may be called twice in case of upgrading a client who has advanced and core FS packages. In which case, the property was getting overwritten
	/*-- Doing this for a safer case. This property should ideally not exist for 9.0 subclients.
	UPDATE APP_SubclientProp
	SET modified = @nowTime
WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = 'Use VSS Enabled' AND modified = 0
	UPDATE APP_SubclientProp
	SET modified = @nowTime
WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = 'Use VSS Options' AND modified = 0*/
	-- If 'Use Shadow Copy' was '1', then 'Use VSS Enabled' will be '1'.
	-- If 'Use Shadow Copy' was '0', then 'Use VSS Enabled' will be '0'.
	INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
SELECT subclientId, 'Use VSS Enabled', 2, VSSValue, @nowTime, 0
		FROM @tempTbl
WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Use VSS Enabled' AND modified = 0)
	-- If 'Use Shadow Copy' was '1', then 'Use VSS Options' should be '1'. (Dont rely on the default value in AppMgr. Better set it here)
	INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
SELECT subclientId, 'Use VSS Options', 7, VSSValue, @nowTime, 0
		FROM @tempTbl
WHERE VSSValue = '1' AND NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Use VSS Options' AND modified = 0)
	IF @@ERROR = 0
		COMMIT TRAN
	ELSE
	BEGIN
		ROLLBACK TRAN
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END
END
IF @isCommServer = 1 AND @prevReleaseId < 16
BEGIN
	DECLARE @subclientId INT
SET @subclientId = ( SELECT TOP 1 id FROM APP_Application WHERE appTypeId = 1000 )	--DR Subclient
IF NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'Use VSS Enabled' AND modified = 0)
	BEGIN
		INSERT INTO APP_SubclientProp (componentnameid, attrName, attrType, attrVal, created, modified)
VALUES( @subclientId, 'Use VSS Enabled', 2, '0', @nowTime, 0 )
	END
END
CleanUp:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_UseVSSOptions')
	delete from GxQscripts where name = 'AppIdaUpgrade_UseVSSOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_UseVSSOptions')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_UseVSSOptions'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_UseVSSOptions',  '00000000000000000000', 'AppIdaUpgrade_UseVSSOptions', '00000000000000000000')
GO

