

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_UseArchiverDriver.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_UseArchiverDriver <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_UseArchiverDriver')
	drop procedure AppIdaUpgrade_UseArchiverDriver
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_UseArchiverDriver')
	delete from GxQscripts where name = 'AppIdaUpgrade_UseArchiverDriver'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_UseArchiverDriver')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_UseArchiverDriver'
GO
print '... Creating Procedure: AppIdaUpgrade_UseArchiverDriver'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_UseArchiverDriver
  @clientId AS INT,
  @apptypeId AS INT,
  @prevReleaseId AS INT,
  @errorCode AS INT OUTPUT,
  @errorString AS NVARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
--DECLARE @clientId AS INT
--DECLARE @apptypeId AS INT
--DECLARE @prevReleaseId AS INT
--DECLARE @errorCode AS INT
--DECLARE @errorString AS NVARCHAR(1024)
SET @errorCode = 0
SET @errorString = 'Succeeded.'
--SET @clientId = 2
--SET @apptypeId = 17
--Convenience defs--
DECLARE @releaseId AS INT
DECLARE @upgradeval AS NVARCHAR
DECLARE @id AS INT
--Basic Checking--
IF NOT EXISTS (SELECT * FROM APP_Client WHERE id = @clientId )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client id[' + CONVERT(NVARCHAR(5),@clientId) + '] is not valid.'
	GOTO cleanup
END
SET @releaseId = ISNULL((SELECT TOP 1 ID FROM simAllGalaxyRel ORDER BY id DESC),0)
IF @prevReleaseId = @releaseId
BEGIN
	SET @errorCode = 0
	SET @errorString = 'Error. Client['+ (SELECT name FROM APP_Client WHERE id = @clientId ) + '] has already been upgraded to release[' +CONVERT(NVARCHAR(5),@releaseId)+'].'
	GOTO cleanup
END
IF (@prevReleaseId <= 14) AND EXISTS (SELECT * FROM APP_IDAName WHERE appTypeId = @apptypeId AND clientId = @clientId)
BEGIN
--Input params valid.--
--proceed with altering the prop values--
BEGIN TRY
BEGIN
		SET @id = (SELECT id
				  FROM APP_IDAName
				  WHERE appTypeId = @apptypeId AND clientId = @clientId)
		SET @upgradeval = ISNULL((SELECT attrVal
								  FROM APP_IDAProp
								  WHERE componentNameId = @id
								  AND attrName = 'Enable Archive' AND modified = 0),'0')
		IF NOT EXISTS(SELECT * FROM APP_IDAProp WHERE componentNameId = @id AND attrName = N'Use Archiver Driver' AND modified = 0)
			INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrval, created, modified, ccpId) VALUES (@id, N'Use Archiver Driver', 2, @upgradeval, dbo.getunixtime(getUTCDate()),0, 0)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END
END CATCH
END
cleanup:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_UseArchiverDriver')
	delete from GxQscripts where name = 'AppIdaUpgrade_UseArchiverDriver'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_UseArchiverDriver')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_UseArchiverDriver'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_UseArchiverDriver',  '00000000000000000000', 'AppIdaUpgrade_UseArchiverDriver', '00000000000000000000')
GO

