

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_UninstalledClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_UninstalledClients.sp,v $ $Id: AppIdaUpgrade_UninstalledClients.sp,v 1.21.60.11 2020/12/04 20:57:07 anarde Exp $";
-- 	+-----------------------------------------------------------------------+
--	|			Stored Procedure: "AppIdaUpgrade_UninstalledClients"		|
--	|																		|
--	|			Converted from Cursor 3/19/2007 For Qinetix 7.0				|
--	|           Expect Calling program to implement transaction!			|
--	|																		|
--	| OPTIONS:																|
--	|		inClient = 0 Do for all clients EXCEPT commserver				|
--	|		clientId <>0 Do for specific Client								|
--	|		clientId ==2 Special Processing in addition to above			|
--	|																		|
--	|		inFlags		 Currently has not meaning ... placeholder!			|
--  |																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_UninstalledClients')
BEGIN
	print '>>> Drop Stored Procedure: AppIdaUpgrade_UninstalledClients <<<'
	drop procedure AppIdaUpgrade_UninstalledClients
END
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_UninstalledClients')
	delete from GxQscripts where name = 'AppIdaUpgrade_UninstalledClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_UninstalledClients')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_UninstalledClients'
GO
print '... Creating Procedure: AppIdaUpgrade_UninstalledClients'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppIdaUpgrade_UninstalledClients
  @inClient integer,
  @inFlags integer
AS
SET  nocount on
-- ONLY UPDATE CLIENTS THAT ARE NO MORE THAN (2) RELEASES BACK ----
DECLARE @topReleaseId integer = ISNULL((select top 1 id from simAllGalaxyRel order by id desc), 2)
DECLARE @minReleaseId integer = @topReleaseId - 2
DECLARE @errCode integer = 0
DECLARE @errString varchar(2048) = ''
DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @BUILD_PROP_ATTR Nvarchar(12) = N'Galaxy Build'
DECLARE @BUILD_PROP_VAL Nvarchar(256) = N'BUILD80'
DECLARE		@LIC_PROP_NAME		varchar(1024)		-- Needed for Case where client = 2 (Commcell)
DECLARE		@packageStateId		integer
DECLARE		@packageStateName	varchar(256)
DECLARE		@hasSharePoint		integer
DECLARE		@hasFileArchiver	integer
-----------------------------------------------
-- VARIABLES FOR VARIOUS CURSORS:
DECLARE 	@clientId		int
DECLARE		@appTypeId		int
DECLARE 	@releaseId		int
DECLARE		@simOSId		int
-----------------------------------------------
BEGIN TRY
	------------------------------------------------
	--BUILD THE LIST OF CLIENTS TO LOOK AT:		--
	------------------------------------------------
	IF object_id('tempdb.dbo.#ClientList') IS NOT Null
	DROP TABLE #ClientList
	CREATE TABLE #ClientList (
		[clientId] 				int NOT NULL PRIMARY KEY,
[clientName]			nvarchar(255),
		[simOperatingSystemId]	int,
		[releaseId] 			int,
		[errCode]				int,
[errString]				varchar(2048)
	)
	IF @inClient <> 0									-- ANY SPECIFIC CLIENT (PROBABLY COMMCELL)
		INSERT #ClientList
			Select [id], [name], [simOperatingSystemId], [releaseId], 0, ''
			FROM APP_Client
			WHERE id =@inClient
	ELSE
	INSERT #ClientList									-- ALL CLIENTS EXCEPT COMMCELL
			Select distinct C.id, C.name, C.simOperatingSystemId, C.releaseId, 0, ''
			FROM APP_Client C LEFT OUTER JOIN SimInstalledPackages p ON
                                  p.clientId = C.Id
		      WHERE (C.status & 2) <> 0
			  AND C.id <> 2
			  AND C.releaseId >= @minReleaseId
			  AND C.releaseId < @topReleaseId
			  AND p.clientId IS NULL
	------------------------------------------------
	-- BUILD THE LIST OF IDA
	------------------------------------------------
	IF object_id('tempdb.dbo.#AppClientList') IS NOT Null
	DROP TABLE #AppClientList
	-- IDA UPGRADE
	CREATE TABLE #AppClientList (
		[clientId] 				int,
		[appType]				int,
		[simOperatingSystemId]	int,
		[releaseId] 			int,
		[packageStateId]		int,
		[packageStateName]		varchar(128),
		[licenseName]			varchar(128)
	)
	INSERT #AppClientList
	SELECT C.clientId,A.appTypeId,C.simOperatingSystemId,C.releaseId,0,'',''
	fROM  #ClientList C JOIN App_IdaName A ON
	C.clientId = A.clientId
	------------------------------------------------------------------------------------------------
	-- IDA UPGRADE
	------------------------------------------------------------------------------------------------
	DECLARE clientCursor CURSOR STATIC FOR
	Select [clientId], [appType],[simOperatingSystemId], [releaseId] From #AppClientList
	OPEN clientCursor
	FETCH NEXT From clientCursor INTO @clientId, @appTypeId, @simOSId, @releaseId
	WHILE @@FETCH_STATUS = 0
	BEGIN
			EXEC AppIdaUpgrade_Wrapped @clientId, @appTypeId, @topReleaseId, @releaseId, @errCode OUTPUT, @errString OUTPUT, 1
			IF @errCode <> 0
			BEGIN
				GOTO RETURN_RESULTS								-- In Future, may want to skip over errors
			END
	FETCH NEXT From clientCursor INTO @clientId,@appTypeId, @simOSId, @releaseId
	END
	CLOSE       clientCursor
	DEALLOCATE  clientCursor
	-- Moving All queries that take time to a sp body to do bulk update IDA UPGRADE
-- ------------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
------------------------------------------------------------------------------------------------
---- Description: Bulk version of AppIdaUpgrade_TurboSubclients to be included in AppIdaUpgrade_UninstalledClients.
------------------------------------------------------------------------------------------------
BEGIN
	------------------------------------------------------------------------------------------------
	-- UPGRADE TURBO SUBCLIENT  : Replacing cursor lines 200-255 in App_Idaupgrade_Wrapped.sp
	------------------------------------------------------------------------------------------------
	IF object_id('tempdb.dbo.#tempScTbl') IS NOT Null
		DROP TABLE #tempScTbl
	CREATE TABLE #tempScTbl (
	appId int NOT NULL PRIMARY KEY,
	appTypeId int NOT NULL,
	isTurbo int)
	INSERT INTO #tempScTbl
	SELECT DISTINCT APP.id,APP.apptypeId,0
	FROM #AppClientList C JOIN APP_APPLICATION APP ON (C.clientId = APP.clientId AND C.appType = APP.appTypeId)
	WHERE
		( C.appType IN (select appTypeId from
					APP_AppTypeGroupAssoc
					where appGroupId IN(22, 34)) OR C.appType = 54)
AND C.ReleaseId <= 14
	UPDATE #tempScTbl
	SET isTurbo = 1
	WHERE appID in (SELECT T.appId FROM #tempScTbl T
	JOIN APP_SubClientProp PROP ON PROP.ComponentNameId = T.appId AND PROP.attrName = 'Is Turbo Subclient'
	WHERE PROP.attrVal = '1' and PROP.modified = 0)
	UPDATE APP_SubClientProp
	SET modified = @nowTime
	WHERE  modified = 0
	AND (
			(   componentNameId IN ( SELECT appId FROM #tempScTbl where isTurbo = 0)
				AND attrName IN (N'Days to keep items past their expiration', N'Keep items past their expiration')
			) OR
			(
				componentNameId IN ( SELECT appId FROM #tempScTbl where appTypeId <> 54)
				AND attrName = N'Archived expiration days'
			)
		)
	INSERT INTO APP_SubClientProp
	SELECT appId, N'Archived expiration days' , 7 ,'-1', @nowTime, 0, 0
	FROM #tempScTbl WHERE appTypeId <> 54
	UNION
	SELECT appId, N'Days to keep items past their expiration' , 7 , 0, @nowTime, 0, 0
	FROM #tempScTbl where isTurbo = 0
	DROP TABLE #tempScTbl
END
	IF @errCode <> 0
		GOTO RETURN_RESULTS
-- -------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
BEGIN TRY
/**************************************************************************
Description: Bulk version of AppIdaUpgrade_MvScanOptionToSC to be included
in AppIdaUpgrade_UninstalledClients.
Author: jswaminathan
**************************************************************************/
IF OBJECT_ID('tempdb.dbo.#backupSetListAndValues') IS NOT NULL
		DROP TABLE #backupSetListAndValues
	CREATE TABLE #backupSetListAndValues
	(
		clientId INT,
		appTypeId INT,
		backupsetId INT,
		resetFileAccessTimes INT,
		useChangeJournal INT,
		useDC INT,
		useArchiveBit INT,
		useClassicScan INT
	)
	INSERT INTO #backupSetListAndValues (clientId, appTypeId, backupsetId)
		SELECT DISTINCT Appl.clientId, Appl.appTypeId, Appl.backupset						--will this DISTINCT be costly ?
		FROM #clientList Cl INNER JOIN APP_Client C ON Cl.clientId = C.id AND C.releaseId <= 14
							INNER JOIN APP_Application Appl ON Cl.clientId = Appl.clientId AND Appl.appTypeId IN (36, 33, 74, 64, 48, 40, 29, 21, 20, 19, 18, 17, 34, 43, 42, 58)
	DELETE bkp
	FROM #backupSetListAndValues bkp INNER JOIN App_BackupsetProp Prop
	ON bkp.backupsetId = Prop.componentNameID AND Prop.attrName = N'Associated subclient Policy' AND Prop.modified = 0
	--reset file access times: direct dependency on property 'reset file access times' or 'preserve file access times'
	--use change journal:
	--if apptypeid is windows:
	--	if 'use change journal' exists: set use change journal to that value
	--	else: default to 1
	--else:
	--	set use change journal to 0
	--useDC:
	--if apptypeId <> 74:
	--	if 'Use DC for FS backups' exists: set usedc to that value
	--	else: default to 0
	--else
	--	set useDc to 0
	--useArchiveBit:
	--if apptypeId <> 74:
	--	if 'Use Archive bit' exists: set useArchiveBit to that value
	--	else: default to 0
	--else
	--	set useArchiveBit to 0
	UPDATE bkp
	SET bkp.useChangeJournal = Flat.[Use Change Journal],
		bkp.useDC = Flat.[Use DC for FS backups],
		bkp.useArchiveBit = Flat.[Use Archive bit],
		bkp.resetFileAccessTimes = CASE WHEN Flat.[Reset File access Times] IS NOT NULL THEN [Reset File access Times] ELSE [Preserve File access Times] END
	FROM #backupSetListAndValues bkp INNER JOIN (SELECT componentNameId, [Use Change Journal], [Use DC for FS backups], [Use Archive bit], [Reset File access Times], [Preserve File access Times]
											FROM
											(
														SELECT componentNameId, attrName, CAST(attrVal AS INT) AS attrVal
														FROM APP_BackupSetProp
														WHERE attrName IN (N'Use Change Journal', N'Use DC for FS backups', N'Use Archive bit', N'Reset File access Times', N'Preserve File access Times')
														AND modified = 0
											)AS bkp1
											PIVOT
											(
														MAX(attrVal)
														FOR attrName IN ([Use Change Journal], [Use DC for FS backups], [Use Archive bit], [Reset File access Times], [Preserve File access Times])
											)AS Pvt)Flat
	ON bkp.backupsetId = Flat.componentNameId
	UPDATE #backupSetListAndValues
	SET useDC = (CASE WHEN (useDC IS NULL OR appTYpeID = 74) THEN 0 ELSE useDC END),
		useArchiveBit = (CASE WHEN (useArchiveBit IS NULL OR appTypeID = 74) THEN 0 ELSE useArchiveBit END)
	UPDATE #backupSetListAndValues
	SET useChangeJournal = 1
	FROM #backupSetListAndValues bkp INNER JOIN APP_AppTypeGroupAssoc G
	ON bkp.appTypeId = G.appTypeId AND G.appGroupId = 57 AND bkp.useChangeJournal IS NULL
	UPDATE #backupSetListAndValues
	SET useChangeJournal = 0
	WHERE useChangeJournal IS NULL
	UPDATE #backupSetListAndValues
	SET resetFileAccessTimes = 0
	WHERE resetFileAccessTimes IS NULL
	--use classic scan:
	--if appTypeID in 57 apptypegroup:
	--	if use DC and use change journal are 0: set use classic scan as 1
	--	else: set use classic scan as 0
	--else:
	--	set use change journal as 0:
	UPDATE #backupSetListAndValues
	SET useClassicScan = CASE WHEN useDC = 0 AND useChangeJournal = 0 THEN 1 ELSE 0 END
	INSERT INTO APP_SubclientProp (componentNameId , attrName , attrType , attrVal,created, modified )
		SELECT Apl.id, N'Use Change Journal', 2, useChangeJournal, dbo.GetUnixTime(GETUTCDATE()), 0
		FROM #backupSetListAndValues bkp INNER JOIN APP_Application Apl
		ON bkp.backupsetId = Apl.backupSet
		WHERE NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = Apl.id AND attrName = N'Use Change Journal' AND modified = 0)
		UNION
		SELECT Apl.id, N'Preserve File Access Times', 2, resetFileAccessTimes, dbo.GetUnixTime(GETUTCDATE()), 0
		FROM #backupSetListAndValues bkp INNER JOIN APP_Application Apl
		ON bkp.backupsetId = Apl.backupSet
		WHERE NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = Apl.id AND attrName = N'Preserve File Access Times' AND modified = 0)
		UNION
		SELECT Apl.id, N'Use DC for FS Backups', 2, useDC, dbo.GetUnixTime(GETUTCDATE()), 0
		FROM #backupSetListAndValues bkp INNER JOIN APP_Application Apl
		ON bkp.backupsetId = Apl.backupSet
		WHERE NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = Apl.id AND attrName = N'Use DC for FS Backups' AND modified = 0)
		UNION
		SELECT Apl.id, N'Use Archive Bit', 2, useArchiveBit, dbo.GetUnixTime(GETUTCDATE()), 0
		FROM #backupSetListAndValues bkp INNER JOIN APP_Application Apl
		ON bkp.backupsetId = Apl.backupSet
		WHERE NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = Apl.id AND attrName = N'Use Archive Bit' AND modified = 0)
		UNION
		SELECT Apl.id, N'Use Classic file scan', 2, useClassicScan, dbo.GetUnixTime(GETUTCDATE()), 0
		FROM #backupSetListAndValues bkp INNER JOIN APP_Application Apl
		ON bkp.backupsetId = Apl.backupSet
		WHERE NOT EXISTS (SELECT * FROM APP_SubClientProp WHERE componentNameId = Apl.id AND attrName = N'Use Classic file scan' AND modified = 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode = ERROR_NUMBER()
	SET @errString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
	IF @errCode <> 0
		GOTO RETURN_RESULTS
-- -------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
BEGIN TRY
/**************************************************************************
Description: Bulk version of AppIdaUpgrade_UseArchiverDriver to be included
in AppIdaUpgrade_UninstalledClients.
Author: jswaminathan
**************************************************************************/
	IF OBJECT_ID ('tempdb.dbo.#useArchiverDriver_client_list') IS NOT NULL
		DROP TABLE #useArchiverDriver_client_list
	CREATE TABLE #useArchiverDriver_client_list
	(
		clientId INT,
		appTypeId INT,			--this is app_idaname::id
		attrVal nvarchar(10)
	)
	INSERT INTO #useArchiverDriver_client_list (clientId, appTYpeId, attrVal)
		SELECT CL.clientId, I.id, ISNULL(Prop.attrVal, '0')
		FROM APP_IDAName I INNER JOIN #ClientList CL
		ON I.clientId = CL.clientId AND I.appTypeId IN (29, 21, 17, 19)
		INNER JOIN APP_Client C ON C.id = CL.clientID AND C.releaseId <= 14
		LEFT OUTER JOIN APP_IDAProp Prop ON Prop.componentNameId = I.id AND Prop.attrName = 'Enable Archive' AND Prop.modified = 0
	INSERT INTO APP_IDAProp (componentNameId, attrName, attrType, attrval, created, modified, ccpId)
		 SELECT appTypeId, 'Use Archiver Driver', 2, attrVal, dbo.getunixtime(getUTCDate()), 0, 0
		 FROM #useArchiverDriver_client_list
		 WHERE NOT EXISTS (SELECT * FROM APP_IdaProp WHERE componentNameId = #useArchiverDriver_client_list.appTypeId AND attrName = 'Use Archiver Driver' AND modified = 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode = ERROR_NUMBER()
	SET @errString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
	IF @errCode <> 0
		GOTO RETURN_RESULTS
-- -------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- -------------------------------------------------------------------------
BEGIN TRY
/**************************************************************************
Description: Bulk version of AppIdaUpgrade_MvRecoveryPointtoBkp to be included
in AppIdaUpgrade_UninstalledClients.
Author: jswaminathan
**************************************************************************/
	IF OBJECT_ID ('tempdb.dbo.#mvrecoverypointtobkp_client_list') IS NOT NULL
	DROP TABLE #mvrecoverypointtobkp_client_list
	CREATE TABLE #mvrecoverypointtobkp_client_list
	(
		clientId INT,
		appTypeId INT,
		backupsetId INT
	)
	INSERT INTO #mvrecoverypointtobkp_client_list
		SELECT DISTINCT A.clientId, A.appTypeId, A.backupSet
		FROM #ClientList CL INNER JOIN APP_Client C ON CL.clientId = C.id AND C.releaseId <= 14
							INNER JOIN APP_ExtendedProperties E ON E.clientId = C.id AND E.attrType = 127
							INNER JOIN APP_Application A ON C.id = A.clientId AND A.appTypeId IN (
1,11,33,
34,42,43,
17,18,17,19,
20,19,21,29,
38,36,63,64,
74)
							INNER JOIN APP_BackupSetName B ON (B.id = A.backupset ) AND (B.status & 0x8 = 0x8)
	--Input params valid.--
	--proceed with altering the prop values--
	--check that each client has only one entry in here
	IF EXISTS (SELECT COUNT(*),clientId FROM #mvrecoverypointtobkp_client_list GROUP BY clientId HAVING COUNT(*) >= 2)
	BEGIN
			--should we throw error ?
			SET @errCode = 1
			SET @errString = 'Client Id [' + (SELECT TOP 1 CAST(clientId AS NVARCHAR(10)) FROM #mvrecoverypointtobkp_client_list GROUP BY clientId HAVING COUNT(*) >= 2) + '] has more than one default FS backupsets'
			GOTO RETURN_RESULTS
	END
    --Update BackupSetId and AppTypeId
	--Because in 9.0 windows client was saved as CV_APPTYPE_WINDOWS_FILESYSTEM(33) but from 10.0 they are saved with respective apptypes
	UPDATE E
	SET E.backupSet = Temp.backupsetID, E.apptypeid = Temp.appTypeId
	FROM APP_ExtendedProperties E INNER JOIN #mvrecoverypointtobkp_client_list Temp
	ON E.clientId = Temp.clientID AND E.attrType = 127
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode = ERROR_NUMBER()
	SET @errString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
	IF @errCode <> 0
		GOTO RETURN_RESULTS
-- -------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
BEGIN TRY
/**************************************************************************
Description: Bulk version of AppIdaUpgrade_UseVSSOptions to be included
in AppIdaUpgrade_UninstalledClients.
Author: jswaminathan
**************************************************************************/
/*Upgrade rules
If Use Shadow Copy = 1, set Use VSS Enabled = 1 and Use VSS Options = 1
If Use Shadow Copy = 0 or not exists, set Use VSS Enabeld = 0 and Use VSS Options = 1
*/
IF OBJECT_ID ('tempdb.dbo.#useVSSOptions_client_list') IS NOT NULL
	DROP TABLE #useVSSOptions_client_list
CREATE TABLE #useVSSOptions_client_list
(
	clientId INT,
	appTypeId INT
)
INSERT INTO #useVSSOptions_client_list
	SELECT I.clientId, I.appTypeId
	FROM APP_IDAName I INNER JOIN #ClientList CL
	ON I.clientId = CL.clientid AND I.appTypeId IN (1,11,33,34,42,43,17,18,17,19,20,19,21,29,38,36,63,64,74)
	INNER JOIN APP_Client C ON I.clientId = C.id AND C.releaseId <= 14
	DECLARE @tempTbl TABLE
	(
		subClientId INT,
		VSSValue nvarchar(MAX)
	)
	-- Push all the subclients of this client and this apptype into the temp table
	-- Don't do any restriction based on the apptype here. They will be handled in AppIdaUpgade_Wrapped.sp
	-- from where this SP is called during upgrade of a client.
	INSERT INTO @tempTbl
		SELECT Appl.id,
			   ISNULL(Prop.attrVal, '0')
		FROM APP_Application AS Appl INNER JOIN #useVSSOptions_client_list CL
		ON CL.clientId = Appl.clientId AND Cl.appTypeId = Appl.apptypeid
		LEFT OUTER JOIN APP_SubclientProp Prop ON Appl.id = Prop.componentNameId AND Prop.attrName = 'Use Shadow Copy' AND Prop.modified = 0
	-- Now delete those subclients, who are associated to a subclient policy.
	-- Since for them, the subclient policy will take care of the property.
	DELETE FROM @tempTbl
	WHERE subClientId IN (SELECT componentNameId
						  FROM APP_SubclientProp
						  WHERE attrName = 'Associated subclient Policy' AND modified = 0)
	-- Age the old property
	UPDATE Prop
	SET modified = dbo.getunixtime(GETUTCDATE())
	FROM APP_SubclientProp Prop INNER JOIN @tempTbl SC
	ON Prop.componentNameId = Sc.subClientId AND attrName = 'Use Shadow Copy' AND modified = 0
	-- If 'Use Shadow Copy' was '1', then 'Use VSS Enabled' will be '1'.
	-- If 'Use Shadow Copy' was '0', then 'Use VSS Enabled' will be '0'.
	INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Use VSS Enabled', 2, VSSValue, dbo.getunixtime(GETUTCDATE()), 0
        FROM @tempTbl
        WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Use VSS Enabled' AND modified = 0)
	-- If 'Use Shadow Copy' was '1', then 'Use VSS Options' should be '1'. (Dont rely on the default value in AppMgr. Better set it here)
	INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Use VSS Options', 7, VSSValue, dbo.getunixtime(GETUTCDATE()), 0
        FROM @tempTbl
        WHERE VSSValue = '1' AND NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Use VSS Options' AND modified = 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode = ERROR_NUMBER()
	SET @errString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
	IF @errCode <> 0
		GOTO RETURN_RESULTS
-- -------------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
BEGIN TRY
/**************************************************************************
Description: Bulk version of AppIdaUpgrade_SRMOptions to be included
in AppIdaUpgrade_UninstalledClients.
Author: jswaminathan
**************************************************************************/
	IF OBJECT_ID ('tempdb.dbo.#SRMOptions_client_list') IS NOT NULL
	DROP TABLE #SRMOptions_client_list
	CREATE TABLE #SRMOptions_client_list
	(
		clientId INT,
		appTypeId INT,
		attrVal INT
	)
	INSERT INTO #SRMOptions_client_list
		SELECT CL.clientId, I.appTypeId, ISNULL(Prop.attrVal, '0')
		FROM APP_IDAName I INNER JOIN #ClientList CL ON I.clientId = CL.clientID AND I.appTYpeId IN (1,11,33,34,42,43,17,18,17,19,20,19,21,29,38,36,63,64,74, 13)
		INNER JOIN APP_Client C ON I.clientId = C.id AND C.releaseID <= 14
		LEFT OUTER JOIN APP_IDAProp Prop ON Prop.componentNameId = I.id AND Prop.attrName = 'SRM Data Collection Enabled' AND Prop.modified = 0
	DECLARE @tempTbl1 TABLE
	(
		subclientId INT,
		newVal	NVARCHAR(10)
	)
	--Rule:
	--At iDA level, if 'SRM Data Collection Enabled' = 1, then 'SRM Data Collection Options' = 1
	--At iDA level, if 'SRM Data Collection Enabled' = 0 or not exists, then 'SRM Data Collection Options' = 0
	INSERT INTO @tempTbl1
		SELECT appl.id, temp.attrVal
		FROM APP_Application AS appl INNER JOIN #SRMOptions_client_list temp
		ON Appl.clientId = temp.ClientID AND aPPL.apptypeid = temp.apptypeid
		 --Age the old property
		 UPDATE APP_SubClientProp
		 SET modified = dbo.getunixtime(getutcdate())
		 WHERE componentNameId in (SELECT subclientId FROM @tempTbl1) AND attrName = 'SRM Data Collection Options' AND modified = 0
		 --Insert the new property
		 INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT subclientId, 'SRM Data Collection Options', 10, newVal, dbo.getunixtime(getutcdate()), 0
			FROM @tempTbl1
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode = ERROR_NUMBER()
	SET @errString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
	IF @errCode <> 0
		GOTO RETURN_RESULTS
-- ------------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ------------------------------------------------------------------------
BEGIN TRY
/**************************************************************************
Description: Bulk version of AppIdaUpgrade_logspchange to be included
in AppIdaUpgrade_UninstalledClients.
Author: jswaminathan
**************************************************************************/
	IF OBJECT_ID('tempdb.dbo.#logspchange_client_list') IS NOT NULL
		DROP TABLE #logspchange_client_list
	CREATE TABLE #logspchange_client_list
	(
		clientId INT,
		appTypeId INT
	)
	INSERT INTO #logspchange_client_list (clientId, appTypeId)
		SELECT I.clientId, I.appTypeId
		FROM APP_IDAName I INNER JOIN #clientList CL
		ON I.clientId = CL.clientID AND I.appTypeID = 79
		INNER JOIN APP_Client C ON C.Id = CL.clientID AND C.releaseID <= 14
	UPDATE Appl
	SET Appl.logArchGrpID = Appl.dataArchGrpID
	FROM APP_Application Appl INNER JOIN #logspchange_client_list lp
	ON Appl.clientId = lp.clientId AND Appl.appTypeId = lp.appTypeId
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode = ERROR_NUMBER()
	SET @errString = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END CATCH
	IF @errCode <> 0
		GOTO RETURN_RESULTS
	-- CLIENT PACKAGES INSTALLED INFO
	UPDATE #AppClientList
	SET [licenseName] = dbo.GetLicensePropName(appType),
	 packageStateId = ISNULL((dbo.GetPackageID(appType, simOperatingSystemId)), 0)
	DELETE #AppClientList WHERE packageStateId IN( 0, 1)
	UPDATE #AppClientList
	SET packageStateName = 'PackageStateForId ' + CONVERT(varchar(10), packageStateId)
	WHERE [licenseName] = 'Installed'
	MERGE App_ClientProp DEST
	USING (select distinct clientId,packageStateName from #AppClientList WHERE licenseName = 'Installed') AS SRC
	ON SRC.clientId = DEST.componentNameId
	AND DEST.attrName = SRC.packageStateName AND DEST.modified = 0
	WHEN MATCHED THEN
		UPDATE  SET attrVal = '1'
	WHEN NOT MATCHED THEN
		INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
		VALUES (SRC.clientId, SRC.packageStateName, 2, '1', @nowTime, 0);
	IF @clientId = 2
	BEGIN
		MERGE App_ClientProp DEST
		USING  (select distinct clientId,licenseName from #AppClientList WHERE licenseName <> 'Installed')  AS SRC
		ON SRC.clientId = @clientId AND SRC.clientId = DEST.componentNameId
		AND DEST.attrName	= SRC.licenseName AND DEST.modified = 0
		WHEN MATCHED THEN
			UPDATE  SET attrVal = '1'
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (SRC.clientId, SRC.licenseName, 2, '1', @nowTime, 0);
	END
	-- CLIENT PROCESSING
	UPDATE APP_CLIENT SET GUID = NEWID()WHERE GUID = '00000000-0000-0000-0000-000000000000' and id IN
	(SELECT clientId FROM #ClientList)
	--Remove Duplicate names
	DECLARE @deConfiguredPseudoClients TABLE (clientId INT)
	INSERT INTO @deConfiguredPseudoClients
	SELECT clientId FROM #ClientList WHERE  dbo.IsPseudoClient(clientId) = 1
	AND (LEN(ISNULL((SELECT net_hostname FROM APP_Client WHERE id = clientId),'')) = 0)
	-- In V10 and earlier released, Non-NDMP clients had the simOperatingSystemId as 29. It was changed to 19 in v11.
	-- * Careful - Hitechi NAS has simOperatingSystem of 29 (true in V10) - so do NOT do this change if CV_STATUS_NAS bit is set.
	-- * Careful - only do this for simOperatingSystemId = 29. NetApp is 16, Celerra is 17 - we don't want to modify correct values.
	-- In V11 and later releases this simOperatingSystemId has been corrected. Do not change V11 clients (releaseId of 16 or later)
	-- * Careful - do this BEFORE modifying the releaseId
	UPDATE APP_CLIENT
	set simOperatingSystemId = 19
	where simOperatingSystemId = 29
	and releaseId < 16
and (status & (CONVERT(INT,0x8000000) | CONVERT(INT,0x0080))) = 0x8000000
	UPDATE APP_CLIENT SET releaseId = @topReleaseId, net_hostname = name + '_Upgraded_' +  convert(nvarchar(10),@nowTime)
	FROM APP_client as SRC
	JOIN @deConfiguredPseudoClients as DEST
	ON DEST.clientId = SRC.id
	AND EXISTS ( SELECT id FROM APP_CLIENT C where C.net_hostname = SRC.name)
	UPDATE  APP_CLIENT SET releaseId = @topReleaseId, net_hostname = name WHERE (LEN(ISNULL(net_hostname,'')) = 0)
	AND id in (SELECT clientId FROM @deConfiguredPseudoClients)
	--Update Release Id
	UPDATE APP_Client SET releaseId = @topReleaseId WHERE [id] IN (SELECT clientId FROM #ClientList) AND releaseId <> @topReleaseId
	-- Clean up SIMINstalledPackages
	IF @clientId <> 2
		DELETE simInstalledPackages WHERE [clientId] IN (SELECT clientId FROM #ClientList)
	-- Update Version
	MERGE APP_CLIENTPROP as DEST
	USING  #clientList as SRC
	ON SRC.clientId = DEST.componentNameId AND DEST.attrName =  @BUILD_PROP_ATTR and DEST.Modified = 0
	WHEN MATCHED THEN
		UPDATE
			SET AttrVal = @BUILD_PROP_VAL, created = @nowTime
	WHEN NOT MATCHED THEN
		INSERT  (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (clientId, @BUILD_PROP_ATTR, 1, @BUILD_PROP_VAL, @nowTime, 0);
	-- Update SP Version
	DECLARE @releaseString varchar(5) = (SELECT release FROM simAllGalaxyRel WHERE id = @topReleaseId)
	MERGE APP_CLIENTPROP as DEST
	USING #clientList as SRC
	ON DEST.componentNameId = SRC.clientId AND DEST.attrName = 'SP Version Info'
	WHEN MATCHED THEN
		UPDATE  SET attrVal = @releaseString, created = @nowTime
	WHEN NOT MATCHED THEN
		INSERT (componentNameId,attrName,attrType,attrVal,created,modified)
			VALUES(clientId,'SP Version Info',1,@releaseString,@nowTime,0);
	-- Reset Special client flags
	DECLARE	@i_clientId		integer=-1
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- AppIdaUpgrade_UninstalledClients via AppUpgrade_SetSpecialClientStates.spb
BEGIN
		DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(CURRENT_TIMESTAMP) )
		-- Reset default special status flag row to 0
		UPDATE App_Client
		SET specialClientFlags = 0
		WHERE id IN (SELECT clientId FROM #ClientList)
			AND specialClientFlags <> 0			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
			--AND releaseId >= SIM_ID_GX_REL90 -- We reset the flag for any types of client, this is as per SIM team as for older clients this has to be set
											   -- to 0, also this was initially disabled as per Waqas but nobody remembers why. So for timebeing after having
											   -- discussion with Parag, Hemant and Xuemei removing only this check.
		-- create the client list temporary table
		IF object_id('tempdb.dbo.#ResetClientListStatusTbl') IS NOT null DROP TABLE #ResetClientListStatusTbl
		CREATE TABLE #ResetClientListStatusTbl	([r_id]	INT PRIMARY KEY)
		-- Check for each status flag
		-- 1. 0x1   HIDE_IN_GUI_CLIENT_LIST  outlook add-in
		-- Set the HIDE_IN_GUI_CLIENT_LIST property
		UPDATE APP_Client
		SET specialClientFlags = specialClientFlags | 0x1
		FROM APP_Client C
		WHERE 	C.id IN (SELECT clientId FROM #ClientList)
				AND specialClientFlags <> (specialClientFlags | 0x1)			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND C.releaseId >= 14
				AND
				(
					(
						1 = (
								SELECT COUNT(*)
								FROM simInstalledPackages S WITH(NOLOCK)
								WHERE S.ClientId = C.id
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
								)
								AND EXISTS (
											SELECT id
											FROM simInstalledPackages S WITH(NOLOCK)
											WHERE S.ClientId = C.id
AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In' and 'Lotus Notes Add-in'
							)
					)
					 OR	  	(
								EXISTS (
									SELECT ACP.componentNameId
									FROM APP_ClientProp ACP WITH(NOLOCK)
									WHERE ACP.componentNameId = C.id
										AND ( ACP.attrName = 'Virtual Server Discovered Clients'
											  OR ACP.attrName = 'Mini SRM Agent'
											) AND attrVal='1'
									)
								AND NOT EXISTS(
											SELECT ClientId
											FROM simInstalledPackages S WITH(NOLOCK)
											WHERE S.ClientId = C.id
									)
								AND
								(
									0 = (
											SELECT COUNT(*)
											FROM APP_Application WITH(NOLOCK)
WHERE  clientId = C.id AND appTypeId < 600 AND (subclientStatus & 0x200000) = 0
										)
								)
							)
				--	OR
				--		( --Set HIDE_IN_GUI_CLIENT_LIST flag for NAS Deconfigured Clients
				--			EXISTS (
				--				SELECT * FROM APP_ClientProp WITH(NOLOCK)
				--				WHERE componentNameId = C.Id
				--				AND attrName = 'PlatformDeleted 4'
				--				AND attrVal = '1'
				--				AND C.simOperatingSystemId in (SELECT ID FROM simOperatingSystem WITH(NOLOCK) WHERE SubType = 'NAS'))
				--		)
					OR
						(	--Set HIDE_IN_GUI_CLIENT_LIST flag for EDC Discovered Clients
							EXISTS (	SELECT  CGA.clientId
																		  FROM app_clientgroup CG WITH(NOLOCK) INNER JOIN app_clientGroupAssoc CGA WITH(NOLOCK)
																				ON CG.id = CGA.clientGroupId and CGA.clientId = C.Id
																		  WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200))
									)
						)
				)
		-- Insert outlook addin package flag (THIS FLAG IS THE SAME FOR LOTUS NOTES ADD-IN TOO - CONFIRMED WITH ANAND)
		DELETE APP_ClientProp
		FROM APP_ClientProp C
		WHERE attrName = 'Outlook Addin Client' and modified = 0
			and componentNameId IN (SELECT clientId FROM #ClientList)
			AND
				1= (
					SELECT COUNT(*)
					FROM simInstalledPackages S WITH(NOLOCK)
					WHERE S.ClientId = C.componentNameId
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
					)
				AND EXISTS (
							SELECT id
							FROM simInstalledPackages S WITH(NOLOCK)
							WHERE S.ClientId = C.componentNameId
							AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In'
						   )
		INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		SELECT id,'Outlook Addin Client', 10, 1, @currentTime, 0 , 0
		FROM APP_Client C WITH(NOLOCK)
		WHERE 	C.id IN (SELECT clientId FROM #ClientList)
AND C.releaseId >= 14
				AND
				1= (
					SELECT COUNT(*)
					FROM simInstalledPackages S WITH(NOLOCK)
					WHERE S.ClientId = C.id
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
					)
				AND EXISTS (
							SELECT id
							FROM simInstalledPackages S WITH(NOLOCK)
							WHERE S.ClientId = C.id
							AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In'
						   )
		-- 2. 0X2   SAME_COMMCELL_GALAXY_PACKAGES_ABSENT  look for package table
		INSERT INTO #ResetClientListStatusTbl (r_id)
		SELECT id
		FROM APP_Client C WITH(NOLOCK)
		WHERE C.id IN (SELECT clientId FROM #ClientList)
AND C.releaseId >= 14
			  AND
			  EXISTS (
						SELECT ClientId
						FROM simInstalledPackages WITH(NOLOCK)
						WHERE ClientId = C.id
					 )
		-- Set the SAME_COMMCELL_GALAXY_PACKAGES_ABSENT property
		UPDATE APP_Client
		SET specialClientFlags = specialClientFlags | 0x2
		WHERE id IN (SELECT clientId FROM #ClientList)
			  AND specialClientFlags <> (specialClientFlags | 0x2)			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND releaseId >= 14
			  AND
			  id NOT IN (
							SELECT r_id
							FROM #ResetClientListStatusTbl
						)
		-- 3. 0X8   NO_COUNT_IN_SCALE_LIMITS  Virtual server, add-in,  miniSRM  ( - All package + add-in )
		-- Set the NO_COUNT_IN_SCALE_LIMITS property
		UPDATE APP_Client
		SET specialClientFlags = specialClientFlags | 0x8
		FROM APP_Client C
		WHERE
			C.id IN (SELECT clientId FROM #ClientList)
			AND specialClientFlags <> (specialClientFlags | 0x8)			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND C.releaseId >= 14
			AND
			(
				(
					1 =   (
							SELECT COUNT(*)
							FROM simInstalledPackages S WITH(NOLOCK)
							WHERE S.ClientId = C.id
AND S.simPackageID NOT IN ( SELECT id FROM simPackage WITH(NOLOCK) WHERE id IN (1,2,
1002,1003))
							)
							AND EXISTS (
										SELECT id
										FROM simInstalledPackages S WITH(NOLOCK)
										WHERE S.ClientId = C.id
										AND S.simPackageID IN ( 159,204 ) -- 'DataArchiver Outlook Add-In' and 'Lotus Notes Add-in'
						   )
				)
				 OR	  (
						(
							EXISTS (
									SELECT ACP.componentNameId
									FROM APP_ClientProp ACP WITH(NOLOCK)
									WHERE ACP.componentNameId = C.id
										AND ( ACP.attrName = 'Virtual Server Discovered Clients'
											  OR ACP.attrName = 'Mini SRM Agent'
											) AND attrVal='1'
									)
							OR
							EXISTS(
									SELECT componentNameId FROM APP_IDAProp WITH(NOLOCK)
WHERE componentNameId in(SELECT id from APP_IDAName WITH(NOLOCK) where clientId= C.id AND apptypeId=106)
									AND attrName = 'Pseudo Apptype' AND attrVal='1'
								)
						)
						AND NOT EXISTS(
										SELECT ClientId
										FROM simInstalledPackages S WITH(NOLOCK)
										WHERE S.ClientId = C.id
								)
					  )
			)
		-- Handle client states for Commnet clients
		UPDATE App_Client
		SET specialClientFlags = 0xB
		WHERE id IN (SELECT clientId FROM #ClientList)
		AND specialClientFlags <> 0xB			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
AND releaseId >= 14
		AND name like '%CommNetAgent_%'
		-- For commserv none of the flags make sense so hardcode it to 0, this is after discussion with Amey and Parag
		UPDATE App_Client
		SET specialClientFlags = 0
		WHERE  id = 2
			AND specialClientFlags <> 0			-- stop firing CCS Trigger to eliminate the need to push row updates to CCS Laptop Clients with NODATACHANGE
		DROP TABLE #ResetClientListStatusTbl
END
	-- Set the client version . Already called in upgrades in post upgrade.lst. Do not repeat
	-- EXEC	AppSetClientVersion	0
BEGIN
	-- Handle Addin Clients
	-- THIS IS BOTH LOTUS NOTES AND OUTLOOK ADDIN EVEN THOUGH THE PROPERTY NAME IS MISLEADING
	DECLARE @outlookAddinClntsCount INT = (SELECT COUNT(*)
										FROM APP_ClientProp WITH(NOLOCK)
										WHERE componentNameId IN (select clientId FROM  #ClientList) AND
											attrName = 'Outlook Addin Client' AND modified = 0 AND attrVal = 1
										)
	IF (@outlookAddinClntsCount = 0 AND @i_clientId = 0)
	BEGIN
		DELETE APP_ClientGroupAssoc
WHERE clientGroupId IN ( SELECT id FROM APP_ClientGroup WITH(NOLOCK) WHERE flag & 0x0400 = 0x0400 )
		DELETE APP_ClientGroup
WHERE flag & 0x0400 = 0x0400
	END
ELSE IF NOT EXISTS( SELECT * FROM APP_ClientGroup WITH(NOLOCK) where flag & 0x0400 = 0x0400) AND @outlookAddinClntsCount > 0
	BEGIN
		INSERT INTO APP_ClientGroup(name
				   ,description
				   ,flag
				   ,status
				   ,userId
				   ,refTime
				   ,modified
				   ,origCCId
				   ,fwPorts)
				   VALUES
				   ('AddIn Clients'
				   ,'All AddIn Clients'
,0x0400
				   ,0
				   ,1
				   ,dbo.GetUnixTime(GetDate())
				   ,0
				   ,2
				   ,' ')
	END
DECLARE @addinGroupId INT = ISNULL(( SELECT id FROM APP_ClientGroup WITH(NOLOCK) WHERE flag & 0x0400 = 0x0400 ),0)
	IF (@addinGroupId <> 0)
	BEGIN
		DELETE APP_ClientGroupAssoc
		WHERE clientId IN (select clientId FROM  #ClientList) AND
			clientGroupId = @addinGroupId
		INSERT INTO APP_ClientGroupAssoc (clientGroupId,clientId)
		SELECT @addinGroupId,componentNameId
		FROM APP_ClientProp WITH(NOLOCK)
		WHERE (@i_clientId=0 OR componentNameId IN (select clientId FROM  #ClientList)) AND
			attrName = 'Outlook Addin Client' and modified = 0 AND attrVal = 1
	END
	--SELECT id
	--FROM APP_ClientGroup
	--WHERE flag & CV_FLAG_ADDIN_CLIENT_GROUP = CV_FLAG_ADDIN_CLIENT_GROUP
END
	-- SELECT 	@o_specialStatusFlags    -- CALLER SHOULD CHECK FOR DB_NODATA AS THE CORRECT RESPONSE  -SKatz
	-- Check for Update of smart client groups for this client
	--exec AppSCGUpdateClient 1, @i_clientId
	--Do not update smart client group if none available.
	--4096 = Smart client group flag.
	IF EXISTS (SELECT 1 FROM APP_ClientGroup WHERE flag & 4096 = 4096)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#AppSCGUpdateClientExtTable') IS NOT NULL
		BEGIN
			DROP TABLE #AppSCGUpdateClientExtTable
		END
		-- External Inputted Table does not exist
		CREATE TABLE #AppSCGUpdateClientExtTable (
				clientId		INT PRIMARY KEY
		)
		INSERT INTO #AppSCGUpdateClientExtTable
		SELECT clientId
		FROM #clientList CL
		-- sp5a
		exec AppSCGUpdateClient 1, -1
		IF OBJECT_ID('tempdb.dbo.#AppSCGUpdateClientExtTable') IS NOT NULL
		BEGIN
			-- Temp Table created internally
			DROP TABLE #AppSCGUpdateClientExtTable
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
   	set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END	  CATCH
RETURN_RESULTS:
	IF ( CURSOR_STATUS('global', 'clientCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'clientCursor') >= 0 )
		CLOSE clientCursor
	IF ( CURSOR_STATUS('global','clientCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','clientCursor') = -1 )
		DEALLOCATE clientCursor
	if @errCode = 0
			select * from #ClientList
	else
			select 0, 'NoName',0, @minReleaseId, @errCode, @errString
	IF object_id('tempdb.dbo.#ClientList') IS NOT NULL
		DROP TABLE #ClientList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_UninstalledClients')
	delete from GxQscripts where name = 'AppIdaUpgrade_UninstalledClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_UninstalledClients')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_UninstalledClients'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_UninstalledClients',  '00010021006000110000', 'AppIdaUpgrade_UninstalledClients', '00010021006000110000')
GO

