

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_SRMOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -------------------------------------------------------------------------------------------------------------------------------------
--	Till 9.0 SP6, this property was present under both iDA level and at sub-client level
--	In iDA level, it was 'SRM Data Collection Enabled' (a boolean option)
--	In sub-client level, it was 'SRM Data Collection Options', a integer option implemented as a bit mask of various options
--	From 9.0 SP7, this option has been changed to iDA level ONLY
--	From 10.0, this option is present under Sub-client level ONLY
--	This upgrade script is written to move the option from iDA level at 9.0 to sub-client level at 10.0
--	This script moves the value from iDA property 'SRM Data Collection Enabled' to sub-client property 'SRM Data Collection Options',
								--REGARDLESS OF THE VALUE OF THIS OPTION AT SUB-CLIENT LEVEL
--	This script works ONLY on File system agents. Not on SRM standalone agents
--	SRM stand alone agents are depleted from 10.0, except for SRM NAS.
--	For SRM NAS, this property need not be upgraded
-- -------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_SRMOptions <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_SRMOptions')
	drop procedure AppIdaUpgrade_SRMOptions
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_SRMOptions')
	delete from GxQscripts where name = 'AppIdaUpgrade_SRMOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SRMOptions')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SRMOptions'
GO
print '... Creating Procedure: AppIdaUpgrade_SRMOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_SRMOptions
  @clientID int,
  @apptypeID int,
  @prevReleaseID int,
  @errorCode int OUTPUT,
  @errorString nvarchar(1024) OUTPUT
AS
DECLARE @CSCurrentReleaseId AS INT
SET @CSCurrentReleaseId = ISNULL((SELECT TOP 1 id FROM simAllGalaxyRel ORDER BY id DESC),0)
DECLARE @nowTime AS INT
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
SET @errorCode = 0
SET @errorString = 'Successful'
IF @prevReleaseId >= @CSCurrentReleaseId
BEGIN
	SET @errorString = 'Client '+ (SELECT name FROM APP_Client WHERE id = @clientId) + ' has been upgraded already to release [' + Convert(varchar(3), @CSCurrentReleaseId) + '].'
	SET @errorCode = 0
	GOTO Cleanup
END
IF @prevReleaseId < 15
BEGIN
	DECLARE @tempTbl TABLE
	(
		subclientId INT,
		newVal	NVARCHAR(10)
	)
	--Rule:
	--At iDA level, if 'SRM Data Collection Enabled' = 1, then 'SRM Data Collection Options' = 1
	--At iDA level, if 'SRM Data Collection Enabled' = 0 or not exists, then 'SRM Data Collection Options' = 0
	INSERT INTO @tempTbl
	SELECT appl.id,
			CASE WHEN EXISTS (SELECT * FROM APP_IDAProp
							  WHERE componentNameId = (SELECT DISTINCT id FROM App_iDAName WHERE clientId = appl.clientId AND appTypeId = appl.appTypeId)
									AND attrName = 'SRM Data Collection Enabled' AND attrVal = '1' AND modified = 0)
					 THEN '1'
				 ELSE
					 '0'
			END
	 FROM APP_Application AS appl
	 WHERE appl.clientId = @clientId AND appl.appTypeId = @apptypeId
	 BEGIN TRAN
		 --Age the old property
		 UPDATE APP_SubClientProp
		 SET modified = @nowTime
		 WHERE componentNameId in (SELECT subclientId FROM @tempTbl) AND attrName = 'SRM Data Collection Options' AND modified = 0
		 --Insert the new property
		 INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT subclientId, 'SRM Data Collection Options', 10, newVal, @nowTime, 0
			FROM @tempTbl
	IF @@ERROR = 0
		COMMIT TRAN
	ELSE
	BEGIN
		ROLLBACK TRAN
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END
END
CLEANUP:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_SRMOptions')
	delete from GxQscripts where name = 'AppIdaUpgrade_SRMOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SRMOptions')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SRMOptions'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_SRMOptions',  '00000000000000000000', 'AppIdaUpgrade_SRMOptions', '00000000000000000000')
GO

