

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_SPDBtoSPDoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_SPDBtoSPDoc.sp,v $ $Id: AppIdaUpgrade_SPDBtoSPDoc.sp,v 1.35.60.2 2018/03/27 08:18:48 jiechen Exp $";
----------------------------------------------------------------------
-- SPDM merged into SPDoc iDA UPGRADE
--
-- PreRequisite:  SPDoc iDA 8.0 installed on client - is this handled by caller?
-- APP_BackupSetName: Find SPDB backupset created by Install/Update under SPDoc iDA for given client.
-- APP_application: Change SPDB subclients to point to new SPDB backupset and instance; change appTypeId to SPDoc.
-- APP_application: Flag above backupset and subclients as SPDB.
-- Move Apptype-level props (except sql uname/pw) in APP_idaProp to new id (clientId+SPDoc appTypeId in APP_idaName)
-- Note here are no SPDB backupset-level props to move except may need some basic prop "Use Change Journal"? deleted.
-- Adjust/Add to any referencing tables (scheds/policies) - 2 JM tables: JMBkpStats, JMRestoreStats, + 2 Sched tables
-- Delete anyting left under now-obsolete SPDB iDA: idaProps, instanceProps, instance, buset, buset props
-- Delete subclient that Install/Update created with SPDB backupset
-- Note there is one instance-level prop exposed at ida-level (Sharepoint server name) - SPDoc already has this, so deleted.
--
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
-- 09-Jan-2008	Initial
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_SPDBtoSPDoc <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_SPDBtoSPDoc')
	drop procedure AppIdaUpgrade_SPDBtoSPDoc
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_SPDBtoSPDoc')
	delete from GxQscripts where name = 'AppIdaUpgrade_SPDBtoSPDoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SPDBtoSPDoc')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SPDBtoSPDoc'
GO
print '... Creating Procedure: AppIdaUpgrade_SPDBtoSPDoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_SPDBtoSPDoc
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
-----------------------------------------------------------
-- Need the following when inserting into "props" tables --
-- ..(Should be set by environment)						 --
-----------------------------------------------------------
--SET ANSI_PADDING ON
--GO
--SET ARITHABORT ON
--GO
--SET QUOTED_IDENTIFIER ON
--GO
-----------------------------------------------------------
IF EXISTS ( select * from sysobjects where name='#spdb_worklist' )
	DROP TABLE #spdb_worklist
-----------------------
-- CONVENIENCE DEFS  --
-----------------------
DECLARE @nowTime	integer
SET		@nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @NO_BITS	integer
SET     @NO_BITS	= 4
--2/6/08 change: install/update will create and name this - we should just look at the flag
--DECLARE	@SPDB_BACKUPSET_NAME				varchar(50)
--SET		@SPDB_BACKUPSET_NAME				='Databases'
DECLARE	@SPDB_DEFAULT_BSET_STATUS			int				--for backupset
SET		@SPDB_DEFAULT_BSET_STATUS			= 8+2048		--default+SPDB
DECLARE	@SPDB_DEFAULT_SUB_STATUS			int				--for default subclient
SET		@SPDB_DEFAULT_SUB_STATUS			= 8+2048		--default+SPDB
DECLARE	@SPDB_FLAG_BITVALUE					int
SET		@SPDB_FLAG_BITVALUE					= 2048
--DECLARE @currentReleaseId					int
--SET		@currentReleaseId					= ISNULL((Select releaseId from app_client where id = @i_clientId), 0)
-----
DECLARE	@CV_PROP_SHAREPOINT2_INDEX_BACKUP_RESTORE_PATH   varchar(50)
SET		@CV_PROP_SHAREPOINT2_INDEX_BACKUP_RESTORE_PATH	='SharePoint Remote Index Backup Restore Path'
DECLARE	@CV_RELEASE_TOPOLOGY_LOCK		varchar(50)
SET		@CV_RELEASE_TOPOLOGY_LOCK		='Release Topology lock'
DECLARE	@CV_PROP_SHAREPOINT2_IS_REMOTE_SQL_SERVER   varchar(50)
SET		@CV_PROP_SHAREPOINT2_IS_REMOTE_SQL_SERVER	='SharePoint Is Remote SQL server'
DECLARE	@CV_PROP_SSO_NAME   varchar(50)
SET		@CV_PROP_SSO_NAME	='User Name'
DECLARE	@CV_PROP_SSO_PASSWORD   varchar(50)
SET		@CV_PROP_SSO_PASSWORD	='User Password'
DECLARE	@CV_PROP_SHAREPOINT2__REMOTE_SQL_USER_NAME   varchar(50)
SET		@CV_PROP_SHAREPOINT2__REMOTE_SQL_USER_NAME	='SharePoint Remote SQL user name'
DECLARE	@CV_PROP_SHAREPOINT2__REMOTE_SQL_PASSWORD   varchar(50)
SET		@CV_PROP_SHAREPOINT2__REMOTE_SQL_PASSWORD	='SharePoint Remote SQL password'
DECLARE	@OLD_SPDB_APPTYPE				int
SET		@OLD_SPDB_APPTYPE				= 69
DECLARE @SPDOC_APPTYPE					int
SET		@SPDOC_APPTYPE					= 78
DECLARE @ReleaseId	int
SET		@ReleaseId = ISNULL((Select releaseId from app_client where id = @i_clientId), 0)
DECLARE	@CLIENTNAME	varchar(512)
SET		@CLIENTNAME = ISNULL((Select name from app_client where id = @i_clientId), 'Undetermined Client_'+convert(varchar(12), @i_clientId))
--DECLARE @errCode	int				-- Be Optimistic
SET		@errCode	=0			-- 'DB_OK'
----------------------------------
--DECLARE @errString	varchar(1024)	-- Be Optimistic
set		@errString	='SPDB iDA Upgrade Succeeded.'
--- Variables for our Cursors --
DECLARE	@subClient			int
DECLARE @oldAppType			int
DECLARE @oldIdaNameId		int
DECLARE @oldInstance		int
DECLARE @oldBackupSet		int
DECLARE @newIdaNameId		int
DECLARE	@newInstance		int
DECLARE @newBackupSet		int
DECLARE @deleteSubclient	int
---------------------------------
CREATE TABLE #spdb_worklist
    (
    [subClientId]		int,
    [oldAppType]		int,
	[oldIdaNameId]		int,
	[oldInstance]		int,
	[oldBackupSet]		int,
	[newIdaNameId]		int,
	[newInstance]		int,
	[newBackupSet]		int,
	[subClientStatus]	int,
	[deleteSubclient]	int,
	)
---------------------------------------------------
-- DO SOME BASIC CHECKING BEFORE GETTING STARTED --
---------------------------------------------------
IF @i_prevReleaseId > 12		-- Release id=12 (7.0) requires update, but 8.0 and 9.0 do not.
BEGIN
	SET @errCode = 0
	SET @errString = 'Sharepoint Agent on client [' +@clientName + '] does not require upgrade.'
	goto CLEANUP
END
BEGIN TRY
------------------------------------------------------------------------------------------------
-- IF SIM HAS NOT DONE IT'S PREINSTALL FOR SOME REASON, WE NEED TO "FAKE" OUT WHAT SIM IS
-- SUPPOSED TO DO UNDER THESE CIRCUMSTANCES
------------------------------------------------------------------------------------------------
	DECLARE @defaultDocBkupSet		int
	DECLARE @defaultDocSubClient	int
	DECLARE @newBackupsetId			int
	DECLARE @newSubclientId			int
--------------------------------------------------------------------------------------------------
-- IN SEEMS THAT SIM IS NOT CREATING MISSING SPDOC iDA if EXISTING SPDB iDa is Deconfigured		--
-- .. SO WE WILL MANUALLY ADD IT IN HERE!!!														--
--------------------------------------------------------------------------------------------------
	DECLARE @instanceId int
	DECLARE @backupsetId int
	IF NOT EXISTS (SELECT id from APP_IDAName where clientId = @i_clientId AND appTypeId = @SPDOC_APPTYPE)
	BEGIN
		INSERT APP_IDAName (clientId, appTypeId, status, refTime, modified)
		VALUES (@i_clientId, @SPDOC_APPTYPE, 2, 0, @nowTime)
		INSERT APP_InstanceName(name, refTime, modified, status)
			VALUES('defaultInstanceName', @nowTime-5000, @nowTime, 2)
		SET @instanceId = @@IDENTITY
		INSERT APP_BackupSetName(name, refTime, modified, status)
			VALUES('Databases', @nowTime-5000, @nowTime, @SPDB_DEFAULT_BSET_STATUS+2)
		SET @backupSetId = @@IDENTITY
		INSERT APP_Application(clientId, appTypeId, instance, backupSet,
							   appNumber, dataArchGrpID, logArchGrpID, refTime,
							   modified, subclientName, subclientStatus)
			VALUES (@i_clientId, @SPDOC_APPTYPE, @instanceId, @backupSetId, 0, 1, 1, @nowTime-5000, @nowTime, 'default', @SPDB_DEFAULT_SUB_STATUS+2)
	END
--	IF @i_prevReleaseId = 12 AND @currentReleaseId = 12
--	BEGIN
---------------------------------------------------
--  SIMULATE WHAT "SIM" IS SUPPOSED TO DO PRIOR	---
--  TO CALLING THE UPGRADE SCRIPT				---
---------------------------------------------------
		-- Get the default subClient for the default backupset for the SPDoc & this client
		SET @defaultDocSubClient = ISNULL((Select distinct A.id FROM app_backupsetName as B, App_Application as A
									WHERE (B.status & 8) <> 0
									AND    B.id = A.backupset
									AND	   A.clientId = @i_clientId
									AND    A.appTypeId = @SPDOC_APPTYPE			--78
									AND	   (A.subclientStatus & 8) = 8), 0)      -- defaultSubClient
		SET @defaultDocBkupSet = (select backupset from App_Application where id = @defaultDocSubClient)
		UPDATE App_backupsetName
			SET name = 'Documents' where id = @defaultDocBkupSet
		INSERT App_BackupsetName (name, refTime,     modified,    status)
			VALUES('Databases', @nowTime, 0, @SPDB_DEFAULT_BSET_STATUS)
		SET @newBackupsetId = @@Identity
		INSERT APP_Application(clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpId, refTime, modified, subclientName, subclientStatus)
			SELECT  clientId,  appTypeId, instance, @newBackupSetId , appNumber, dataArchGrpID, logArchGrpId, refTime, modified, subclientName, @SPDB_DEFAULT_SUB_STATUS
			FROM APP_Application
			WHERE id = @defaultDocSubClient
		SET @newSubclientId = @@IDENTITY				-- Really need this?
		UPDATE APP_Application
			SET subclientStatus = subClientStatus & ~2						-- "BAD" Upgrade marked SPDB uninstalled, so we need to "fix"
			WHERE clientId = @i_clientId and appTypeId = @OLD_SPDB_APPTYPE
--	END
------------------------------------------------------------------------------------------------
--Install/Upgrade has already created the 8.0+ SPDB Backupset under the SPDoc iDa.
--Get default instanceId for SPDB iDA of this client.
SET @newInstance = (SELECT DISTINCT instance from app_application as APP, app_backupsetName as buname
			WHERE app.clientId			= @i_clientId
			AND app.appTypeId = @SPDOC_APPTYPE
			AND app.subClientStatus = @SPDB_DEFAULT_SUB_STATUS
			AND ((buname.status & @SPDB_FLAG_BITVALUE) = @SPDB_FLAG_BITVALUE))
--2/6/08 change: install/update creates SPDB backupset, so if it does not exist, exit with error
--Check if backupset flagged as SPDB exists under SPDoc iDA for this client and instance
if NOT exists	(	SELECT DISTINCT app.backupset from app_application as APP, app_backupsetName as buname
				WHERE app.clientId			= @i_clientId
				AND app.appTypeId = @SPDOC_APPTYPE
				AND app.instance = @newInstance
				AND app.subClientStatus = @SPDB_DEFAULT_SUB_STATUS
				AND ((buname.status & @SPDB_FLAG_BITVALUE) = @SPDB_FLAG_BITVALUE)
			)
BEGIN
	SET @errString = 'Client [' +@clientName + '] does not have Sharepoint DataBase backupset created and flagged.'
	set @errCode = 1						-- 'DB_WARN'
	goto CLEANUP
END
--2/6/08 change: if old SPDB apptype does not exist for this client, this upgrade has already been run
if NOT exists	(	SELECT TOP 1 id from APP_IDANAME
					WHERE clientId = @i_clientId AND appTypeId = @OLD_SPDB_APPTYPE)
BEGIN
	--7/23/08 change: exit, but do not send error because maybe client never had SPDB iDA
	--SET @errString = 'SPDB iDA on Client [' +@clientName + '] has already been upgraded.'
	--set @errCode = DB_WARN						-- 'DB_WARN'
	goto CLEANUP
END
-- select debug='debug pre', * from app_application WHERE clientId = @i_clientId
BEGIN
	INSERT #spdb_worklist
	SELECT id, appTypeId, 0, instance, backupset, 0, 0, 0, subClientStatus, 0
		FROM app_application
		WHERE clientId	= @i_clientId
			AND appTypeId = @OLD_SPDB_APPTYPE
--			AND (SubClientStatus & @NO_BITS) = 0
--	oldIdaNameId-
	UPDATE #spdb_worklist
	set [oldIdaNameId] = (select id from app_idaName Where clientId = @i_clientId AND appTypeId = @OLD_SPDB_APPTYPE)
--	newIdaNameId-
	UPDATE #spdb_worklist
	set [newIdaNameId] = (select id from app_idaName Where clientId = @i_clientId AND appTypeId = @SPDOC_APPTYPE)
--	newInstance-
	UPDATE #spdb_worklist
	SET [newInstance] = @newInstance
--BEGIN TRAN
--2/6/08 change: Find SPDB backupset created by Install/Update under SPDoc iDA for given client.
-- APP_BackupSetName: Create new BackupSet "defaultSpDbBackupset" under SPDoc iDA (do not create new subclient).
--Insert App_BackupsetName
--		VALUES(@SPDB_BACKUPSET_NAME, @nowTime, @nowTime, @SPDB_DEFAULT_BSET_STATUS, 0, 0)
-- Get ID of the SPDB backupset
SET @newBackupSet = (SELECT DISTINCT app.backupset from app_application as APP, app_backupsetName as buname
		WHERE app.clientId = @i_clientId
		AND app.appTypeId = @SPDOC_APPTYPE
		AND app.instance = @newInstance
		AND app.subClientStatus = @SPDB_DEFAULT_SUB_STATUS
		AND ((buname.status & @SPDB_FLAG_BITVALUE) = @SPDB_FLAG_BITVALUE))
--	newBackupSet-
	UPDATE #spdb_worklist
	SET [newBackupSet] = @newBackupSet
SET @deleteSubclient = (SELECT TOP 1 id from app_application as APP
		WHERE clientId = @i_clientId
		AND appTypeId = @SPDOC_APPTYPE
		AND instance = @newInstance
		AND backupset = @newBackupSet)
--	deleteSubclient-
	UPDATE #spdb_worklist
	SET [deleteSubclient] = @deleteSubclient
--select * from  #spdb_worklist
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--	NOW THAT WE'VE ESTABLISHED ALL THE 'BASE' DATA, TIME TO LOOP THROUGH ALL THE	--
--	SUBCLIENTS AND TAKE ACTION AS REQUIRED BASED ON NEW INSTANCE TYPE				--
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	DECLARE subClientCursor CURSOR STATIC FOR
		SELECT [subClientId],	[oldAppType],	[oldIdaNameId], [oldInstance],	[oldBackupSet], [newIdaNameId],	[newInstance], [newBackupSet]
	FROM #spdb_worklist
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @subClient, @oldAppType, @oldIdaNameId, @OldInstance, @oldBackupSet, @newIdaNameId, @newInstance, @newBackupSet
    WHILE @@FETCH_STATUS = 0
	BEGIN
	-- update any "other" tables here that involve subclientId!
	UPDATE JMBkpStats
 	SET appType = @SPDOC_APPTYPE,
 		modifiedTime = @nowTime
 	WHERE appType = @OLD_SPDB_APPTYPE AND appId = @subClient
	--schedules belonging to a scheduled template associated to the client must now affect only the db backupset
	update schedbackuptask
	SET  appTypeId = @SPDOC_APPTYPE, instance = @newInstance, backupSet = @newBackupSet
	FROM schedbackuptask SB, Schedtemplate ST, schedtemplateinstance SI, schedule S
	where SB.clientid =@i_clientId and SB.apptypeid = @OLD_SPDB_APPTYPE and SB.subclient =0 and
		SB.id = S.taskid and S.schedtemplateinstanceid = SI.id and SI.schedtemplateid = ST.id  and
		ST.apptype in (100078, 100032,100046,100068)
--		-------------------------------------------
--		FLUSH NEW ID's BACK TO APPLICATION TABLE --
--		------------------------------------------
-- APP_application: Change SPDB subclients to point to new backupset and instance; change appTypeId to SPDoc.
-- APP_application: Flag above backupset and subclients as SPDB.
UPDATE APP_APPLICATION
		SET appTypeId = @SPDOC_APPTYPE,
			instance  = @newInstance,
			backupSet = @newBackupSet,
			subclientStatus = [subclientStatus] + @SPDB_FLAG_BITVALUE
		WHERE  id= @subClient
		----------
    FETCH NEXT FROM subClientCursor INTO @subClient, @oldAppType, @oldIdaNameId, @OldInstance, @oldBackupSet, @newIdaNameId,  @newInstance, @newBackupSet
	END
	CLOSE       subClientCursor
	DEALLOCATE  subClientCursor
-- Move needed Apptype-level props in APP_idaProp to new id (clientId+SPDoc appTypeId in APP_idaName)
INSERT APP_IDAPROP
		Select @newIdaNameId, attrName, AttrType, AttrVal, created, modified, ccpId
			FROM APP_IdaProp
			WHERE componentNameId = @oldIdaNameId
			AND (attrName = @CV_PROP_SHAREPOINT2_IS_REMOTE_SQL_SERVER
			OR  attrname = @CV_PROP_SHAREPOINT2_INDEX_BACKUP_RESTORE_PATH
			OR attrname = @CV_RELEASE_TOPOLOGY_LOCK)
-- Move needed instance-level props in APP_InstanceProp to new id (i.e. from SPDB to SPDoc)
-- But first we must delete the same 2 props that (7.0) install creates for SPDoc, but are never used! nice...
DELETE APP_INSTANCEPROP
		WHERE componentNameId = @newInstance
			AND (attrName = @CV_PROP_SSO_NAME
			OR  attrname = @CV_PROP_SSO_PASSWORD)
INSERT APP_INSTANCEPROP
		Select @newInstance, attrName, AttrType, AttrVal, created, modified, ccpId
			FROM APP_InstanceProp
			WHERE componentNameId = @oldInstance
			AND (attrName = @CV_PROP_SSO_NAME
			OR  attrname = @CV_PROP_SSO_PASSWORD)
-- 4/4/08 Previously, we were going to not move this prop because SPDoc iDA already has it,
-- But in some cases, the SPDoc iDA may not exist, so we must move it with the upgrade.
-- We can't have 2 sets of the prop, so it one does exist for SPDoc, delete it.
DELETE APP_IDAPROP
		WHERE componentNameId = @newIdaNameId
			AND (attrName = @CV_PROP_SHAREPOINT2__REMOTE_SQL_USER_NAME
			OR  attrname = @CV_PROP_SHAREPOINT2__REMOTE_SQL_PASSWORD)
INSERT APP_IDAPROP
		Select @newIdaNameId, attrName, AttrType, AttrVal, created, modified, ccpId
			FROM APP_IdaProp
			WHERE componentNameId = @oldIdaNameId
			AND (attrName = @CV_PROP_SHAREPOINT2__REMOTE_SQL_USER_NAME
			OR  attrname = @CV_PROP_SHAREPOINT2__REMOTE_SQL_PASSWORD)
-- "Remove" remaining rows for SPDB App
DELETE APP_IDAPROP										-- Delete is required so that we can delete from app_idaname
	WHERE componentnameId = @oldIdaNameId
DELETE APP_IDANAME										-- Leaving this in will cause this "ida" to show up in the
	WHERE clientId = @i_clientId AND appTypeId = @OLD_SPDB_APPTYPE	-- .. commcell tree, even if we mark it "deleted"!
-- Remove old SPDB instance and any instance props
DELETE APP_INSTANCEPROP
	WHERE componentnameid = @oldInstance
DELETE APP_INSTANCENAME
	where id = @oldInstance
-- Remove old SPDB backupset and any backupset props
DELETE APP_BACKUPSETPROP
	WHERE componentnameid = @oldBackupSet
DELETE APP_BACKUPSETNAME
	where id = @oldBackupSet
DELETE APP_SUBCLIENTPROP
	where componentnameid = @deleteSubclient
-- Delete subclient that Install/Update created with SPDB backupset
DELETE APP_APPLICATION
	where id = @deleteSubclient
----------------------------------------------------------------------
-- "OTHER" TABLE UPDATES											--
----------------------------------------------------------------------
--subclient level schedules & iDa level schedules (subclient==0)
UPDATE SchedBackupTask
SET appTypeId = @SPDOC_APPTYPE, instance = @newInstance, backupSet = @newBackupSet
WHERE clientId = @i_clientId AND appTypeId = @OLD_SPDB_APPTYPE
UPDATE JMRestoreStats
SET appType = @SPDOC_APPTYPE,
	bkpSetID = @newBackupSet,
	modifiedTime = @nowTime
WHERE srcClientId = @i_clientId AND appType = @OLD_SPDB_APPTYPE
UPDATE SchedRestoreTask
SET appTypeId = @SPDOC_APPTYPE, instanceId = @newInstance, backupSetId = @newBackupSet
WHERE sourceClientId = @i_clientId AND appTypeId = @OLD_SPDB_APPTYPE
--9/20/08 per AnandV
UPDATE schedTemplate
SET appType = (SELECT AppGroup1 FROM APP_iDAType WHERE type = @SPDOC_APPTYPE)
WHERE appType = (SELECT AppGroup1 FROM APP_iDAType WHERE type = @OLD_SPDB_APPTYPE)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
--  ROLLBACK TRAN
END
END CATCH
CLEANUP:
IF EXISTS (select * from sysobjects where name = '#spdb_worklist')
	DROP table #spdb_worklist
--select errCode = @errCode, errString= @errString
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_SPDBtoSPDoc')
	delete from GxQscripts where name = 'AppIdaUpgrade_SPDBtoSPDoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SPDBtoSPDoc')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SPDBtoSPDoc'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_SPDBtoSPDoc',  '00010035006000020000', 'AppIdaUpgrade_SPDBtoSPDoc', '00010035006000020000')
GO

