

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_SPContentToXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_SPContentToXML.sp,v $ $Id: AppIdaUpgrade_SPContentToXML.sp,v 1.4.60.3 2018/03/27 08:08:31 jiechen Exp $";
----------------------------------------------------------------------
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_SPContentToXML <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_SPContentToXML')
	drop procedure AppIdaUpgrade_SPContentToXML
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_SPContentToXML')
	delete from GxQscripts where name = 'AppIdaUpgrade_SPContentToXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SPContentToXML')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SPContentToXML'
GO
print '... Creating Procedure: AppIdaUpgrade_SPContentToXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_SPContentToXML
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
---------------------------------------------------
-- DO SOME BASIC CHECKING BEFORE GETTING STARTED --
---------------------------------------------------
DECLARE @CLIENTNAME nvarchar(512)
SET     @CLIENTNAME = ISNULL((Select name from app_client where id = @i_clientId), 'Undetermined Client_'+convert(varchar(12), @i_clientId))
IF @i_prevReleaseId > 14		-- Only release id=13 (8.0) and Release id = 14 (9.0) require upgrade.
BEGIN
	SET @errCode = 0
	SET @errString = 'Sharepoint Agent on client [' +@clientName + '] does not require upgrade.'
	goto ALL_DONE
END
BEGIN TRY
	DECLARE @spSubclients TABLE (appId INT, isSPDB INT)
	DECLARE @subclientID INT = 0
	DECLARE @isDBSubclient INT = 0
	DECLARE @currentTime INT
	SET @currentTime = dbo.GetUnixTime(GetUTCdate())
	INSERT INTO @spSubclients
	SELECT APP.id, CASE APP.subclientStatus & 0x0800 --CV_STATUS_SPDB_SUB
						WHEN 0 THEN 0
						ELSE 1
				   END
	FROM APP_Application APP WITH (NOLOCK)
WHERE APP.clientId = @i_clientId AND APP.appTypeId = 78
	IF ( CURSOR_STATUS('global', 'GetSPSubclient') >= 0   OR CURSOR_STATUS('local', 'GetSPSubclient') >= 0 )  -- CLOSE CURSOR IF OPEN
			CLOSE GetSPSubclient
	IF ( CURSOR_STATUS('global','GetSPSubclient') = -1     OR CURSOR_STATUS('local','GetSPSubclient') = -1 )
			DEALLOCATE GetSPSubclient
	DECLARE GetSPSubclient CURSOR
	FOR SELECT appId, isSPDB FROM @spSubclients
	OPEN GetSPSubclient
	FETCH GetSPSubclient INTO @subclientID, @isDBSubclient
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @contentId INT = 0
		DECLARE @contentPath NVARCHAR(MAX) = ''
		DECLARE @contentType INT = 0
		IF ( CURSOR_STATUS('global', 'GetContent') >= 0   OR CURSOR_STATUS('local', 'GetContent') >= 0 )  -- CLOSE CURSOR IF OPEN
			CLOSE GetContent
		IF ( CURSOR_STATUS('global','GetContent') = -1     OR CURSOR_STATUS('local','GetContent') = -1 )
			DEALLOCATE GetContent
		DECLARE GetContent CURSOR
		FOR SELECT id, fileName, type FROM APP_ScFilterFile SCF WITH(NOLOCK)
			WHERE componentNameId = @subclientID AND modified = 0
		OPEN GetContent
		FETCH GetContent INTO @contentId, @contentPath, @contentType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			/*
			Message SharePointItem
			{
				string fullPath
				string relativePath
				string webAppPath
				string siteCollectionPath
				string webPath
				string objectType
				string objectDescription
				string contentPath
				string Reserved_1
				string Reserved_2
			}
			*/
			DECLARE @tempContent NVARCHAR(MAX) = ''
			DECLARE @resultContentPath NVARCHAR(MAX) = '\MB' -- Declare Resultant 10.0 path with '\MB', for default SC
			DECLARE @fullPath NVARCHAR(MAX) = ''
			DECLARE @webAppPath NVARCHAR(MAX) = ''
			DECLARE @siteCollectionPath NVARCHAR(MAX) = ''
			DECLARE @webPath NVARCHAR(MAX) = ''
			DECLARE @subPath NVARCHAR(MAX) = '' -- What is this in .x?
			DECLARE @relativePath NVARCHAR(MAX) = ''
			DECLARE @newContent NVARCHAR(MAX) = ''
			DECLARE @objectType INT = 0
			DECLARE @newContentType INT = ( CASE @contentType
											WHEN 1 /*CV_CONTENT*/ THEN 21 /*CV_XML_CONTENT*/
											WHEN 2 /*CV_YESDIRS_BACKUP_FILTERS*/ THEN 22 /*CV_XML_YESDIRS_BACKUP_FILTERS*/
											WHEN 3 /*CV_NODIRS_BACKUP_FILTERS*/ THEN 23 /*CV_XML_NODIRS_BACKUP_FILTERS*/
											END
										)
			SET @tempContent = @contentPath
			DECLARE @bDone INT = 0
			IF @tempContent = '\MB'
			BEGIN
				SET @relativePath = @tempContent
				SET @objectType = 1
			END
			ELSE
			IF @tempContent LIKE '\MB\%'
			BEGIN
				IF @isDBSubclient = 1
				BEGIN
					SET @objectType = 1
					GOTO PATH_DONE
				END
				DECLARE @currLocation INT = 1
				DECLARE @prevLocation INT = 1
				-- Pre-step to handle a sepcial scenario. Replace '/' by 0x13
				SET @contentPath = REPLACE(@contentPath, '/', 0x13)
				SET @tempContent = @contentPath
				-- 1. Remove \MB\.
				SET @tempContent = SUBSTRING(@tempContent, 5, LEN(@tempContent))
				--SELECT @tempContent AS '1'
				-- 2. Convert all special char to '/'
				SET @tempContent = REPLACE(@tempContent, 0x13, '/')
				--SELECT @tempContent AS '2'
				-- 3. Split paths based on '\'. First will be web path.
				SET @currLocation = (SELECT CHARINDEX('\', @tempContent, @prevLocation))
				IF @currLocation > 0
				BEGIN
					SET @webAppPath = SUBSTRING(@tempContent, @prevLocation, @currLocation-@prevLocation)
					--SELECT @webAppPath AS '3'
				END
				ELSE
				BEGIN
					SET @webAppPath = SUBSTRING(@tempContent, @prevLocation, LEN(@tempContent))
					--SELECT @webAppPath AS '3.1'
					SET @bDone = 1
				END
				SET @relativePath = @webAppPath
				-- Trim trailing '/' and assign it to full path with object type 2
				IF @webAppPath LIKE '%/'
						SET @webAppPath = SUBSTRING(@webAppPath, 1, LEN(@webAppPath)-1)
				SET @fullPath = @webAppPath
				SET @resultContentPath = @resultContentPath + '\' + @webAppPath -- \MB\http:--webapp
				SET @objectType = 2
				IF @bDone = 1
					GOTO PATH_DONE
				--4. Next will be site collection path
				SET @prevLocation = @currLocation + 1
				SET @currLocation = (SELECT CHARINDEX('\', @tempContent, @prevLocation))
				IF @currLocation > 0
				BEGIN
					SET @siteCollectionPath = SUBSTRING(@tempContent, @prevLocation, @currLocation-@prevLocation)
					--SELECT @siteCollectionPath AS '4'
				END
				ELSE
				BEGIN
					SET @siteCollectionPath = SUBSTRING(@tempContent, @prevLocation, LEN(@tempContent))
					--SELECT @siteCollectionPath AS '4.1'
					SET @bDone = 1
				END
				IF @siteCollectionPath NOT LIKE ('%'+@webAppPath+'%') AND @siteCollectionPath NOT LIKE '%:%'
				BEGIN
					-- TRIM BEGIN
					IF @siteCollectionPath LIKE '/%'
						SET @siteCollectionPath = SUBSTRING(@siteCollectionPath, 2, LEN(@siteCollectionPath))
					-- TRIM END
					IF @siteCollectionPath LIKE '%/'
						SET @siteCollectionPath = SUBSTRING(@siteCollectionPath, 1, LEN(@siteCollectionPath)- 1)
					SET @siteCollectionPath = @webAppPath + '/' + @siteCollectionPath
				END
				SET @fullPath = @siteCollectionPath
				-- TRIM END
				IF @fullPath LIKE '%/'
						SET @fullPath = SUBSTRING(@fullPath, 1, LEN(@fullPath)- 1)
				DECLARE @TempSiteCollection NVARCHAR(MAX) = ''
				SET @TempSiteCollection = @siteCollectionPath
				IF @TempSiteCollection LIKE (@webAppPath+'%') OR @siteCollectionPath = @webAppPath
				BEGIN
						DECLARE @pos INT = 0
						SET @pos = LEN(@TempSiteCollection) - LEN(@webAppPath)
						if @pos > 0
							  SET @TempSiteCollection = SUBSTRING(@TempSiteCollection, LEN(@webAppPath)+ 1, @pos)
						else
							  SET @TempSiteCollection = '/'
				END
				-- TRIM END
				IF @TempSiteCollection LIKE '%/' AND @TempSiteCollection != '/'
						SET @TempSiteCollection = SUBSTRING(@TempSiteCollection, 1, LEN(@TempSiteCollection)- 1)
				SET @resultContentPath = @resultContentPath + '\' + @TempSiteCollection -- form the full path
				SET @relativePath = @TempSiteCollection
				SET @objectType = 3
				IF @bDone = 1
					GOTO PATH_DONE
				--5. Next will be web path
				SET @prevLocation = @currLocation + 1
				SET @currLocation = (SELECT CHARINDEX('\', @tempContent, @prevLocation))
				IF @currLocation > 0
				BEGIN
					SET @webPath = SUBSTRING(@tempContent, @prevLocation, @currLocation-@prevLocation)
					--SELECT @webPath AS '5'
				END
				ELSE
				BEGIN
					SET @webPath = SUBSTRING(@tempContent, @prevLocation, LEN(@tempContent))
					--SELECT @webPath AS '5.1'
					SET @bDone = 1
				END
				IF @webPath NOT LIKE ('%'+@siteCollectionPath+'%') AND @webPath NOT LIKE '%:%'
				BEGIN
					SET @webPath = @siteCollectionPath + @webPath
				END
				-- TRIM END
				IF @webPath LIKE '%/'
						SET @webPath = SUBSTRING(@webPath, 1, LEN(@webPath)- 1)
				SET @fullPath = @webPath
				DECLARE @TempWebSite NVARCHAR(MAX) = ''
				SET @TempWebSite = @webPath
				if @TempWebSite like (@siteCollectionPath+'%') OR @siteCollectionPath = @TempWebSite
				BEGIN
						SET @pos = LEN(@TempWebSite) - LEN(@siteCollectionPath)
						if @pos > 0
							  SET @TempWebSite = SUBSTRING(@TempWebSite, LEN(@siteCollectionPath)+ 1, @pos)
						else
							  SET @TempWebSite = '/'
				End
				-- TRIM END
				IF @TempWebSite LIKE '%/' AND @TempWebSite != '/'
						SET @TempWebSite = SUBSTRING(@TempWebSite, 1, LEN(@TempWebSite)- 1)
				SET @resultContentPath = @resultContentPath + '\' + @TempWebSite -- Form the full path
				SET @relativePath = @TempWebSite
				SET @objectType = 4
				IF @bDone = 1
					GOTO PATH_DONE
				--5. All remaining will be sub path
				SET @prevLocation = @currLocation + 1
				SET @subPath = SUBSTRING(@tempContent, @prevLocation, LEN(@tempContent))
				--SELECT @subPath AS '6'
				IF @subPath IS NOT NULL AND @subPath <> ''
				BEGIN
					SET @relativePath = @subPath
					SET @subPath = REPLACE(@subPath, '\', '/');
					SET @fullPath = @fullPath + '/' + @subPath
					SET @resultContentPath = @resultContentPath + '\' + @subPath -- Add Subpath too
					SET @objectType = 101
				END
			END
			ELSE
			BEGIN
				--PRINT('Content ['+ convert(nvarchar(max),@tempContent) + '] is being skipped for subclient [' + convert(nvarchar(max),@subclientId) + '] and isSharepointDB[' + convert(nvarchar(max),@isDBSubclient) + '].')
				GOTO NEXT_CONTENT
			END
			PATH_DONE:
			SET @resultContentPath = REPLACE(@resultContentPath, '/', 0x13)
			SET @newContent = CAST((SELECT	dbo.EncodeInvalidXMLChar(@fullPath) AS '@fullPath',
												dbo.EncodeInvalidXMLChar(@webAppPath) AS '@webAppPath',
												dbo.EncodeInvalidXMLChar(@siteCollectionPath) AS '@siteCollectionPath',
												dbo.EncodeInvalidXMLChar(@webPath) AS '@webPath',
												dbo.EncodeInvalidXMLChar(@relativePath) AS '@relativePath',
												@objectType AS '@objectType',
												dbo.EncodeInvalidXMLChar(@resultContentPath) AS '@contentPath' -- Update with formed resultant 10.0 path
									   FOR XML PATH('EVGui_SharePointItem'), TYPE) AS NVARCHAR(MAX))
			-- Mark old content as modified
			UPDATE APP_ScFilterFile
			SET modified = @currentTime
			WHERE id = @contentId AND componentNameId = @subclientID
			-- Insert upgraded content
			INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified, ccpId)
			SELECT @subclientID, @newContentType, @newContent, @currentTime, 0, 0
			-- Move on to next content
			NEXT_CONTENT:
			FETCH GetContent INTO @contentId, @contentPath, @contentType
		END
		CLOSE GetContent
		DEALLOCATE GetContent
		-- Move on to next sharepoint subclient
		FETCH GetSPSubclient INTO @subclientID, @isDBSubclient
	END
	CLOSE GetSPSubclient
	DEALLOCATE GetSPSubclient
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END
END CATCH
ALL_DONE:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_SPContentToXML')
	delete from GxQscripts where name = 'AppIdaUpgrade_SPContentToXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SPContentToXML')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SPContentToXML'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_SPContentToXML',  '00010004006000030000', 'AppIdaUpgrade_SPContentToXML', '00010004006000030000')
GO

