

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_SAPforOracle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_SAPforOracle.sp,v $ $Id: AppIdaUpgrade_SAPforOracle.sp,v 1.9.12.5 2018/03/27 08:04:06 jiechen Exp $";
----------------------------------------------------------------------
-- AppIdaUpgrade_SAPforOracle		                                --
--																	--
--																	--
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
-- 04-Mar-2010	Moved from appida_upgrade.sp with addition of command line log subClient creata:w
--
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_SAPforOracle <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_SAPforOracle')
	drop procedure AppIdaUpgrade_SAPforOracle
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_SAPforOracle')
	delete from GxQscripts where name = 'AppIdaUpgrade_SAPforOracle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SAPforOracle')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SAPforOracle'
GO
print '... Creating Procedure: AppIdaUpgrade_SAPforOracle'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_SAPforOracle
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
---------------------
-- LOCAL VARIABLES --
---------------------
DECLARE @instance			INT
DECLARE @instanceId			INT
DECLARE @backupsetId		INT
DECLARE @storagePolicy		INT
DECLARE @clientId			INT
DECLARE	@defaultSubClientId	INT
DECLARE @subClientStatus	INT
DECLARE @subClientName		VARCHAR(1024)
DECLARE	@instanceName		VARCHAR(1024)
DECLARE	@nowTime			AS INT =  dbo.GetUnixTime (GetUTCdate())
	SET @errCode			= 0			-- BE OPTIMISTIC!
	SET @errString			= ''
	IF @i_prevReleaseId < 14    -- 8.0 Clients are too old to upgrade
	BEGIN
		SET @errCode = -1
		SET @errString = 'Cannot upgrade SAP_FOR_ORACLE_ID ON Client['
							+ CONVERT(varchar(10), @i_clientId)
							+ '], releaseId ['
							+ CONVERT(varchar(10), @i_prevReleaseId)
							+ ']. Client revision too old'
		GOTO RETURN_RESULTS
	END
	IF @i_prevReleaseId >= 16  -- Cannot upgrade v11 or higher clients (yet)
		GOTO RETURN_RESULTS
-- 	FOLLOWING LOGIC ADDRESSES ISSUE WHERE COMMANDLINE SUBCLIENT STILL HAS 'DEFAULT' STATUS
--  AND THAT THERE IS NO DEFAULT SUBCLIENT   -SKATZ   05-OCT-2009
	BEGIN TRY
--	FOR EVERY INSTANCE OF THIS CLIENT/APPTYPE, GET THE CMDLINE SP FROM THE CMDLINE SUBCLIENT
		IF @i_prevReleaseId = 13				-- Already at 8.0
			GOTO UPGRADE_80_to_90
--UPGRADE_70_to_80:
------------------------------------------------------------------------------
-- SAP IDA UPGRADE FROM 7.0 TO 8.0: FOR EACH SUBCLIENT, SET 8.0 LOG STORAGE POLICY FROM 7.0 CMDLINE STORAGE POLICY
-- 7.0/8.0 CMDLINE SP EXISTS AS THE DATA SP FOR THE CMDLINE SUBCLIENT (ONE PER INSTANCE)
-- 8.0 LOG SP EXISTS AS THE LOG SP FOR EACH SUBCLIENT IN THE INSTANCE
------------------------------------------------------------------------------
--Brahma: We can skip this code path and leave log sp unchanged during upgrade.
		--DECLARE storagePolicyCursor CURSOR STATIC FOR
		--	SELECT Distinct instance, dataArchGrpID
		--	FROM app_application
		--	WHERE clientId = @i_clientId AND appTypeId = CV_APPTYPE_SAP_FOR_ORACLE			--'CV_APPTYPE_SAP_FOR_ORACLE'
		--	AND (subclientStatus & CV_STATUS_CMD_LINE) = CV_STATUS_CMD_LINE
		--OPEN storagePolicyCursor
		--	FETCH NEXT
		--		FROM  storagePolicyCursor
		--		INTO @instance, @storagePolicy
		--
		--	WHILE @@FETCH_STATUS = 0
		--	BEGIN
		--
		--	-- For each instance of this client/apptype, set all the subclient's Log SP to the 7.0 cmdline SP
		--	UPDATE APP_APPLICATION
		--	SET logArchGrpID = @storagePolicy
		--	WHERE instance = @instance
		--
		--	FETCH NEXT
		--		FROM  storagePolicyCursor
		--		INTO @instance, @storagePolicy
		--	END
		--CLOSE               storagePolicyCursor
		--DEALLOCATE  storagePolicyCursor
	DECLARE workCursor CURSOR STATIC FOR
			SELECT distinct clientid, instance, iName=(select name from app_instanceName where id = instance), backupSet
			FROM app_application AS AP, app_client AS CL
				WHERE AP.appTypeId=61
				  AND   AP.clientId = CL.id
--				  AND   CL.releaseId > 12                  -- DEFECT 54744
				  AND CL.id = @i_clientId
				  order by clientId
		OPEN workCursor
		FETCH NEXT FROM workCursor INTO @clientId,  @instanceId, @instanceName, @backupsetId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @defaultSubClientId = ISNULL((Select id from App_Application where clientId=@clientId AND backupset=@backupsetId AND instance=@instanceId and (subClientStatus & 8) = 8), 0)
			SET @subClientStatus    = ISNULL((Select subClientStatus From App_Application where id = @defaultSubClientId), 0)
			SET @subClientName		= ISNULL((Select subClientName from App_application where id  = @defaultSubClientID), 'Unknown')
			IF @instanceName='defaultDummyInstanceForSAP'
				goto SKIP_IT
			IF (@subClientStatus & 4)  = 4				-- Skip Deleted
				goto SKIP_IT
			IF (@subClientStatus & 64) = 64				-- Command Line SubClient is also Default SubClient ... Need to split!
			BEGIN
		--			PRINT 'Command Line SubClient WAS Default SubClient: client['+convert(varchar(8), @clientId)+']'
		--				+ ', instance '+convert(char(25), @instanceName+'['+convert(varchar(8), @instanceId)+'],')
		--				+ ', defaultSubClient['+convert(varchar(8), @defaultSubClientId)+']'
		--				+ ', ['+convert(char(25), @subClientName+']')
		--				+ ', @SubClientStatus['+convert(varchar(8), @subClientStatus)+']'
				UPDATE App_Application Set SubClientStatus = (subClientStatus & ~8) where id = @defaultSubClientId
				INSERT App_Application(clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime, modified, subclientName, subclientStatus, origCCId, GUID)
					SELECT clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, @nowTime, @nowTime, 'default', 8, 2, newid()
						FROM APP_Application Where id=@defaultSubClientId
				SET @defaultSubClientId = SCOPE_IDENTITY()
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'Single Instancing Option',          7,    '1', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'Encrypt: encryption',              10,    '2', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'use prepost username',              7,    '1', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'Oracle Backup Device',              7,    '1', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'last data SP',                     10,    '1', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'last log SP',                      10,    '1', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'Oracle Log backup streams',         7,    '1', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'Full Failover to SP dataPaths',     2,    '0', @nowTime, 0)
				INSERT app_subClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@defaultSubClientId, 'Reason last backup time cleared',   7,    '1', @nowTime, 0)
			END
		--  THIS APPEARS TO BE A CASE WE DON'T NEED TO BE CONCERNED ABOUT:
		--		ELSE IF (@subClientStatus & 16) = 16			-- Default + Dummy
		--		BEGIN
		--			PRINT 'Command Line SubClient WAS DUMMY SubClient: client['+convert(varchar(4), @clientId)+']'
		--				+ ', instance '+convert(char(25), @instanceName+'['+convert(varchar(4), @instanceId)+'],')
		--				+ ', defaultSubClient['+convert(varchar(4), @defaultSubClientId)+']'
		--				+ ', ['+convert(char(25), @subClientName+']')
		--				+ ', @SubClientStatus['+convert(varchar(4), @subClientStatus)+']'
		--		END
		--
		SKIP_IT:
			FETCH NEXT FROM workCursor INTO @clientId,  @instanceId, @instanceName, @backupsetId
		END
UPGRADE_80_to_90:
		IF @i_prevReleaseId = 14
		BEGIN
			DeLETE APP_SubClientProp
			WHERE attrName    = N'sys:last full'
			  AND cs_attrName = checksum(N'sys:last full')
			  AND modified    = 0
AND componentNameId in (Select id from app_application where clientId = @i_clientId And appTypeId = 61)   -- 'CV_APPTYPE_SAP_FOR_ORACLE'
		END
		IF @i_prevReleaseId < 16 -- Only for v10 and v9 clients
		BEGIN
			DECLARE @curTime INT
			SET @curTime  = datediff(second, '01/01/1970', GETUTCDATE())
			DECLARE @tempSCTbl TABLE
			(
				subClientId INT,
				UseRMANValue nvarchar(MAX)
			)
			-- Get all subclients for which Use RMAN for Tape Movement property is set
			INSERT INTO @tempSCTbl
			SELECT	DISTINCT SP.componentNameId, SP.attrVal
			FROM	APP_SubclientProp SP
				INNER JOIN APP_Application A
					ON SP.componentNameId = A.id
			WHERE	A.clientId = @i_clientId
AND	A.appTypeId = 61
				AND	SP.attrName = 'Use RMAN for Tape Movement'
				AND	SP.modified = 0
			-- If 'Use RMAN for Tape Movement' was '0', then 'Oracle Backup Copy Interface' will be '0'.
			-- If 'Use RMAN for Tape Movement' was '1', then 'Oracle Backup Copy Interface' will be '1'.
			INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
				SELECT subclientId, 'Oracle Backup Copy Interface', 2, UseRMANValue, @curTime, 0
				FROM @tempSCTbl
				WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Oracle Backup Copy Interface' AND modified = 0)
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @errCode    = ERROR_NUMBER()
		set @errString	= 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	END CATCH
--	CLEAN-UP
	IF ( CURSOR_STATUS('global', 'workCursor') >= 0  OR CURSOR_STATUS('local', 'workCursor') >= 0 )  -- Cursor is open
		CLOSE workCursor
	IF ( CURSOR_STATUS('global', 'workCursor')  = -1 OR CURSOR_STATUS('local', 'workCursor') = -1 )  -- Cursor is closed
		DEALLOCATE  workCursor
	--IF ( CURSOR_STATUS('global', 'storagePolicyCursor') >= 0  OR CURSOR_STATUS('local', 'storagePolicyCursor') >= 0 )  -- Cursor is open
		--CLOSE storagePolicyCursor
	--IF ( CURSOR_STATUS('global', 'storagePolicyCursor')  = -1 OR CURSOR_STATUS('local', 'storagePolicyCursor') = -1 )  -- Cursor is closed
		--DEALLOCATE  storagePolicyCursor
RETURN_RESULTS:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_SAPforOracle')
	delete from GxQscripts where name = 'AppIdaUpgrade_SAPforOracle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SAPforOracle')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SAPforOracle'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_SAPforOracle',  '00010009001200050000', 'AppIdaUpgrade_SAPforOracle', '00010009001200050000')
GO

