

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_SAPHANA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_SAPHANA.sp,v $ $Id: AppIdaUpgrade_SAPHANA.sp,v 1.4.2.2 2018/03/27 08:17:18 jiechen Exp $";
----------------------------------------------------------------------
-- AppIdaUpgrade_SAPHANA		                                --
--																	--
--																	--
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
-- 07/10/2015	Initial Edit
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_SAPHANA <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_SAPHANA')
	drop procedure AppIdaUpgrade_SAPHANA
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_SAPHANA')
	delete from GxQscripts where name = 'AppIdaUpgrade_SAPHANA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SAPHANA')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SAPHANA'
GO
print '... Creating Procedure: AppIdaUpgrade_SAPHANA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_SAPHANA
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
---------------------
-- LOCAL VARIABLES --
---------------------
DECLARE @instance			INT
DECLARE @dataStoragePolicy	INT
DECLARE @logStoragePolicy	INT
DECLARE @clientId			INT
	SET @errCode			= 0			-- BE OPTIMISTIC!
	SET @errString			= ''
	IF @i_prevReleaseId < 14    -- 8.0 Clients are too old to upgrade
	BEGIN
		SET @errCode = -1
		SET @errString = 'Cannot upgrade SAP HANA ON Client['
							+ CONVERT(varchar(10), @i_clientId)
							+ '], releaseId ['
							+ CONVERT(varchar(10), @i_prevReleaseId)
							+ ']. Client revision too old'
		GOTO RETURN_RESULTS
	END
	IF @i_prevReleaseId >= 16  -- Cannot upgrade v11 or higher clients (yet)
		GOTO RETURN_RESULTS
-- 	FOLLOWING LOGIC ADDRESSES ISSUE WHERE default SUBCLIENT DOESN'T HAVE STORAGE POLICY ASSOCIATED
--	THIS APPLIES ONLY FOR THE CLIENTS GETTING UPGRADED FROM V10 (RELEASE ID: 15)
--	STELAGAMSETTI 07/10/2015
	BEGIN TRY
		IF (@i_prevReleaseId = 15)
		BEGIN
			DECLARE storagePolicyCursor CURSOR STATIC FOR
			SELECT	DISTINCT A.clientId, A.instance, A.dataArchGrpId, A.logArchGrpId
			FROM	APP_InstanceProp IP
				INNER JOIN APP_Application A ON IP.componentNameId = A.instance
				CROSS APPLY dbo.Split(attrVal, '+') S
			WHERE	IP.attrName = 'Database Clients'
				AND IP.modified = 0
AND	A.appTypeId = 135								-- 'CV_APPTYPE_SAP_HANA'
AND (A.subclientStatus & 0x0040) = 0x0040	-- 'CV_STATUS_CMD_LINE'
				AND CAST(S.Data AS INT) = @i_clientId
			OPEN storagePolicyCursor
				FETCH NEXT
					FROM	storagePolicyCursor
					INTO	@clientId, @instance, @dataStoragePolicy, @logStoragePolicy
				WHILE @@FETCH_STATUS = 0
				BEGIN
					-- For each instance of this physical client/apptype, set default subclient's data SP to cmdline SP
					UPDATE	APP_Application
					SET		dataArchGrpID = @dataStoragePolicy,
							logArchGrpId = @logStoragePolicy
					WHERE	instance = @instance
						AND	clientId = @clientId
AND appTypeId = 135
AND (subclientStatus & 0x00008) = 0x00008	-- 'CV_STATUS_DEFAULT'
						AND dataArchGrpId = 1
					FETCH NEXT
						FROM	storagePolicyCursor
						INTO	@clientId, @instance, @dataStoragePolicy, @logStoragePolicy
				END
			CLOSE               storagePolicyCursor
			DEALLOCATE  storagePolicyCursor
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @errCode    = ERROR_NUMBER()
		set @errString	= 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	END CATCH
IF ( CURSOR_STATUS('global', 'storagePolicyCursor') >= 0  OR CURSOR_STATUS('local', 'storagePolicyCursor') >= 0 )  -- Cursor is open
	CLOSE storagePolicyCursor
IF ( CURSOR_STATUS('global', 'storagePolicyCursor')  = -1 OR CURSOR_STATUS('local', 'storagePolicyCursor') = -1 )  -- Cursor is closed
	DEALLOCATE  storagePolicyCursor
RETURN_RESULTS:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_SAPHANA')
	delete from GxQscripts where name = 'AppIdaUpgrade_SAPHANA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_SAPHANA')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_SAPHANA'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_SAPHANA',  '00010004000200020000', 'AppIdaUpgrade_SAPHANA', '00010004000200020000')
GO

