

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_Oracle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_Oracle.sp,v $ $Id: AppIdaUpgrade_Oracle.sp,v 1.5.12.3 2018/03/27 07:59:47 jiechen Exp $";
----------------------------------------------------------------------
-- AppIdaUpgrade_Oracle	 (non-SAP)	                                --
--																	--
--																	--
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
-- 08-Jun-2010	Initial Edit										--
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_Oracle <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_Oracle')
	drop procedure AppIdaUpgrade_Oracle
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_Oracle')
	delete from GxQscripts where name = 'AppIdaUpgrade_Oracle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_Oracle')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_Oracle'
GO
print '... Creating Procedure: AppIdaUpgrade_Oracle'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_Oracle
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_appTypeId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
---------------------
-- LOCAL VARIABLES --
---------------------
DECLARE	@nowTime						AS INT 			=  dbo.GetUnixTime (GetUTCdate())
DECLARE @CV_LASTFULL_PROP               AS NVARCHAR(50) = N'sys:last full'
DECLARE @CV_TABLEBROWSE_PROP			AS NVARCHAR(50) = N'Oracle Enable Table Browse'
DECLARE @CV_SNAP_ENABLE_PROP			AS NVARCHAR(50) = N'Enable Snap Backups'
	SET @errCode			= 0			-- BE OPTIMISTIC!
	SET @errString			= ''
	IF @i_prevReleaseId < 14    -- 8.0 Clients are too old to upgrade
	BEGIN
		SET @errCode = -1
		SET @errString = 'Cannot upgrade SAP_FOR_ORACLE_ID ON Client['
							+ CONVERT(varchar(10), @i_clientId)
							+ '], releaseId ['
							+ CONVERT(varchar(10), @i_prevReleaseId)
							+ ']. Client revision too old'
		GOTO RETURN_RESULTS
	END
	IF @i_prevReleaseId >= 16  -- Cannot upgrade v11 or higher clients (yet)
		GOTO RETURN_RESULTS
--  UPGRAADE FOR 7.0 or 8.0 is the same:
	BEGIN TRY
		IF @i_prevReleaseId = 14
		BEGIN
			DECLARE @subClientidTable  table (subid  integer,
											  name	 nvarchar(256),
											  status integer
											  )
	-- 		FETCH A LIST OF ALL POSSIBLE SUBCLIENTS WE NEED TO CHECK:
			INSERT @subClientidTable
				SELECT id, subclientName, subClientStatus
				FROM APP_Application
					WHERE clientId = @i_clientId AND appTypeId = @i_appTypeId and (subclientStatus & 4) = 0   -- SKIP FOR DELETED SUBCLIENTS (but not uninstalled)
	-- 		IF "LAST FULL" PROP NOT ALREADY SET FOR A SUBCLIENT, REMOVE IT FROM THE LIST
			DeLeTe @subClientidTable
			WHERE NOT EXISTS (select * from app_subclientProp
								WHERE attrName    = @CV_LASTFULL_PROP
								  AND cs_attrName = checksum(@CV_LASTFULL_PROP)
								  AND modified    = 0
								  AND componentNameId = subid)
	--		BOTH TABLE BROWSE AND SNAP BACKUP HAVE TO BE ENABLED IF WE ARE TO FORCE NEXT BACKUP TO BE A FULL
	-- 		Per Brahmaiah V. 06-Jul-2009, the case is if EITHER is SET, not BOTH  -SKatz
			DeLeTe @subClientidTable
			WHERE NOT EXISTS (select * from app_subclientProp
								WHERE attrName    = @CV_TABLEBROWSE_PROP
								  AND cs_attrName = checksum(@CV_TABLEBROWSE_PROP)
								  AND attrVal     <> N'0'
								  AND modified    = 0
								  AND componentNameId = subid)
			AND NOT EXISTS (select * from app_subclientProp
								WHERE attrName    = @CV_SNAP_ENABLE_PROP
								  AND cs_attrName = checksum(@CV_SNAP_ENABLE_PROP)
								  AND attrVal     <> N'0'
								  AND modified    = 0
								  AND componentNameId = subid)
	--		ONLY SUBCLIENT ID'S LEFT IN TEMP TABLE ARE THE ONE'S THAT REQUIRE BACKUPS FORCED TO FULL
			DeLeTe APP_SubClientProp
			   WHERE attrName    = @CV_LASTFULL_PROP
				 AND cs_attrName = checksum(@CV_LASTFULL_PROP)
				 AND modified    = 0
				 AND componentNameId in (Select subid from @subClientidTable)
		END
		IF @i_prevReleaseId < 16 -- Only for v10 and v9 clients
		BEGIN
			DECLARE @curTime INT
			SET @curTime  = datediff(second, '01/01/1970', GETUTCDATE())
			DECLARE @tempSCTbl TABLE
			(
				subClientId INT,
				UseRMANValue nvarchar(MAX)
			)
			-- Get all subclients for which Use RMAN for Tape Movement property is set
			INSERT INTO @tempSCTbl
			SELECT	DISTINCT SP.componentNameId, SP.attrVal
			FROM	APP_SubclientProp SP
				INNER JOIN APP_Application A
					ON SP.componentNameId = A.id
			WHERE	A.clientId = @i_clientId
AND (A.appTypeId = 22 OR A.appTypeId = 80)
				AND	SP.attrName = 'Use RMAN for Tape Movement'
				AND	SP.modified = 0
			-- If 'Use RMAN for Tape Movement' was '0', then 'Oracle Backup Copy Interface' will be '0'.
			-- If 'Use RMAN for Tape Movement' was '1', then 'Oracle Backup Copy Interface' will be '1'.
			INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
				SELECT subclientId, 'Oracle Backup Copy Interface', 2, UseRMANValue, @curTime, 0
				FROM @tempSCTbl
				WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Oracle Backup Copy Interface' AND modified = 0)
		END
--	SELECT * from  @subClientidTable
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @errCode    = ERROR_NUMBER()
		set @errString	= 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	END CATCH
--	CLEAN-UP (IF ANY)
RETURN_RESULTS:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_Oracle')
	delete from GxQscripts where name = 'AppIdaUpgrade_Oracle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_Oracle')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_Oracle'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_Oracle',  '00010005001200030000', 'AppIdaUpgrade_Oracle', '00010005001200030000')
GO

