

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_NoUseQSnap.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_NoUseQSnap.sp,v $ $Id: AppIdaUpgrade_NoUseQSnap.sp,v 1.9.2.2 2018/03/27 08:03:02 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: AppIdaUpgrade_NoUseQSnap()
--
--  | 05-June-2008  -SKatz
--
--  | This script will age all the "Use QSNAP"
--  | properties for selected AppTypes and
--  |replace them with "Use VSS' props
--  |
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: appIdaUpgrade_NoUseQSnap <<<'

IF EXISTS (select * from sysobjects where name='appIdaUpgrade_NoUseQSnap')
	drop procedure appIdaUpgrade_NoUseQSnap
IF EXISTS (select * from GxQscripts where name='appIdaUpgrade_NoUseQSnap')
	delete from GxQscripts where name = 'appIdaUpgrade_NoUseQSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='appIdaUpgrade_NoUseQSnap')
	delete from GXDBVersions where aliasname = 'appIdaUpgrade_NoUseQSnap'
GO
print '... Creating Procedure: appIdaUpgrade_NoUseQSnap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure appIdaUpgrade_NoUseQSnap
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer         OUTPUT,
  @errString varchar(1024)   OUTPUT
AS
-- FOLLOWING IS "ROW" THAT IS RETURNED --
--:DECLARE  retCode    integer;
--:DECLARE  infoString nvarchar(MAX_VARCHAR_SIZE);
SET NOCOUNT ON
SET @errString =  ''
SET @errCode    =  0
--THESE ARE THE APPTYPES THAT WE WILL PROCESS "Use QSNAP" FOR:
-------------------------------------------------------------
--#define CV_APPTYPE_WINDOWS_FILESYSTEM                  33
--#define LEGACY_CV_APPTYPE_XP64_BIT                  34
--#define LEGACY_CV_APPTYPE_WIN2003_32BIT              42
--#define LEGACY_CV_APPTYPE_WIN2003_64BIT              43
--#define CV_APPTYPE_IMAGE_WINFS_IDA                      65
DECLARE @DEBUGGER	int
SET	    @DEBUGGER   = 1								-- IF <> 0, DO DEBUGGING, ROLLBACK ALL RESULTS
----------------------------------
-- SOME CONVENIENCE DEFINITIONS --
----------------------------------
DECLARE @PROP_CV_ASSOCIATED_SCP			NVarchar(128)
SET		@PROP_CV_ASSOCIATED_SCP			='Associated subclient Policy'
DECLARE @PROP_CV_USE_QSNAP				NVarchar(128)	-- THIS IS THE SUBCLIENT PROPERTY WE ARE OBSOLETING
SET		@PROP_CV_USE_QSNAP				= 'Use QSNAP'
DECLARE @PROP_CV_USE_SHADOW_COPY		NVarchar(128)	-- THIS IS THE SUBCLIENT PROPERTY (THAT ALREADY EXISTS) THAT WE ARE REPLACING IT WITH
SET		@PROP_CV_USE_SHADOW_COPY		= 'Use Shadow Copy'
DECLARE @1030	int
SET     @1030    =1030
DECLARE	@SIM_ID_GX_REL70  integer
SET	    @SIM_ID_GX_REL70  =12
DECLARE @nowTime   integer
SET		@nowTime  =   dbo.GetUnixTime (GetUTCdate())
-----------------------
-- "Local Variables" --
-----------------------
DECLARE @clientId     int
DECLARE @appTypeId    int
DECLARE @subclientId  int						-- Current SubClient we are looking at
DECLARE @id           int						-- PK of subclientProp table entry currently being looked at
DECLARE @attrVal	  nvarchar(128)				-- "value" of subClient Property currently being looked at
DECLARE @releaseId	  int
DECLARE @simOSid      int
DECLARE @oldId		  int
DECLARE @createdSCP  int
DECLARE @created     int
--===================================================================================================
-- Check if there are any subclient policies with  qsnap enabled.  If so, we will need to process  --
-- any associated subclients accordingly.  We should only have to do this as part of commcell-wide --
-- update (i_clientid = 0), as this process will age all scp qsnap properties & gui will no longer --
-- allow it to be set at scp level.  Note that we DO NOT care what apptype is being referred to    --
-- as the "use qsnap" property is being fully deprecated for all apptypes (thru SCP)!              --
--===================================================================================================
IF (@I_CLIENTID = 0)
BEGIN
	DECLARE ScpCursor CURSOR STATIC FOR
	SELECT SCP1.id, SCP1.componentNameId, AssocSubClientId=SCP1.attrVal
FROM APP_SUBCLIENTPROP AS SCP1
       INNER JOIN  APP_SUBCLIENTPROP AS SCP2 ON
              SCP1.AttrName = @PROP_CV_ASSOCIATED_SCP
              AND SCP1.cs_attrName = 	CHECKSUM(@PROP_CV_ASSOCIATED_SCP)
              AND SCP1.modified = 0
              AND SCP2.componentNameId =  SCP1.attrVal
              AND SCP2.cs_attrName = CHECKSUM(@PROP_CV_USE_QSNAP)
              AND  SCP2.attrname = @PROP_CV_USE_QSNAP
        AND  SCP2.attrVal  = '1'
        AND  SCP2.modified = '0'
	OPEN ScPCursor
	FETCH NEXT FROM ScpCursor INTO @id, @subClientId, @attrVal
	WHILE @@FETCH_STATUS = 0
	BEGIN
	-- ------------------------------------------------
	--	CHECK IF CLIENT WAS PROVIDED AS INPUT, AND   --
	--  SKIP ANY CLIENTS THAT DON'T MATCH IT IF SO:  --
	-- ------------------------------------------------
		set @clientId  = (select clientId		FROM APP_APPLICATION	WHERE Id=@subClientId)
		IF @Clientid = @I_CLIENTID AND @I_CLIENTID <> 0
			GOTO SKIP_SCP_SUBCLIENT
	--  ------------------------------------------------
	--  IF THERE IS A VALID "Use QSNAP" prop. for     --
	--  subClient, Ignore whatever was set for the    --
	--  SubClientPolicy!                              --
	--  ------------------------------------------------
		SET @oldId =   ISNULL((SELECT id FROM APP_SUBCLIENTPROP
								WHERE ComponentNameId = @subClientId
									AND		 attrname = @PROP_CV_USE_QSNAP
									AND modified = '0'),0)
		IF (@oldId <> 0)
			GOTO SKIP_SCP_SUBCLIENT
	--  DON'T CARE ABOUT RELEASEID or APPTYPE HERE, THAT WILL BE LOOKED AT IN THE
	--  NEXT CURSOR LOOP.  FOR NOW, CREATE A QSNAP PROPERTY FOR THE SUBCLIENT THAT WAS
	--  POINTED TO BY A SCP (that had QSnap enabled)
	--	set @appTypeId = (select apptypeid		FROM APP_APPLICATION	WHERE Id=@subClientId)
	--	set @releaseId = (select releaseId      FROM APP_CLIENT         WHERE id=@clientId)
		if @DEBUGGER > 1
			PRINT 'Based on SCP rules, creating [USE QSNAP] property for SubClient [' + convert(varchar(10), @subClientId) + '].'
		INSERT APP_SUBCLIENTPROP VALUES  (@subClientId, @PROP_CV_USE_QSNAP, 2, '1', @nowTime, 0, 0)
	SKIP_SCP_SUBCLIENT:
		FETCH NEXT FROM ScpCursor INTO @id, @subClientId, @attrVal
	END
	CLOSE       ScpCursor
	DEALLOCATE  ScpCursor
--  -----------------------------------------------------------------------------------------------
--  NOW THAT WE ARE ALL DONE WITH SCP SET "USE QSNAP" OPTION, AGE ALL SCP LEVEL "Use QSnap" options:
--  -----------------------------------------------------------------------------------------------
	UPDATE APP_SUBCLIENTPROP
		SET modified = @nowTime
		FROM APP_SUBCLIENTPROP AS SCP, APP_APPLICATION AS APP
			WHERE	 attrname = @PROP_CV_USE_QSNAP
  			  AND SCP.modified = 0
			  AND APP.id = SCP.componentNameId
AND APP.apptypeId = @1030
	if @DEBUGGER > 1
		SELECT step='cleanup', * FROM app_subClientProp where modified = @nowTime
END
--===================================================================================================
-- NOW WE WILL LOOK AT CERTAIN APPTYPES, & CONVERT THE "USE QSNAP" to "USE VSS" AS APPROPRIATE     --
--===================================================================================================
-- --------------------------------------------------
-- FETCH ALL THE APPLICABLE "USE QSNAP" SUBCLIENTS --
-- --------------------------------------------------
DECLARE subClientCursor CURSOR STATIC FOR
	SELECT SCP.id, SCP.componentNameId, APP.clientId, APP.appTypeId
	 FROM app_subClientProp AS SCP, app_application AS APP
		WHERE SCP.attrname = @PROP_CV_USE_QSNAP
		  AND SCP.cs_attrname = CHECKSUM(@PROP_CV_USE_QSNAP)
		  AND SCP.attrVal  = '1'
		  AND SCP.modified = '0'
		  AND SCP.componentNameId = APP.id
		  AND APP.appTypeId in (33, 34, 42, 43, 65)
          AND (@i_ClientId = 0 OR APP.clientId = @i_ClientId)
OPEN subClientCursor
FETCH NEXT FROM subClientCursor  INTO @ID, @subClientId, @clientId, @appTypeId
WHILE @@FETCH_STATUS = 0
BEGIN
if @DEBUGGER > 1
	SELECT Step ='subClientCursor', id=@ID, subClientId=@subClientId, clientId=@clientId, appType=@appTypeId
if @DEBUGGER > 2
BEGIN
	SELECT Step='before', * from APP_subClientProp
	Where componentNameId = @subClientId
	AND attrName in (@PROP_CV_USE_QSNAP, @PROP_CV_USE_SHADOW_COPY)
    ORDER BY id
END
--  -------------------------
--	CHECK IF 7.0 OR LATER  --
--  -------------------------
	IF (@i_clientID = 0)
	BEGIN
		SET @releaseId = ISNULL((Select releaseId from APP_Client where id = @clientId), 0)
		if  @releaseId < @SIM_ID_GX_REL70
		BEGIN
			IF @DEBUGGER <> 0
				print 'SKipping Client[' +convert(varchar(10), @clientId) + '], releaseId[' + convert(varchar(10), @releaseId) + '].'
			GOTO SKIP_SUBCLIENT
		END
	END
------------------------------------
--  IF IMAGE LEVEL, EXCLUDE WIN2K --
------------------------------------
	if (@appTypeId = 65)
	BEGIN
		IF @DEBUGGER > 2
			PRINT 'SubClient[' +convert(varchar(5), @subclientId) + '] is image.'
		--SET @simOSId = (ISNULL((Select simOSid from simSYstemOS where id = (select simSystemOsId From app_client where id = @clientId)), 0))
		SET @simOSId = ISNULL((select simOperatingSystemId From app_client where id = @clientId), 0)
		IF @simOSId = 3
		BEGIN
			IF @DEBUGGER <> 0
				print 'SKipping Client[' +convert(varchar(10), @clientId) + '], simOSId[' + convert(varchar(10), @simOSId) + '].'
			GOTO SKIP_SUBCLIENT
		END
	END
--  -------------------------
--	-- "AGE" OLD PROPERTY  --
--  -------------------------
	UPDATE app_subClientProp SET modified = @nowtime
    WHERE id = @ID
--  -----------------------------------------------------
--  -- SEE IF WE NEED TO ADD "USE SHADOW COPY", or NOT --
--  -----------------------------------------------------
	SET @id = ISNULL((Select id from app_subClientProp
						WHERE componentNameId = @subclientId
                          AND attrName = @PROP_CV_USE_SHADOW_COPY
                          AND modified = 0),0)
--  SHADOW COPY PROPERTY (ENABLED OR OTHERWISE) NOT IN DB --
	IF @id = 0
		INSERT APP_SUBCLIENTPROP VALUES (@subClientId, @PROP_CV_USE_SHADOW_COPY, 2, '1', @nowTime, 0, 0)
--  SHADOW COPY PROPERTY, IN DB, BUT WAS IT "ENABLED"? --
	ELSE
	BEGIN
		SET @AttrVal = (select attrVal from APP_subClientProp WHERE id = @id)
		if  @AttrVal = '0'
			BEGIN
			UPDATE App_subClientProp SET modified = @nowTime WHERE id = @id				-- AGE EXISTING "DISABLED" PROPERTY
			INSERT APP_SUBCLIENTPROP VALUES  (@subClientId, @PROP_CV_USE_SHADOW_COPY, 2, '1', @nowTime, 0, 0)	-- ADD IN NEW "ENABLED" PROPERTY
			END
	END
if @DEBUGGER >3
	SELECT Step='after', * from APP_subClientProp
	Where componentNameId = @subClientId
	AND attrName in (@PROP_CV_USE_QSNAP, @PROP_CV_USE_SHADOW_COPY)
    ORDER BY id
SKIP_SUBCLIENT:
	FETCH NEXT FROM subClientCursor  INTO @ID, @subClientId, @clientId, @appTypeId
END
CLOSE       subClientCursor
DEALLOCATE  subClientCursor
RETURN_RESULTS:
--  SELECT [retCode] = @retCode, [infoString] = @infoString		-- THIS IS THE DATA THE CALLER IS EXPECTING
  SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_NoUseQSnap')
	delete from GxQscripts where name = 'AppIdaUpgrade_NoUseQSnap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_NoUseQSnap')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_NoUseQSnap'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_NoUseQSnap',  '00010009000200020000', 'AppIdaUpgrade_NoUseQSnap', '00010009000200020000')
GO

