

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_MySql.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_MySql.sp,v $ $Id: AppIdaUpgrade_MySql.sp,v 1.1.2.6 2018/03/27 08:08:39 jiechen Exp $";
----------------------------------------------------------------------
-- AppIdaUpgrade_MySql		                                        --
--																	--
--																	--
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
-- 07/10/2015	Initial Edit
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_MySql <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_MySql')
	drop procedure AppIdaUpgrade_MySql
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_MySql')
	delete from GxQscripts where name = 'AppIdaUpgrade_MySql'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_MySql')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_MySql'
GO
print '... Creating Procedure: AppIdaUpgrade_MySql'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_MySql
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
    DECLARE @currentTime INT = dbo.getUnixTime(GETUTCDATE())
    DECLARE @instanceId INT
    DECLARE @logSP      INT
    DECLARE @backupSetId INT
DECLARE @STATUS_DEFAULT AS INT = 0x00008
DECLARE @STATUS_DUMMY   AS INT = 0x00010
DECLARE @STATUS_CMD_LINE	AS INT = 0x0040
	SET @errCode			= 0			-- BE OPTIMISTIC!
	SET @errString			= ''
	IF @i_prevReleaseId < 14    -- 8.0 Clients are too old to upgrade
	BEGIN
		SET @errCode = -1
		SET @errString = 'Cannot upgrade MySql Client['
							+ CONVERT(varchar(10), @i_clientId)
							+ '], releaseId ['
							+ CONVERT(varchar(10), @i_prevReleaseId)
							+ ']. Client revision too old'
		GOTO RETURN_RESULTS
	END
    -- Copy logbackup Sp to Command Line Backup SP in all Mysql Instances in the given client
	BEGIN TRY
		IF object_id('tempdb.dbo.#selectedBkpSet') is NOT NULL
			DROP TABLE #selectedBkpSet
		CREATE TABLE #selectedBkpSet
		(
			instanceId INT,
			backupSetId INT,
			logSP INT
		)
		IF object_id('tempdb.dbo.#newSc') is NOT NULL
			DROP TABLE #newSc
		CREATE TABLE #newSc
		(
			scId INT,
			errorCode INT,
			errorStr NVARCHAR(2048)
		)
		---------------------------------------------------------------------
		-- Select only Instances which do not have commandline Subclients  --
		-- It is possible that some old instances created by Item based    --
		-- protocol do have commandline subclients.						   --
		---------------------------------------------------------------------
		INSERT INTO  #selectedBkpSet
		SELECT AppR.instance, AppR.backupSet, AppR.logArchGrpID
		FROM APP_Application AppR
			LEFT JOIN APP_Application AppL
			ON AppR.instance = AppL.instance
			AND AppL.subclientStatus & @STATUS_CMD_LINE = @STATUS_CMD_LINE
		WHERE
AppR.appTypeId = 104
			AND AppR.clientId = @i_clientId
			AND AppR.subclientStatus & (@STATUS_DEFAULT | @STATUS_DUMMY | @STATUS_CMD_LINE) = @STATUS_DEFAULT
			AND AppL.id is NULL
		DECLARE instanceCursor CURSOR
		FOR
		SELECT * FROM #selectedBkpSet
		OPEN instanceCursor
		FETCH NEXT FROM instanceCursor INTO @instanceId,@backupSetId,@logSP
		WHILE @@FETCH_STATUS = 0
		BEGIN
			---------------------------------------------
			-- Create commandlineSubclient 			   --
			---------------------------------------------
			INSERT #newSc
EXEC AppInsertSubclient '(command line)',@i_clientId, 104, @instanceId, @backupSetId, @logSP, @logSP, @currentTime,@STATUS_CMD_LINE, 0, 0
			----------------------------------
			-- Get values for next Instance --
			----------------------------------
			FETCH NEXT FROM instanceCursor INTO @instanceId,@backupSetId,@logSP
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @errCode    = ERROR_NUMBER()
		set @errString	= 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	END CATCH
RETURN_RESULTS:
	IF object_id('tempdb.dbo.#selectedBkpSet') is not null
			DROP TABLE #selectedBkpSet
	IF object_id('tempdb.dbo.#newSc') is not null
			DROP TABLE #newSc
	IF ( CURSOR_STATUS('global', 'instanceCursor') >= 0 OR CURSOR_STATUS('local', 'instanceCursor') >= 0)
	BEGIN
		CLOSE instanceCursor
		DEALLOCATE instanceCursor
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_MySql')
	delete from GxQscripts where name = 'AppIdaUpgrade_MySql'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_MySql')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_MySql'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_MySql',  '00010001000200060000', 'AppIdaUpgrade_MySql', '00010001000200060000')
GO

