

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_MvScanOptionToSC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_MvScanOptionToSC.sp,v $ $Id: AppIdaUpgrade_MvScanOptionToSC.sp,v 1.7.60.3 2018/03/27 08:04:36 jiechen Exp $";
----------------------------------------------------------------------
-- UNIX/WIN FS CLIENT UPGRADE										--
--														--
-- 1. Move Job Scan Method Properties from BackupSet to Subclient level 		--
--														--
----------------------------------------------------------------------------------------------------------------------
-- EDIT HISTORY																										--
-- DATE			REV.	DESCRIPTION																					--
-- -----------	------	--------------------------------------------------------------------------------------
--																			--
-- 																			--
--------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_MvScanOptionToSC <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_MvScanOptionToSC')
	drop procedure AppIdaUpgrade_MvScanOptionToSC
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_MvScanOptionToSC')
	delete from GxQscripts where name = 'AppIdaUpgrade_MvScanOptionToSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_MvScanOptionToSC')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_MvScanOptionToSC'
GO
print '... Creating Procedure: AppIdaUpgrade_MvScanOptionToSC'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_MvScanOptionToSC
  @clientID int,
  @apptypeID int,
  @prevReleaseID int,
  @errorCode int OUTPUT,
  @errorString nvarchar(1024) OUTPUT
AS
SET NOCOUNT ON
DECLARE @subclient AS int
DECLARE @scpolicyID AS int
DECLARE @toupgradevalues AS nvarchar(5)
DECLARE @bsid AS int
DECLARE @temptbl table
(
		Combination nvarchar(5),
		Counter int
)
DECLARE @UseChangeJournal AS nvarchar
DECLARE @resetfileaccesstime AS nvarchar
DECLARE @useDC AS nvarchar
DECLARE @useArchiveBit AS nvarchar
DECLARE @useclassicscan AS nvarchar
DECLARE @backupset AS int
DECLARE @releaseID AS int
SET @errorcode = 0
SET @errorstring = 'Succeeded.'
--Basic checking--
IF EXISTS (SELECT *
		   FROM APP_Client
		   WHERE id = @clientID)
BEGIN
	SET @releaseID = ISNULL((Select top 1 ID from simAllGalaxyRel order by id desc), 0)
	IF @prevReleaseId = @releaseId
	BEGIN
		SET @errorstring  = 'Client [' + (SELECT name FROM APP_Client WHERE id = @clientID) + '] has already been upgraded to release[' + Convert(varchar(3), @releaseId) + '].'
--	set @errCode = DB_WARN						-- 'DB_WARN'
		SET @errorcode  = 0							-- Ignore, 8.0 -->9.0 Upgrade Kludge
		GOTO Cleanup
	END
END
ELSE
BEGIN
	SET @errorcode = 1
	SET @errorstring = 'Client ID ' + @clientID + ' is invalid'
	GOTO Cleanup
END
--SET @clientID = 2
--SET @apptypeID = 1030
IF @prevReleaseId < 15
BEGIN
--Validation successfull--
BEGIN TRY
BEGIN
	/*IF @clientID = 2			--for base client upgradation, alone call this, this is for moving scan options to subclient policy
	BEGIN
		--fetch the subclient id's associated with subclient policies (only windows and unix, excludes netware)
		DECLARE subclientcursor CURSOR STATIC FOR
			SELECT id
			FROM APP_Application
			WHERE apptypeID = 1030 AND clientID = 2 AND backupSet not in (SELECT componentnameid
																		  FROM APP_BackupSetProp
																		  WHERE attrName = N'Associated subclient policy ida type' and attrVal = 4 and modified =0)
		OPEN subclientcursor
		FETCH NEXT FROM subclientcursor INTO @subclient
		WHILE @@FETCH_STATUS = 0
		BEGIN
			--Find the subclient policy to which this subclient is associated to--
			SET @scpolicyID = ISNULL((SELECT backupSet
									  FROM APP_Application
									  WHERE id = @subclient),0)
			--Check whether this subclient policy is associated with any backupset, if so then proceed.--
			IF EXISTS ( SELECT componentNameId
						FROM APP_BackupsetProp
						WHERE attrval = convert(char,@scpolicyID) AND modified = 0 AND attrName = N'Associated Subclient Policy' )
			BEGIN
				--fetch all the backupset id's with the same attrval, ie., the same subclient policy
				DECLARE iteratorcursor CURSOR STATIC FOR
					SELECT componentNameId
					FROM APP_BackupsetProp
					WHERE attrval = convert(char,@scpolicyID) AND modified = 0 AND attrName = N'Associated Subclient Policy'
				OPEN iteratorcursor
				FETCH NEXT FROM iteratorcursor INTO @bsid
				WHILE @@FETCH_STATUS = 0
				BEGIN
					SET @UseChangeJournal = ISNULL((SELECT attrVal FROM APP_BackupSetProp WHERE componentNameId = @bsid AND attrName = N'Use Change Journal' AND modified = 0),'1')
					SET @resetfileaccesstime = ISNULL((SELECT attrval FROM APP_BackupSetProp WHERE componentNameId = @bsid AND attrName = N'Reset File Access Times' AND modified = 0),'0')
					SET @useDC  = ISNULL((SELECT attrval FROM APP_BackupSetProp WHERE componentNameId = @bsid AND attrName = N'Use DC for FS backups' AND modified = 0 ),'0')
					SET @useArchiveBit  = ISNULL((SELECT attrval FROM APP_BackupSetProp WHERE componentNameId = @bsid AND attrName = N'Use Archive Bit' AND modified = 0),'0')
					IF  @useChangeJournal = '0' AND @useDC = '0'
		   				SET @useClassicScan = '1'
					ELSE
    					SET @useClassicScan = '0'
					--Insert into the @temptbl the string combination and the count--
					IF NOT EXISTS (SELECT *
								   FROM @temptbl
								   WHERE Combination = @UseChangeJournal+@resetfileaccesstime+@useDC+@useArchiveBit+@useClassicscan)
					BEGIN
	   					INSERT @temptbl	VALUES (@UseChangeJournal + @resetfileaccesstime + @useDC + @useArchiveBit + @useclassicscan ,1)
	   				END
					ELSE
					BEGIN
						UPDATE @temptbl
						SET Counter = Counter + 1
						WHERE Combination = @UseChangeJournal+@resetfileaccesstime+@useDC+@useArchiveBit+@useClassicscan
					END
					FETCH NEXT FROM iteratorcursor INTO @bsid
				END
				CLOSE iteratorcursor
				DEALLOCATE iteratorcursor
				SET @toupgradevalues = (SELECT top 1 Combination
										FROM @temptbl
										WHERE Counter = (SELECT MAX(Counter)
														 FROM @temptbl))
				DELETE FROM @temptbl
   				IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient  AND attrName = N'Use Change Journal')
					INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use Change Journal',2,SUBSTRING(@toupgradevalues ,1,1),dbo.GetUnixTime(GetUTCdate()),0)
				IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Reset File Access Times')
					INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Reset File Access Times',2,SUBSTRING(@toupgradevalues ,2,1),dbo.GetUnixTime(GetUTCdate()),0)
				IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Use DC for FS Backups')
					INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use DC for FS Backups',2,SUBSTRING(@toupgradevalues ,3,1),dbo.GetUnixTime(GetUTCdate()),0)
				IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Use Archive Bit')
					INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use Archive Bit',2,SUBSTRING(@toupgradevalues ,4,1),dbo.GetUnixTime(GetUTCdate()),0)
				IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Use Classic file scan')
					INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use classic file scan',2,SUBSTRING(@toupgradevalues ,5,1),dbo.GetUnixTime(GetUTCdate()),0)
			END
			FETCH NEXT FROM subclientcursor INTO @subclient
		END
		CLOSE subclientcursor
		DEALLOCATE subclientcursor
	END
	ELSE
	BEGIN*/
		DECLARE backupsetcursor CURSOR STATIC FOR
			SELECT DISTINCT backupset
			FROM APP_Application
			WHERE clientID = @clientID AND apptypeID = @apptypeID
		OPEN backupsetcursor
		FETCH NEXT FROM backupsetcursor INTO @backupset
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT EXISTS ( SELECT *
							FROM APP_BackupSetProp
							WHERE componentNameId = @backupset AND attrName = N'Associated subclient Policy' AND modified = 0)
			BEGIN
				SET @resetfileaccesstime  = '0'
				SET @useDC  = '0'
				SET @useArchiveBit = '0'
				SET @UseChangeJournal = '0'
				SET @useClassicscan = '0'
				IF EXISTS (SELECT * FROM APP_BackupSetProp WHERE componentNameId = @backupSet AND attrName = N'Reset File access Times' AND attrVal = '1' AND modified = 0) OR EXISTS (SELECT * FROM APP_BackupSetProp WHERE componentNameId = @backupSet AND attrName = N'Preserve File access Times' AND attrVal = '1' AND modified = 0)
					SET @resetfileaccesstime  = '1'
				IF @apptypeID <> 74
				BEGIN
					SET @UseChangeJournal = ISNULL((SELECT attrval FROM APP_Backupsetprop WHERE componentNameId = @backupset AND attrName = N'Use Change Journal' AND modified = 0),'1')
					IF (@apptypeID IN (SELECT appTypeId FROM App_AppTypeGroups WHERE osGroup LIKE 'Unix')) and (NOT EXISTS(select 1 from APP_ClientProp with (NOLOCK) where componentNameId = @clientID and attrName = N'Data Classification Installed on Client' ))		--Unix
						SET @useDC = '0'
					ELSE
						SET @useDC  = ISNULL((SELECT attrval FROM APP_Backupsetprop WHERE componentNameId = @backupset AND attrName = N'Use DC for FS backups' AND modified = 0),'0')
					SET @useArchiveBit  = ISNULL((SELECT attrval FROM APP_Backupsetprop WHERE componentNameId = @backupset AND attrName = N'Use Archive bit' AND modified = 0),'0')
				END
				ELSE
				BEGIN
					SET @usechangejournal  = '0'
					SET @useDC  = '0'
					SET @useArchiveBit = '0'
				END
				IF @apptypeID IN (SELECT appTypeId FROM APP_AppTypeGroupAssoc WHERE appGroupId = 57)		--Windows
				BEGIN
					IF @UseChangeJournal = '0' AND @useDC = '0'
						SET @useclassicscan = '1'
					ELSE
						SET @useclassicscan = '0'
					END
				ELSE
				BEGIN
					SET @UseChangeJournal = '0'
					IF @useDC = '0'
						SET @useclassicscan = '1'
					ELSE
						SET @useclassicscan = '0'
				END
				SET @toupgradevalues = @UseChangeJournal + @resetfileaccesstime + @useDC + @useArchiveBit + @useclassicscan
				DECLARE subclientcursor CURSOR STATIC FOR
					SELECT id FROM APP_Application WHERE backupset = @backupset
				OPEN subclientcursor
				FETCH NEXT FROM subclientcursor INTO @subclient
				WHILE @@FETCH_STATUS = 0
				BEGIN
					IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient  AND attrName = N'Use Change Journal' AND modified = 0)
						INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use Change Journal',2,SUBSTRING(@toupgradevalues ,1,1),dbo.GetUnixTime(GetUTCdate()),0)
					IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Preserve File Access Times' AND modified = 0)
						INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Preserve File Access Times',2,SUBSTRING(@toupgradevalues ,2,1),dbo.GetUnixTime(GetUTCdate()),0)
					IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Use DC for FS Backups' AND modified = 0)
						INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use DC for FS Backups',2,SUBSTRING(@toupgradevalues ,3,1),dbo.GetUnixTime(GetUTCdate()),0)
					IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Use Archive Bit' AND modified = 0)
						INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use Archive Bit',2,SUBSTRING(@toupgradevalues ,4,1),dbo.GetUnixTime(GetUTCdate()),0)
					IF NOT EXISTS (SELECT * FROM APP_Subclientprop WHERE componentnameid = @subclient AND attrName = N'Use Classic file scan' AND modified = 0)
						INSERT APP_SubClientProp (componentNameId , attrName , attrType , attrVal,created, modified ) VALUES (@subclient, N'Use classic file scan',2,SUBSTRING(@toupgradevalues ,5,1),dbo.GetUnixTime(GetUTCdate()),0)
					FETCH NEXT FROM subclientcursor INTO @subclient
				END
				CLOSE subclientcursor
				DEALLOCATE subclientcursor
			END
		FETCH NEXT FROM backupsetcursor INTO @backupset
		END
		CLOSE backupsetcursor
		DEALLOCATE backupsetcursor
	--END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
	SET @errorcode = ERROR_NUMBER()
	SET @errorstring = 'Procedure [' + ERROR_PROCEDURE () + '] Error Line [' + CONVERT(nvarchar(5), ERROR_LINE()) + '].' + ERROR_MESSAGE()
END
END CATCH
END
Cleanup:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_MvScanOptionToSC')
	delete from GxQscripts where name = 'AppIdaUpgrade_MvScanOptionToSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_MvScanOptionToSC')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_MvScanOptionToSC'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_MvScanOptionToSC',  '00010007006000030000', 'AppIdaUpgrade_MvScanOptionToSC', '00010007006000030000')
GO

