

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_MvRecoveryPointtoBkp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Precedure: AppIdaUpgrade_MvRecoveryPointtoBkp
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        jswaminathan      Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_MvRecoveryPointtoBkp <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_MvRecoveryPointtoBkp')
	drop procedure AppIdaUpgrade_MvRecoveryPointtoBkp
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_MvRecoveryPointtoBkp')
	delete from GxQscripts where name = 'AppIdaUpgrade_MvRecoveryPointtoBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_MvRecoveryPointtoBkp')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_MvRecoveryPointtoBkp'
GO
print '... Creating Procedure: AppIdaUpgrade_MvRecoveryPointtoBkp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_MvRecoveryPointtoBkp
  @clientId INT,
  @apptypeId INT,
  @prevReleaseId INT,
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(1024) OUTPUT
AS
SET NOCOUNT ON
SET @errorCode = 0
SET @errorString = 'Succeeded.'
--Convenience defs--
DECLARE @releaseId AS INT
DECLARE @upgradeval AS NVARCHAR
DECLARE @id AS INT
--Basic Checking--
IF NOT EXISTS (SELECT * FROM APP_Client WHERE id = @clientId )
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Client id[' + CONVERT(NVARCHAR(5),@clientId) + '] is not valid.'
	GOTO cleanup
END
SET @releaseId = ISNULL((SELECT TOP 1 ID FROM simAllGalaxyRel ORDER BY id DESC),0)
IF @prevReleaseId = @releaseId
BEGIN
	SET @errorCode = 0
	SET @errorString = 'Error. Client['+ (SELECT name FROM APP_Client WHERE id = @clientId ) + '] has already been upgraded to release[' +CONVERT(NVARCHAR(5),@releaseId)+'].'
	GOTO cleanup
END
IF @prevReleaseId < 15
BEGIN
--Input params valid.--
--proceed with altering the prop values--
BEGIN TRAN
	DECLARE @backupSetId AS INT
	DECLARE @FSTypeId AS INT
	--Fetch the File System AppType for this client
	SET @FSTypeId = (SELECT TOP 1 appTypeId
					 FROM App_Application
WHERE clientId = @clientId AND apptypeId in (1,11,33,
34,42,43,
17,18,17,19,
20,19,21,29,
38,36,63,64,
74))
    --Fetch the default backupset for this FS app type for this client
	SET @backupSetId = (SELECT TOP 1 app.backupSet
						FROM App_Application AS app INNER JOIN App_BackupSetName AS bkp
						ON app.backupset = bkp.id
WHERE app.clientId = @clientId AND app.apptypeId = @FSTypeId AND bkp.status & 0x00008 = 0x00008)
	--Update BackupSetId and AppTypeId
	--Because in 9.0 windows client was saved as CV_APPTYPE_WINDOWS_FILESYSTEM(33) but from 10.0 they are saved with respective apptypes
	UPDATE APP_ExtendedProperties
	SET backupSet = @backupSetId, apptypeid = @FSTypeId
	WHERE attrType = 127 AND clientId = @clientId ---will affect both VMe and 1-Touch(Windows and Linux)
	IF @@ERROR = 0
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
END
cleanup:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_MvRecoveryPointtoBkp')
	delete from GxQscripts where name = 'AppIdaUpgrade_MvRecoveryPointtoBkp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_MvRecoveryPointtoBkp')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_MvRecoveryPointtoBkp'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_MvRecoveryPointtoBkp',  '00000000000000000000', 'AppIdaUpgrade_MvRecoveryPointtoBkp', '00000000000000000000')
GO

