

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_FSDM_DMNAS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_FSDM_DMNAS.sp,v $ $Id: AppIdaUpgrade_FSDM_DMNAS.sp,v 1.54.2.2 2018/03/27 08:03:33 jiechen Exp $";
----------------------------------------------------------------------
-- FSDM/DM-NAS CLIENT UPGRADE										--
--																	--
-- 1. Create new Instances/BackupSets/(default)SubClients as needed	--
-- 2. Move properties from Application Level to Instance Level		--
-- 3. Set Instance Type Property									--
-- 4. Convert DB-NAS iDa as necessary to FSFM						--
-- 5. Adjust/Add to any referencing tables (scheds/policies)		--
--																	--
----------------------------------------------------------------------------------------------------------------------
-- EDIT HISTORY																										--
-- DATE			REV.	DESCRIPTION																					--
-- -----------	------	------------------------------------------------------------------------------------		--
-- 01-Nov-2007	??		Code Review Edit																			--
-- 28-Nov-2007	??		Encorporate Code Review Changes																--
-- 23-Jul-2009	1.34	Defect 24347:																				--
--						   1. per Rahul (9/22), Local Migration, and now Celerra can have at most 1 instance as 	--
--                            part of upgrade (after upgrade, Celerra can have multiple instances)					--
----------------------------------------------------------------------------------------------------------------------
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_FSDM_DMNAS <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_FSDM_DMNAS')
	drop procedure AppIdaUpgrade_FSDM_DMNAS
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_FSDM_DMNAS')
	delete from GxQscripts where name = 'AppIdaUpgrade_FSDM_DMNAS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_FSDM_DMNAS')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_FSDM_DMNAS'
GO
print '... Creating Procedure: AppIdaUpgrade_FSDM_DMNAS'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_FSDM_DMNAS
  @i_clientId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
-----------------------------------------------------------
AS
	IF EXISTS ( select * from sysobjects where name='#fsdm_worklist' )
DROP TABLE #fsdm_worklist
/*
--  FOR 8.0 AND BELOW:
*/
-----------------------
-- CONVENIENCE DEFS  --
-----------------------
DECLARE @nowTime integer = dbo.GetUnixTime(GetUTCdate())
DECLARE @NO_BITS integer = 4
DECLARE @FPOLICY_SUBCLIENT_PROPNAME nvarchar(50) = N'NDPA FSDM FPolicy SubClient'
DECLARE @FPOLICY_INSTANCE_PROPNAME nvarchar(50) = N'Use Fpolicy'
DECLARE @CV_FSDM_INSTANCE_TYPE nvarchar(50) = N'FSDM Instance Type'
DECLARE @CV_PROP_NTAP_DM_FILER_NAME nvarchar(50) = N'NTAP DM filer name'
DECLARE @CV_PROP_NTAP_DM_USER_NAME nvarchar(50) = N'NTAP DM user name'
DECLARE @CV_PROP_NTAP_DM_USER_PASSWORD nvarchar(50) = N'NTAP DM password'
DECLARE @CV_PROP_NTAP_DM_STUB_LOCATION nvarchar(50) = N'NTAP DM stub location'
---------------------------------------------------------------
DECLARE @CV_PROP_FSDM_USER_NAME nvarchar(50) = N'FSDM User Name'-- THESE ARE DEPRICATED IN 8.0 (MR 23955)
DECLARE @CV_PROP_FSDM_USER_PASSWORD nvarchar(50) = N'FSDM User Password'
---------------------------------------------------------------
DECLARE @CV_PROXY_STUB_SUBCLIENT nvarchar(50) = N'Proxy Stub SubClient'
DECLARE @CV_ON_DEMAND_BST nvarchar(50) = N'OnDemand Backupset'-- BackupSet Level Property
DECLARE @DEFAULT_ARCHIVE_SET nvarchar(50) = N'defaultArchiveSet'
DECLARE @ARCHIVE_SET nvarchar(50) = N'ArchiveSet'
DECLARE @OLD_FSDM_APPTYPE int = 58
DECLARE @OLD_DMNAS_APPTYPE int = 73
DECLARE @APP_FSDM_LOCAL_MIGRATION int = 1
DECLARE @APP_FSDM_CELERRA int = 2
DECLARE @APP_FSDM_NETWORK_SHARE int = 3
DECLARE @ReleaseId int = ISNULL((Select top 1 ID from simAllGalaxyRel order by id desc), 0)
DECLARE @ReleaseName varchar(128) = ISNULL((Select release from simAllGalaxyRel where id = @ReleaseId), 'Unknown')
DECLARE @ClientName varchar(512) = ISNULL((Select name from app_client where id = @i_clientId), 'Undetermined Client_'+convert(varchar(12), @i_clientId))
DECLARE @oldSchedId						int
DECLARE @taskId							int
DECLARE @oldTaskId						int
DECLARE @schedId						int
--- Variables for our Cursors --
DECLARE	@subClient			int
DECLARE @oldAppType			int
DECLARE @oldIdaNameId		int
DECLARE @oldInstance		int
DECLARE @oldBackupSet		int
DECLARE	@isFPolicySC		int
DECLARE @isILMClass			int
DECLARE @isFShareArchProxy	int
DECLARE	@isOnDemandBkupSet	int
DECLARE @filerName			nvarchar(1024)
DECLARE @filerUser			nvarchar(1024)
DECLARE	@instanceType		int
DECLARE	@newInstance		int
DECLARE @newBackupSet		int
DECLARE	@newBackupSetName	varchar(128)
DECLARE	@newInstanceName	varchar(128)
DECLARE @celerraCount int = 1-- Used for "naming" instances/backupset
DECLARE @netWorkShareCount int = 1
			-- .. we create here
---------------------------------
DECLARE	@reUseFromSubClient	int
DECLARE @Status             int
CREATE TABLE #fsdm_worklist
    (
    [subClientId]		int,
    [oldAppType]		int,
	[oldIdaNameId]		int,
	[oldInstance]		int,
	[oldBackupSet]		int,
	[newInstance]		int,
	[newBackupSet]		int,
	[subClientStatus]	int,
	[isFpolicySC]		int,
	[isILMClass]		int,
	[isFShareArchProxy]	int,
	[isOnDemandBkupSet]	int,
	[InstanceType]		int,
	[filerName]			nvarchar(1024),
	[filerUser]			nvarchar(1024)
    )
SET		@errCode	= 0			-- 'DB_OK',  BE OPTIMISTIC
SET		@errString  = 'Succeeded.'
---------------------------------------------------
-- DO SOME BASIC CHECKING BEFORE GETTING STARTED --
---------------------------------------------------
if @i_prevReleaseId = @releaseId
  OR EXISTS (Select [clientId] FROM  APP_FSDM_Worklist Where clientId = @i_clientId AND [newRev] = @releaseId AND [subClientId] <> 0)
 BEGIN
	SET @errString = 'Client [' +@ClientName + '] has already been upgraded to release[' + @ReleaseName + '].'
	set @errCode = 0							-- Ignore, 8.0 -->9.0 Upgrade Kludge
	goto CLEANUP
END
if @i_prevReleaseId = 14						-- No Upgrade Required from 9.0 (YET!)
BEGIN
	SET @errString = 'Client [' +@ClientName + '] does not require uprade to release[' + @ReleaseName + '].'
	set @errCode = 0							-- Ignore, 8.0 -->9.0 Upgrade Kludge
	goto CLEANUP
END
-- IS THIS AN UPGRADE FROM 8.0?
if @i_prevReleaseId = 13
	goto STEP_90
BEGIN TRY
BEGIN
INSERT #fsdm_worklist
		SELECT id, appTypeId, 0, instance, backupSet, 0, 0, subClientStatus, 0, 0, 0, 0, 0, NuLL, NuLL
		FROM app_application
		WHERE clientId = @i_clientId
			AND appTypeId in ( @OLD_FSDM_APPTYPE, @OLD_DMNAS_APPTYPE)            -- FSDM, DM-NAS
--			AND (SubClientStatus & @NO_BITS) = 0
--	idaNameId-
UPDATE #fsdm_worklist
	set [oldIdaNameId] = (select id from app_idaName Where clientId = @i_clientId AND appTypeId = oldappType)
--	FPOLICY --
UPDATE #fsdm_worklist
	SET isFpolicySC = 1
	WHERE EXISTS (Select * from app_subClientProp
						Where componentNameId = subClientId
						 AND attrName = @FPOLICY_SUBCLIENT_PROPNAME
						 AND modified = 0 AND attrval <> '0' )
UPDATE #fsdm_worklist
		SET filerName = ISNULL((Select attrVal from app_subClientProp
						Where componentNameId = subClientId
						 AND attrName = @CV_PROP_NTAP_DM_FILER_NAME
						 AND cs_attrName = checksum(@CV_PROP_NTAP_DM_FILER_NAME)
						 AND modified = 0 AND attrval <> '0' ), '')
--------------------------------------------------------------------------
--	DEFECT 20815: Missing Filer Name for non-fPolicy (subClient) instances
UPDATE #fsdm_worklist
		SET filerName = 	ISNULL((SELECT TOP 1 REPLACE(SUBSTRING(filename, 0, PATINDEX('%\%', filename)), 'UNC-NT_', '')
								FROM app_scfilterfile
								WHERE componentNameId = subClientId
--								AND   modified = 0												-- We need filer name for deleted subClients so we
								AND   filename like 'UNC-NT_%' order by created desc), '')		-- can do instance, backupset assignments
		WHERE filerName = '';
--------------------------------------------------------------------------
UPDATE #fsdm_worklist
		SET filerUser = ISNULL((Select attrVal from app_subClientProp
						Where componentNameId = subClientId
						 AND attrName = @CV_PROP_NTAP_DM_USER_NAME
						 AND cs_attrName = checksum(@CV_PROP_NTAP_DM_USER_NAME)
						 AND modified = 0 AND attrval <> '0' ), '')
UPDATE #fsdm_worklist
		SET isFShareArchPRoxy = ISNULL((Select attrVal from app_subClientProp
						Where componentNameId = subClientId
						 AND attrName = @CV_PROXY_STUB_SUBCLIENT
						 AND modified = 0 AND attrval <> '0' ), '')
UPDATE #fsdm_worklist
	SeT IsILMClass = 1
		WHERE (SubClientStatus & 1024) <> 0			-- CV_STATUS_ILM_CLASS 0x400
UPDATE #fsdm_worklist
	SET isOnDemandBkupSet = 1
		Where exists (select * from APP_BackupSetProp
						Where componentNameId = @oldBackupSet
						 AND attrName = @CV_ON_DEMAND_BST
						 AND modified = 0
						 AND attrVal <> '0')
--  ----------------------------------------------------------------------------------
--	NOW THAT ALL THE PROPS ARE SET IN THE TABLE, DETERMINE THE NEW INSTANCE TYPES	--
--  ----------------------------------------------------------------------------------
UPDATE #fsdm_worklist
	SET instanceType = @APP_FSDM_LOCAL_MIGRATION
	WHERE oldAppType = @OLD_FSDM_APPTYPE  AND  isFShareArchProxy = 0  -- THIS XTRA STUFF DOESN'T SEEM TO HOLD H20 -- AND (isILMClass <> 0 OR isOnDemandBkupSet <> 0)
UPDATE #fsdm_worklist
	SET instanceType = @APP_FSDM_CELERRA
	WHERE oldAppType = @OLD_FSDM_APPTYPE  AND isFShareArchProxy <> 0
UPDATE #fsdm_worklist
	SET instanceType = @APP_FSDM_NETWORK_SHARE
	WHERE oldAppType = @OLD_DMNAS_APPTYPE
-- 	Defqault hidden subClients causing "extra" Local Migration SubClient to be created.. They "should" be recreated
--	as we iterate through all the things we need to do.
DELETE APP_SCFILTERFILE 	WHERE componentNameId	IN (Select subClientId from #fsdm_worklist where (subClientStatus & 40) = 40)
DELETE APP_SUBCLIENTPROP	WHERE componentNameId	IN (Select subClientId from #fsdm_worklist where (subClientStatus & 40) = 40)
DELETE APP_Application 		WHERE [Id]				in (Select subClientId from #fsdm_worklist where (subClientStatus & 40) = 40)
DELETE #fsdm_worklist				WHERE (subClientStatus & 40) = 40
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
--	NOW THAT WE'VE ESTABLISHED ALL THE 'BASE' DATA, TIME TO LOOP THROUGH ALL THE	--
--	SUBCLIENTS AND TAKE ACTION AS REQUIRED BASED ON NEW INSTANCE TYPE				--
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
	DECLARE subClientCursor CURSOR STATIC FOR
		SELECT [subClientId],	[oldAppType],	[oldInstance],			[oldBackupSet],
			   [isFpolicySC],	[isILMClass],	[isFShareArchProxy],	[isOnDemandBkupSet],
			   [InstanceType],	[filerName],	[filerUser]
FROM #fsdm_worklist
	ORDER BY instanceType, oldBackupSet, subClientId
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @subClient, @oldAppType, @OldInstance, @OldBackupSet,
			 @isFpolicySC, @isILMClass, @isFShareArchProxy, @isOnDemandBkupSet, @instanceType, @filerName, @filerUser
    WHILE @@FETCH_STATUS = 0
	BEGIN
	SET @newBackupSet = 0
	SET @oldIdaNameId = ISNULL((Select id from APP_IdaName Where clientId = @i_clientId AND appTypeId = @oldAppType), 0)
	UPDATE JMBkpStats SET appType = @OLD_FSDM_APPTYPE
		WHERE appId = @subClient
--		--------------------
--		- LOCAL_MIGRATION  -
--		--------------------
--		SUBCLIENTS (NO MATTER WHAT!) WILL SHARE THE SAME INSTANCE (& KEEP THE ORIGINAL BACKUPSET?)
--		IF @instanceType = @APP_FSDM_LOCAL_MIGRATION
		IF @instanceType = @APP_FSDM_LOCAL_MIGRATION OR @instanceType = @APP_FSDM_CELERRA   ---Defect 24347
SET @reUseFromSubClient = ISNULL((Select top 1 subClientId from #fsdm_worklist WHERE instanceType = @instanceType AND newInstance <> 0), 0)
--		-----------
--		- CELERRA -
--		-----------
--		SUBCLIENTS WILL EACH BE IN THEIR OWN INSTANCE/BACKUPSET		-- Defect 24347
--		ELSE IF @instanceType = @APP_FSDM_CELERRA
--			SET @reUseFromSubClient = 0
--		----------------
--		-NETWORK SHARE -
--		----------------
--		1. IF NOT FPOLICY SUBCLIENT, PUT UNDER SAME INSTANCE AS ALL OTHER NON-FPOLICY SUBCLIENTS
--		2. IF FPOLICY SUBCLIENT, PUT UNDER SAME INSTANCE AS OTHER FPOLICY SUBCLIENTS W/SAME FILER/USER NAME.
--		3. IF FPOLICY SUBCLIENT, BUT FILER/USERNAME DON'T MATCH, CREATE NEW INSTANCE/BACKUPSET
		ELSE IF @instanceType = @APP_FSDM_NETWORK_SHARE
		BEGIN
--			IF @isFpolicySC <> 0 AND EXISTS (SELECT * FROM APP_APPLICATION WHERE backupSet = @oldBackupSet and (subClientStatus & 38) = 0 AND id <> @subClient)   --hidded+uninstalled+deleted
			IF @isFpolicySC <> 0 AND EXISTS (SELECT * FROM APP_APPLICATION WHERE                               (subClientStatus & 38) = 0 AND id <> @subClient)   --hidded+uninstalled+deleted
SET @reUseFromSubClient = ISNULL((SELECT TOP 1 subClientId from #fsdm_worklist
													WHERE filerName = @filerName AND fileruser = @filerUser AND newInstance <> 0 AND instanceType = @instanceType), 0)
			ELSE
SET @reUseFromSubClient = ISNULL((Select top 1 subClientId from #fsdm_worklist
													WHERE instanceType = @instanceType AND isFpolicySC = 0 AND newInstance <> 0 AND instanceType = @instanceType),
													 0)
--			SELECT step='isNetworkShare', subClient=@subClient, reuseFromSubClient=@reUseFromSubClient, isFpolicy=@isFpolicySC
		END
--		THE INFAMOUS "SHOULD NEVER GET HERE"
		ELSE
			SET @reUseFromSubClient = 0
---------------------------------------------------------------
--	NOW CREATE OR REUSE INSTANCES AS DETERMINED BY THE ABOVE --
---------------------------------------------------------------
--		REUSE EXISTING INSTANCE/BACKUPSET:
--		----------------------------------
--		IF @reUseFromSubClient = 0 AND @instanceType = @APP_FSDM_LOCAL_MIGRATION
--		BEGIN																-- THIS MUST BE THE 1st LOCAL MIGRATION SUBCLIENT WE ARE LOOKING AT!
--			SET @newInstance  = @oldInstance
--			SET @newBackupSet = @oldBackupSet
--		END
--		CREATE A NEW INSTANCE/BACKUPSET:
--		--------------------------------
		IF @reUseFromSubClient = 0 -- AND @instanceType <> @APP_FSDM_LOCAL_MIGRATION
		BEGIN
			IF @instanceType = @APP_FSDM_CELERRA
			BEGIN
				SET @newInstanceName	= 'Celerra Instance '  + Convert(varchar(10), @celerraCount)
				IF @celerraCount = 1
					SET @newBackupSetName = @DEFAULT_ARCHIVE_SET
				ELSE
				SET @newBackupSetName	= @ARCHIVE_SET + ' ' + Convert(varchar(10), @celerraCount)
				SET @celerraCount		= @celerraCount +1
			END
			ELSE IF @instanceType = @APP_FSDM_LOCAL_MIGRATION
			BEGIN
				SET @newInstanceName	= 'Local Migration Instance'	-- NO Matter what, will only have 1 instance of
				SET @newBackupSetName 	= @DEFAULT_ARCHIVE_SET	-- this type per iDa
			END
			ELSE
			BEGIN
				SET @newInstanceName	= 'Network Share Instance '  + Convert(varchar(10), @netWorkShareCount)
				IF @netWorkShareCount = 1
					SET @newBackupSetName = @DEFAULT_ARCHIVE_SET
				ELSE
					SET @newBackupSetName	= @ARCHIVE_SET + ' '        + Convert(varchar(10), @netWorkShareCount)
				SET @netWorkShareCount	= @netWorkShareCount +1
			END
			INSERT app_instanceName	(name, refTime, modified, status)										-- THIS MUST BE THE 1st LOCAL MIGRATION SUBCLIENT WE ARE LOOKING AT
				Select @newInstanceName, refTime, modified, status
				FROM app_instanceName
				WHERE id = @oldInstance
			SET @newInstance = @@identity
UPDATE #fsdm_worklist							-- 07-Mar-2008 SK
				SET newInstance = @newInstance
					WHERE [subClientId] = @subClient
			INSERT APP_InstanceProp (componentNameId, attrName, AttrType, AttrVal, created, modified)
				Select @newInstance, attrName, AttrType, AttrVal, created, modified
					FROM APP_IdaProp
					WHERE componentNameId = @oldIdaNameId
--			DEFECT 23955: AFTER UPGRADE, CELERRA LOGIN CREDENTIALS ARE LOST --
			IF NOT EXISTS (SELECT * FROM APP_InstanceProp WHERE componentNameId = @newInstance
			                   AND (attrName = @CV_PROP_NTAP_DM_USER_NAME or attrName =@CV_PROP_NTAP_DM_USER_PASSWORD))
			BEGIN
				UPDATE APP_instanceProp
					SET attrName =@CV_PROP_NTAP_DM_USER_NAME
					WHERE ComponentNameId = @newInstance and attrName = @CV_PROP_FSDM_USER_NAME
				UPDATE APP_instanceProp
					SET attrName =@CV_PROP_NTAP_DM_USER_PASSWORD
					WHERE ComponentNameId = @newInstance and attrName = @CV_PROP_FSDM_USER_PASSWORD
			END
			INSERT APP_InstanceProp (componentNameId, attrName, AttrType, AttrVal, created, modified)
				VALUES (@newInstance, @CV_FSDM_INSTANCE_TYPE, 1, CONVERT(nvarchar(10), @instanceType), @nowTime, 0)
--			-------------------------------------------------------------------------------
--			IF Network Share and FPolicy, need to move "filer" properties to instance Level
--			-------------------------------------------------------------------------------
			IF @instanceType = @APP_FSDM_NETWORK_SHARE AND @isFpolicySC <> 0
			BEGIN
				-- SINCE THE "FILER" PROPERTIES MAY BE SET FOR MULTIPLE SUBCLIENTS,
				-- .. MAKE SURE WE ONLY WRITE TO INSTANCEPROP ONCE!
                ----------------------------------------------------------------------------
				IF NOT EXISTS(SELECT *	FROM App_InstanceProp
										WHERE componentNameId = @newInstance
										AND attrName = @CV_PROP_NTAP_DM_USER_NAME
										AND modified = 0)
					INSERT App_InstanceProp(componentNameId, attrName, AttrType, AttrVal, created, modified)
						SELECT @newInstance, attrName, AttrType, AttrVal, created, modified
						FROM APP_SubClientProp
						WHERE componentNameId = @subClient
							AND attrName = @CV_PROP_NTAP_DM_USER_NAME
							AND modified = 0
                ----------------------------------------------------------------------------
				IF NOT EXISTS(SELECT *  FROM App_InstanceProp
										WHERE componentNameId = @newInstance
										AND attrName = @CV_PROP_NTAP_DM_USER_PASSWORD
										AND modified = 0)
					INSERT App_InstanceProp(componentNameId, attrName, AttrType, AttrVal, created, modified)
						SELECT @newInstance, attrName, AttrType, AttrVal, created, modified
						FROM APP_SubClientProp
						WHERE componentNameId = @subClient
							AND attrName = @CV_PROP_NTAP_DM_USER_PASSWORD
							AND modified = 0
                ----------------------------------------------------------------------------
				IF NOT EXISTS (SELECT *	FROM App_InstanceProp
										WHERE componentNameId = @newInstance
										AND attrName = @CV_PROP_NTAP_DM_FILER_NAME
										AND modified = 0)
					INSERT App_InstanceProp(componentNameId, attrName, AttrType, AttrVal, created, modified)
						SELECT @newInstance, attrName, AttrType, AttrVal, created, modified
						FROM APP_SubClientProp
						WHERE componentNameId = @subClient
							AND attrName = @CV_PROP_NTAP_DM_FILER_NAME
							AND modified = 0
                ----------------------------------------------------------------------------
				IF NOT EXISTS (SELECT *	FROM App_InstanceProp
										WHERE componentNameId = @newInstance
										AND attrName = @CV_PROP_NTAP_DM_STUB_LOCATION
										AND modified = 0)
					INSERT App_InstanceProp(componentNameId, attrName, AttrType, AttrVal, created, modified)
					SELECT @newInstance, attrName, AttrType, AttrVal, created, modified
						FROM APP_SubClientProp
						WHERE componentNameId = @subClient
							AND attrName = @CV_PROP_NTAP_DM_STUB_LOCATION
							AND modified = 0
                ----------------------------------------------------------------------------
					INSERT App_InstanceProp(componentNameId, attrName, AttrType, AttrVal, created, modified)
						VALUES (@newInstance, @FPOLICY_INSTANCE_PROPNAME, 2, '1', @nowTime, 0)
-- FOR FPOLICY SUBCLIENT, IF SC IS MARKED DELETED (DECONFIGURED), MARK NEWLY CREATED INSTANCE FOR IT DECONFIGURED AS WELL
				SET @Status =ISNULL((Select subClientstatus from APP_Application WHere id = @subClient), 0)
				IF (@Status & 2) = 2
					UPDATE APP_INSTANCENAME SET STATUS = 2 WHERE id = @newInstance
			END			-- (CREATE NEW INSTANCE)
		END
		ELSE
	--  !IS! RE-USE FROM SUBCLIENT
		BEGIN
		  DECLARE @reUseBackupset 	integer
SET 	  @reUseBackupset	= ISNULL((Select oldBackupSet from #fsdm_worklist where subClientId = @reUseFromSubClient), 0)   -- Defect 24347
--			24347: Even for reuse, allowed to reuse Bkupset at least once.
		   IF @isILMClass = 0    AND @instanceType = @APP_FSDM_NETWORK_SHARE  AND @oldBackupSet = @reUseBackupset	--  Defect 24347
				SET @newBackupSet = (Select newBackupSet
FROM #fsdm_worklist
					WHERE SubclientId = @reUseFromSubClient)
		ELSE
				SET @newBackupSet = @oldBackupSet
				SET @newInstance = (Select newInstance
FROM #fsdm_worklist
					WHERE SubclientId = @reUseFromSubClient)
				IF @instanceType = @APP_FSDM_NETWORK_SHARE AND @isFpolicySC = 0			-- Defect 24347
					SET @newBackupSet = @oldBackupSet
		END
-- IF FILER WAS PREVIOUSLY DEFINED AS SUBCLIENT CONTENT, NEED TO PROMOTE IT IT INSTANCE LEVEL HERE:
		IF (NOT EXISTS (Select * from APP_InstanceProp Where ComponentNameId = @newInstance
														AND attrName =@CV_PROP_NTAP_DM_FILER_NAME
														AND modified = 0)) AND len(@filerName) > 0
			INSERT APP_InstanceProp(componentNameId, attrName, AttrType, AttrVal, created, modified)
				VALUES (@newInstance, @CV_PROP_NTAP_DM_FILER_NAME, 1, @filerName, @nowTime, 0)
------------------------------------------------------------------------------
--	WE CAN RE-USE THE ORIGINAL BACKUPSET ONCE.  AFTER THAT, WE NEED TO DUMP	--
--  THE CONTENT OF THE OLD ONE INTO A NEW ONE (WITH THE SAME NAME) SINCE	--
--	WE ARE NOT ALLOWED TO SHARE BACKUPSETS ACROSS INSTANCES!				--
------------------------------------------------------------------------------
		IF @newBackupSet <> 0
			GOTO SKIP_CREATE_BACKUPSET
		IF @reUseFromSubClient <> 0
SET @newBackupSet = (select TOP 1 newBackupSet FROM #fsdm_worklist WHERE newInstance = @newInstance)
		IF @newBackupSet = 0
		BEGIN
			SET @newBackupSet = @oldBackupSet
IF EXISTS (Select * from #fsdm_worklist WHERE newBackupSet = @newBackupSet)
			BEGIN
				INSERT APP_BAckupSetName(name,  refTime,  modified, status, ccpId, ccpTime, origCCId)		--			Create New BackupSet
				SELECT @newBackupSetName, refTime, modified, status, 0, 0, 2
					FROM APP_BackupSetName
					WHERE id  = @oldBackupSet
				SET @newBackupSet = @@Identity
				INSERT app_BackupSetprop(componentNameId, attrName, AttrType, AttrVal, created, modified)							--			Copy Any BackupSetProps into new BackupSet
				SELECT @newBackupSet, attrName, attrType, attrVal, created, modified
				FROM app_BackupSetProp
				WHERE ComponentNameId = @oldBackupSet
				----------------------------------------------------------------------------------
				-- FOR BACKUPS AT THE BACKUPSET LEVEL, WE NEED TO "COPY" SCHEDULE INFO FOR THE	--
				-- NEWLY CREATED BACKUPSET														--
				----------------------------------------------------------------------------------
				DECLARE ScheduleCursor CURSOR STATIC FOR
				SELECT DISTINCT	[scheduleId]
				FROM SchedBackupTask
				WHERE backupSet = @OldbackupSet and subClient = 0			-- Don't need this for backups @ SC level!
				OPEN ScheduleCursor
				FETCH NEXT FROM ScheduleCursor INTO @oldSchedId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT  schedule
					SELECT  taskId, taskType, type, counter, errors, fireIfMissed, canBeDeleted, inProcess, canBeEdited, isReported,
							isSingleton, sCount, mask, monthDay, occurence, dayNumber, atTime, interval, endValue, startTime, flags,
							ds_flags, tz_offset, tz_name, taskDescription, nextEvent, firstEvent, lastEvent, lastAttempt,
							schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
					FROM schedule where id = @oldSchedId
					SET @schedId = @@IDENTITY
					INSERT schedBackupTask
					SELECT  @schedId, dataSourceId, userId, sequenceNumber_h, sequenceNumber_l, type, clientId, @OLD_FSDM_APPTYPE,
							@newInstance, @newBackupSet, 0, description, flags, alertId, jobDescription
					FROM	schedBackupTask
					WHERE	scheduleId = @oldSchedId
					SET @taskId = @@IDENTITY
					UPDATE Schedule SET taskId = @taskID where id = @schedId
					INSERT SchedBackupTaskOptions
					SELECT @taskId, name, value
					FROM   SchedBackupTaskOptions
					WHERE  backupTaskId = (select taskId from schedule where ID = @oldSchedId)
					FETCH NEXT FROM ScheduleCursor INTO @oldSchedId
				END
				CLOSE       ScheduleCursor
				DEALLOCATE  ScheduleCursor
				----------------------------------------------------------------------------------
				-- FOR ALL RESTORES, WE NEED TO COPY SCHEDULED FOR ALL NEWLY CREATED BACKUPSETS	--
				----------------------------------------------------------------------------------
				DECLARE ScheduleCursor CURSOR STATIC FOR
				SELECT DISTINCT	[scheduleId], [id]
				FROM SchedRestoreTask
				WHERE backupSetID = @OldbackupSet
				OPEN ScheduleCursor
				FETCH NEXT FROM ScheduleCursor INTO @oldSchedId, @oldTaskId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT  schedule
					SELECT  taskId, taskType, type, counter, errors, fireIfMissed, canBeDeleted, inProcess, canBeEdited, isReported,
							isSingleton, sCount, mask, monthDay, occurence, dayNumber, atTime, interval, endValue, startTime, flags,
							ds_flags, tz_offset, tz_name, taskDescription, nextEvent, firstEvent, lastEvent, lastAttempt,
							schedTemplateInstanceId, endOfDay, skipOccurence, skipDayNumber, calendarId
					FROM schedule where id = @oldSchedId
					SET @schedId = @@IDENTITY
					INSERT schedRestoreTask
					SELECT  externRestoreTaskId, @schedId, sourceClientId, @newBackupSet, destClientId, toTime, fromTime, @OLD_FSDM_APPTYPE, @newInstance, userId,
							sequenceNumber_h, sequenceNumber_l, preserveOrStripLevel, archGroupCopyPrecedence, flags, type_h, type_l, alertId, jobDescription
							FROM	schedRestoreTask
					WHERE	scheduleId = @oldSchedId
					SET @taskId = @@IDENTITY
					INSERT SchedRestoreFiles
					SELECT @taskId, type, name
						FROM SchedRestoreFiles
						WHERE restoreTaskId = @OldtaskId
					UPDATE Schedule SET taskId = @taskID where id = @schedId
					INSERT SchedRestoreTaskOptions
						SELECT @taskId, name, value
						FROM   SchedRestoreTaskOptions
						WHERE  restoreTaskId = (select taskId from schedule where ID = @oldSchedId)
					FETCH NEXT FROM ScheduleCursor INTO @oldSchedId, @oldTaskId
				END
				CLOSE       ScheduleCursor
				DEALLOCATE  ScheduleCursor
				----------------------------------------------------------------------------------
	--				APP_BackupSetFilterFile.tbl, sqlDatabase.tbl  ... Don't think they are applicable!
			END
			ELSE BEGIN
				UPDATE SchedRestoreTask						-- Didn't Create a New BackupSet
					SET
						instanceId = @newInstance,
						backupSetId= @newBackupSet,
						appTypeId  = @OLD_FSDM_APPTYPE
					WHERE
						sourceClientId = @i_clientId AND
						backupSetId    = @oldBackupSet	AND
						instanceID = 1
			END
		END
SKIP_CREATE_BACKUPSET:
UPDATE #fsdm_worklist
			SET newBackupSet = @newBackupSet, newInstance = @newInstance
			WHERE [subClientId] = @subClient
--		-------------------------------------------
--		FLUSH NEW ID's BACK TO APPLICATION TABLE --
--		-------------------------------------------
		UPDATE APP_APPLICATION
		SET appTypeId = @OLD_FSDM_APPTYPE,							-- NOW ALWAYS FSDM
			instance  = @newInstance,
			backupSet = @newBackupSet
		WHERE id = @subClient
		UPDATE SchedBackupTask						-- THIS IS FOR ALL THE SCHEDULES AT THE SUBCLIENT LEVEL --
			SET										-- MUCH EASIER !!!!!
				instance   = @newInstance,
				backupSet  = @newBackupSet,
				appTypeId  = @OLD_FSDM_APPTYPE
			WHERE
				clientId   = @i_clientId AND
				backupSet  = @oldBackupSet AND
				(subClient  = @subClient OR (subClient = 0 and instance = 1))
		UPDATE JMRstJobinfo								-- DEFECT 21024
			SET
				instanceId = @newInstance,
				appType    = @old_FSDM_APPTYPE
			WHERE
				srcClientId = @i_clientId
			AND	bkpSetId    = @newBackupSet			-- WANT TO WORK ONLY IN CASE WHERE OLDBACKUPSET == NEW!
			AND appType     in (58, 73)				-- Only FSDM/DMNAS History to be updated!
--  ALL DONE, GET NEXT ROW FROM TABLE TO PROCESS --
	SET @newBackupSet = 0;			-- Clear these out to make sure we don't get "wrap-around"    07-Mar-2008
	SET @newInstance  = 0;
    FETCH NEXT FROM subClientCursor INTO @subClient, @oldAppType, @OldInstance, @OldBackupSet,
			 @isFpolicySC, @isILMClass, @isFShareArchProxy, @isOnDemandBkupSet, @instanceType, @filerName, @filerUser
	END
	CLOSE       subClientCursor
	DEALLOCATE  subClientCursor
--------------------------------------------------------------------------------------
--	CREATE A NEW DEFAULT SUBCLIENT FOR ANY NEWLY CREATED BACKUPSET THAT DOES NOT	--
--	ALREADY HAVE ONE.  USE DEFAULT SUBCLIENT FROM ORIGINAL BKUPSET AS TEMPLATE		--
--------------------------------------------------------------------------------------
	DECLARE subClientCursor CURSOR STATIC FOR
		SELECT DISTINCT	[newInstance],	[newBackupSet]
FROM #fsdm_worklist
    OPEN subClientCursor
    FETCH NEXT FROM subClientCursor INTO @newInstance, @newBackupSet
    WHILE @@FETCH_STATUS = 0
	BEGIN
		IF NOT EXISTS (Select * from App_Application
						Where	clientId = @i_clientId
						  AND appTypeId	 = @OLD_FSDM_APPTYPE
						  AND instance	 = @newInstance
						  AND backupSet	 = @newBackupSet
						  AND (subClientStatus & 8) <> 0											-- CV_STATUS_DEFAULT
		)
		BEGIN
--			NEED TO CREATE A DEFAULT SUBCLIENT FOR BACKUPSETS WHERE IT MAY BE MISSING:
--			SET @oldBackupSet = (Select DISTINCT oldBackupSet from #fsdm_worklist WHERE newBackupset=@newBackupSet)
			Insert App_Application (clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID, refTime, modified, subclientName, subclientStatus, origCCId, GUID)
				SELECT TOP 1 clientId, @OLD_FSDM_APPTYPE, @newInstance, @newBackupSet,
					appNumber, 1, 1, refTime, modified, 'default', 8, 2 ,newid()		-- Default subclients were hidden, so not possible (previously) to set storage policy!
				FROM APP_Application
				WHERE backupSet = @newBackupSet
		END
--			NOTE: TESTING INDICATES DO NOT NEED TO COPY APP_SCFILTERFILE CONTENT FROM OLD "default" SubClinet
	    FETCH NEXT FROM subClientCursor INTO @newInstance, @newBackupSet
	END
	CLOSE       subClientCursor
	DEALLOCATE  subClientCursor
--  8.0 SIM IS CREATING A FSDM IDA ENTRY IF ONLY A DM-NAS EXISTED BEFORE.  FOLLOWING STATEMENT WILL CAUSE CLEANUP
--	IF EXISTS (select * from WORKLIST WHERE oldAppType = @OLD_FSDM_APPTYPE)
--		 AND EXISTS (select * from WORKLIST WHERE oldAppType = @OLD_DMNAS_APPTYPE)
--		UPDATE App_IDAName
--		SET modified = @nowTime WHERE ClientId = @i_clientId AND appTypeId=@OLD_DMNAS_APPTYPE
	UPDATE APP_IDANAME
		  SET modified=@nowTime								-- Mark for deletion
				WHERE clientId = @i_clientId
				AND appTypeID in (58, 73)					-- OLD DMNAS, OLD FSDM
AND id NOT IN (Select distinct oldIdaNameId from #fsdm_worklist)
---------------------------------------------------------------------------------
--  DEFECT 19763 IF OLD iDA was Deconfigured, MAKE SURE ANY NEW INSTANCES CREATED
--  FOR IT ARE ALSO DECONFIGURED, AND THAT iDA is always Configured
---------------------------------------------------------------------------------
	UPDATE APP_InstanceName
	SET status = idaName.status
FROM APP_InstanceName as InstanceName, APP_IDAName as idaName, #fsdm_worklist as worklist
	WHERE
		idaName.clientId  = @i_clientId
	AND	idaName.appTypeId = worklist.oldAppType
	AND instanceName.id   = worklist.newInstance
 	UPDATE App_IDAName
		SET Status = 0
		WHERE clientId = @i_clientId AND appTypeId = @OLD_FSDM_APPTYPE
---------------------------------------------------------------------------------
IF EXISTS (select * from #fsdm_worklist WHERE oldAppType = @OLD_DMNAS_APPTYPE)
AND NOT EXISTS (select * from #fsdm_worklist WHERE oldAppType = @OLD_FSDM_APPTYPE)
		UPDATE App_IDAName
			SET appTypeId = @OLD_FSDM_APPTYPE WHERE ClientId = @i_clientId AND appTypeId=@OLD_DMNAS_APPTYPE
----------------------------------------------------------------------------------
--  NEED TO NOW REMOVE ANY "STALE" ENTRY FROM THE APP_IDANAME TABLE.  IF WE		--
--  DON'T IT ILL CAUSE THE IDA TO SHOW UP MORE THAN ONCE IN THE COMMCELL TREE!	--
----------------------------------------------------------------------------------
/*  UNCOMMENT OUT FOR DEBUGGING ONLY!
	If NOT EXISTS (Select * from sysobjects where name = 'APP_IDANAME_LOG')
		CREATE TABLE APP_IDANAME_LOG
		(
		xTime		int,
		id			int,
		clientId	int,
		appTypeId	int,
		status		int,
		refTime		int,
		modified	int,
		ccpId		int,
		ccpTime		int
		)
	INSERT APP_IDANAME_LOG
		SELECT @nowTime, * FROM APP_IDANAME Where clientId = @i_clientId
*/
	DELETE APP_IDAProp	WHERE componentNameId in	(SELECT id  from APP_IdaName Where clientId = @i_clientId AND appTypeId = @OLD_DMNAS_APPTYPE)
	DELETE APP_IDAName	WHERE						clientId = @i_clientId AND appTypeId = @OLD_DMNAS_APPTYPE
	DELETE APP_IDAProp  WHERE componentNameId in	(SELECT id  from APP_IdaName Where clientId = @i_clientId AND modified = @nowTime)
	DELETE App_IdaName	WHERE 						clientId = @i_clientId AND modified = @nowTime
----------------------------------------------------------------------
-- "OTHER" TABLE UPDATES											--
----------------------------------------------------------------------
UPDATE JMRestoreStats
SET appType = @OLD_FSDM_APPTYPE
WHERE srcClientId = @i_clientId AND appType = @OLD_DMNAS_APPTYPE
-- FOR 6.1 iDa upgrade, need to rename 'defaultMigrationSet' (defect 21027):
UPDATE APP_BACKUPSETNAME
SET  name = @DEFAULT_ARCHIVE_SET
WHERE id in (Select [newBackupSet] FROM #fsdm_worklist)
  AND name = 'defaultMigrationSet'
---------------------------------------------------------------------------------------------
-- DEFECT 23956: After CS & agent upgrade from 7.0 to 8.0 DC scheduled recovery is pending --
UPDATE SchedRestoreTask
SET instanceId = (select DISTINCT newInstance from #fsdm_worklist where newBackupSet = backupSetId)
WHERE  sourceClientId = @i_clientId and appTypeid = @OLD_FSDM_APPTYPE and instanceId = 1
-- NOT IN DEFECT, BUT JUST IN CASE:
UPDATE SchedBackupTask
SET instance = (select DISTINCT newInstance from #fsdm_worklist where newBackupSet = backupSet)
WHERE  ClientId = @i_clientId and appTypeid = @OLD_FSDM_APPTYPE and instance = 1
---------------------------------------------------------------------------------------------
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END
END CATCH
--	 SEE IF WE CREATED ANY INSTANCES COMPRISED TOTALLY OF HIDDEN -or- DELETED -or- DUMMY SUBCLIENTS  --
--   .. MARK THEM "DELETED (DECONFIGURED) TOO
BEGIN TRY
BEGIN
	DECLARE NewInstanceCursor CURSOR STATIC  for
	SELECT distinct instance FROM app_APPLICATION WHERE appTypeid=58 and clientId = @i_clientId
	OPEN NewInstanceCursor
	FETCH NEXT from NewInstanceCursor into @newInstance
	WHILE @@FETCH_STATUS = 0
	BEGIN
		set @status = (select status from app_instanceName where id = @newInstance)
		IF NOT EXISTS (select * from APP_APPLICATION WHERE instance=@newInstance AND (subClientStatus & 6) = 0)  --UNINSTALLED(2) + DELETED(4)
			UPDATE APP_INSTANCENAME
				SET STATUS = STATUS  | 2
				WHERE id = @newInstance
		FETCH NEXT from NewInstanceCursor into @newInstance
	END
	CLOSE NewInstanceCursor
	DEALLOCATE NewInstanceCursor
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END
END CATCH
STEP_90:
--------------------------------------------------------------------
-- 8.0 to 9.0 UPGRADE:											----
-- MAKE SURE DEFAULT SUBCLIENTS ARE NOT HIDDEN, HAVE CONTENT 	----
-- AND HAVE THE MINIMUM DEFAULT PROPERTIES						----
--------------------------------------------------------------------
DECLARE defSubClientCursor CURSOR STATIC FOR
	SELECT DISTINCT	[id], [backupset]
	FROM APP_APPLICATION
	WHERE clientId = @i_clientId AND appTypeId = @OLD_FSDM_APPTYPE AND (subClientStatus & 8) = 8
    OPEN defSubClientCursor
    FETCH NEXT FROM defSubClientCursor INTO @subClient, @newBackupSet
    WHILE @@FETCH_STATUS = 0
	BEGIN
		UPDATE APP_Application set subclientStatus = (subclientStatus & ~32) WHERE id = @subclient
--		---------------------------------------------------------------------------------------------
--		IF THERE ARE NO ACTIVE USER CREATED SUBCLIENTS IH THE BACKUPSET FOR THIS DEFAULT SUBCLENT,
-- 		MARK THE DEFAULT SUBCLIENT DECONFIGURED AND THE BACKUPSET DECONFIGURED.  WE WILL LK. TO SEE
--		IF WE NEED TO MARK THE INSTANCE DECONFIGURED OUTSIDE THIS CURSOR
		IF NOT EXISTS (Select id FROM app_application where backupset = @newBackupSet AND (subClientStatus & (8+4+2)) = 0)  -- DEFAULT | DELETED | UNINSTALLED
		BEGIN
			UPDATE App_Application Set subClientStatus = (subClientStatus | 2) Where id = @subClient
			UPDATE APP_BackupsetName set status = (status | 2) where id = @newBackupset
		END
--		---------------------------------------------------------------------------------------------
		IF NOT EXISTS (Select id from APP_ScFilterFile where componentNameId = @subClient and type=1 AND fileName = N'\' and cs_fileName = 121)
			INSERT APP_ScFilterFile(componentNameId, type, fileName, created, modified)
				VALUES(@subClient, 1, '\', @nowTime, 0 )
IF NOT EXISTS (Select [id] From app_subClientProp where componentNameId = @subClient AND attrName = N'Minimum File Size' AND cs_attrName = checksum(N'Minimum File Size'))	INSERT App_subClientProp (componentNameId, attrName, AttrType, AttrVal, created, modified)																VALUES (@subClient, N'Minimum File Size', 10, 1, @nowTime, 0)
IF NOT EXISTS (Select [id] From app_subClientProp where componentNameId = @subClient AND attrName = N'Num of Days Old' AND cs_attrName = checksum(N'Num of Days Old'))	INSERT App_subClientProp (componentNameId, attrName, AttrType, AttrVal, created, modified)																VALUES (@subClient, N'Num of Days Old', 10, 90, @nowTime, 0)
IF NOT EXISTS (Select [id] From app_subClientProp where componentNameId = @subClient AND attrName = N'Num of Days Old Modified' AND cs_attrName = checksum(N'Num of Days Old Modified'))	INSERT App_subClientProp (componentNameId, attrName, AttrType, AttrVal, created, modified)																VALUES (@subClient, N'Num of Days Old Modified', 10, 90, @nowTime, 0)
IF NOT EXISTS (Select [id] From app_subClientProp where componentNameId = @subClient AND attrName = N'Percent Disk Space Free' AND cs_attrName = checksum(N'Percent Disk Space Free'))	INSERT App_subClientProp (componentNameId, attrName, AttrType, AttrVal, created, modified)																VALUES (@subClient, N'Percent Disk Space Free', 10, 80, @nowTime, 0)
IF NOT EXISTS (Select [id] From app_subClientProp where componentNameId = @subClient AND attrName = N'Low Percent Disk Space Free' AND cs_attrName = checksum(N'Low Percent Disk Space Free'))	INSERT App_subClientProp (componentNameId, attrName, AttrType, AttrVal, created, modified)																VALUES (@subClient, N'Low Percent Disk Space Free', 10, 50, @nowTime, 0)
IF NOT EXISTS (Select [id] From app_subClientProp where componentNameId = @subClient AND attrName = N'Data Migrator Rule Flag' AND cs_attrName = checksum(N'Data Migrator Rule Flag'))	INSERT App_subClientProp (componentNameId, attrName, AttrType, AttrVal, created, modified)																VALUES (@subClient, N'Data Migrator Rule Flag', 10, 8208, @nowTime, 0)--DISABLED|MANUAL MIGRATION
		FETCH NEXT FROM defSubClientCursor INTO @subClient, @newBackupSet
	END
CLOSE       defSubClientCursor
DEALLOCATE  defSubClientCursor
-- DECONFIGURE INSTANCE IF THERE ARE NO DECONFIGURED BACKUPSETS IN IT:
UPDATE APP_InstanceName
SET status = status | 2
WHERE NOT EXISTS (Select id from APP_BackupsetName where (status & 2 ) = 0
					AND id in (Select backupset FROM App_application where instance = APP_InstanceNAme.id))
CLEANUP:
INSERT APP_FSDM_WorkList
Select @i_clientId,  @nowTime, @i_PrevReleaseId, @releaseId, (select subClientName from app_application where [id] = [subclientId]), * from #fsdm_worklist
INSERT APP_FSDM_WorkList
	VALUES (@i_clientId, @nowTime, @i_prevReleaseId, @releaseId, N'', 0,0,0,0,0,0,0,0,0,0,0,0,@errCode, 'errCode in InstanceType Col., errString in filerUser Col.', @errString)
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_FSDM_DMNAS')
	delete from GxQscripts where name = 'AppIdaUpgrade_FSDM_DMNAS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_FSDM_DMNAS')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_FSDM_DMNAS'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_FSDM_DMNAS',  '00010054000200020000', 'AppIdaUpgrade_FSDM_DMNAS', '00010054000200020000')
GO

