

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade_ExchangeArchiver.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade_ExchangeArchiver.sp,v $ $Id: AppIdaUpgrade_ExchangeArchiver.sp,v 1.4.2.2 2018/03/27 08:07:37 jiechen Exp $";
----------------------------------------------------------------------
-- AppIdaUpgrade_ExchangeArchiver									--
--																	--
--																	--
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
--                                                                  --
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade_ExchangeArchiver <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade_ExchangeArchiver')
	drop procedure AppIdaUpgrade_ExchangeArchiver
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade_ExchangeArchiver')
	delete from GxQscripts where name = 'AppIdaUpgrade_ExchangeArchiver'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_ExchangeArchiver')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_ExchangeArchiver'
GO
print '... Creating Procedure: AppIdaUpgrade_ExchangeArchiver'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade_ExchangeArchiver
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_clientId integer,
  @i_appTypeId integer,
  @i_prevReleaseId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
---------------------
-- LOCAL VARIABLES --
---------------------
DECLARE	@nowTime						AS INT 			=  dbo.GetUnixTime (GetUTCdate())
DECLARE @CV_USE_INCREMENTAL_PROP		AS NVARCHAR(50) = N'Use Incremental'
	SET @errCode			= 0			-- BE OPTIMISTIC!
	SET @errString			= ''
	IF @i_prevReleaseId > 15  -- Cannot upgrade clients 11.0 or higher clients (yet)
		GOTO RETURN_RESULTS
	BEGIN TRY
		DECLARE @tempTbl TABLE
		(
			subClientId INT
		)
		INSERT INTO @tempTbl
		SELECT DISTINCT Appl.id
		FROM APP_Application AS Appl
		WHERE Appl.clientId = @i_clientId AND Appl.appTypeId = @i_appTypeId
		-- Age the old property
		UPDATE APP_SubclientProp
		SET modified = @nowTime
		WHERE componentNameId IN (SELECT subClientId FROM @tempTbl) AND attrName = @CV_USE_INCREMENTAL_PROP AND modified = 0
		INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, @CV_USE_INCREMENTAL_PROP, 7, '1', @nowTime, 0
		FROM @tempTbl
		WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = @CV_USE_INCREMENTAL_PROP AND modified = 0)
		INSERT INTO APP_SubclientProp (componentnameId, attrName, attrType, attrVal, created, modified)
		SELECT subclientId, 'Upgrade checks for Exchange Archiver', 7, '1', @nowTime, 0
		FROM @tempTbl
		WHERE NOT EXISTS (SELECT * FROM APP_SubclientProp WHERE componentNameId = subclientId AND attrName = 'Upgrade checks for Exchange Archiver' AND modified = 0)
		-- MR133918 - Exchange Derived Instance Property used attrType of 1(pre-11.0) when it should have used 111 to indicate it was derived
		-- Change needed for CCS Subsystem, so that the row can be encoded properly into XML and avoid the performance hit
		-- of encoding generic string property types.
		UPDATE ip
			SET attrType = 111
		FROM
			(SELECT DISTINCT instance FROM APP_Application WITH(NOLOCK) WHERE clientId = @i_clientId AND appTypeId = @i_appTypeId) a
			INNER JOIN APP_InstanceProp ip ON
				a.instance = ip.componentNameId
				AND ip.attrName LIKE 'Target Mailboxes%'
				AND ip.attrType = 1
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Set @errCode    = ERROR_NUMBER()
		set @errString	= 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	END CATCH
--	CLEAN-UP (IF ANY)
RETURN_RESULTS:
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade_ExchangeArchiver')
	delete from GxQscripts where name = 'AppIdaUpgrade_ExchangeArchiver'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade_ExchangeArchiver')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade_ExchangeArchiver'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade_ExchangeArchiver',  '00010004000200020000', 'AppIdaUpgrade_ExchangeArchiver', '00010004000200020000')
GO

