

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppIdaUpgrade.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppIdaUpgrade.sp,v $ $Id: AppIdaUpgrade.sp,v 1.32.60.4 2018/03/27 08:12:23 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: AppIdaUpgrade()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--  +========================================================================+
--  NOTE: Logic moved to AppIdaUpgrade_Wrapped.  DO NOT make any logic changes here!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppIdaUpgrade <<<'

IF EXISTS (select * from sysobjects where name='AppIdaUpgrade')
	drop procedure AppIdaUpgrade
IF EXISTS (select * from GxQscripts where name='AppIdaUpgrade')
	delete from GxQscripts where name = 'AppIdaUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade'
GO
print '... Creating Procedure: AppIdaUpgrade'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppIdaUpgrade
  @i_clientId integer,
  @i_appTypeId integer,
  @i_releaseId integer,
  @i_prevReleaseId integer
AS
-- FOLLOWING IS "ROW" THAT IS RETURNED --
  DECLARE @retCode integer;
  DECLARE @infoString nvarchar(255);
SET NOCOUNT ON
DECLARE @locInfoString nvarchar(255);
DECLARE @locRetCode 		int
SET @locInfoString =  ''
SET @locRetCode    =  0
BEGIN TRY
	IF @i_appTypeId<>1002
	BEGIN
		exec appIdaUpgrade_Wrapped @i_clientId, @i_appTypeId, @i_releaseId, @i_prevReleaseId, @locRetCode OUTPUT, @locInfoString OUTPUT	-- SINCE THiS CAN BE FOR MANY APPTYPES, WE HAVE NO CHOICE BUT TO CALL IT EVERY TIME!
	END
	ELSE
	BEGIN
		-- MA needs to upgrade index cache location schema when upgrated to V11 from previous release
		if @i_releaseId>15 AND @i_prevReleaseId<16
		BEGIN
			if not exists (select 1 from app_clientprop where componentNameId=@i_clientId and attrName='Idx: cache path')
			BEGIN
				DECLARE @path as varchar(max)
				select @path=iap.Path from IdxAccessPath iap, IdxCache ic where iap.ClientId=@i_clientId and iap.IdxCacheId=ic.IdxCacheId and ic.IdxCacheType=1
				if @path is not null
				BEGIN
					CREATE TABLE #tempTable(retCode int)
					INSERT into #tempTable
					exec dbo.MMS2UpdateIndexCacheForInstall @i_clientId, @path, '', ''
					DROP TABLE #tempTable
				END
			END
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		set @retCode = ERROR_NUMBER()
		set @infoString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		+ERROR_MESSAGE() + '].'
END CATCH
SELECT [retCode] = @locRetCode, [infoString] = @locInfoString		-- THIS IS THE DATA THE CALLER IS EXPECTING
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppIdaUpgrade')
	delete from GxQscripts where name = 'AppIdaUpgrade'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppIdaUpgrade')
	delete from GXDBVersions where aliasname = 'AppIdaUpgrade'
GO

insert into GXDBVersions values(2, 'AppIdaUpgrade',  '00010032006000040000', 'AppIdaUpgrade', '00010032006000040000')
GO

