

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHasUserDelegatedMailBox.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppHasUserDelegatedMailBox.sp,v $ $Id: AppHasUserDelegatedMailBox.sp,v 1.2.86.4.16.1 2021/02/19 23:09:12 msaiganta Exp $";
--	+===================================================================+
--	| AppHasUserDelegatedMailBox - Get Laptop user delegated mail box				|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppHasUserDelegatedMailBox')
BEGIN
	print '>>> Drop Stored Procedure: AppHasUserDelegatedMailBox <<<'
	drop procedure AppHasUserDelegatedMailBox
END
IF EXISTS (select * from GxQscripts where name='AppHasUserDelegatedMailBox')
	delete from GxQscripts where name = 'AppHasUserDelegatedMailBox'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHasUserDelegatedMailBox')
	delete from GXDBVersions where aliasname = 'AppHasUserDelegatedMailBox'
GO
print '... Creating Procedure: AppHasUserDelegatedMailBox'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppHasUserDelegatedMailBox
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId INT = 0,
  @delegatedMailboxGuid nvarchar(255) = '',
  @folderPath nvarchar(max),
  @adminDomainUserGUID nvarchar(255)
-----------------------------------------------------------
AS
  DECLARE @isMailboxDelegated int
DECLARE @userGuid nvarchar(255) =''
DECLARE @APPCLIENTTYPE_EXCHANGE INT  = 25 --Value from Enum ClientType in App.x
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET @isMailboxDelegated = 0
-- For the resource domain user, use adminUserGUID directly as the userId will not be populated.
IF @userId = 0 AND LEN(@adminDomainUserGUID) > 0
	SET @userGuid = REPLACE(@adminDomainUserGUID,'X','-')
ELSE
BEGIN
	SET @userGuid = (select top 1 userGuid From UMUsers where id=@userId )
	SET @userGuid = '{' + @userGuid + '}'
END
IF EXISTS(SELECT * FROM APP_MailBoxDelegates where  mailboxUserGUID= @userGuid
AND delegateUserGUID= REPLACE(@delegatedMailboxGuid,'X','-') and
( (@folderPath = '\' AND delegateInfo.value('(/.//@folder)[1]', 'nvarchar(max)') = @folderPath) OR (@folderPath <> '\'  AND (delegateInfo.value('(/.//@folder)[1]', 'nvarchar(max)') =@folderPath  OR delegateInfo.value('(/.//@folder)[1]', 'nvarchar(max)') ='\' OR @folderPath like delegateInfo.value('(/.//@folder)[1]', 'nvarchar(max)') + '%')
AND delegateInfo.value('(/.//@rights)[1]', 'nvarchar(max)') <> 'None')))
	SET @isMailboxDelegated = 1
--- CODE BELOW HERE IS FROM AppGetSharedMailboxes.spb STARTS -------
DECLARE @getSharedFoldersByMeReqest XML = '<App_GetSharedFoldersReq propertyLevel="20" getHiddenShares="1" > <shareInfo shareType="1"> <browseInfo clientType="25"/> </shareInfo> </App_GetSharedFoldersReq>'
DECLARE @getShareFoldersWithMeReqest XML = '<App_GetSharedFoldersReq propertyLevel="20" getHiddenShares="1" > <shareInfo shareType="2"> <browseInfo clientType="25"/> </shareInfo> </App_GetSharedFoldersReq>'
IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NULL
BEGIN
	CREATE TABLE #OutputAppSharingGetSharedFolders
	(
	outputXml XML
	)
END
--Get Shared by me folders
EXEC AppSharingGetSharedFolders @getSharedFoldersByMeReqest, @userId, 0
--Get Shared with me folders
EXEC AppSharingGetSharedFolders @getShareFoldersWithMeReqest, @userId, 0
--- CODE FROM AppGetSharedMailboxes.spb ENDS----------
IF( SELECT TOP 1 SC.value('(shares/shareFolder/@syncWebFolderId)[1]', 'INT')
		FROM #OutputAppSharingGetSharedFolders T
		CROSS APPLY T.outputXml.nodes('App_GetSharedFoldersResp') DOC(SC)
		WHERE ISNULL(SC.value('(shares/browseInfo/@clientType)[1]', 'INT'),0) = @APPCLIENTTYPE_EXCHANGE ) != 0
			SET @isMailboxDelegated = 1
SELECT @isMailboxDelegated AS isMailboxDelegated
IF OBJECT_ID('tempdb.dbo.#OutputAppSharingGetSharedFolders') IS NOT NULL
	DROP TABLE #OutputAppSharingGetSharedFolders
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppHasUserDelegatedMailBox')
	delete from GxQscripts where name = 'AppHasUserDelegatedMailBox'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHasUserDelegatedMailBox')
	delete from GXDBVersions where aliasname = 'AppHasUserDelegatedMailBox'
GO

insert into GXDBVersions values(2, 'AppHasUserDelegatedMailBox',  'v1.2.86.4.16.1', 'AppHasUserDelegatedMailBox', 'v1.2.86.4.16.1')
GO

