

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHandleWorkQueueForSCPAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppHandleWorkQueueForSCPAssociations
--  |
--  | Description:  SP for handling work queue request for subclient policy
--  |				associations
--  |
--  |       Input:  xxx
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppHandleWorkQueueForSCPAssociations <<<'

IF EXISTS (select * from sysobjects where name='AppHandleWorkQueueForSCPAssociations')
	drop procedure AppHandleWorkQueueForSCPAssociations
IF EXISTS (select * from GxQscripts where name='AppHandleWorkQueueForSCPAssociations')
	delete from GxQscripts where name = 'AppHandleWorkQueueForSCPAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleWorkQueueForSCPAssociations')
	delete from GXDBVersions where aliasname = 'AppHandleWorkQueueForSCPAssociations'
GO
print '... Creating Procedure: AppHandleWorkQueueForSCPAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppHandleWorkQueueForSCPAssociations
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @ErrorMessage NVARCHAR(512)
DECLARE @ErrorSeverity INT
DECLARE @ErrorState INT
BEGIN TRY
	BEGIN TRAN
	DECLARE @addedOrRemovedCGAssoc TABLE
	(
		propId			INT,
		clientGroupId	INT,
		clientIds		XML,
		isAdded			INT
	)
	INSERT INTO @addedOrRemovedCGAssoc
		SELECT Prop.id, Param.clientGroupId, Param.clients, Param.isAdded FROM
			(SELECT id, CONVERT(XML, stringVal) as xmlVal
				FROM APP_ComponentProp
WHERE componentType = 1 AND componentId = 2 AND propertyTypeId = 2500 AND modified = 0) AS Prop
			CROSS APPLY
			(SELECT ref.value('(clientGroup/@clientGroupId)[1]', 'INT') as clientGroupId,
					ref.query('clients') as clients,
					ref.value('@isAdded', 'INT') as isAdded
				FROM Prop.xmlVal.nodes('App_SCPClientGroupAssocWorkQueueParam/addedOrRemovedCGAssoc') R (ref)) AS Param
	IF EXISTS (SELECT 1 FROM @addedOrRemovedCGAssoc )
	BEGIN
		-- Client Group can be associated to multiple Subclient Policies of different Ida Type.
		-- Currently it could be maximum 2 (i.e. Windows and Unix Ida Types)
		DECLARE @ClientGroupSCPAssoc TABLE
		(
			id				INT		IDENTITY (1,1),
			cgId			INT,
			scpId			INT,
			clientIds		XML,
			isAdded			INT
		)
		INSERT INTO @ClientGroupSCPAssoc
		SELECT CGAssoc.clientGroupId, SCPAssoc.scpId, CGAssoc.clientIds, CGAssoc.isAdded FROM APP_SubclientPolicyAssoc SCPAssoc
			INNER JOIN
			(
				SELECT tbl.clientGroupId, tbl.isAdded,
				(
					SELECT tbl1.clientIds.query('.')
					FROM @addedOrRemovedCGAssoc tbl1
					WHERE tbl1.clientGroupId = tbl.clientGroupId AND tbl1.isAdded = tbl.isAdded
					FOR XML PATH('')
				) as clientIds
				FROM @addedOrRemovedCGAssoc tbl
				GROUP BY tbl.clientGroupId, tbl.isAdded
			) CGAssoc
ON SCPAssoc.entityType = 28
					AND SCPAssoc.entityId = CGAssoc.clientGroupId
		DECLARE @index INT = 1
		DECLARE @maxIndex INT = ISNULL((SELECT MAX(id) FROM @ClientGroupSCPAssoc), 0)
		DECLARE @clientGroupId INT = 0
		DECLARE @scpId INT = 0
		DECLARE @clientIds XML = N''
		DECLARE @isAdded INT = 0
		DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @returnValueTbl TABLE (rc INT)
		IF OBJECT_ID('tempdb.dbo.#ClientOrGroupIdList') IS NOT NULL
			DROP TABLE #ClientOrGroupIdList
		CREATE TABLE #ClientOrGroupIdList
		(
			id				INT
		)
		WHILE @index <= @maxIndex
		BEGIN
			SELECT @scpId = scpId, @clientGroupId = cgId, @clientIds = clientIds, @isAdded = isAdded
				FROM @ClientGroupSCPAssoc WHERE id = @index
			TRUNCATE TABLE #ClientOrGroupIdList
			INSERT INTO #ClientOrGroupIdList
				SELECT ref.value('@clientId', 'INT')
					FROM @clientIds.nodes('clients') R (ref)
			DECLARE @id INT
			DECLARE @maxId INT
			DECLARE @backupsetId INT
			DECLARE @CGId INT
			IF @isAdded <> 0
			BEGIN
				IF OBJECT_ID('tempdb.dbo.#AssociateBackupsets') IS NOT NULL
					DROP TABLE #AssociateBackupsets
				CREATE TABLE #AssociateBackupsets
				(
					id				INT		IDENTITY (1,1),
					backupsetId		INT,
					clientGroupId	INT
				)
				-- This sp will use #ClientOrGroupIdList temp table for list of client ids
				-- And it will populated #AssociateBackupsets temp table with backupsets to be associated
				EXEC AppGetBackupSetsForSCPAssociation @scpId, @clientGroupId
				--Dont associate backupsets that are already associated with Subclient Policy
				DELETE AB
				FROM #AssociateBackupsets AB
				INNER JOIN APP_BackupSetProp BSP ON BSP.componentNameId = AB.backupsetId AND BSP.attrName = N'Associated subclient Policy' AND BSP.modified = 0
				--#AssociateBackupsets becomes input to AppAssocSubClientPolicy
				EXEC AppAssocSubClientPolicy 0, @scpId, @currentTime
				-- Insert scp association level as 2 (i.e. Client Group Level)
				INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
					SELECT backupsetId, N'Subclient Policy Association Level', 7, 2, @currentTime, 0 FROM #AssociateBackupsets
				-- Insert client group id for inherited association from client group level
				INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
					SELECT backupsetId, N'Client Group For SCP Association', 7, clientGroupId, @currentTime, 0 FROM #AssociateBackupsets
			END
			ELSE
			BEGIN
				-- Check if we have to dissociate backupset or not
				DECLARE @dissociateBackupset INT = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp WHERE componentNameId = @scpId AND attrName = N'Automatically Dissociate Backupsets Associated From Client Group Level' AND modified = 0), 0)
				IF OBJECT_ID('tempdb.dbo.#DissociateBackupsets') IS NOT NULL
					DROP TABLE #DissociateBackupsets
				CREATE TABLE #DissociateBackupsets
				(
					id				INT		IDENTITY (1,1),
					backupsetId		INT,
					clientGroupId	INT
				)
				-- This sp will use #ClientOrGroupIdList temp table for list of client ids
				-- And it will populated #DissociateBackupsets temp table with backupsets to be dissociated
				EXEC AppGetBackupSetsForSCPDissociation @scpId, @clientGroupId
				IF @dissociateBackupset <> 0
					EXEC AppDissocSubClientPolicy 0, @currentTime --gets backupsetId from #DissociateBackupsets
				ELSE
					UPDATE BSP
					SET BSP.modified = @currentTime
					FROM APP_BackupSetProp BSP
					INNER JOIN #DissociateBackupsets DB ON BSP.componentnameId = DB.backupsetId AND
					 (BSP.attrName = N'Subclient Policy Association Level' OR BSP.attrName = N'Client Group For SCP Association') AND BSP.modified = 0
			END
			SET @index = @index + 1
		END
	END
	--Delete processed entries from APP_ComponentProp table
	DELETE Prop
		FROM APP_ComponentProp Prop
		INNER JOIN @addedOrRemovedCGAssoc Assoc
			ON Prop.id = Assoc.propId
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	ROLLBACK TRAN
	SELECT @ErrorMessage = ERROR_MESSAGE(),@ErrorSeverity = ERROR_SEVERITY(),@ErrorState = ERROR_STATE()
	RAISERROR (@ErrorMessage,@ErrorSeverity,@ErrorState)
END CATCH
IF OBJECT_ID('tempdb.dbo.#ClientOrGroupIdList') IS NOT NULL
	DROP TABLE #ClientOrGroupIdList
IF OBJECT_ID('tempdb.dbo.#AssociateBackupsets') IS NOT NULL
				DROP TABLE #AssociateBackupsets
IF OBJECT_ID('tempdb.dbo.#DissociateBackupsets') IS NOT NULL
				DROP TABLE #DissociateBackupsets
GO

IF EXISTS (select * from GxQscripts where name = 'AppHandleWorkQueueForSCPAssociations')
	delete from GxQscripts where name = 'AppHandleWorkQueueForSCPAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleWorkQueueForSCPAssociations')
	delete from GXDBVersions where aliasname = 'AppHandleWorkQueueForSCPAssociations'
GO

insert into GXDBVersions values(2, 'AppHandleWorkQueueForSCPAssociations',  '00000000000000000000', 'AppHandleWorkQueueForSCPAssociations', '00000000000000000000')
GO

