

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHandleVMAllocationPolicy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppHandleVMAllocationPolicy.sp,v $ $Id: AppHandleVMAllocationPolicy.sp,v 1.15.46.33 2020/12/21 07:38:22 jswaminathan Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppHandleVMAllocationPolicy"
--	|	This Procedure is used to handle the different request for VM Allocation Policy
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppHandleVMAllocationPolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppHandleVMAllocationPolicy <<<'
	drop procedure AppHandleVMAllocationPolicy
END
IF EXISTS (select * from GxQscripts where name='AppHandleVMAllocationPolicy')
	delete from GxQscripts where name = 'AppHandleVMAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleVMAllocationPolicy')
	delete from GXDBVersions where aliasname = 'AppHandleVMAllocationPolicy'
GO
print '... Creating Procedure: AppHandleVMAllocationPolicy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppHandleVMAllocationPolicy
-- Input arguments
  @i_uid INT,
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_ReturnResult XML;
DECLARE @i_action 		varchar(8)
DECLARE @i_policyName 	varchar(256)
DECLARE @i_policyDescription varchar(max)
DECLARE @i_policyId 	INT
DECLARE @i_policyData 	XML
DECLARE @errorString	NVARCHAR(MAX)
DECLARE @errorCode		INT = 0
DECLARE @i_dataCenterId INT = 0
DECLARE @i_policyType	INT	= 0
DECLARE @i_localeId		INT	= 0
declare @isResourceGroupPolicyProp INT
DECLARE @opMsgId int = 0
DECLARE @opId int = 0
DECLARE @dataIsEvent		INT = 0
DECLARE @opEvMsgId			INT = 0
DECLARE @paramMsgId			INT = 0
DECLARE @autoShutdownHours  INT = 0
DECLARE @toMigrate			INT = 0
DECLARE @vmPolicyAppType	INT = 0
declare @instanceId int
DECLARE @unixTime			INT = dbo.GetUnixTime (GetUTCdate())
DECLARE @flag           	INT = 0
DECLARE @minutesRetainUntil INT = 0
DECLARE @HvDatastoreId INT = 0
DECLARE @existingDatastoreRowId INT = 0
DECLARE @maxAccessNode INT
DECLARE @PrevMaxAccessNode INT
DECLARE @isPublicIP INT
DECLARE @prevIsPublicIP INT
DECLARE @InstanceType NVARCHAR(MAX)
DECLARE @PrevInstanceType NVARCHAR(MAX)
DECLARE @IAMRole NVARCHAR(MAX)
DECLARE @PrevIAMRole NVARCHAR(MAX)
SET	@i_action = ISNULL (( SELECT ref.value('@action', 'varchar(8)')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq') R(ref)), '')
SET	@i_policyName = ISNULL (( SELECT ref.value('@vmAllocPolicyName', 'varchar(256)')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/entity') R(ref)), '')
SET	@i_policyType = ISNULL (( SELECT ref.value('@policyType', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/entity') R(ref)), 0)
SET @isResourceGroupPolicyProp = ISNULL(( SELECT ref.value('@isResourceGroupPolicy', 'INT') FROM @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
SET @vmPolicyAppType = ISNULL(( SELECT ref.value('@vmPolicyAppType', 'INT') FROM @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
SET @i_policyData = @i_xmlText.query('Ida_VMAllocationPolicyReq/policy')
SET @i_localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/processinginstructioninfo/locale') R(ref)), 0)
SET @minutesRetainUntil = ISNULL(( SELECT ref.value('@minutesRetainUntil', 'INT') FROM @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
--SET @i_policyData.modify('delete (/policy/dataCenter)')
-- Delete datastores, esxservers and templates only for non resource group policy. For resource group policy, names are sent only and hence there is no value for these in prop tables
if @isResourceGroupPolicyProp=0
begin
	SET @i_policyData.modify('delete (/policy/dataStores)')
	SET @i_policyData.modify('delete (/policy/esxServers)')
	SET @i_policyData.modify('delete (/policy/templates)')
end
SET @i_policyData.modify('delete (/policy/securityAssociations)')
SET @i_policyData.modify('delete (/policy/mediaAgent)')
declare @destinationHyperV int = 0
set @destinationHyperV = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/destinationHyperV') R(ref)), 0)
declare @proxyClientId int = 0
set @proxyClientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/proxyClientEntity') R(ref)), 0)
SET @autoShutdownHours = ISNULL(( SELECT ref.value('@autoShutdownHours', 'INT') FROM @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
IF (@i_policyType in ( 1,11) and @isResourceGroupPolicyProp =0)
BEGIN
 --CAN NOT DELETE THE COMPLETE AMAZON NODE AS IT HAVE THE DEFAULT VALUES ALSO AS A ATTRIBUTE
--	SET @i_policyData.modify('delete (/policy/amazonPolicy)')
	SET @i_policyData.modify('delete (/policy/amazonPolicy/availabilityZones)')
	SET @i_policyData.modify('delete (/policy/amazonPolicy/instanceType)')
--	SET @i_policyData.modify('delete (/policy/amazonPolicy/securityGroup)')
--	SET @i_policyData.modify('delete (/policy/amazonPolicy/keyPair)')
END
IF @i_policyType = 14 or  @isResourceGroupPolicyProp =1
BEGIN
	select @i_dataCenterId = id from App_VMDataCenter where name = '_NO_NAME_'
END
ELSE
BEGIN
	SET @i_dataCenterId =  ISNULL (( SELECT ref.value('@dataCenterId', 'INT')
				FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/dataCenter') R(ref)), 0)
END
declare @dataStoreList table
(
	dataStoreId varchar(8)
)
Insert into @dataStoreList
select ref.value('@dataStoreId', 'varchar(8)')
FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/dataStores') R(ref)
where ref.value('@dataStoreId', 'varchar(8)') is not null
declare @esxServerList table
(
	esxServerId varchar(8)
)
Insert into @esxServerList
select ref.value('@esxServerId', 'varchar(8)')
from @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/esxServers') R(ref)
where ref.value('@esxServerId', 'varchar(8)') is not null
declare @recordTranStarted int = 0
begin try
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN Tran
		SET @recordTranStarted = 1
	END
IF (@i_action = '0')
BEGIN
--Get the name of the policy from the xml data and create policy for that name
	IF (@i_policyName = '')
	BEGIN
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1021 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0,2);
     SET @r_ReturnResult = (	SELECT	1				as TAG,
     NULL			as Parent,
     @errorCode		as [EVGui_GenericResp!1!errorCode],
     @errorString	as [EVGui_GenericResp!1!errorMessage]
     FOR XML EXPLICIT
     );
     SELECT @r_ReturnResult;
     return;
	END
	IF EXISTS (SELECT * FROM App_VmAllocationPolicy WHERE name=@i_policyName)
	BEGIN
	--Can not have two policies with same name
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1024 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0,2);
     SET @r_ReturnResult = (	SELECT	1				as TAG,
     NULL			as Parent,
     @errorCode		as [EVGui_GenericResp!1!errorCode],
     @errorString	as [EVGui_GenericResp!1!errorMessage]
     FOR XML EXPLICIT
     );
     SELECT @r_ReturnResult;
     return;
	END
	SET	@i_policyDescription = ISNULL (( SELECT ref.value('@description', 'varchar(max)')
				FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), '')
	SELECT @IAMRole = ref.value('@name', 'NVARCHAR(MAX)') FROM
			@i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/roleInfo') R(ref)
	SELECT @PrevIAMRole = R.ref.value('@name', 'NVARCHAR(MAX)')  FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy/roleInfo') R(ref)
			WHERE id = @i_policyId
	-- Max no. of access node
	SELECT @maxAccessNode = ref.value('@maxVMthreshold', 'INT') FROM
			@i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/scaleOption/scaleOutParam') R(ref)
	SELECT @prevMaxAccessNode = R.ref.value('@maxVMthreshold', 'INT') FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy/scaleOption/scaleOutParam') R(ref)
			WHERE id = @i_policyId
	-- Create Public IP
	SELECT @isPublicIP = ref.value('@isPublicIPSettingsAllowed', 'INT') FROM
			@i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)
	SELECT @prevIsPublicIP = R.ref.value('@isPublicIPSettingsAllowed', 'INT') FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy') R(ref)
			WHERE id = @i_policyId
	--instanceType
	 SELECT @InstanceType = ref.value('@vmInstanceTypeName', 'nvarchar(max)')
				FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/instanceType/instanceType') R(ref)
 	 SELECT @prevInstanceType = R.ref.value('@vmInstanceTypeName', 'nvarchar(max)') FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy/amazonPolicy/instanceType/instanceType') R(ref)
			WHERE id = @i_policyId
	INSERT INTO [dbo].[App_VmAllocationPolicy] (name, vDataCenterId, description, vxml, ownerId, created, modified, alive)
	VALUES (@i_policyName, @i_dataCenterId, @i_policyDescription, @i_policyData, @i_uid, @unixTime , '0', '1')
	SET @i_policyId = @@IDENTITY
	UPDATE dbo.App_VmAllocationPolicy SET vxml.modify('insert attribute vmAllocPolicyId {sql:variable("@i_policyId")} as last into (/policy/entity)[1]') WHERE id = @i_policyId
	-- Creator security association
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(1 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @i_uid, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 93, @i_policyId
SET @opMsgId = (332 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	EXEC EvGuiAuditSetOperation @opMsgId, @i_uid, @opEvMsgId OUTPUT, @opId OUTPUT
	--get migration
	SET @toMigrate = ISNULL(( SELECT ref.value('@migrateVMs', 'INT') FROM @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
		if (@minutesRetainUntil <> 0)
			SET @flag=@flag | 2;
		 if (@autoShutdownHours <> 0)
			SET @flag=@flag | 8;
		if (@toMigrate <> 0)
			SET @flag=@flag | 16
		if (@minutesRetainUntil <> 0 OR @autoShutdownHours <> 0 OR @toMigrate <> 0)
			UPDATE APP_VMAllocationPolicy SET flags = flags | @flag WHERE id = @i_policyId
		if @i_xmlText.exist('(Ida_VMAllocationPolicyReq/policy/mediaAgent)[1]') =1
		begin
				INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT @i_policyId, 'mediaagent',  2, C.id,  @unixTime,0
				FROM  APP_Client C
				where c.name = @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/mediaAgent/@clientName)[1]', 'nvarchar(256)')
		end
		--esxservers
		INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @i_policyId, 'esxserver',  2,esxServerId ,  @unixTime,0
		FROM  @esxServerList
		--VM templates
		UNION ALL
		SELECT @i_policyId, 'vmtemplate',  1, ref.value('@vmGUID', 'varchar(max)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/templates') R(ref)
		--users
		UNION ALL
		SELECT @i_policyId, 'user',  2,ref.value('@userId', 'varchar(8)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/securityAssociations/users') R(ref)
		--user groups
		UNION ALL
		SELECT @i_policyId, 'usergroup',  2,ref.value('@userGroupId', 'varchar(8)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/securityAssociations/userGroups') R(ref)
		--external user groups
		UNION ALL
		SELECT @i_policyId, 'extusergroup',  2,ref.value('@groupId', 'varchar(8)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/securityAssociations/externalUserGroups') R(ref)
        --insert disableSuccessEmails flag
        IF ISNULL((SELECT ref.value('@disableSuccessEmail', 'int') FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)),'')!=''
        BEGIN
            INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
            SELECT @i_policyId, 'disableSuccessMails',  2,ref.value('@disableSuccessEmail', 'int'),  @unixTime,0
            FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)
        END
		-- Amazon
		IF (@i_policyType = 1 or @i_policyType = 11) and ( @isResourceGroupPolicyProp =0)
		BEGIN
			--availabilityZones
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'availabilityZones', 2, ref.value('@availabilityZoneId', 'varchar(32)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/availabilityZones') R(ref)
			--vmInstanceTypes
			UNION ALL
			SELECT @i_policyId, 'vmInstanceTypes', 2, ref.value('@vmInstanceTypeId', 'varchar(64)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/instanceType/instanceType') R(ref)
			--securityGroup
			UNION ALL
			SELECT @i_policyId, 'securityGroup', 2, ref.value('@securityGroupId', 'varchar(32)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/securityGroups') R(ref)
			--keyPair
			UNION ALL
			SELECT @i_policyId, 'keyPair', 2, ref.value('@keyPairId', 'varchar(32)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/keyPair') R(ref)
		END
		ELSE
		BEGIN
			--datastores
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'datastore', 2, dataStoreId ,  @unixTime,0
			from @dataStoreList
		END
		-- check whether its resource group policy and update flags accordingly.
		if @isResourceGroupPolicyProp>0
		begin
			DECLARE @iflags INT = 4
			-- Check if Test Failover for Policies created from Admin console, Azure RM and MinutesRetailUntil
			if (@i_policyType = 7) and (@minutesRetainUntil >0)
				SET @iflags = @iflags | 32
			UPDATE APP_VMAllocationPolicy SET flags = flags | @iflags WHERE id = @i_policyId
		end
		INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @i_policyId, 'destinationHyperV', 7, @destinationHyperV,  @unixTime,0
		IF @isResourceGroupPolicyProp > 0 AND @proxyClientId > 0
		BEGIN
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'ProxyClientEntity', 7, @proxyClientId,  @unixTime,0
		END
		-- auto scale policy
		if ( @vmPolicyAppType =2)
		begin
			-- update instance properties
			select @instanceId = instance from app_application a
			inner join app_client c
			on a.clientid = c.id
			and a.apptypeid = 106
			and c.id = @destinationHyperV
			declare @instanceCompId int = NULL
			select @instanceCompId = id from app_instanceprop
						where attrname ='Enable Automatic Proxy Management' and componentNameId  = @instanceId and modified =0
			if  (  @instanceCompId is not NULL )
			begin
				update app_instanceprop
				set modified = dbo.GetUnixTime(GETUTCDATE())
				where id = @instanceCompId
			end
			insert into app_instanceprop values ( @instanceId, 'Enable Automatic Proxy Management' , 2, '1', dbo.GetUnixTime(GETUTCDATE()),0,0 )
			set @instanceCompId = NULL
			select @instanceCompId = id from app_instanceprop
						where attrname ='Auto Scale Policy' and componentNameId = @instanceId and modified =0
			if  (  @instanceCompId is not NULL )
			begin
				update app_instanceprop
				set modified = dbo.GetUnixTime(GETUTCDATE())
				where id = @instanceCompId
			end
			insert into app_instanceprop values ( @instanceId, 'Auto Scale Policy' , 2, @i_policyId , dbo.GetUnixTime(GETUTCDATE()),0,0 )
		end
		-- Hedvig datastore INsert
		IF(@isResourceGroupPolicyProp = 1 AND @i_xmlText.exist('Ida_VMAllocationPolicyReq/policy/HedvigDatastore') =1)
			BEGIN
				SET @HvDatastoreId  = ( SELECT ref.value('@dataStoreId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/HedvigDatastore') R(ref))
				INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES (@i_policyId, 'hedvigdatastoreid', 2, @HvDatastoreId ,  @unixTime,0)
				INSERT INTO HedVigDatastoreProp
				VALUES ( @HvDatastoreId, 'VMAllocation Policy Id', 1, @i_policyId, dbo.GetUnixTime(getutcdate()), 0)
			END
END
--Edit the policy
IF (@i_action = '1')
BEGIN
	DECLARE @rows INT
	SET	@i_policyDescription = ISNULL (( SELECT ref.value('@description', 'varchar(max)')
				FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), '')
	SET	@i_policyId = ISNULL (( SELECT ref.value('@vmAllocPolicyId', 'varchar(256)')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/entity') R(ref)), '')
	SELECT @IAMRole = ref.value('@name', 'NVARCHAR(MAX)') FROM
			@i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/roleInfo') R(ref)
	SELECT @PrevIAMRole = R.ref.value('@name', 'NVARCHAR(MAX)')  FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy/roleInfo') R(ref)
			WHERE id = @i_policyId
	-- Max no. of access node
	SELECT @maxAccessNode = ref.value('@maxVMthreshold', 'INT') FROM
			@i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/scaleOption/scaleOutParam') R(ref)
	SELECT @prevMaxAccessNode = R.ref.value('@maxVMthreshold', 'INT') FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy/scaleOption/scaleOutParam') R(ref)
			WHERE id = @i_policyId
	-- Create Public IP
	SELECT @isPublicIP = ref.value('@isPublicIPSettingsAllowed', 'INT') FROM
			@i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)
	SELECT @prevIsPublicIP = R.ref.value('@isPublicIPSettingsAllowed', 'INT') FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy') R(ref)
			WHERE id = @i_policyId
	--instanceType
	 SELECT @InstanceType = ref.value('@vmInstanceTypeName', 'nvarchar(max)')
				FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/instanceType/instanceType') R(ref)
 	 SELECT @prevInstanceType = R.ref.value('@vmInstanceTypeName', 'nvarchar(max)') FROM app_vmallocationPolicy
			CROSS APPLY vxml.nodes('policy/amazonPolicy/instanceType/instanceType') R(ref)
			WHERE id = @i_policyId
	if (@autoShutdownHours <> 0)
			UPDATE APP_VMAllocationPolicy SET flags = flags | 8 WHERE id = @i_policyId
	-- In case allocation policy details has changed for policies created from admin console, delete replication guids using this allocation policy
	declare @allocPolicyXml xml
	declare @hasAllocPolicyChanged int = 0
	select @allocPolicyXml = vxml
	from [App_VmAllocationPolicy]
	where id = @i_policyId
	if (@isResourceGroupPolicyProp=1)
	begin
		-- Check if Test Failover for Policies created from Admin console, Azure RM, and MinutesRetailUntil
		if (@i_policyType = 7) and (@minutesRetainUntil >0)
				UPDATE APP_VMAllocationPolicy SET flags = flags | 32 WHERE id = @i_policyId
		-- MR 94198. Allow edit for prefix/suffix for recovery targets. So no need to delete replications for prefix/suffix changes.
		if (@allocPolicyXml.value('(policy/destinationHyperV/@clientId)[1]', 'integer') <> @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/destinationHyperV/@clientId)[1]', 'integer') OR
		@allocPolicyXml.value('(policy/esxServers/@esxServerName)[1]', 'nvarchar(max)') <> @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/esxServers/@esxServerName)[1]', 'nvarchar(max)') OR
		@allocPolicyXml.value('(policy/dataStores/@dataStoreName)[1]', 'nvarchar(max)') <> @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/dataStores/@dataStoreName)[1]', 'nvarchar(max)') OR
		@allocPolicyXml.value('(policy/@resourcePoolPath)[1]', 'nvarchar(max)') <> @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/@resourcePoolPath)[1]', 'nvarchar(max)') OR
	    @vmPolicyAppType = 1
		)
		begin
			set @hasAllocPolicyChanged = 1
		end
	end
	--get migration
	SET @toMigrate = ISNULL(( SELECT ref.value('@migrateVMs', 'INT') FROM @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
	if (@toMigrate <> 0)
		UPDATE APP_VMAllocationPolicy SET flags = flags | 16 WHERE id = @i_policyId
	--Error Condition: If the given policyId does not exist
	UPDATE [dbo].[App_VmAllocationPolicy]
	SET name=@i_policyName, vDataCenterId=@i_dataCenterId, description=@i_policyDescription, vxml = @i_policyData, modified = @unixTime
	where id = @i_policyId
	SET @rows = @@ROWCOUNT
	if (@rows = 0)
	BEGIN
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1022 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0,2);
     SET @r_ReturnResult = (	SELECT	1				as TAG,
     NULL			as Parent,
     @errorCode		as [EVGui_GenericResp!1!errorCode],
     @errorString	as [EVGui_GenericResp!1!errorMessage]
     FOR XML EXPLICIT
     );
     SELECT @r_ReturnResult;
     return;
	END
SET @opMsgId = (334 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @i_uid, @opEvMsgId OUTPUT, @opId OUTPUT
		IF OBJECT_ID('tempdb.dbo.#vmAllocationPolicyPropTemp') IS NOT NULL DROP TABLE #vmAllocationPolicyPropTemp
		CREATE TABLE #vmAllocationPolicyPropTemp(id INT,componentNameId INT,attrName nvarchar(1024),attrType INT, attrVal nvarchar(1024),created int, modified int)
		INSERT INTO #vmAllocationPolicyPropTemp
		SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'mediaagent'
		UNION ALL
		SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'vmtemplate'
		UNION ALL
		SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'user'
		UNION ALL
		SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'usergroup'
		UNION ALL
		SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'extusergroup'
		DELETE vProp  FROM dbo.app_vmallocationpolicyprop vProp INNER JOIN #vmAllocationPolicyPropTemp v
		 on vProp.componentNameId = v.componentNameId and vProp.attrName = v.attrName
		if @i_xmlText.exist('(Ida_VMAllocationPolicyReq/policy/mediaAgent)[1]') =1
		begin
				INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT @i_policyId, 'mediaagent',  2, C.id,  @unixTime,0
				FROM  APP_Client C
				where c.name = @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/mediaAgent/@clientName)[1]', 'nvarchar(256)')
		end
		if exists(select 1 from @esxserverList)
		begin
			--esxserves
			DELETE  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='esxserver'
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'esxserver',  2, esxServerId,  @unixTime,0
			FROM @esxserverList
		end
		--templates
		INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT @i_policyId, 'vmtemplate', 1,ref.value('@vmGUID', 'varchar(max)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/templates') R(ref)
		--users
		UNION ALL
		SELECT @i_policyId, 'user', 2, ref.value('@userId', 'varchar(8)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/securityAssociations/users') R(ref)
		--user groups
		UNION ALL
		SELECT @i_policyId, 'usergroup', 2, ref.value('@userGroupId', 'varchar(8)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/securityAssociations/userGroups') R(ref)
		--external user groups
		UNION ALL
		SELECT @i_policyId, 'extusergroup', 2, ref.value('@groupId', 'varchar(8)'),  @unixTime,0
		FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/securityAssociations/externalUserGroups') R(ref)
		--edit disableSuccessEmails flag
        IF ISNULL((SELECT ref.value('@disableSuccessEmail', 'int') FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)),'')!=''
        BEGIN
            DELETE  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='disableSuccessMails'
            INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
            SELECT @i_policyId, 'disableSuccessMails',  2,ref.value('@disableSuccessEmail', 'int'),  @unixTime,0
            FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)
        END
        ELSE
        BEGIN
            DELETE  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='disableSuccessMails'
        END
		-- Amazon
		IF (@i_policyType = 1 or @i_policyType = 11) and ( @isResourceGroupPolicyProp =0)
		BEGIN
			DELETE #vmAllocationPolicyPropTemp
			INSERT INTO #vmAllocationPolicyPropTemp
			SELECT * FROM dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'availabilityZones'
			UNION ALL
			SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'vmInstanceTypes'
			UNION ALL
			SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'securityGroup'
			UNION ALL
			SELECT * FROM  dbo.app_vmallocationpolicyprop WHERE componentNameId = @i_policyId AND attrName = 'keyPair'
			DELETE vProp  FROM dbo.app_vmallocationpolicyprop vProp INNER JOIN #vmAllocationPolicyPropTemp v
		    on vProp.componentNameId = v.componentNameId and vProp.attrName = v.attrName
		    DROP TABLE #vmAllocationPolicyPropTemp
			--availabilityZones
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'availabilityZones', 2, ref.value('@availabilityZoneId', 'varchar(32)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/availabilityZones') R(ref)
			--vmInstanceTypes
			UNION ALL
			SELECT @i_policyId, 'vmInstanceTypes', 2, ref.value('@vmInstanceTypeId', 'varchar(64)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/instanceType/instanceType') R(ref)
			--securityGroup
			UNION ALL
			SELECT @i_policyId, 'securityGroup', 2, ref.value('@securityGroupId', 'varchar(32)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/securityGroups') R(ref)
			--keyPair
			UNION ALL
			SELECT @i_policyId, 'keyPair', 2, ref.value('@keyPairId', 'varchar(32)'),  @unixTime,0
			FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/amazonPolicy/keyPair') R(ref)
		END
		ELSE
		BEGIN
			if exists(select 1 from @dataStoreList)
			begin
				--datastores
				DELETE  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='datastore'
				INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT @i_policyId, 'datastore', 2, dataStoreId ,  @unixTime,0
				FROM  @dataStoreList
			end
		END
		-- Modify destination hyper V in app_vmallocationpolicyprop
		if (@destinationHyperV>0)
		begin
			DELETE  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='destinationHyperV'
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'destinationHyperV', 7, @destinationHyperV,  @unixTime,0
		end
		if (@proxyClientId>0)
		begin
			DELETE  dbo.app_vmallocationpolicyprop WHERE componentNameId=@i_policyId AND attrName='ProxyClientEntity'
			INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT @i_policyId, 'ProxyClientEntity', 7, @proxyClientId,  @unixTime,0
		end
		if @hasAllocPolicyChanged=1
		begin
			declare @subTaskIdForchange int = 0
			declare @hasOpBeenAudited int = 0
			DECLARE schedulesUsingAllocPolicy CURSOR STATIC FOR
			SELECT TM_Subtaskoptions.subtaskId FROM TM_Subtaskoptions WITH (NOLOCK)
			INNER JOIN TM_Subtaskoptions UseAllocPolicyOption WITH (NOLOCK)
			ON UseAllocPolicyOption.subTaskId = TM_Subtaskoptions.subtaskId
			AND TM_Subtaskoptions.value=convert(nvarchar(max),@i_policyId)
and TM_Subtaskoptions.optionId=1008442949
AND UseAllocPolicyOption.optionID = 1264497636
			AND UseAllocPolicyOption.value = '1'
			OPEN schedulesUsingAllocPolicy
			FETCH NEXT FROM schedulesUsingAllocPolicy INTO @subTaskIdForchange
			WHILE @@FETCH_STATUS = 0
			BEGIN
				if @hasOpBeenAudited=0
				begin
					set @hasOpBeenAudited = 1
set @opMsgId = (536 | (CAST(POWER(2, 24) AS BIGINT) * 84))
					EXEC EvGuiAuditSetOperation @opMsgId, @i_uid, @opEvMsgId OUTPUT, @opId OUTPUT
					EXEC EvGuiAuditSetParamData @opId, @i_policyName, @dataIsEvent
SET @paramMsgId = (1490 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
				end
				declare @subtaskNameForDeleteRepl nvarchar(max) = ''
				declare @taskIdForDeleteRepl int = 0
				select @subtaskNameForDeleteRepl = subtaskName , @taskIdForDeleteRepl=taskId from TM_subtask
				where subTaskId=@subTaskIdForchange
				if (@taskIdForDeleteRepl>0)
				begin
					EXEC EvGuiAuditSetParamData @opId, @subtaskNameForDeleteRepl, @dataIsEvent
SET @paramMsgId = (1492 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
					Update App_VSAReplication
					set flags=1
					where taskId=@taskIdForDeleteRepl
				end
				FETCH NEXT FROM schedulesUsingAllocPolicy INTO @subTaskIdForchange
			END
		end
		-- Hedvig datastore Update
		DECLARE @existingDsId INT = 0
		select top 1 @existingDatastoreRowId=id, @existingDsId=attrVal from dbo.app_vmallocationpolicyprop WITH (NOLOCK)where attrName = 'hedvigdatastoreid' AND componentNameId=@i_policyId and modified = 0
		IF @existingDsId <> 0 AND @existingDsId <> @HvDatastoreId
				DELETE FROM HedVigDatastoreProp WHERE attrName = 'VMAllocation Policy Id' AND componentNameId = @existingDsId
		IF(@isResourceGroupPolicyProp = 1 AND @i_xmlText.exist('Ida_VMAllocationPolicyReq/policy/HedvigDatastore') =1)
			BEGIN
				SET @HvDatastoreId  = ( SELECT ref.value('@dataStoreId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/HedvigDatastore') R(ref))
				IF @existingDatastoreRowId <> 0
					UPDATE dbo.app_vmallocationpolicyprop SET attrVal = @HvDatastoreId WHERE id = @existingDatastoreRowId
				ELSE
					INSERT INTO dbo.app_vmallocationpolicyprop(componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES (@i_policyId, 'hedvigdatastoreid', 2, @HvDatastoreId ,  @unixTime,0)
				IF @existingDsId <> @HvDatastoreId
					INSERT INTO HedVigDatastoreProp
					VALUES ( @HvDatastoreId, 'VMAllocation Policy Id', 1, @i_policyId, dbo.GetUnixTime(getutcdate()), 0)
			END
		ELSE
			IF @existingDatastoreRowId <> 0
				DELETE FROM dbo.app_vmallocationpolicyprop WHERE id = @existingDatastoreRowId
END
IF ((@i_action = '0' or @i_action ='1') and @vmPolicyAppType =2)
begin
	-- update member server list from auto scale policy
	select @instanceId = instance from app_application a
	inner join app_client c
	on a.clientid = c.id
	and a.apptypeid = 106
	and c.id = @destinationHyperV
	declare @memberserversXML xml
	declare @memberDBId int
	select @memberserversXML = attrval, @memberDBId =id  from APP_InstanceProp
	where attrname ='Vs Member Servers' and componentNameId = @instanceId
	declare @memberservers table
	(
		clientGroupId int
	)
	insert into @memberservers
	select M.m.value('@clientGroupId', 'int')
	from @memberserversXML.nodes('/App_MemberServers/memberServers/client') as  M(m)
	where M.m.value('@clientGroupId', 'int') is not null
	declare @clientGroupId int
	declare @clientGroupName nvarchar(max)
	select @clientGroupId = @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/associatedClientGroup/@clientGroupId)[1]', 'int'),
		   @clientGroupName = @i_xmlText.value('(Ida_VMAllocationPolicyReq/policy/associatedClientGroup/@clientGroupName)[1]', 'nvarchar(max)')
	declare @prevClientGroupId int
	declare @prevClientGroupName nvarchar(max)
	declare @serverswithxmltag nvarchar(max)
	declare @updatemembers int = 0
	if not exists ( select clientGroupId from @memberservers where clientGroupid = @clientGroupId )
	begin
			declare @clientGroupNode xml
			set @clientGroupNode = (select '28' as '@_type_',
				   @clientGroupId as '@clientGroupId',
				   @clientGroupName as '@clientGroupName'
				   for xml path ('client') ,type
				   ,root('memberServers'))
			SET @memberserversXML.modify('insert sql:variable("@clientGroupNode") as last into (/App_MemberServers)[1]')
			set @updatemembers = 1
	end
	--during edit remove old client group assocation, if client group changes
	if (@i_action ='1' )
	begin
		select @prevClientGroupId = @allocPolicyXml.value('(policy/associatedClientGroup/@clientGroupId)[1]', 'int'),
		   @prevClientGroupName = @allocPolicyXml.value('(policy/associatedClientGroup/@clientGroupName)[1]', 'nvarchar(max)')
		if (  @clientGroupId <> @prevClientGroupId )
		begin
			set @memberserversXML.modify('delete (/App_MemberServers/memberServers[client/@clientGroupId=sql:variable("@prevClientGroupId")])')
			set @updatemembers = 1
	    end
    end
	if ( @updatemembers = 1)
	begin
			set @serverswithxmltag  ='<?xml version="1.0" encoding="UTF-16" standalone="no" ?>' + cast(@memberserversXML as nvarchar(max))
			update app_instanceprop set attrval = @serverswithxmltag  where id = @memberDBId
	end
		IF (@prevClientGroupName IS NOT NULL)
		SET @prevClientGroupName = ''
		IF (@ClientGroupName IS NOT NULL)
		SET @ClientGroupName = ''
		IF(@prevClientGroupName <> @ClientGroupName)
		BEGIN
			EXEC EvGuiAuditSetParamData @opId, @prevClientGroupName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @ClientGroupName, @dataIsEvent
SET @paramMsgId = (1122 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
		END
end
--Audit operation for auto scale
IF(@i_action = '1' OR @i_action = '0')
BEGIN
	IF (@maxAccessNode IS NULL)
		SET @maxAccessNode = 0
	IF (@maxAccessNode <> @PrevMaxAccessNode)
	BEGIN
		EXEC EvGuiAuditSetParamData @opId, @PrevMaxAccessNode, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @maxAccessNode, @dataIsEvent
SET @paramMsgId = (1859 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
	END
	IF(@prevIsPublicIP IS NULL)
		SET @prevIsPublicIP = 0
	IF(@isPublicIP <> @prevIsPublicIP)
	BEGIN
	IF(@isPublicIP = 0)
		EXEC EvGuiAuditSetParamData @opId, 'false', @dataIsEvent
	ELSE
		EXEC EvGuiAuditSetParamData @opId, 'true', @dataIsEvent
SET @paramMsgId = (1856 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
	END
	--Auto select instance type
	IF (@InstanceType = ''  OR @InstanceType IS NULL)
	BEGIN
SET @paramMsgId = (1855 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
	END
	IF (@PrevInstanceType IS NULL)
			SET @PrevInstanceType = ''
	IF(@InstanceType <> @PrevInstanceType AND (@InstanceType <> ''  AND @InstanceType IS NOT NULL))
	BEGIN
		EXEC EvGuiAuditSetParamData @opId, @PrevInstanceType, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @InstanceType, @dataIsEvent
SET @paramMsgId = (1858 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
	END
	IF(@PrevIAMRole IS NULL)
	SET @PrevIAMRole = ''
	IF(@IAMRole <> @PrevIAMRole)
	BEGIN
		EXEC EvGuiAuditSetParamData @opId, @PrevIAMRole, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @IAMRole, @dataIsEvent
SET @paramMsgId = (1857 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_uid
	END
END
--Delete the policy , dont actually delete just mark its not alive
IF (@i_action = '2')
BEGIN
DECLARE @deleted_policyName 	varchar(256)
SET @deleted_policyName = @i_policyName + '_deleted_' + CAST(@unixTime AS nvarchar(32))
SET	@i_policyId = ISNULL (( SELECT ref.value('@vmAllocPolicyId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/entity') R(ref)), 0)
	-- Check whether user is creator. If not, he should have administrative management
	declare @policyCreator int = 0
	select @policyCreator=ownerId from App_VmAllocationPolicy
	where id=@i_policyId
	if (@policyCreator<>@i_uid)
	begin
		-- Check administrative management at CS level.
		declare @isAdminUser int = 0
EXEC sec_checkPermissionOnEntity @i_uid, 1, @isAdminUser OUT,1,2
		if (@isAdminUser=0)
		begin
			SET @errorCode = 1;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1647 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0,2);
			SET @r_ReturnResult = (	SELECT	1				as TAG,
			NULL			as Parent,
			@errorCode		as [EVGui_GenericResp!1!errorCode],
			@errorString	as [EVGui_GenericResp!1!errorMessage]
			FOR XML EXPLICIT
			);
			SELECT @r_ReturnResult;
			return;
		end
	end
	-- Verify whether this allocation policy is associated to schedule or not. If so, please dont delete it.
	--#define ALLOCATIONPOLICY_VM_ALLOC_POLICY_ID 1008442949
	--#define ALLOCATIONPOLICY_VM_ALLOC_POLICY_ID_XPATH  "options[1]/restoreOptions[1]/virtualServerRstOption[1]/allocationPolicy[1]/@vmAllocPolicyId"
	declare @subTaskId int = 0
	declare @subTaskName nvarchar(max) = ''
	select @subTaskId=TM_subtask.subtaskId from TM_SubTaskOptions
		inner join TM_Subtask on TM_SubTaskOptions.subtaskId=TM_subtask.subtaskId
		inner join TM_task on TM_task.taskId = TM_subtask.taskID
		where TM_SubTaskOptions.optionId=1008442949
		and TM_subtask.subtasktype = 3
		and TM_task.deleted=0 -- Ensure task isnt deleted
		and TM_SubTaskOptions.value = @i_policyId
	if @subTaskId>0
	begin
		select @subTaskName = RG.name from TM_subtask st
		inner join App_ReplicationGroupAssociation RGA
		on RGA.taskId = st.taskId
		inner join APP_ReplicationGroup RG on
		RGA.componentNameId = RG.id
		where subTaskId=@subTaskId
		IF ISNULL(@subTaskName,'') = ''
		BEGIN
			select @subTaskName=subtaskname from TM_subtask
			where subTaskId=@subTaskId
		END
		SET @errorCode = 2;
SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (1648 | (CAST(POWER(2, 24) AS BIGINT) * 83)) AND [localeId] = @i_localeId)
		SET @errorString = REPLACE(@errorString, '^1%s', @subTaskName)
		SET @r_ReturnResult = (	SELECT	1				as TAG,
		NULL			as Parent,
		@errorCode		as [EVGui_GenericResp!1!errorCode],
		@errorString	as [EVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		);
		SELECT @r_ReturnResult;
		return;
	end
	UPDATE [dbo].[App_VmAllocationPolicy]
	SET modified = @unixTime, alive = '0', name= @deleted_policyName
	where id = @i_policyId
	-- Hedvig datastore DELETE
		DELETE FROM HedVigDatastoreProp  WHERE  attrName = 'VMAllocation Policy Id' AND attrVal = @i_policyId
END
IF (@i_action = '5')
BEGIN
	DECLARE @i_polStatus INT
	SET @i_polStatus = ISNULL (( SELECT ref.value('@enabled', 'INT')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy') R(ref)), 0)
	SET	@i_policyId = ISNULL (( SELECT ref.value('@vmAllocPolicyId', 'varchar(256)')
					FROM  @i_xmlText.nodes ('Ida_VMAllocationPolicyReq/policy/entity') R(ref)), '')
	--Error Condition: If the given policyId does not exist
	IF NOT EXISTS (SELECT * FROM APP_VMAllocationPolicy WHERE id = @i_policyId)
	BEGIN
SET @errorCode = 100;
SET @errorString = dbo.fn_EvFormatEventMsgText(0, @i_localeId, (1023 | (CAST(POWER(2, 24) AS BIGINT) * 83)), 0,2);
		SET @r_ReturnResult = (	SELECT	1				as TAG,
		NULL			as Parent,
		@errorCode		as [EVGui_GenericResp!1!errorCode],
		@errorString	as [EVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
		);
		SELECT @r_ReturnResult;
		return;
	END
	SELECT @i_policyData = vxml FROM APP_VMAllocationPolicy WHERE id = @i_policyId
	SET @i_policyData.modify('replace value of (/policy/@enabled)[1] with sql:variable("@i_polStatus")')
	UPDATE APP_VMAllocationPolicy SET vxml = @i_policyData WHERE id =  @i_policyId
END
--return data
SET @r_ReturnResult = (
		SELECT @i_policyId AS '@vmAllocPolicyId', @deleted_policyName AS '@vmAllocPolicyName'
		FOR XML PATH('entity'), ROOT('Ida_VMAllocationPolicyResp')
		)
	if @recordTranStarted=1
	begin
		commit tran
	end
	SELECT @r_ReturnResult;
	return
end try
begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	if @recordTranStarted=1
	begin
		rollback tran
	end
end catch
SET @errorCode = 100;
     SET @errorString = 'Database error in performing operation'
     SET @r_ReturnResult = (	SELECT	1				as TAG,
     NULL			as Parent,
     @errorCode		as [EVGui_GenericResp!1!errorCode],
     @errorString	as [EVGui_GenericResp!1!errorMessage]
     FOR XML EXPLICIT
     );
	SELECT @r_ReturnResult;
	return
GO

IF EXISTS (select * from GxQscripts where name = 'AppHandleVMAllocationPolicy')
	delete from GxQscripts where name = 'AppHandleVMAllocationPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleVMAllocationPolicy')
	delete from GXDBVersions where aliasname = 'AppHandleVMAllocationPolicy'
GO

insert into GXDBVersions values(2, 'AppHandleVMAllocationPolicy',  '00010015004600330000', 'AppHandleVMAllocationPolicy', '00010015004600330000')
GO

