

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHandleMaskingPolicyReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppHandleMaskingPolicyReq <<<'

IF EXISTS (select * from sysobjects where name='AppHandleMaskingPolicyReq')
	drop procedure AppHandleMaskingPolicyReq
IF EXISTS (select * from GxQscripts where name='AppHandleMaskingPolicyReq')
	delete from GxQscripts where name = 'AppHandleMaskingPolicyReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleMaskingPolicyReq')
	delete from GXDBVersions where aliasname = 'AppHandleMaskingPolicyReq'
GO
print '... Creating Procedure: AppHandleMaskingPolicyReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppHandleMaskingPolicyReq
  @i_xml XML
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(1024) = N''
	DECLARE @timeNow INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @opType INTEGER = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/@opType)[1]','INT')), 0)
	DECLARE @policyID INTEGER
	DECLARE @instanceId INTEGER
	DECLARE @backupsetId INTEGER
	DECLARE @appTypeId INTEGER
	DECLARE @policyName NVARCHAR(256)
	DECLARE @ccId INTEGER
	SET @ccId = ISNULL((SELECT TOP 1 id FROM APP_Commcell WHERE type = 1 and id > 1), 0)
	DECLARE @maskingConfig XML
	IF @opType = 1 --Modify
	BEGIN
		SET @policyId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/policy/@policyId)[1]', 'INT')), 0)
		IF @policyId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Policy ID is not found in the request xml. Aborting modify policy operation'
			GOTO ERROR_EXIT;
		END
		SET @instanceId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/association/@instanceId)[1]', 'INT')), 0)
		SET @appTypeId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/association/@applicationId)[1]', 'INT')), 0)
		SET @backupsetId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/association/@backupsetId)[1]', 'INT')), 0)
		SET @policyName = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/policy/@policyName)[1]', 'NVARCHAR(256)')), 0)
		SET @maskingConfig = ISNULL((SELECT @i_xml.query('/App_DataMaskingPolicyOpReq/policy/config')), '<config />')
		IF @instanceId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Instance ID is not found in the request xml. Aborting modify policy operation'
			GOTO ERROR_EXIT;
		END
		IF EXISTS (SELECT 1 FROM APP_MaskingPolicy WHERE instanceId = @instanceId AND backupsetId = @backupsetId AND name = @policyName and modifiedTime = 0 and id != @policyId)
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'A policy with name ' + @policyName + ' already exists for the same instance. Please use a different name.'
			GOTO ERROR_EXIT;
		END
		IF EXISTS (SELECT 1 FROM APP_MaskingPolicy WHERE instanceId = @instanceId AND backupsetId = @backupsetId and modifiedTime = 0 and id = @policyId)
		BEGIN
			UPDATE APP_MaskingPolicy
			SET	name = @policyName,
				maskingConfig = @maskingConfig
			WHERE id = @policyId
		END
		--INSERT INTO APP_MaskingPolicy VALUES (@policyName, @instanceId, @backupsetId, @appTypeId, @maskingConfig, @timeNow, 0, @ccId)
	END
	ELSE IF @opType = 2 --Add
	BEGIN
		SET @instanceId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/association/@instanceId)[1]', 'INT')), 0)
		SET @appTypeId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/association/@applicationId)[1]', 'INT')), 0)
		SET @backupsetId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/association/@backupsetId)[1]', 'INT')), 0)
		SET @policyName = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/policy/@policyName)[1]', 'NVARCHAR(256)')), 0)
		SET @maskingConfig = ISNULL((SELECT @i_xml.query('App_DataMaskingPolicyOpReq/policy/config')), '<config />')
		IF @instanceId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Instance ID is not found in the request xml. Aborting create policy operation'
			GOTO ERROR_EXIT;
		END
		IF EXISTS (SELECT 1 FROM APP_MaskingPolicy WHERE instanceId = @instanceId AND backupsetId = @backupsetId AND name = @policyName and modifiedTime = 0)
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'A policy with name ' + @policyName + ' already exists for the same instance. Please use a different name.'
			GOTO ERROR_EXIT;
		END
		INSERT INTO APP_MaskingPolicy VALUES (@policyName, @instanceId, @backupsetId, @appTypeId, @maskingConfig, @timeNow, 0, @ccId)
	END
	IF @opType = 3 --Delete
	BEGIN
		SET @policyId = ISNULL((SELECT @i_xml.value('(/App_DataMaskingPolicyOpReq/policy/policy/@policyId)[1]', 'INT')), 0)
		IF @policyId = 0
		BEGIN
			SET @errorCode = 1
			SET @errorMsg = 'Policy ID not found in the request xml. Aborting delete operation'
			GOTO ERROR_EXIT;
		END
		UPDATE	APP_MaskingPolicy SET modifiedTime = @timeNow WHERE id = @policyId
	END
ERROR_EXIT:
	SELECT
			@errorCode as '@errorCode',
			@errorMsg as '@errorMessage'
	FOR XML PATH('App_GenericResp'), TYPE
GO

IF EXISTS (select * from GxQscripts where name = 'AppHandleMaskingPolicyReq')
	delete from GxQscripts where name = 'AppHandleMaskingPolicyReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleMaskingPolicyReq')
	delete from GXDBVersions where aliasname = 'AppHandleMaskingPolicyReq'
GO

insert into GXDBVersions values(2, 'AppHandleMaskingPolicyReq',  '00000000000000000000', 'AppHandleMaskingPolicyReq', '00000000000000000000')
GO

