

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHandleDeleteHanaNode.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppHandleDeleteHanaNode')
BEGIN
	print '>>> Drop Stored Procedure: AppHandleDeleteHanaNode <<<'
	drop procedure AppHandleDeleteHanaNode
END
IF EXISTS (select * from GxQscripts where name='AppHandleDeleteHanaNode')
	delete from GxQscripts where name = 'AppHandleDeleteHanaNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleDeleteHanaNode')
	delete from GXDBVersions where aliasname = 'AppHandleDeleteHanaNode'
GO
print '... Creating Procedure: AppHandleDeleteHanaNode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppHandleDeleteHanaNode
  @clientId INT
AS
SET NOCOUNT ON
  DECLARE @errorCode INT 
BEGIN
	SET @errorCode = 0
	--Find the instance list
	DECLARE @instanceList TABLE(instanceId INT, dbClients NVARCHAR(MAX) default N'', attrVal NVARCHAR(MAX))
	DECLARE @InstanceAndNodes TABLE (instanceId INT, clientId INT)
	INSERT INTO @instanceList(instanceId, attrVal)
	SELECT DISTINCT IP.componentNameId, IP.attrVal
	FROM APP_InstanceProp IP WITH (NOLOCK)
		CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
	WHERE	IP.attrName = 'Database Clients'
		AND	IP.modified = 0 AND S.Data = @clientId
	-- Get the list of nodes excluding the current client
	INSERT INTO @InstanceAndNodes (instanceId, clientId)
	SELECT	I.instanceId, S.Data
	FROM	@instanceList I
		CROSS APPLY dbo.SplitString(I.attrVal, '+') S
	WHERE	S.Data <> @clientId
	UPDATE	IL
	SET		IL.dbClients = (SELECT STUFF((SELECT '+' + CAST(clientId AS NVARCHAR(16))
							FROM @InstanceAndNodes IAN
								WHERE IAN.instanceId = IL.instanceId
							FOR XML PATH('')) ,1,1,''))
	FROM	@instanceList IL
	UPDATE	IP
	SET		IP.attrVal = ISNULL(IL.dbClients, N'')
	FROM	APP_InstanceProp IP
		INNER JOIN @instanceList IL
			ON IP.componentNameId = IL.instanceId AND IP.attrName = 'Database Clients' AND modified = 0
	SELECT @errorCode
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppHandleDeleteHanaNode')
	delete from GxQscripts where name = 'AppHandleDeleteHanaNode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleDeleteHanaNode')
	delete from GXDBVersions where aliasname = 'AppHandleDeleteHanaNode'
GO

insert into GXDBVersions values(2, 'AppHandleDeleteHanaNode',  '00000000000000000000', 'AppHandleDeleteHanaNode', '00000000000000000000')
GO

