

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHandleCSLiveSyncAutoConnectGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppHandleCSLiveSyncAutoConnectGroup.sp,v $ $Id: AppHandleCSLiveSyncAutoConnectGroup.sp,v 1.1.2.8 2020/08/13 17:59:07 sneralla Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppHandleCSLiveSyncAutoConnectGroup()
--  |
--  | Description:  Handles creating CS Live Sync auto connect client group based on CS Live Sync status
--  |
--  |       Input:  xxx
--  |
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Srilatha N				   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppHandleCSLiveSyncAutoConnectGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppHandleCSLiveSyncAutoConnectGroup <<<'
	drop procedure AppHandleCSLiveSyncAutoConnectGroup
END
IF EXISTS (select * from GxQscripts where name='AppHandleCSLiveSyncAutoConnectGroup')
	delete from GxQscripts where name = 'AppHandleCSLiveSyncAutoConnectGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleCSLiveSyncAutoConnectGroup')
	delete from GXDBVersions where aliasname = 'AppHandleCSLiveSyncAutoConnectGroup'
GO
print '... Creating Procedure: AppHandleCSLiveSyncAutoConnectGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppHandleCSLiveSyncAutoConnectGroup
AS
SET NOCOUNT ON
BEGIN
DECLARE @errorCode INT = 0
DECLARE @scgExitCode INT
DECLARE @scgExitMsg VARCHAR(1024)
DECLARE @masterUserGroupId INT = dbo.GetMasterGroupID()
DECLARE @createAsUserID INT
DECLARE @weStartedTransaction INTEGER = 0
		BEGIN TRY
			DECLARE @isEnabled INTEGER = 1
SELECT TOP 1  @isEnabled=CAST(CAST(value AS VARCHAR(16)) AS INTEGER)	FROM APP_AdvanceSettings	WHERE keyName = 'nEnableCSLiveSyncAutoConnect' AND type='INTEGER' AND relativePath='CommServDB.GxGlobalParam' AND enabled=1
			IF @isEnabled<>1
				GOTO END_OF_PROC
			IF @@TRANCOUNT = 0
			BEGIN
				BEGIN TRANSACTION ThisSPInitiatedTransaction
				SET @weStartedTransaction = 1
			END
			DECLARE @cvFailoverConfigStatus INTEGER = 0
SELECT @cvFailoverConfigStatus = CONVERT(INT,value) FROM GxGlobalparam WITH(NOLOCK) WHERE name='nCSFailoverConfigStatus' AND modified = 0
			DECLARE @scgId INTEGER
			DECLARE @allCapability BIGINT = ISNULL((SELECT CAST(CAST(value AS NVARCHAR(MAX)) AS BIGINT) FROM GXGlobalParam  WITH(NOLOCK) WHERE name = 'SystemOwnerCapibilities' ),(SELECT SUM(POWER(2.0, id-1)) FROM UMCapability))
			DECLARE @ownerId INT = ISNULL((SELECT TOP(1) id FROM UMUsers  WITH(NOLOCK) WHERE (flags & 0x40 = 0x40)), 1)
DECLARE @clientGroupCreatorRoleID INT = ISNULL((SELECT id FROM UMRoles  WITH(NOLOCK) WHERE name = 'Client Group Creator' AND flags & (1 | 2) <> 0), 1)
			IF @cvFailoverConfigStatus = 1
			BEGIN
IF NOT EXISTS (SELECT * FROM App_ClientGroup WHERE name = 'Clients For Commserv LiveSync')
				BEGIN
							-- converted to SCG V2
							DECLARE @CommservLiveSyncGroupRuleQuery NVARCHAR (MAX) = ''
							INSERT INTO App_ClientGroup (name, description, flag, status, userId, refTime, modified, fwPorts, origCCId)
values('Clients For Commserv LiveSync', 'On a commcell with LiveSync configured, this group consists of clients which can connect to CS automatically post failover.', 0x1000, 0, @masterUserGroupId  , 0, '0', '', 2)
							SET @scgId = SCOPE_IDENTITY()
							SET @scgExitCode = 0
							SET @scgExitMsg = ''
							EXEC sec_setCreatorForEntity	@ownerId,
															@clientGroupCreatorRoleId,
															'',
															@scgExitCode OUTPUT,
															@scgExitMsg OUTPUT,
28,
															@scgId,
															0,
															0,
															0,
															0,
															0,
															0,
															0,
															0,
															@masterUserGroupId
							IF (@scgExitCode <> 0)
							BEGIN
								PRINT 'Error setting creator for group. [' + @scgExitMsg + ']'
								SET @errorCode = @scgExitCode
								GOTO END_OF_PROC
							END
							SET @scgExitCode = 0
							SET @scgExitMsg = ''
							--For Rule 1, filterId = 104 (>=)
							--For Rule 1, value=14 >=SP level 14
							--For Rule 2, filterId = 101 (<>)
							--For Rule 2, value is picked from : https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/Db/Sp/AppSCGGetClientPropsEnum.sp
							DECLARE @SCGRule NVARCHAR(1024) = '<scgRule op="0">
																			   <rules>
<rule propID="117" filterID="104" propType="9" value="14" />
																			   </rules>
																			   <rules>
<rule propID="2" filterID="101" propType="4" value="11" secValue="CS Client" />
																			   </rules>
															   </scgRule>'
							EXEC APPSCGV2GenerateQueryParams @SCGRule, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @CommservLiveSyncGroupRuleQuery OUTPUT
							IF (@scgExitCode <> 0)
							BEGIN
								PRINT 'Failed to create Clients For Commserv LiveSync. [' + @scgExitMsg +  ']'
								SET @errorCode = @scgExitCode
								GOTO END_OF_PROC
							END
							INSERT INTO app_scgrule (scgId, ruleXml, ruleQuery, ownerId, created, modified)
							values(@scgId,
								@SCGRule,
								@CommservLiveSyncGroupRuleQuery,
								1, 0, '0')
							-- Set additional setting
							DECLARE @interfaceList NVARCHAR(MAX) = ''
							SET @interfaceList = STUFF ((SELECT ',' + AC.net_hostname
														FROM APP_Client AS AC WITH(NOLOCK)
														INNER JOIN APP_ClientProp AS ACP WITH(NOLOCK)
														ON AC.id=ACP.componentNameId
														WHERE ACP.attrName = 'Linked CS Client' AND ACP.modified=0 AND AC.status=0
														FOR XML PATH('')), 1, 1, '')
							IF @interfaceList<>''
							BEGIN
								DECLARE @errorCodeTbl TABLE (errorCode INT)
								INSERT INTO @errorCodeTbl
								EXEC AppSetAdditionalSettingsForEntity @scgID, 28, 'sCSINTERFACELIST', 'CommServe', 'STRING', @interfaceList, 0, 'Comma separated list of all CS LiveSync node hostnames'
							END
				END
			END
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode = ERROR_NUMBER()
		END CATCH
END_OF_PROC:
IF @weStartedTransaction = 1
BEGIN
	IF @errorCode=0
		COMMIT TRAN ThisSPInitiatedTransaction
	ELSE
		ROLLBACK TRAN ThisSPInitiatedTransaction
END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppHandleCSLiveSyncAutoConnectGroup')
	delete from GxQscripts where name = 'AppHandleCSLiveSyncAutoConnectGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleCSLiveSyncAutoConnectGroup')
	delete from GXDBVersions where aliasname = 'AppHandleCSLiveSyncAutoConnectGroup'
GO

insert into GXDBVersions values(2, 'AppHandleCSLiveSyncAutoConnectGroup',  '00010001000200080000', 'AppHandleCSLiveSyncAutoConnectGroup', '00010001000200080000')
GO

