

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHandleAgentLessSRMClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppHandleAgentLessSRMClients.sp,v $ $Id: AppHandleAgentLessSRMClients.sp,v 1.17.78.3 2019/07/17 20:47:24 syadav Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppHandleAgentLessSRMClients"	|
-- 	+-----------------------------------------------------------------------+
--  +-------------------------------------------------------------------------------------+
--  |   Revision History                                                                  |
--  |   ================                                                                  |
--  |   Procedure Name                        Description                                 |
--  |   -----------------------------         ------------------------------------------  |
--  +-------------------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppHandleAgentLessSRMClients')
BEGIN
	print '>>> Drop Stored Procedure: AppHandleAgentLessSRMClients <<<'
	drop procedure AppHandleAgentLessSRMClients
END
IF EXISTS (select * from GxQscripts where name='AppHandleAgentLessSRMClients')
	delete from GxQscripts where name = 'AppHandleAgentLessSRMClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleAgentLessSRMClients')
	delete from GXDBVersions where aliasname = 'AppHandleAgentLessSRMClients'
GO
print '... Creating Procedure: AppHandleAgentLessSRMClients'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppHandleAgentLessSRMClients
  @i_jobId int
AS
  DECLARE @o_clientGroupId int
SET NOCOUNT ON
BEGIN
DECLARE @clientTbl TABLE ( id INT, clientStatus INT )
DECLARE @jobOptionTbl TABLE (o_type			INT,
							 o_optionId		bigint,
							 o_value		NVARCHAR(MAX)
							)
SET @o_clientGroupId = 0
IF @i_jobId = 0 OR @i_jobId IS NULL
	RETURN
INSERT INTO @jobOptionTbl
EXEC TM_GetAllJobOptions @jobId = @i_jobId
DECLARE @i_csHostName nvarchar(255) = (SELECT net_hostname FROM APP_Client WHERE id = 2)
DECLARE @i_simOsType int = 0
SELECT @i_simOsType =
	CASE CAST(value AS int)
WHEN 0 THEN 21
WHEN 1 THEN 20
ELSE 0
	END
FROM TM_SubTaskOptions WHERE subTaskId =
(SELECT TOP 1 subTaskId FROM TM_SubTask WHERE taskId = ( SELECT TOP 1 o_value
FROM @jobOptionTbl
WHERE o_optionId = 140024
)
) AND optionId = 423390229
-- Insert data in the app client table
MERGE App_Client AS C
USING ( SELECT clientId,clientName FROM JMQinetixUpdateStatus WHERE jobId = @i_jobId ) TMP
		ON (C.name = TMP.clientName OR C.net_hostName = TMP.clientName OR
		C.net_hostName = CASE CHARINDEX('.',TMP.clientName) WHEN
							 0 THEN TMP.clientName
							 ELSE SUBSTRING(TMP.clientName,1, CHARINDEX('.',TMP.clientName) - 1)
							 END )
WHEN NOT MATCHED THEN
		INSERT VALUES( TMP.clientName,
					   @i_simOsType,
					   TMP.clientName,
					   N'2edyCCCP1CCypCCypCCyyCCP6CCy9CCPdCC',
					   0,
					   0,
					   0,
					   0,
					   @i_csHostName,
					   N'SRM Agentless Client',
					   N'N/A',
					   0,
					   0,
					   0,
0x00002,
16,
					   0,
					   0,
					   0,
					   2,
					   NEWID(),
					   0,
					   TMP.clientName);
-- Insert data in client prop table
INSERT INTO @clientTbl
SELECT DISTINCT id,APP_Client.status
FROM APP_Client INNER JOIN JMQinetixUpdateStatus ON jobId = @i_jobId AND (net_hostname = clientName OR name = clientName)
-- Insert entry into App Platform table
INSERT INTO APP_Platform
SELECT C.id,4,'N/A',0
FROM @clientTbl C
WHERE NOT EXISTS ( SELECT clientId
				   FROM APP_Platform AP
				   WHERE AP.clientId = C.id
				 )
DELETE APP_ClientProp
WHERE componentNameId IN ( SELECT id FROM @clientTbl WHERE clientStatus <> 0x00002 )
	AND attrName = 'Mini SRM Agent'
DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(CURRENT_TIMESTAMP) )
-- Here we have to set the mini srm agent property and
-- platform deleted flag if its an uninstalled client
INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT id,'Mini SRM Agent', 2, '1', @currentTime, 0 , 0
FROM @clientTbl C
WHERE NOT EXISTS ( SELECT attrVal
				   FROM APP_ClientProp CP
				   WHERE CP.componentNameId = C.id
					AND CP.attrName = 'Mini SRM Agent'
					AND CP.modified = 0
					AND CP.attrVal = '1' )
DELETE APP_ClientProp
WHERE componentNameId IN ( SELECT id FROM @clientTbl WHERE clientStatus = 0x00002 )
	AND attrName = 'PlatformDeleted 4'
INSERT INTO APP_ClientProp(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
SELECT id,'PlatformDeleted 4', 2, '1', @currentTime, 0 , 0
FROM @clientTbl C
WHERE clientStatus = 0x00002
-- Now create the client group or update the membership
DECLARE @clientGroupName nvarchar(512) = ISNULL( (SELECT o_value FROM @jobOptionTbl WHERE o_optionId = 140025  ), '')
IF LEN(@clientGroupName) = 0
	RETURN
IF NOT EXISTS( SELECT * FROM APP_ClientGroup where name = @clientGroupName )
BEGIN
	INSERT INTO APP_ClientGroup(name
           ,description
           ,flag
           ,status
           ,userId
           ,refTime
           ,modified
           ,origCCId
		   ,fwPorts)
           VALUES
           (@clientGroupName
           ,'SRM Agentless Group'
           ,0
           ,0
           ,1
           ,@currentTime
           ,0
           ,2
		   ,' ')
END
-- Now modify the association
SET @o_clientGroupId = ( SELECT id FROM APP_ClientGroup where name = @clientGroupName )
DELETE APP_ClientGroupAssoc
WHERE clientGroupId = @o_clientGroupId
INSERT INTO APP_ClientGroupAssoc (clientGroupId,clientId)
SELECT @o_clientGroupId,id
FROM @clientTbl
IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupProp WHERE componentNameId = @o_clientGroupId AND attrName = 'System Created')
BEGIN
	INSERT APP_ClientGroupProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@o_clientGroupId, 'System Created', 7, 0, @currentTime, 0)
END
UPDATE JMQinetixUpdateStatus
SET clientId = C.id
FROM JMQinetixUpdateStatus JMQ
INNER JOIN APP_Client C on
 jobId = @i_jobId
  and (C.name = JMQ.clientName OR C.net_hostName = JMQ.clientName OR
				C.net_hostName =	CASE CHARINDEX('.',JMQ.clientName) WHEN
							 0 THEN JMQ.clientName
							 ELSE SUBSTRING(JMQ.clientName,1, CHARINDEX('.',JMQ.clientName) - 1)
							 END )
-- Set the special client states
EXEC AppSetSpecialClientStates
SELECT @o_clientGroupId
END
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'AppHandleAgentLessSRMClients')
	delete from GxQscripts where name = 'AppHandleAgentLessSRMClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHandleAgentLessSRMClients')
	delete from GXDBVersions where aliasname = 'AppHandleAgentLessSRMClients'
GO

insert into GXDBVersions values(2, 'AppHandleAgentLessSRMClients',  '00010017007800030000', 'AppHandleAgentLessSRMClients', '00010017007800030000')
GO

