

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppHACNodeOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppHACNodeOperation
--  | Description:   Creates/ delete entries in DM2SearchServerCodeInfo, DM2Cloud
--  |
--  |			create hac cluster node cloud
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppHACNodeOperation.sp,v $ $Id: AppHACNodeOperation.sp,v 1.1.2.4 2020/08/24 15:17:39 sjohnson Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppHACNodeOperation')
BEGIN
	print '>>> Drop Stored Procedure: AppHACNodeOperation <<<'
	drop procedure AppHACNodeOperation
END
IF EXISTS (select * from GxQscripts where name='AppHACNodeOperation')
	delete from GxQscripts where name = 'AppHACNodeOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHACNodeOperation')
	delete from GXDBVersions where aliasname = 'AppHACNodeOperation'
GO
print '... Creating Procedure: AppHACNodeOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppHACNodeOperation
  @i_userID INT,
  @i_inputXml XML,
  @o_errorCode INT OUTPUT,
  @o_errorStr varchar(512) OUTPUT
AS
SET @o_errorCode = 0
SET @o_errorStr = 'Success'
DECLARE @opType INT = 0
DECLARE @clientId INT = 0
DECLARE @cloudId INT = 0
DECLARE @zkElectionPort INT = 0
DECLARE @zkListenerPort INT = 0
DECLARE @zkDataPort INT = 0
DECLARE @zkServerId INT = 0
DECLARE @cloudType INT = 0
DECLARE @commcellId INT = 2
DECLARE @status INT = 0
DECLARE @nodeProps NVARCHAR(2048)
DECLARE @clientName NVARCHAR(2048)
DECLARE @cloudPoolDisplayName NVARCHAR(2048)
DECLARE @installTime int = dbo.GetUnixTime(GETDATE())
DECLARE @cloudName NVARCHAR(1024)
DECLARE @opEvMsgId          INT = 0
DECLARE @dataIsEvent        INT = 0
DECLARE @opMsgId            INT = 0
DECLARE @opId               INT = 0
DECLARE @paramMsgId         INT = 0
/*<App_NodeOperation cloudId="18">
                       <nodes opType="1" status="3">
                           <nodeClientEntity clientId="2" />
                           <nodeMetaInfos name="analytics_datadirectory" value="C:\Program Files\CommVault\AEDataNew" />
						    <nodeMetaInfos name="analytics_jvmMaxMem" value="4098" />
							 <nodeMetaInfos name="analytics_startport" value="20000" />
							  <nodeMetaInfos name="analytics_stopport" value="20010" />
                       </nodes>
               </App_NodeOperation>
*/
SET @status = ISNULL (( SELECT ref.value('@status', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)), 0)
--get node properties
DECLARE @nodeProperties TABLE (t_clientId INT, t_name NVARCHAR(1024), T_value NVARCHAR(1024))
INSERT INTO @nodeProperties
SELECT ref.value('nodeClientEntity[1]/@clientId', 'INT'), ref1.value('@name', 'NVARCHAR(1024)'), ref1.value('@value', 'NVARCHAR(1024)')
 FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
 CROSS APPLY R.ref.nodes('nodeMetaInfos') as R1(ref1)
 DELETE @nodeProperties WHERE t_name IN ('URL', 'WEBSERVER','ISENABLED','ISASSOCIATED')
--get node metaprops xml
DECLARE @nodeOperation TABLE (t_OpType INT, t_clientId INT, t_clientName NVARCHAR(2048), t_nodeMetaInfos NVARCHAR(2048), t_zkElectionPort INT, t_zkDataPort INT, t_zkListenerPort INT)
INSERT INTO @nodeOperation (t_OpType, t_clientId)
SELECT ref.value('@opType', 'INT'), ref.value('nodeClientEntity[1]/@clientId', 'INT')
FROM @i_inputXml.nodes ('App_NodeOperation/nodes') R(ref)
SET @cloudId = ISNULL (( SELECT ref.value('@cloudId', 'INT')
                              FROM @i_inputXml.nodes ('App_NodeOperation') R(ref)), 0)
SET @cloudType = ISNULL((SELECT cloudType FROM DM2Cloud WHERE  cloudId = @cloudId ),0)
UPDATE @nodeOperation
SET t_nodeMetaInfos =(SELECT t_name as '@name', T_value AS '@value'
				FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId FOR XML PATH('nodeMetaInfos'), ROOT('NodeMetaProp')),
t_zkElectionPort =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'zkElectionPort'),
t_zkDataPort =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'zkDataPort'),
t_zkListenerPort =(SELECT  CAST (T_value AS INT) FROM @nodeProperties P WHERE P.t_clientId = N.t_clientId AND P.t_name = 'zkListenerPort')
FROM @nodeOperation N
UPDATE @nodeOperation
SET t_clientName = C.name
FROM APP_Client C (NOLOCK)
WHERE c.ID =t_clientId
--
-- SET GUI AUDIT OPERATION
SET @opMsgId = (633 | (CAST(POWER(2, 24) AS BIGINT) * 84))
SET @cloudPoolDisplayName = ISNULL((SELECT name FROM DM2Cloud (NOLOCK) WHERE  cloudId = @cloudId ), N'')
--
BEGIN transaction
	DECLARE nodeOperationCur CURSOR FOR
            SELECT t_OpType, t_clientId, t_nodeMetaInfos, t_clientName, t_zkElectionPort,  t_zkDataPort, t_zkListenerPort
            FROM @nodeOperation
    OPEN nodeOperationCur
    -- Process each SCG configured
    FETCH NEXT FROM nodeOperationCur INTO @opType, @clientId, @nodeProps,@clientName, @zkElectionPort,  @zkDataPort, @zkListenerPort
    WHILE @@fetch_status = 0
    BEGIN
		IF @opType =  1 --common::OperationType_ADD
		BEGIN
			-- all looks good, create properties
declare @engineType int = (16 | 8)
			DECLARE @coreName nvarchar(1024)
			SET @coreName = 'Cloud_' + CAST(@CloudId as varchar(10)) + '_Client_' + CAST(@ClientId as varchar(10)) + '_Core'
DECLARE @coreRoles INT = 8 | 16
			--ADD A NEW NODE
			IF NOT EXISTS (SELECT 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE CloudId = @CloudId AND ClientId = @ClientId AND cloudType= @cloudType )
			BEGIN
				INSERT INTO DM2SearchServerCoreInfo
				(
					CoreName, CommCellId, CloudId, ClientId,
					CreateTime,
					SoftState, Enabled,
					Attributes,
					ServiceLink, CoreRoles,
					CollectionSize, FreeSpace, OccupiedSpace,
					Description,
					skippedItems, failedItems, numFiles, numEmails, status, cloudType, portNo, nodeProps, modifiedTime
				)
				VALUES
				(
					@coreName, @CommCellId, @CloudId, @ClientId,
					getutcdate(),
					1, 1,
					0,	'', @coreRoles,
					0, -1, 0,
					'',	0, 0, 0, 0, @status, @cloudType, 0, @nodeProps,0
				)
			END
			ELSE
			BEGIN
				UPDATE DM2SearchServerCoreInfo
				SET nodeProps = @nodeProps
				WHERE CloudId = @CloudId AND ClientId = @ClientId AND cloudType= @cloudType AND status != 1
			END
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SELECT @cloudPoolDisplayName =  ISNULL(@cloudPoolDisplayName,''), @clientName = ISNULL(@clientName,''), @zkElectionPort = ISNULL(@zkElectionPort, 0), @zkDataPort = ISNULL(@zkDataPort, 0), @zkListenerPort = ISNULL(@zkListenerPort, 0)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudPoolDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkElectionPort, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkDataPort, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkListenerPort, @dataIsEvent
SET @paramMsgId = (1710 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
		ELSE IF @opType =  2 --common::OperationType_DELETE
		BEGIN
			DELETE DM2SearchServerCoreInfo
			WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId
			DELETE FROM APP_ClientProp WHERE componentNameId = @clientId AND modified = 0
			AND attrname IN ('Zookeeper Installation Status_old','Zookeeper Listener Port_old','Zookeeper Data Port_old','Zookeeper Election Port_old','Zookeeper Server ID_old')
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SELECT @cloudPoolDisplayName =  ISNULL(@cloudPoolDisplayName,''), @clientName = ISNULL(@clientName,''), @zkElectionPort = ISNULL(@zkElectionPort, 0), @zkDataPort = ISNULL(@zkDataPort, 0), @zkListenerPort = ISNULL(@zkListenerPort, 0)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudPoolDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkElectionPort, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkDataPort, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkListenerPort, @dataIsEvent
SET @paramMsgId = (1712 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
		ELSE IF @opType =  3 --common::OperationType_MODIFY
		BEGIN
			--update node property for pool
			UPDATE DM2SearchServerCoreInfo
			SET nodeProps = @nodeProps,
				modifiedTime = @installTime
			WHERE cloudId = @cloudId AND  cloudType = @cloudType AND clientId = @clientId AND nodeProps != @nodeProps
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @i_userID, 3 , @clientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SELECT @cloudPoolDisplayName =  ISNULL(@cloudPoolDisplayName,''), @clientName = ISNULL(@clientName,''), @zkElectionPort = ISNULL(@zkElectionPort, 0), @zkDataPort = ISNULL(@zkDataPort, 0), @zkListenerPort = ISNULL(@zkListenerPort, 0)
			-- SET GUI AUDIT PARAMETER
			EXEC EvGuiAuditSetParamData @opId, @clientName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @cloudPoolDisplayName, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkElectionPort, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkDataPort, @dataIsEvent
			EXEC EvGuiAuditSetParamData @opId, @zkListenerPort, @dataIsEvent
SET @paramMsgId = (1711 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userID
		END
	FETCH NEXT FROM nodeOperationCur INTO @opType, @clientId, @nodeProps,@clientName, @zkElectionPort,  @zkDataPort, @zkListenerPort
    END
    CLOSE nodeOperationCur
    DEALLOCATE nodeOperationCur
errorexit:
	if @o_errorCode <> 0 begin
		if @@TRANCOUNT > 0 rollback transaction
	end
	else begin
		if @@TRANCOUNT > 0 commit transaction
	end
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppHACNodeOperation')
	delete from GxQscripts where name = 'AppHACNodeOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppHACNodeOperation')
	delete from GXDBVersions where aliasname = 'AppHACNodeOperation'
GO

insert into GXDBVersions values(2, 'AppHACNodeOperation',  '00010001000200040000', 'AppHACNodeOperation', '00010001000200040000')
GO

